/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.hr.time.TimeAttendanceCatalogFactory;
import com.kingdee.eas.hr.time.TimeAttendanceCatalogInfo;
import com.kingdee.eas.hr.time.TimeAttendanceException;
import com.kingdee.eas.hr.time.client.AbstractTimeAttendanceCatalogEditUI;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TimeAttendanceCatalogEditUI
extends AbstractTimeAttendanceCatalogEditUI {
    private static final long serialVersionUID = -61166L;
    private KDTree tree = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tree = (KDTree)this.getUIContext().get("tree");
        this.actionAddNew.setVisible(false);
        this.actionRemove.setVisible(false);
    }

    protected IObjectValue createNewData() {
        return new TimeAttendanceCatalogInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TimeAttendanceCatalogFactory.getRemoteInstance();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        if (this.isSave()) {
            KDTreeNode treeNode = (KDTreeNode)this.tree.getLastSelectedPathComponent();
            ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent((MutableTreeNode)treeNode);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.editData.getNumber())) {
            this.txtNumber.requestFocusInWindow();
            throw new TimeAttendanceException(TimeAttendanceException.ATTENDANCE_NUMBER_NOT_NULL);
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.txtName.requestFocusInWindow();
            throw new TimeAttendanceException(TimeAttendanceException.ATTENDANCE_NAME_NOT_NULL);
        }
        if (this.editData.getName().length() > 30) {
            this.txtName.requestFocusInWindow();
            throw new TimeAttendanceException(TimeAttendanceException.ATT_NAME_LENGTH);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        EditUI ui;
        super.actionSubmit_actionPerformed(e);
        IUIObject obj = this.uiWindow.getUIObject();
        if (obj instanceof EditUI && (ui = (EditUI)obj).getUIContext().containsKey("InitDataObject")) {
            ui.getUIContext().remove("InitDataObject");
        }
    }

    protected void showSubmitSuccess() {
        String id = (String)this.getUIContext().get("ID");
        this.editData.setId(BOSUuid.read((String)id));
        try {
            this.refreshTreeNode(this.editData);
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        super.showSubmitSuccess();
    }

    private void refreshTreeNode(TimeAttendanceCatalogInfo info) throws Exception {
        if (this.tree == null || info == null) {
            return;
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            KDTreeNode newNode = new KDTreeNode((Object)info);
            KDTreeNode rootNode = (KDTreeNode)((DefaultTreeModel)this.tree.getModel()).getRoot();
            rootNode.add((MutableTreeNode)newNode);
            ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged((TreeNode)rootNode);
            TreePath path = new TreePath(newNode);
            this.tree.scrollPathToVisible(path);
            this.tree.startEditingAtPath(path);
            this.tree.makeVisible(path);
        } else {
            TreePath path = this.tree.getSelectionPath();
            if (path != null) {
                KDTreeNode selectNode = (KDTreeNode)path.getLastPathComponent();
                selectNode.setUserObject((Object)info);
                selectNode.setText(info.getName());
                ((DefaultTreeModel)this.tree.getModel()).reload((TreeNode)selectNode);
            }
        }
    }
}

