/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.ItemSubjectEnum;
import com.kingdee.eas.hr.time.ITimeAttendance;
import com.kingdee.eas.hr.time.TimeAttendanceCatalogInfo;
import com.kingdee.eas.hr.time.TimeAttendanceException;
import com.kingdee.eas.hr.time.TimeAttendanceFactory;
import com.kingdee.eas.hr.time.TimeAttendanceInfo;
import com.kingdee.eas.hr.time.UnitTypeEnum;
import com.kingdee.eas.hr.time.client.AbstractTimeAttendanceEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class TimeAttendanceEditUI
extends AbstractTimeAttendanceEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TimeAttendanceEditUI.class);
    private TimeAttendanceCatalogInfo selectInfo = null;

    public void onLoad() throws Exception {
        HashMap map = (HashMap)this.getUIContext();
        this.selectInfo = (TimeAttendanceCatalogInfo)map.get("selectUserObject");
        this.comboUnitType.setRequired(true);
        this.txtNumber.setRequired(true);
        this.initSpinnerMaxMinValue();
        this.initEntityViewInfo();
        this.loadComboDataType();
        super.onLoad();
        this.menuItemCopy.setVisible(false);
        this.menuItemCopy.setEnabled(false);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.kDSpinnerDecDigital.setValue((Object)2);
            this.kDSpinnerLength.setValue((Object)2);
            if (this.comboDataType.getItemCount() > 0) {
                this.comboDataType.setSelectedIndex(0);
                this.setDecDigitalEnabled();
            }
        }
    }

    int getInitNumberValue() throws EASBizException, BOSException {
        ITimeAttendance iTime = TimeAttendanceFactory.getRemoteInstance();
        return iTime.getMaxNumber();
    }

    void initSpinnerMaxMinValue() {
        ((SpinnerNumberModel)this.kDSpinnerLength.getModel()).setMaximum(Integer.valueOf(65535));
        ((SpinnerNumberModel)this.kDSpinnerLength.getModel()).setMinimum(Integer.valueOf(0));
        ((SpinnerNumberModel)this.kDSpinnerDecDigital.getModel()).setMaximum(Integer.valueOf(65535));
        ((SpinnerNumberModel)this.kDSpinnerDecDigital.getModel()).setMinimum(Integer.valueOf(0));
        this.txtLastUnit.setPrecision(2);
        this.txtLastUnit.setHorizontalAlignment(4);
    }

    void loadComboDataType() {
        DefaultComboBoxModel<ItemDataTypeEnum> model = new DefaultComboBoxModel<ItemDataTypeEnum>();
        model.addElement(ItemDataTypeEnum.INT);
        model.addElement(ItemDataTypeEnum.FLOAT);
        this.comboDataType.setModel(model);
    }

    protected void comboDataType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            this.setDecDigitalEnabled();
        }
    }

    private void setDecDigitalEnabled() {
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            if (((ItemDataTypeEnum)this.comboDataType.getSelectedItem()).getValue() == 40) {
                this.kDSpinnerDecDigital.setEnabled(false);
                this.kDSpinnerDecDigital.setValue((Object)0);
            } else {
                this.kDSpinnerDecDigital.setEnabled(true);
            }
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        } else if (((ItemDataTypeEnum)this.comboDataType.getSelectedItem()).getValue() == 40) {
            this.kDSpinnerDecDigital.setEnabled(false);
            this.kDSpinnerDecDigital.setValue((Object)0);
        } else {
            this.kDSpinnerDecDigital.setEnabled(true);
        }
    }

    void initEntityViewInfo() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cmpItemCatalog.number", (Object)"FCHK"));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        view.setFilter(filter);
        this.promptCmpScheme.setEntityViewInfo(view);
    }

    void setControlState() {
        if (this.editData != null && this.editData.isEnable()) {
            this.txtNumber.setEnabled(false);
            this.chkEnable.setEnabled(false);
            this.comboDataType.setEnabled(false);
            this.comboUnitType.setEnabled(false);
            this.kDSpinnerDecDigital.setEnabled(false);
            this.kDSpinnerLength.setEnabled(false);
            this.contLastUnit.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
            this.chkEnable.setEnabled(true);
            this.comboDataType.setEnabled(true);
            this.comboUnitType.setEnabled(true);
            this.kDSpinnerDecDigital.setEnabled(true);
            this.kDSpinnerLength.setEnabled(true);
            if (this.editData != null && !this.editData.getUnitType().equals((Object)UnitTypeEnum.DAY) && !this.editData.getUnitType().equals((Object)UnitTypeEnum.HOUR)) {
                this.contLastUnit.setEnabled(false);
            } else {
                this.contLastUnit.setEnabled(true);
            }
            this.btnEdit.setEnabled(true);
            this.btnRemove.setEnabled(true);
        }
    }

    public void loadFields() {
        super.loadFields();
        this.setControlState();
        this.setDecDigitalEnabled();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        TimeAttendanceInfo attendInfo = new TimeAttendanceInfo();
        attendInfo.setAttendCatalog(this.selectInfo);
        attendInfo.setDataType(ItemDataTypeEnum.INT);
        attendInfo.setDecDigital(0);
        attendInfo.setLength(2);
        attendInfo.setUnitType(UnitTypeEnum.DAY);
        attendInfo.setInnerType(ItemSubjectEnum.NOTSYSINIT);
        attendInfo.setLastUnit(new BigDecimal("0.00"));
        return attendInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TimeAttendanceFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.editData.getNumber())) {
            this.txtNumber.requestFocusInWindow();
            throw new TimeAttendanceException(TimeAttendanceException.ATTENDANCE_NUMBER_NOT_NULL);
        }
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.txtName.requestFocusInWindow();
            throw new TimeAttendanceException(TimeAttendanceException.ATTENDANCE_NAME_NOT_NULL);
        }
        if (this.editData.getName().length() > 30) {
            this.txtName.requestFocusInWindow();
            throw new TimeAttendanceException(TimeAttendanceException.ATT_NAME_LENGTH);
        }
        if (Integer.parseInt(this.kDSpinnerDecDigital.getValue().toString()) > Integer.parseInt(this.kDSpinnerLength.getValue().toString())) {
            throw new TimeAttendanceException(TimeAttendanceException.LENGTH_MUST_LARGE_PRE);
        }
        if (this.selectInfo == null && this.editData.getId() == null) {
            throw new TimeAttendanceException(TimeAttendanceException.MUST_SELECT_TIMECATA);
        }
        if (this.txtLastUnit.getBigDecimalValue() != null && this.txtLastUnit.getBigDecimalValue().floatValue() < 0.0f) {
            this.txtLastUnit.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"75_TimeAttendanceEditUI"));
            SysUtil.abort();
        }
        if (!this.editData.getUnitType().equals((Object)UnitTypeEnum.DAY) && !this.editData.getUnitType().equals((Object)UnitTypeEnum.HOUR)) {
            this.editData.setLastUnit(new BigDecimal("0"));
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setControlState();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.getOprtState().equals(OprtState.ADDNEW)) {
            this.editData.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
            this.editData.setAttendCatalog(this.selectInfo);
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected void showMessageForStatus() {
        super.showMessageForStatus();
    }

    public boolean checkBeforeWindowClosing() {
        return super.checkBeforeWindowClosing();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (ItemSubjectEnum.SYSINIT.equals((Object)this.editData.getInnerType())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource", (String)"innerTypeNotDel"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("innerType"));
        return sic;
    }

    protected void comboUnitType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboUnitType_itemStateChanged(e);
        Object obj = e.getItem();
        if (obj.equals((Object)UnitTypeEnum.DAY)) {
            this.kDLabel1.setText(EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"76_TimeAttendanceEditUI"));
            this.contLastUnit.setEnabled(true);
        } else if (obj.equals((Object)UnitTypeEnum.HOUR)) {
            this.kDLabel1.setText(EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"77_TimeAttendanceEditUI"));
            this.contLastUnit.setEnabled(true);
        } else {
            this.kDLabel1.setText("");
            this.contLastUnit.setEnabled(false);
        }
    }
}

