/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.time.client.AbstractTimeAttendanceManagerDetailListUI;
import com.kingdee.eas.hr.time.client.HRTimeClientUtils;
import com.kingdee.eas.hr.time.client.TimeUtil;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class TimeAttendanceManagerDetailListUI
extends AbstractTimeAttendanceManagerDetailListUI {
    private static final Logger logger = CoreUIObject.getLogger(TimeAttendanceManagerDetailListUI.class);
    private String RES = "com.kingdee.eas.hr.train.client.TrainSignResource";
    String personID = null;
    private boolean isRelateOrg;
    int checkState = -1;

    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    public void onLoad() throws Exception {
        TrainClientUtil.checkValidPerson((CoreUI)this);
        this.fetchUIContext();
        this.isRelateOrg = TimeUtil.getParamValue("AttendanceData_Relate_OrgUnit");
        super.onLoad();
        this.tblMain.getColumn("totalValue").getStyleAttributes().setNumberFormat("0.00");
        this.tblMain.getColumn("startDate").setEditor(EmployeeClientUtils.getDateTimeCellEditor());
        this.tblMain.getColumn("startDate").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getLongTimePatternStr());
        this.tblMain.getColumn("endDate").setEditor(EmployeeClientUtils.getDateTimeCellEditor());
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getLongTimePatternStr());
    }

    private void fetchUIContext() {
        this.personID = (String)this.getUIContext().get("personID");
        if (this.getUIContext().get("checkState") != null) {
            this.checkState = Integer.valueOf(this.getUIContext().get("checkState").toString());
        }
        if (TrainClientUtil.objectIsNull((Object)this.personID)) {
            TrainClientUtil.showErrorMessage((String)this.RES, (String)"personNotNull", (CoreUI)this);
        }
    }

    public void onGetRowSet(IRowSet rowSet) {
        if (!this.isRelateOrg) {
            try {
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    rowSet.updateString("adminOrgUnit1.name", rowSet.getString("adminOrgUnit.name"));
                }
                rowSet.beforeFirst();
            }
            catch (Exception ex) {
                this.abort(ex);
            }
        }
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                rowSet.updateBigDecimal("totalValue", new BigDecimal(rowSet.getDouble("totalValue")));
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.abort(ex);
        }
        super.onGetRowSet(rowSet);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.personID, CompareType.EQUALS));
        if (this.getUIContext().get("ctrlBeginDate") != null && this.getUIContext().get("ctrlEndDate") != null) {
            filter.getFilterItems().add(new FilterItemInfo("startDate", this.getUIContext().get("ctrlEndDate"), CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("endDate", this.getUIContext().get("ctrlBeginDate"), CompareType.GREATER_EQUALS));
        } else if (this.getUIContext().get("ctrlBeginDate") != null && this.getUIContext().get("ctrlEndDate") == null) {
            filter.getFilterItems().add(new FilterItemInfo("startDate", this.getUIContext().get("ctrlBeginDate"), CompareType.GREATER_EQUALS));
        } else if (this.getUIContext().get("ctrlBeginDate") == null && this.getUIContext().get("ctrlEndDate") != null) {
            filter.getFilterItems().add(new FilterItemInfo("endDate", this.getUIContext().get("ctrlEndDate"), CompareType.LESS_EQUALS));
        }
        if (this.isRelateOrg && this.getUIContext().get("adminName") != null) {
            filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit1.name", this.getUIContext().get("adminName"), CompareType.EQUALS));
        }
        if (this.checkState != -1) {
            filter.getFilterItems().add(new FilterItemInfo("checkState", (Object)this.checkState, CompareType.EQUALS));
        }
        return filter;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        SorterItemInfo item = new SorterItemInfo("endDate");
        item.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(item);
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        return exec;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

