/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.basedata.org.client.f7.NewAdminByHROF7;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.benefit.util.CommonQueryUtil;
import com.kingdee.eas.hr.emp.IUserPermission;
import com.kingdee.eas.hr.emp.UserPermissionCollection;
import com.kingdee.eas.hr.emp.UserPermissionFactory;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.time.LeaveDetailException;
import com.kingdee.eas.hr.time.client.AbstractTimeAttendanceQueryPanelUI;
import com.kingdee.eas.hr.time.client.TimeAttendanceFilterInfo;
import com.kingdee.eas.hr.train.client.CustomerQueryUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class TimeAttendanceQueryPanelUI
extends AbstractTimeAttendanceQueryPanelUI {
    private static final Logger logger = CoreUIObject.getLogger(TimeAttendanceQueryPanelUI.class);
    private String personType = null;
    private boolean isSetParam = false;
    public static final String strResource = "com.kingdee.eas.hr.time.TimeAttendanceReportResource";
    private static final String START_DATE = "startDateReal";
    private static final String END_DATE = "endDateReal";
    private static final String CHECKSTATE = "checkState";
    private static final String ADMINORG = "AdminOrgUnit.name";
    private static final String PERSON_TYPE = "";
    private static final String PERSON_NAME = "Person.name";
    private static final String HRID = "hrOrgUnit.id";

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    void initCmoboBoxData() {
        DefaultComboBoxModel<EmpInServiceType> model = new DefaultComboBoxModel<EmpInServiceType>();
        model.addElement(new EmpInServiceType(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.EMPLOYEETYPE_INSERVICE"), 1));
        model.addElement(new EmpInServiceType(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.EMPLOYEETYPE_NOTINSERVICE"), 0));
        model.addElement(new EmpInServiceType(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.EMPLOYEETYPE_LEAVEINSERVICE"), 2));
        model.addElement(new EmpInServiceType(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.EMPLOYEETYPE_RETIRESERVICE"), 3));
        this.comboEmp.setModel(model);
    }

    public void initDefaultComb() {
        int size = this.comboEmp.getItemCount();
        for (int i = 0; i < size; ++i) {
            if (!((EmpInServiceType)this.comboEmp.getItemAt(i)).getName().equals(this.personType)) continue;
            this.comboEmp.setSelectedIndex(i);
            break;
        }
    }

    public String getCurrOUListToString() throws EASBizException, BOSException {
        IHROrgUnit iHRO = HROrgUnitFactory.getRemoteInstance();
        StringBuffer OUstrs = new StringBuffer();
        int counts = 0;
        HROrgUnitInfo hroInfo = SysContext.getSysContext().getCurrentHRUnit();
        AdminOrgUnitCollection adminColl = iHRO.getAdminOrgUnitCollectionWithOrgRangeFilter(hroInfo.getId().toString());
        if (adminColl != null) {
            counts = adminColl.size();
        }
        if (counts == 0) {
            return null;
        }
        for (int i = 0; i < counts; ++i) {
            if (counts == 1) {
                OUstrs.append("'");
                OUstrs.append(adminColl.get(i).getId().toString());
                OUstrs.append("'");
                continue;
            }
            if (i != 0) {
                OUstrs.append(",'" + adminColl.get(i).getId().toString());
                OUstrs.append("'");
                continue;
            }
            OUstrs.append("'");
            OUstrs.append(adminColl.get(i).getId().toString());
            OUstrs.append("'");
        }
        return OUstrs.toString();
    }

    public TimeAttendanceFilterInfo getQryFilter() {
        TimeAttendanceFilterInfo qryFilter = new TimeAttendanceFilterInfo();
        qryFilter.isLowLevel = this.chkIsLowLevel.isSelected();
        if (this.prmtOrgUnit.getData() != null && this.radioOrg.isSelected()) {
            qryFilter.adminOrgInfo = ((AdminOrgUnitInfo)this.prmtOrgUnit.getData()).getLongNumber().toString();
        } else if (this.prmtOrgUnit.getData() == null && this.radioOrg.isSelected()) {
            qryFilter.adminOrgInfo = SysContext.getSysContext().getCurrentAdminUnit().getLongNumber().toString();
            qryFilter.isLowLevel = true;
        } else {
            qryFilter.adminOrgInfo = SysContext.getSysContext().getCurrentAdminUnit().getLongNumber().toString();
        }
        if (this.prmtEmp.getValue() != null && this.radioPerson.isSelected()) {
            qryFilter.personInfo = ((PersonInfo)this.prmtEmp.getValue()).getId().toString();
            qryFilter.adminOrgInfo = null;
        }
        try {
            qryFilter.cuOrgInfo = this.getCurrOUListToString() != null ? this.getCurrOUListToString() : null;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        catch (BOSException e1) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
        qryFilter.ctrlBeginDate = (Date)this.pkStartDate.getValue();
        if (qryFilter.ctrlBeginDate == null) {
            qryFilter.ctrlBeginDate = new Date();
        }
        qryFilter.ctrlBeginDate.setHours(0);
        qryFilter.ctrlBeginDate.setMinutes(0);
        qryFilter.ctrlBeginDate.setSeconds(0);
        qryFilter.ctrlEndDate = (Date)this.pkEndDate.getValue();
        if (qryFilter.ctrlEndDate == null) {
            qryFilter.ctrlEndDate = new Date();
        }
        qryFilter.ctrlEndDate.setHours(23);
        qryFilter.ctrlEndDate.setMinutes(59);
        qryFilter.ctrlEndDate.setSeconds(59);
        qryFilter.checkState = this.btnAudit.isSelected() ? 1 : (this.btnUnAudit.isSelected() ? 0 : -1);
        EmpInServiceType intervalType = (EmpInServiceType)this.comboEmp.getSelectedItem();
        qryFilter.personType = intervalType == null ? -1 : intervalType._type;
        Object value = this.prmtEmpState.getValue();
        if (value != null && value instanceof Object[]) {
            Object[] typesInfo = (Object[])value;
            StringBuffer typesString = new StringBuffer();
            typesString.append(((EmployeeTypeInfo)typesInfo[0]).getId().toString());
            int size = typesInfo.length;
            for (int i = 1; i < size; ++i) {
                typesString.append("','").append(((EmployeeTypeInfo)typesInfo[i]).getId().toString());
            }
            qryFilter.employeeType = typesString.toString();
        }
        qryFilter.isIncludeNoRecPerson = this.chkIsIncludeNoRecPerson.isSelected();
        return qryFilter;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initF7();
        this.initCmoboBoxData();
        if (this.personType != null) {
            this.initDefaultComb();
        }
    }

    public void initLayout() {
        super.initLayout();
        if (!this.isSetParam) {
            this.pkStartDate.setValue((Object)this.getTheDate((Date)this.pkEndDate.getValue()));
        }
        this.isSetParam = false;
    }

    public void clear() {
        super.clear();
        this.clearPanel();
    }

    public void initF7() {
        EmployeeMultiF7PromptBox mBox = new EmployeeMultiF7PromptBox((IUIObject)this);
        try {
            this.setF7Filter(mBox);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        mBox.setModal(true);
        mBox.setIsSingleSelect(false);
        mBox.showNoPositionPerson(true);
        mBox.showOnlyPayPerson(true);
        mBox.setUserOrgRangeFilter(true);
        mBox.setReturnPositionAndUnit(false);
        mBox.setIsSingleSelect(true);
        mBox.showNoPositionPerson(true);
        this.prmtEmp.setSelector((KDPromptSelector)mBox);
        this.prmtEmp.setEnabled(false);
        HashSet<BOSUuid> set = new HashSet<BOSUuid>();
        set.add(SysContext.getSysContext().getCurrentHRUnit().getId());
        mBox.setHROFilter(set);
        this.prmtEmp.setEditable(false);
        this.prmtOrgUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.prmtOrgUnit.setCommitFormat("$number$");
        this.prmtOrgUnit.setEditFormat("$number$");
        this.prmtOrgUnit.setDisplayFormat("$name$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        this.prmtOrgUnit.setEntityViewInfo(evi);
        this.prmtOrgUnit.setHasCUDefaultFilter(false);
        this.prmtOrgUnit.setEditable(false);
        this.prmtOrgUnit.setSelector((KDPromptSelector)new NewAdminByHROF7());
        this.radioOrg.setSelected(true);
    }

    private void setF7Filter(EmployeeMultiF7PromptBox pmt) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        IUserPermission iup = UserPermissionFactory.getRemoteInstance();
        UserPermissionCollection collection = iup.getUserPermissionCollection(viewInfo);
        String filterString = null;
        if (collection != null && collection.size() > 0) {
            filterString = collection.get(0).getFilter();
        }
        if (filterString == null) {
            return;
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.emp.app", "EmpInfoQuery");
        IQueryExecutor iQe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        filter = new FilterInfo(filterString);
        viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(sic);
        iQe.setObjectView(viewInfo);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)iQe.getSQL(), CompareType.INNER));
        pmt.setNopositionPersonFilter(filter);
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        cp.putDate("beginDate", (Date)this.pkStartDate.getValue());
        cp.putDate("endDate", (Date)this.pkEndDate.getValue());
        cp.putBoolean("all", this.btnAll.isSelected());
        cp.putBoolean("yes", this.btnAudit.isSelected());
        cp.putBoolean("no", this.btnUnAudit.isSelected());
        cp.putBoolean("isOrg", this.radioOrg.isSelected());
        cp.putBoolean("isPerson", this.radioPerson.isSelected());
        cp.putBoolean("isLow", this.chkIsLowLevel.isSelected());
        cp.putBoolean("isIncludeNoRecPerson", this.chkIsIncludeNoRecPerson.isSelected());
        CommonQueryUtil.getAdminFromQueryPanel((CustomerParams)cp, (KDBizPromptBox)this.prmtOrgUnit);
        CommonQueryUtil.getPerFromQueryPanel((CustomerParams)cp, (KDBizPromptBox)this.prmtEmp);
        CustomerQueryUtil.storeToCustomerParams((CustomerParams)cp, (KDBizPromptBox)this.prmtEmpState);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        this.clear();
        this.isSetParam = true;
        if (cp == null) {
            return;
        }
        this.pkStartDate.setValue((Object)cp.getDate("beginDate"));
        this.pkEndDate.setValue((Object)cp.getDate("endDate"));
        this.radioOrg.setSelected(cp.getBoolean("isOrg"));
        this.chkIsLowLevel.setSelected(cp.getBoolean("isLow"));
        this.radioPerson.setSelected(cp.getBoolean("isPerson"));
        this.btnUnAudit.setSelected(cp.getBoolean("no"));
        this.btnAudit.setSelected(cp.getBoolean("yes"));
        this.btnAll.setSelected(cp.getBoolean("all"));
        this.chkIsIncludeNoRecPerson.setSelected(cp.getBoolean("isIncludeNoRecPerson"));
        CommonQueryUtil.setAdminFromQueryPanel((CustomerParams)cp, (KDBizPromptBox)this.prmtOrgUnit);
        CommonQueryUtil.setPerFromQueryPanel((CustomerParams)cp, (KDBizPromptBox)this.prmtEmp);
        CustomerQueryUtil.loadFromCustomerParams((CustomerParams)cp, (KDBizPromptBox)this.prmtEmpState, (String)EmployeeTypeInfo.class.getName());
    }

    public void clearPanel() {
        Date date = new Date();
        GregorianCalendar cal = new GregorianCalendar(DateTimeUtils.getYear((Date)date), DateTimeUtils.getMonth((Date)date) - 1, 1);
        this.pkStartDate.setValue((Object)cal.getTime());
        this.pkEndDate.setValue((Object)date);
        this.btnAll.setSelected(true);
        int size = this.comboEmp.getItemCount();
        for (int i = 0; i < size; ++i) {
            if (!((EmpInServiceType)this.comboEmp.getItemAt(i)).getName().equals(EASResource.getString((String)"com.kingdee.eas.hr.base.HRBasedataResource.EMPLOYEETYPE_INSERVICE"))) continue;
            this.comboEmp.setSelectedIndex(i);
            break;
        }
        this.prmtEmp.setValue(null);
        this.prmtOrgUnit.setValue(null);
        this.chkIsLowLevel.setSelected(false);
        this.prmtEmp.setEnabled(false);
        this.prmtOrgUnit.setEnabled(true);
        this.prmtEmpState.setValue(null);
        this.prmtEmpState.setEnabled(true);
    }

    public boolean verify() {
        Date beginDate = (Date)this.pkStartDate.getValue();
        Date endDate = (Date)this.pkEndDate.getValue();
        try {
            if (beginDate == null) {
                throw new LeaveDetailException(LeaveDetailException.BEGINTIME_NULL);
            }
            if (endDate == null) {
                throw new LeaveDetailException(LeaveDetailException.ENDTIME_NULL);
            }
        }
        catch (LeaveDetailException e) {
            super.handUIException((Throwable)((Object)e));
        }
        if (DateTimeUtils.dayAfter((Date)beginDate, (Date)endDate)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)strResource, (String)"DATESCOPEERROR"));
            SysUtil.abort();
        }
        return super.verify();
    }

    protected void pkEndDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkEndDate_dataChanged(e);
    }

    protected void pkStartDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkStartDate_dataChanged(e);
    }

    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrgUnit_dataChanged(e);
        this.prmtEmp.setEnabled(false);
    }

    protected void prmtEmp_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtEmp_dataChanged(e);
        this.prmtOrgUnit.setEnabled(false);
    }

    public Date getTheDate(Date date) {
        Date theDate = null;
        theDate = new Date(date.getYear(), date.getMonth(), 1);
        return theDate;
    }

    protected void radioOrg_itemStateChanged(ItemEvent e) throws Exception {
        boolean flag = this.radioOrg.isSelected();
        this.prmtOrgUnit.setEnabled(flag);
        this.chkIsLowLevel.setEnabled(flag);
        this.prmtEmp.setEnabled(!flag);
    }

    private static class EmpInServiceType {
        private String _name;
        private int _type;

        public EmpInServiceType(String name, int type) {
            this._name = name;
            this._type = type;
        }

        public String getName() {
            return this._name;
        }

        public int getType() {
            return this._type;
        }

        public String toString() {
            return this.getName();
        }
    }
}

