/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.client.util.HRClientUtil;
import com.kingdee.eas.hr.compensation.util.HRReportUtils;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.time.ILeaveAndAttendanceReport;
import com.kingdee.eas.hr.time.LeaveAndAttendanceReportFactory;
import com.kingdee.eas.hr.time.TimeAttendanceCollection;
import com.kingdee.eas.hr.time.TimeAttendanceFactory;
import com.kingdee.eas.hr.time.TimeAttendanceInfo;
import com.kingdee.eas.hr.time.client.AbstractTimeAttendanceReportUI;
import com.kingdee.eas.hr.time.client.TimeAttendanceDetailReportUI;
import com.kingdee.eas.hr.time.client.TimeAttendanceFilterInfo;
import com.kingdee.eas.hr.time.client.TimeAttendanceQueryPanelUI;
import com.kingdee.eas.hr.time.client.TimeUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TimeAttendanceReportUI
extends AbstractTimeAttendanceReportUI {
    private boolean isFirstDefaultQuery = true;
    private boolean isFirstLoaded = false;
    private static final String strResource = "com.kingdee.eas.hr.time.TimeAttendanceReportResource.";
    private String leaveDetailResourceBasicURL = "com.kingdee.eas.hr.time.LeaveDetailResource";
    private static final String PID = "Person.id";
    private static final String RpersonID = "recordPerson.id";
    private static final String RPERSON = "RPERSON";
    private static final String PNUMBER = "Person.number";
    private static final String PNAME = "Person.name";
    private static final String NAME = "Position.name";
    private static final String ANAME = "AdminOrgUnit.name";
    private static final String ADISPLAYNAME = "AdminOrgUnit.displayName";
    private static final String AID = "ATTENDANCEFID";
    private static final String ID = "ID";
    private static final String TOTALVALUE = "TOTALVALUE";
    private CustomerParams queryFilter = new CustomerParams();
    private EntityViewInfo entityViewInfo = new EntityViewInfo();
    TimeAttendanceFilterInfo filterInfo = null;
    boolean isRelateOrg = false;
    CommonQueryDialog commonQueryDialog = null;
    IUIWindow uiWindow = null;
    String maxRowCount = "10000";
    DecimalFormat df = new DecimalFormat("###.##");
    private TimeAttendanceCollection total_coll;

    public void onLoad() throws Exception {
        HRClientUtil.checkCurrentHRUnitNotNull((CoreUI)this);
        this.isRelateOrg = TimeUtil.getParamValue("AttendanceData_Relate_OrgUnit");
        super.onLoad();
        this.btnRefresh.setEnabled(true);
        this.btnQuery.setEnabled(true);
        this.btnPrint.setEnabled(true);
        this.btnPrintPreview.setEnabled(true);
        this.btnDetail.setEnabled(true);
        this.enableExportExcel(this.tblTimeAttendance);
        this.loadFilterUI(true);
        this.initTable();
        this.loadDataTable2();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnDetail.setIcon(EASResource.getIcon((String)"imgTbtn_listaccount"));
        this.setButtonDefaultStyl(this.btnRefresh);
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.menuItemPrint.setEnabled(true);
        this.menuItemPrintPreview.setEnabled(true);
        this.menuItemQuery.setEnabled(true);
        this.menuItemRefresh.setEnabled(true);
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
    }

    private void loadFilterUI(boolean loaded) throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = this.leaveAndAttendanceReportQueryPK.getFullName();
        TimeAttendanceQueryPanelUI filterUI = new TimeAttendanceQueryPanelUI();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName) && this.getUIContext().get("timeview") == null) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            CustomerParams cp = CustomerParams.getCustomerParams2((String)solution.getQueryPanelInfo().get(0).getCustomerParams());
            this.maxRowCount = String.valueOf(solution.getRowCount());
            if (cp != null) {
                filterUI.setCustomerParams(cp);
                this.filterInfo = filterUI.getQryFilter();
                this.leaveAndAttendanceReportQuery = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
                FilterInfo filterInfo2 = null;
                if (this.leaveAndAttendanceReportQuery != null) {
                    filterInfo2 = this.leaveAndAttendanceReportQuery.getFilter();
                }
                if (filterInfo2 != null) {
                    this.initCustomFilter(filterInfo2);
                }
            } else {
                this.showQueryDialog();
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.showQueryDialog();
        }
    }

    private void showQueryDialog() throws EASBizException, BOSException {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.commonQueryDialog.setTitle(EASResource.getString((String)this.leaveDetailResourceBasicURL, (String)"TFILTERNAME"));
            this.commonQueryDialog.setWidth(500);
            this.commonQueryDialog.setHeight(350);
            this.commonQueryDialog.setShowFilter(false);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setQueryObjectPK(this.leaveAndAttendanceReportQueryPK);
            TimeAttendanceQueryPanelUI timeAttendanceQueryPanelUI = null;
            try {
                timeAttendanceQueryPanelUI = new TimeAttendanceQueryPanelUI();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (this.isFirstLoaded) {
                timeAttendanceQueryPanelUI.setCustomerParams(this.queryFilter);
                this.commonQueryDialog.setEntityViewInfo(this.entityViewInfo);
            }
            this.commonQueryDialog.addUserPanel((KDPanel)timeAttendanceQueryPanelUI);
        }
        if (this.commonQueryDialog.show()) {
            TimeAttendanceQueryPanelUI taqUI = (TimeAttendanceQueryPanelUI)this.commonQueryDialog.getUserPanel(0);
            this.filterInfo = taqUI.getQryFilter();
            this.entityViewInfo = this.commonQueryDialog.getEntityViewInfoResult();
            this.queryFilter = taqUI.getCustomerParams();
            this.isFirstLoaded = true;
            if (this.commonQueryDialog.getCommonFilter() != null) {
                this.initCustomFilter(this.commonQueryDialog.getCommonFilter());
            }
        } else {
            SysUtil.abort();
        }
    }

    private void initCustomFilter(FilterInfo filterInfo2) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        FilterItemInfo filterItemInfo = null;
        int size = filterInfo2.getFilterItems().size();
        for (int i = 0; i < size; ++i) {
            filterItemInfo = filterInfo2.getFilterItems().get(i);
            if (filterItemInfo.getPropertyName().equals("attendance.id")) {
                filterItemInfo.setPropertyName("ATTENDANCE.FID");
                sb = sb.append(filterItemInfo.toString());
                sb = sb.append("#");
                filterItemInfo.setPropertyName(AID);
            }
            if (!filterItemInfo.getPropertyName().equals(RpersonID)) continue;
            filterItemInfo.setPropertyName(RPERSON);
        }
        this.filterInfo.totalInfo = filterInfo2.toString();
    }

    private void initTable() throws BOSException, SQLException, EASBizException {
        TimeAttendanceCollection coll;
        this.tblTimeAttendance.removeColumns();
        this.tblTimeAttendance.setRefresh(false);
        IColumn col = null;
        col = this.tblTimeAttendance.addColumn();
        col.getStyleAttributes().setHided(true);
        col.setKey(PID);
        col = this.tblTimeAttendance.addColumn();
        col.setWidth(60);
        col.setKey(PNUMBER);
        col = this.tblTimeAttendance.addColumn();
        col.setWidth(60);
        col.setKey(PNAME);
        col = this.tblTimeAttendance.addColumn();
        col.setWidth(60);
        col.setKey(NAME);
        col = this.tblTimeAttendance.addColumn();
        col.setWidth(80);
        col.setKey(ANAME);
        col = this.tblTimeAttendance.addColumn();
        col.setWidth(80);
        col.setKey(ADISPLAYNAME);
        String hrOrgID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        String oSQL = "Select id,name,unitType Where enable = 1 and (hrOrgUnit.id = '" + hrOrgID + "' or cu.id ='" + "11111111-1111-1111-1111-111111111111CCE7AED4".toString() + "')";
        this.total_coll = coll = TimeAttendanceFactory.getRemoteInstance().getTimeAttendanceCollection(oSQL);
        TimeAttendanceInfo info = null;
        HashMap<String, String> mapName = new HashMap<String, String>();
        HashMap<String, String> mapUnitType = new HashMap<String, String>();
        String id = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            col = this.tblTimeAttendance.addColumn();
            col.getStyleAttributes().setNumberFormat("0.00");
            col.setWidth(90);
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            id = info.getId().toString();
            col.setKey(id);
            mapName.put(id, info.getName());
            mapUnitType.put(id, info.getUnitType().toString());
        }
        IRow iRow = this.tblTimeAttendance.addHeadRow();
        iRow.getCell(PID).setValue((Object)ID);
        iRow.getCell(PNUMBER).setValue((Object)TimeAttendanceReportUI.getAlias("PNUMBER"));
        iRow.getCell(PNAME).setValue((Object)TimeAttendanceReportUI.getAlias("PNAME"));
        iRow.getCell(NAME).setValue((Object)TimeAttendanceReportUI.getAlias("NAME"));
        iRow.getCell(ANAME).setValue((Object)TimeAttendanceReportUI.getAlias("ANAME"));
        iRow.getCell(ADISPLAYNAME).setValue((Object)TimeAttendanceReportUI.getAlias("ANAME"));
        int size2 = this.tblTimeAttendance.getColumnCount();
        for (int i = 6; i < size2; ++i) {
            String key = this.tblTimeAttendance.getColumnKey(i);
            iRow.getCell(key).setValue((Object)(mapName.get(key) + "(" + mapUnitType.get(key) + ")"));
        }
        this.tblTimeAttendance.setRefresh(true);
        this.tblTimeAttendance.repaint();
        this.tblTimeAttendance.setColumnMoveable(true);
        this.tblTimeAttendance.getStyleAttributes().setLocked(true);
        this.tblTimeAttendance.getSelectManager().setSelectMode(2);
        HRUtils.removeLintMenu((KDTable)this.tblTimeAttendance, (KDTMenuManager)this.getMenuManager(this.tblTimeAttendance));
        TimeUtil.setKDTableUISort(this.tblTimeAttendance);
    }

    private void loadDataTable2() throws EASBizException, BOSException, SQLException {
        ILeaveAndAttendanceReport iLar = LeaveAndAttendanceReportFactory.getRemoteInstance();
        if (this.filterInfo == null) {
            throw new BOSException("filterInfo is null!");
        }
        this.dateBegin.setValue((Object)this.filterInfo.ctrlBeginDate);
        this.dateEnd.setValue((Object)this.filterInfo.ctrlEndDate);
        String personId = null;
        Object list = null;
        Object personId1 = null;
        HashMap<String, Integer> personIdMaps = new HashMap<String, Integer>();
        ICell cell = null;
        int rowCount = 0;
        IRowSet row = null;
        Object row2 = null;
        IRow iRow = null;
        if (this.commonQueryDialog != null) {
            this.maxRowCount = String.valueOf(this.commonQueryDialog.getMaxReturnRowCount());
        }
        if (this.filterInfo.isIncludeNoRecPerson) {
            IRowSet rowPerson = null;
            rowPerson = iLar.getTblSetByAdminCount(this.filterInfo.adminOrgInfo, this.filterInfo.isLowLevel, this.filterInfo.employeeType, this.maxRowCount);
            while (rowPerson.next()) {
                personId = this.isRelateOrg ? rowPerson.getString(PID) + rowPerson.getString(NAME) + rowPerson.getString(ANAME) : rowPerson.getString(PID);
                if (personIdMaps.get(personId) != null) {
                    iRow = this.tblTimeAttendance.getRow(((Integer)personIdMaps.get(personId)).intValue());
                    continue;
                }
                iRow = this.tblTimeAttendance.addRow();
                iRow.getCell(PID).setValue((Object)rowPerson.getString(PID));
                iRow.getCell(PNUMBER).setValue((Object)rowPerson.getString("number"));
                iRow.getCell(PNAME).setValue((Object)rowPerson.getString("name"));
                iRow.getCell(NAME).setValue((Object)rowPerson.getString(NAME));
                iRow.getCell(ANAME).setValue((Object)rowPerson.getString(ANAME));
                iRow.getCell(ADISPLAYNAME).setValue((Object)rowPerson.getString(ADISPLAYNAME));
                personIdMaps.put(personId, new Integer(rowCount));
                ++rowCount;
            }
        }
        row = this.isRelateOrg ? iLar.getTblSetUnion(iLar.getTblSetAtt1String(this.filterInfo.ctrlBeginDate, this.filterInfo.ctrlEndDate, this.filterInfo.adminOrgInfo, this.filterInfo.cuOrgInfo, this.filterInfo.personInfo, this.filterInfo.personType, this.filterInfo.checkState, this.filterInfo.totalInfo, this.filterInfo.isLowLevel, this.filterInfo.employeeType), iLar.getTblSetLeave1String(this.filterInfo.ctrlBeginDate, this.filterInfo.ctrlEndDate, this.filterInfo.adminOrgInfo, this.filterInfo.cuOrgInfo, this.filterInfo.personInfo, this.filterInfo.personType, this.filterInfo.checkState, this.filterInfo.totalInfo, this.filterInfo.isLowLevel, this.filterInfo.employeeType)) : iLar.getTblSetUnion(iLar.getTblSetAttString(this.filterInfo.ctrlBeginDate, this.filterInfo.ctrlEndDate, this.filterInfo.adminOrgInfo, this.filterInfo.cuOrgInfo, this.filterInfo.personInfo, this.filterInfo.personType, this.filterInfo.checkState, this.filterInfo.totalInfo, this.filterInfo.isLowLevel, this.filterInfo.employeeType), iLar.getTblSetLeaveString(this.filterInfo.ctrlBeginDate, this.filterInfo.ctrlEndDate, this.filterInfo.adminOrgInfo, this.filterInfo.cuOrgInfo, this.filterInfo.personInfo, this.filterInfo.personType, this.filterInfo.checkState, this.filterInfo.totalInfo, this.filterInfo.isLowLevel, this.filterInfo.employeeType));
        while (row.next()) {
            if (this.isRelateOrg) {
                personId = row.getString("PID") + row.getString("POSITIONNAME") + row.getString("ADMINORGUNITNAME");
                if (personIdMaps.get(personId) != null) {
                    iRow = this.tblTimeAttendance.getRow(((Integer)personIdMaps.get(personId)).intValue());
                } else {
                    iRow = this.tblTimeAttendance.addRow();
                    iRow.getCell(PID).setValue((Object)row.getString("PID"));
                    iRow.getCell(PNUMBER).setValue((Object)row.getString("PNUMBER"));
                    iRow.getCell(PNAME).setValue((Object)row.getString("PNAME"));
                    iRow.getCell(NAME).setValue((Object)row.getString("POSITIONNAME"));
                    iRow.getCell(ANAME).setValue((Object)row.getString("ADMINORGUNITNAME"));
                    iRow.getCell(ADISPLAYNAME).setValue((Object)row.getString("ADMINORGUNITDISPLAYNAME"));
                    personIdMaps.put(personId, new Integer(rowCount));
                    ++rowCount;
                }
                cell = iRow.getCell(row.getString(AID));
                if (cell != null) {
                    cell.setValue((Object)this.df.format(Double.parseDouble(row.getString(TOTALVALUE))));
                }
            } else {
                personId = row.getString("PID");
                if (personIdMaps.get(personId) != null) {
                    iRow = this.tblTimeAttendance.getRow(((Integer)personIdMaps.get(personId)).intValue());
                } else {
                    iRow = this.tblTimeAttendance.addRow();
                    iRow.getCell(PID).setValue((Object)row.getString("PID"));
                    iRow.getCell(PNUMBER).setValue((Object)row.getString("PNUMBER"));
                    iRow.getCell(PNAME).setValue((Object)row.getString("PNAME"));
                    iRow.getCell(NAME).setValue((Object)row.getString("POSITIONNAME"));
                    iRow.getCell(ANAME).setValue((Object)row.getString("ADMINORGUNITNAME"));
                    iRow.getCell(ADISPLAYNAME).setValue((Object)row.getString("ADMINORGUNITDISPLAYNAME"));
                    personIdMaps.put(personId, new Integer(rowCount));
                    ++rowCount;
                }
                cell = iRow.getCell(row.getString(AID));
                if (cell != null) {
                    cell.setValue((Object)this.df.format(Double.parseDouble(row.getString(TOTALVALUE))));
                }
            }
            if (rowCount < Integer.parseInt(this.maxRowCount)) continue;
        }
        this.showDisplayName();
        if (this.tblTimeAttendance.getRowCount() > 0) {
            this.calculateTotalRow(true);
        }
    }

    private static String getAlias(String name) {
        return EASResource.getString((String)(strResource + name));
    }

    private String dateTranse(Date date) {
        SimpleDateFormat transeFormat = new SimpleDateFormat(EASResource.getString((String)"com.kingdee.eas.hr.time.TimeAttendanceReportResource.DATEFRORMAT"));
        String transeDate = transeFormat.format(date);
        return transeDate;
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblTimeAttendance);
        this.tblTimeAttendance.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblTimeAttendance);
        this.tblTimeAttendance.getPrintManager().printPreview();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.commonQueryDialog != null && this.getUIContext() != null && "report".equals(this.getUIContext().get("UIClassParam"))) {
            this.commonQueryDialog.changeOwner((Component)((Object)this));
        }
        this.loadFilterUI(true);
        this.dateBegin.setValue(null);
        this.dateEnd.setValue(null);
        this.initTable();
        this.tblTimeAttendance.revalidate();
        this.loadDataTable2();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.tblTimeAttendance.removeRows();
        this.loadDataTable2();
    }

    protected KDTable getTableForOA() {
        return this.tblTimeAttendance;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.HR_TIME;
    }

    protected KDTable getTableForCommon() {
        return this.tblTimeAttendance;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblTimeAttendance;
    }

    public void actionDetail_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblTimeAttendance);
        if (rows.length <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"78_TimeAttendanceReportUI"));
            SysUtil.abort();
        }
        IRow row = this.tblTimeAttendance.getRow(rows[0]);
        uiContext.put((Object)"personID", (Object)row.getCell(PID).getValue().toString());
        uiContext.put((Object)"adminName", (Object)row.getCell(ANAME).getValue().toString());
        uiContext.put((Object)"ctrlBeginDate", (Object)this.filterInfo.ctrlBeginDate);
        uiContext.put((Object)"ctrlEndDate", (Object)this.filterInfo.ctrlEndDate);
        uiContext.put((Object)"checkState", (Object)this.filterInfo.checkState);
        if (this.uiWindow != null) {
            this.uiWindow.close();
        }
        this.uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(TimeAttendanceDetailReportUI.class.getName(), (Map)uiContext);
        this.uiWindow.show();
    }

    protected void tblTimeAttendance_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && e.getType() != 0) {
            ActionEvent av = new ActionEvent(this.btnDetail, 2, "TimeAttendanceDetail view");
            ItemAction actView = this.getActionFromActionEvent(av);
            actView.actionPerformed(av);
        }
    }

    protected void checkTableCommonMenu(KDTable table) {
        KDTMenuManager tm = this.getMenuManager(table);
        if (tm == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if (!"menuItemPaste".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(false);
        }
    }

    public void actionShowDiaplayName_actionPerformed(ActionEvent e) throws Exception {
        this.showDisplayName();
    }

    protected void showDisplayName() {
        this.showDisplayName(ANAME, ADISPLAYNAME);
    }

    protected void showDisplayName(String col, String displayCol) {
        boolean isShowDisplay = this.chkShowDisplayName.isSelected();
        if (!this.tblTimeAttendance.getColumn(col).getStyleAttributes().isHided() || !this.tblTimeAttendance.getColumn(displayCol).getStyleAttributes().isHided()) {
            this.tblTimeAttendance.getColumn(col).getStyleAttributes().setHided(isShowDisplay);
            this.tblTimeAttendance.getColumn(displayCol).getStyleAttributes().setHided(!isShowDisplay);
            if (isShowDisplay) {
                this.tblTimeAttendance.getColumn(col).setWidth(80);
            } else {
                this.tblTimeAttendance.getColumn(displayCol).setWidth(80);
            }
        }
    }

    private void calculateTotalRow(boolean needAddRow) {
        int i;
        IRow totalRow = null;
        if (needAddRow) {
            totalRow = this.tblTimeAttendance.addRow();
            totalRow.getStyleAttributes().setBackground(HRReportUtils.TOTAL_COLOR);
            if (totalRow.getCell(PNUMBER) != null) {
                totalRow.getCell(PNUMBER).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.time.LeaveDetailCheckResource", (String)"totalValue"));
            }
        } else {
            return;
        }
        if (this.total_coll == null || this.total_coll.size() == 0) {
            return;
        }
        double[] itemsValue = new double[this.total_coll.size()];
        TimeAttendanceInfo info = null;
        IRow row = null;
        for (i = 0; i < this.tblTimeAttendance.getRowCount(); ++i) {
            row = this.tblTimeAttendance.getRow(i);
            for (int col = 0; col < this.total_coll.size(); ++col) {
                info = this.total_coll.get(col);
                if (null == row.getCell(info.getId().toString()).getValue()) continue;
                int n = col;
                itemsValue[n] = itemsValue[n] + Double.parseDouble(row.getCell(info.getId().toString()).getValue().toString());
            }
        }
        int size = this.total_coll.size();
        for (i = 0; i < size; ++i) {
            info = this.total_coll.get(i);
            String id = info.getId().toString();
            totalRow.getCell(id).getStyleAttributes().setNumberFormat("0.00");
            totalRow.getCell(id).setValue((Object)this.df.format(itemsValue[i]));
        }
        KDTSortManager sortManager = new KDTSortManager(this.tblTimeAttendance);
        if (this.tblTimeAttendance.getRowCount() > 2) {
            sortManager.setSortAuto(true);
            TimeUtil.enableTableHeadSortNotNeedSortManager(this.tblTimeAttendance, 0, this.tblTimeAttendance.getRowCount() - 2, sortManager);
            this.tblTimeAttendance.setSortMange(sortManager);
        } else {
            sortManager.setSortAuto(false);
            this.tblTimeAttendance.setSortMange(sortManager);
        }
    }
}

