/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UIModelDialogFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.workflow.IWorkflowUIEnhancement;
import com.kingdee.eas.framework.client.workflow.IWorkflowUISupport;
import com.kingdee.eas.framework.client.workflow.WorkflowUtils;
import com.kingdee.eas.hr.time.ITimeBase;
import com.kingdee.eas.hr.time.TimeBaseException;
import com.kingdee.eas.hr.time.client.AbstractTimeBaseBillListUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public abstract class TimeBaseBillListUI
extends AbstractTimeBaseBillListUI {
    private static final String strResource = "com.kingdee.eas.hr.affair.HRAffairResource.";
    protected BOSUuid personId = null;
    protected boolean isAddNew = false;

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.isAddNew = true;
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.isAddNew = false;
        super.actionEdit_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.isAddNew = false;
        super.actionView_actionPerformed(e);
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected boolean isAllowDefaultSolutionNull() {
        return true;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id == null || id.trim().length() < 1) {
            return;
        }
        MultiApproveUtil.showApproveHis((BOSUuid)BOSUuid.read((String)id), (String)UIModelDialogFactory.class.getName(), (Object)((Object)this));
    }

    protected Object getCellValue(String colName) {
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block != null && block.getTop() != -1) {
            IRow row = this.tblMain.getRow(block.getTop());
            return row.getCell(colName).getValue();
        }
        return null;
    }

    protected boolean isEditable() throws Exception {
        boolean value = true;
        BizEnumValueInfo state = (BizEnumValueInfo)this.getCellValue("bizState");
        if (state == null) {
            value = true;
        } else if (state.getInt() != 0) {
            value = false;
            return value;
        }
        String proposerId = (String)this.getCellValue("proposer.id");
        Boolean isMulti = (Boolean)this.getCellValue("isMultiEntry");
        if (proposerId == null) {
            value = true;
        } else if (isMulti != null && !isMulti.booleanValue()) {
            value = proposerId.equals(this.personId.toString());
        }
        return value;
    }

    protected boolean isMultiEntry() {
        return (Boolean)this.getCellValue("isMultiEntry");
    }

    protected void setEditAction() throws Exception {
        if (!this.isEditable()) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        }
        this.setAuditAction();
        this.setEditRemotAction();
    }

    protected void setAuditAction() throws Exception {
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block != null && block.getTop() == -1) {
            return;
        }
        if (block == null) {
            this.actionAudit.setEnabled(false);
        } else {
            int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            IRow row = null;
            BizEnumValueInfo approveState = null;
            BizEnumValueInfo submitState = null;
            BizEnumValueInfo state = (BizEnumValueInfo)this.getCellValue("bizState");
            for (int i = 0; i < rows.length; ++i) {
                row = this.tblMain.getRow(rows[i]);
                state = (BizEnumValueInfo)row.getCell("bizState").getValue();
                if (state != null && state.getInt() != 0) {
                    this.actionAudit.setEnabled(false);
                    return;
                }
                approveState = (BizEnumValueInfo)row.getCell("approveState").getValue();
                submitState = (BizEnumValueInfo)row.getCell("submitState").getValue();
                if (approveState == null || approveState.getInt() != 0 || submitState.getInt() != 1) {
                    this.actionAudit.setEnabled(false);
                    return;
                }
                this.actionAudit.setEnabled(true);
            }
        }
    }

    private void setEditRemotAction() {
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block != null && block.getTop() == -1) {
            return;
        }
        if (block == null) {
            this.actionAudit.setEnabled(false);
        } else {
            int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            IRow row = null;
            BizEnumValueInfo approveState = null;
            BizEnumValueInfo submitState = null;
            BizEnumValueInfo state = (BizEnumValueInfo)this.getCellValue("bizState");
            for (int i = 0; i < rows.length; ++i) {
                row = this.tblMain.getRow(rows[i]);
                state = (BizEnumValueInfo)row.getCell("bizState").getValue();
                if (state != null && state.getInt() != 0 && state.getInt() != -1) {
                    this.actionEdit.setEnabled(false);
                    this.actionRemove.setEnabled(false);
                    return;
                }
                approveState = (BizEnumValueInfo)row.getCell("approveState").getValue();
                submitState = (BizEnumValueInfo)row.getCell("submitState").getValue();
                if (approveState != null && approveState.getInt() == 0) {
                    this.actionEdit.setEnabled(true);
                    this.actionRemove.setEnabled(true);
                    continue;
                }
                if (approveState != null && approveState.getInt() == 1) {
                    this.actionEdit.setEnabled(true);
                    this.actionRemove.setEnabled(true);
                    continue;
                }
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
                return;
            }
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.setEditAction();
    }

    protected void selectFirstRow() {
        super.selectFirstRow();
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        try {
            this.setEditAction();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAuditResult.setIcon(EASResource.getIcon((String)"imgTbtn_multapproveresult"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnWorkFlowG.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
    }

    public void onLoad() throws Exception {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        if (userInfo.getPerson() == null) {
            throw new TimeBaseException(TimeBaseException.USER_NO_MATCH_PERSON);
        }
        this.personId = userInfo.getPerson().getId();
        super.onLoad();
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.setColumnMoveable(true);
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList list = super.getSelectedIdValues();
        String[] ids = new String[list.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = list.get(i).toString();
        }
        ((ITimeBase)this.getBizInterface()).batchPassAudit(ids);
        this.showAuditSuccess();
        if (this.isPrepareActionAudit()) {
            this.prepareRefresh(null).callHandler();
        }
        this.actionRefresh_actionPerformed(e);
    }

    protected boolean confirmAudit() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.affair.HRAffairResource.Confirm_Audit")));
    }

    protected void showAuditSuccess() {
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.hr.affair.HRAffairResource.Msg_Audit_OK"));
        this.showMessage();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"Owner", (Object)this);
    }

    public void refresh() throws Exception {
        this.refresh(null);
        this.refreshList();
    }

    public final String getQueryFieldNameBindingWf() {
        if (this instanceof IWorkflowUISupport) {
            IWorkflowUIEnhancement enhancement = ((IWorkflowUISupport)this).getWorkflowUIEnhancement();
            return enhancement.getQueryFieldNameBindingWf((CoreUIObject)this);
        }
        return this.getKeyFieldNameForWF();
    }

    public void actionWorkflowG_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        WorkflowUtils.viewWorkFlowGraph((CoreUIObject)this, (String)id);
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionAudit() {
        return true;
    }

    public boolean isActionRefresh() {
        return true;
    }

    public boolean isPrepareActionRefresh() {
        return true;
    }

    public RequestContext prepareActionAudit(IItemAction itemAction) throws Exception {
        RequestContext req = super.prepareActionAudit(itemAction);
        ArrayList list = super.getSelectedIdValues();
        String[] ids = new String[list.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = list.get(i).toString();
        }
        req.put("ids", (Object)ids);
        return req;
    }
}

