/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.time.TimeBaseFacadeFactory;
import com.kingdee.util.LocaleUtils;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import java.util.Set;
import javax.swing.JTextField;

class TimeUtil {
    private static final String MULTI = "multi";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NUM = "number";
    private static final String LONG_NUMBER = "longNumber";
    private static final String CLASSNAME = "class";
    private static final long serialVersionUID = -61166L;

    TimeUtil() {
    }

    public static void saveData(CustomerParams params, Component comp) {
        if (params == null || comp == null) {
            return;
        }
        String keyName = comp.getName();
        if (comp instanceof KDDatePicker) {
            KDDatePicker ctrl = (KDDatePicker)comp;
            Date date = (Date)ctrl.getValue();
            if (date != null) {
                params.putDate(keyName, date);
            }
            return;
        }
        if (comp instanceof KDComboBox) {
            KDComboBox ctrl = (KDComboBox)comp;
            if (ctrl.getSelectedIndex() != -1) {
                params.putInt(keyName, ctrl.getSelectedIndex());
            }
            return;
        }
        if (comp instanceof KDTextField) {
            KDTextField ctrl = (KDTextField)comp;
            String text = ctrl.getText();
            if (text == null || "".equals(text.trim())) {
                return;
            }
            params.addCustomerParam(keyName, text.trim());
            return;
        }
        if (comp instanceof KDRadioButton) {
            KDRadioButton ctrl = (KDRadioButton)comp;
            if (ctrl.isSelected()) {
                params.addCustomerParam(keyName, "true");
            }
            return;
        }
        if (comp instanceof KDCheckBox) {
            KDCheckBox ctrl = (KDCheckBox)comp;
            if (ctrl.isSelected()) {
                params.addCustomerParam(keyName, "true");
            }
            return;
        }
        if (comp instanceof KDBizPromptBox) {
            KDBizPromptBox ctrl = (KDBizPromptBox)comp;
            Object obj = ctrl.getData();
            if (obj != null) {
                if (obj instanceof Object[]) {
                    Object[] array = (Object[])obj;
                    if (array.length > 0 && array[0] != null && array[0] instanceof DataBaseInfo) {
                        params.addCustomerParam(MULTI + keyName, "" + array.length);
                        DataBaseInfo info = null;
                        Object treeInfo = null;
                        for (int i = 0; i < array.length; ++i) {
                            info = (DataBaseInfo)array[i];
                            params.addCustomerParam(ID + i + keyName, info.getId().toString());
                            params.addCustomerParam("namel1" + i + keyName, info.getName(LocaleUtils.getLocale((String)"l1")));
                            params.addCustomerParam("namel2" + i + keyName, info.getName(LocaleUtils.getLocale((String)"l2")));
                            params.addCustomerParam("namel3" + i + keyName, info.getName(LocaleUtils.getLocale((String)"l3")));
                            params.addCustomerParam(NUM + i + keyName, info.getNumber());
                        }
                        params.addCustomerParam(CLASSNAME + keyName, info.getClass().getName());
                    }
                } else if (obj instanceof DataBaseInfo) {
                    DataBaseInfo info = (DataBaseInfo)obj;
                    params.addCustomerParam(ID + keyName, info.getId().toString());
                    params.addCustomerParam("namel1" + keyName, info.getName(LocaleUtils.getLocale((String)"l1")));
                    params.addCustomerParam("namel2" + keyName, info.getName(LocaleUtils.getLocale((String)"l2")));
                    params.addCustomerParam("namel3" + keyName, info.getName(LocaleUtils.getLocale((String)"l3")));
                    params.addCustomerParam(NUM + keyName, info.getNumber());
                    params.addCustomerParam(CLASSNAME + keyName, info.getClass().getName());
                    if (obj instanceof TreeBaseInfo) {
                        TreeBaseInfo treeInfo = (TreeBaseInfo)obj;
                        params.addCustomerParam(LONG_NUMBER + keyName, treeInfo.getLongNumber());
                    }
                }
            }
            return;
        }
    }

    public static void retriveData(CustomerParams params, Component comp) throws Exception {
        if (comp == null) {
            return;
        }
        String keyName = comp.getName();
        if (comp instanceof KDDatePicker) {
            KDDatePicker ctrl = (KDDatePicker)comp;
            ctrl.setValue((Object)params.getDate(keyName));
            return;
        }
        if (comp instanceof KDComboBox) {
            KDComboBox ctrl = (KDComboBox)comp;
            ctrl.setSelectedIndex(params.getInt(keyName));
            return;
        }
        if (comp instanceof KDTextField) {
            KDTextField ctrl = (KDTextField)comp;
            ctrl.setText(params.getCustomerParam(keyName));
            return;
        }
        if (comp instanceof KDRadioButton) {
            KDRadioButton ctrl = (KDRadioButton)comp;
            if (params.getCustomerParam(keyName) != null) {
                ctrl.setSelected(true);
            } else {
                ctrl.setSelected(false);
            }
            return;
        }
        if (comp instanceof KDCheckBox) {
            KDCheckBox ctrl = (KDCheckBox)comp;
            if (params.getCustomerParam(keyName) != null) {
                ctrl.setSelected(true);
            } else {
                ctrl.setSelected(false);
            }
            return;
        }
        if (comp instanceof KDBizPromptBox) {
            KDBizPromptBox ctrl = (KDBizPromptBox)comp;
            String className = params.getCustomerParam(CLASSNAME + keyName);
            if (className == null || "".equals(className.trim())) {
                return;
            }
            String multi = params.getCustomerParam(MULTI + keyName);
            TreeBaseInfo treeInfo = null;
            if (multi == null || "".equals(multi.trim())) {
                DataBaseInfo info = (DataBaseInfo)Class.forName(className).newInstance();
                info.setId(BOSUuid.read((String)params.getCustomerParam(ID + keyName)));
                info.setName(params.getCustomerParam("namel1" + keyName), LocaleUtils.getLocale((String)"l1"));
                info.setName(params.getCustomerParam("namel2" + keyName), LocaleUtils.getLocale((String)"l2"));
                info.setName(params.getCustomerParam("namel3" + keyName), LocaleUtils.getLocale((String)"l3"));
                info.setNumber(params.getCustomerParam(NUM + keyName));
                if (info instanceof TreeBaseInfo) {
                    treeInfo = (TreeBaseInfo)info;
                    treeInfo.setLongNumber(params.getCustomerParam(LONG_NUMBER + keyName));
                }
                ctrl.setData((Object)info);
                return;
            }
            int count = Integer.parseInt(multi);
            DataBaseInfo[] array = new DataBaseInfo[count];
            DataBaseInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (DataBaseInfo)Class.forName(className).newInstance();
                info.setId(BOSUuid.read((String)params.getCustomerParam(ID + i + keyName)));
                info.setName(params.getCustomerParam("namel1" + i + keyName), LocaleUtils.getLocale((String)"l1"));
                info.setName(params.getCustomerParam("namel2" + i + keyName), LocaleUtils.getLocale((String)"l2"));
                info.setName(params.getCustomerParam("namel3" + i + keyName), LocaleUtils.getLocale((String)"l3"));
                info.setNumber(params.getCustomerParam(NUM + i + keyName));
                if (info instanceof TreeBaseInfo) {
                    treeInfo = (TreeBaseInfo)info;
                    treeInfo.setLongNumber(params.getCustomerParam(LONG_NUMBER + i + keyName));
                }
                array[i] = info;
            }
            ctrl.setData((Object)array);
            return;
        }
    }

    public static void saveAllData(CustomerParams params, CustomerQueryPanel queryPanel) {
        Component comp = null;
        int n = queryPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            comp = queryPanel.getComponent(i);
            if (comp instanceof KDLabelContainer) {
                TimeUtil.saveData(params, ((KDLabelContainer)comp).getBoundEditor());
                continue;
            }
            TimeUtil.saveData(params, queryPanel.getComponent(i));
        }
    }

    public static CustomerParams saveAllData(CustomerQueryPanel queryPanel) {
        CustomerParams params = new CustomerParams();
        Component comp = null;
        int n = queryPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            comp = queryPanel.getComponent(i);
            if (comp instanceof KDLabelContainer) {
                TimeUtil.saveData(params, ((KDLabelContainer)comp).getBoundEditor());
                continue;
            }
            TimeUtil.saveData(params, queryPanel.getComponent(i));
        }
        return params;
    }

    public static void retriveAllData(CustomerParams params, CustomerQueryPanel queryPanel) {
        queryPanel.clear();
        if (params == null) {
            return;
        }
        try {
            Component comp = null;
            int n = queryPanel.getComponentCount();
            for (int i = 0; i < n; ++i) {
                comp = queryPanel.getComponent(i);
                if (comp instanceof KDLabelContainer) {
                    TimeUtil.retriveData(params, ((KDLabelContainer)comp).getBoundEditor());
                    continue;
                }
                TimeUtil.retriveData(params, comp);
            }
        }
        catch (Exception ex) {
            queryPanel.handUIException((Throwable)ex);
        }
    }

    public static void setEmpF7Option(EmployeeMultiF7PromptBox f7) {
        f7.setIsSingleSelect(false);
        f7.setModal(true);
        f7.setIsHRFilter(false);
        f7.setIsShowAllAdmin(true);
        f7.showNoPositionPerson(true);
    }

    public static void setDisableColor(KDTable table) {
        Color color = Color.LIGHT_GRAY;
        for (int i = 0; i < table.getColumnCount(); ++i) {
            IColumn column = table.getColumn(i);
            if (!column.getStyleAttributes().isLocked()) continue;
            column.getStyleAttributes().setBackground(color);
        }
    }

    public static int getSelectedRow(KDTable table) {
        KDTSelectBlock selectBlock = table.getSelectManager().get();
        return selectBlock.getTop();
    }

    public static FilterInfo getHRAndAdminRangeFilterInfo(String hrColumnName, String orgUnitColumnName) {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo(orgUnitColumnName, (Object)sql.toString(), CompareType.INNER);
        filter.getFilterItems().add(item);
        if (hrColumnName != null) {
            item = new FilterItemInfo(hrColumnName, (Object)hrOrgUnitID);
            filter.getFilterItems().add(item);
        }
        return filter;
    }

    public static boolean getParamValue(String number) throws Exception {
        String HRO_ID;
        IParamControl iParam = ParamControlFactory.getRemoteInstance();
        String val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(HRO_ID = SysContext.getSysContext().getCurrentHRUnit().getId().toString()), number);
        return "true".equals(val);
    }

    public static FilterInfo getAdminRangeFilterInfo(String orgUnitColumnName, String hrOrgUnitId) {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitId);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo(orgUnitColumnName, (Object)sql.toString(), CompareType.INNER);
        filter.getFilterItems().add(item);
        return filter;
    }

    public static FilterInfo getAdminRangePersonFilter(String colName) {
        if (colName == null || colName.trim().length() <= 0) {
            return new FilterInfo();
        }
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select person.FID from T_BD_PERSON person ");
        sql.append(" inner join t_hr_personPosition pp on person.fid = pp.fPersonId");
        sql.append(" where pp.fpersonDep in ( ");
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append("))");
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo(colName, (Object)sql.toString(), CompareType.INNER));
        return fi;
    }

    public static Set getAdminRangePersonIdSet() throws BOSException {
        return TimeBaseFacadeFactory.getRemoteInstance().getOutRangePersonIds();
    }

    public static void setKDTableUISort(KDTable table) {
        if (table == null) {
            return;
        }
        KDTSortManager sm = new KDTSortManager(table);
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            table.getColumn(i).setSortable(true);
        }
        sm.setSortAuto(true);
    }

    public static ICellEditor getFloatCellEditor(Comparable a, Comparable b, int precision) {
        KDFormattedTextField kft = new KDFormattedTextField();
        kft.setDataType(4);
        kft.setDataVerifierType(-1);
        kft.setPrecision(precision);
        kft.setMinimumValue(a);
        kft.setMaximumValue(b);
        return new KDTDefaultCellEditor((JTextField)kft);
    }

    public static Date getServerTime() throws BOSException {
        return TimeBaseFacadeFactory.getRemoteInstance().getServerTime();
    }

    public static KDTable enableTableHeadSortNotNeedSortManager(KDTable table, int indexBeginRow, int indexEndRow, KDTSortManager sm) {
        if (indexBeginRow < 0 || indexEndRow <= 0) {
            return table;
        }
        sm.setSortAuto(true);
        sm.clearGroup();
        sm.addGroup(indexBeginRow, indexEndRow);
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            table.getColumn(i).setSortable(true);
        }
        return table;
    }

    public static String getCustmerParamsUtil(QuerySolutionInfo solution, String panelClassName) {
        String returnSolution = "";
        int size = solution.getQueryPanelInfo().size();
        for (int i = 0; i < size; ++i) {
            if (solution.getQueryPanelInfo().get(i) == null) continue;
            QueryPanelInfo queryPanelInfo = solution.getQueryPanelInfo().get(i);
            if (!StringUtils.isEmpty((String)panelClassName) && panelClassName.equals(queryPanelInfo.getPanelClassName())) {
                returnSolution = queryPanelInfo.getCustomerParams();
            }
            if (!StringUtils.isEmpty((String)panelClassName) || StringUtils.isEmpty((String)queryPanelInfo.getCustomerParams())) continue;
            returnSolution = queryPanelInfo.getCustomerParams();
            break;
        }
        return returnSolution;
    }
}

