/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.IHRInit;
import com.kingdee.eas.hr.base.client.util.HRClientUtil;
import com.kingdee.eas.hr.emp.IUserPermission;
import com.kingdee.eas.hr.emp.UserPermissionCollection;
import com.kingdee.eas.hr.emp.UserPermissionFactory;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.time.ConvertMethodEnum;
import com.kingdee.eas.hr.time.ConvertTypeEnum;
import com.kingdee.eas.hr.time.IYearVacationBalance;
import com.kingdee.eas.hr.time.IYearVacationRule;
import com.kingdee.eas.hr.time.ObtainVacationDateEnum;
import com.kingdee.eas.hr.time.PrecisionTypeCarryEnum;
import com.kingdee.eas.hr.time.PrecisionTypeEnum;
import com.kingdee.eas.hr.time.ReservationTypeEnum;
import com.kingdee.eas.hr.time.ServiceYearTypeEnum;
import com.kingdee.eas.hr.time.UnitTypeEnum;
import com.kingdee.eas.hr.time.UseVacationDateEnum;
import com.kingdee.eas.hr.time.YVRuleException;
import com.kingdee.eas.hr.time.YearVacationBalanceFactory;
import com.kingdee.eas.hr.time.YearVacationCarryforwardInfo;
import com.kingdee.eas.hr.time.YearVacationPersonCollection;
import com.kingdee.eas.hr.time.YearVacationPersonFactory;
import com.kingdee.eas.hr.time.YearVacationPersonInfo;
import com.kingdee.eas.hr.time.YearVacationQuantityInfo;
import com.kingdee.eas.hr.time.YearVacationRuleFactory;
import com.kingdee.eas.hr.time.YearVacationRuleInfo;
import com.kingdee.eas.hr.time.client.AbstractYearVacationEditUI;
import com.kingdee.eas.hr.time.client.IProgTask;
import com.kingdee.eas.hr.time.client.ProgDialog;
import com.kingdee.eas.hr.time.util.TimeServerUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.IntEnum;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class YearVacationEditUI
extends AbstractYearVacationEditUI {
    private static Logger logger = Logger.getLogger(YearVacationEditUI.class);
    private static final long serialVersionUID = -3158950884675131214L;
    private static final String LIST = "list";
    private static final String RES = "com.kingdee.eas.hr.time.TimeResource";
    private YearVacationRuleInfo yearVacationRule = null;
    private String unitTypeString = null;
    private ArrayList delList = new ArrayList();
    private String selectedID = null;

    public void onLoad() throws Exception {
        HRClientUtil.checkCurrentHRUnitNotNull((CoreUI)this);
        this.initBaseInfo();
        this.initYearPerson();
        super.onLoad();
        this.kDLabel1.setText("<html><p><font size=3>" + EASResource.getString((String)RES, (String)"dateSpeak1") + "</font></p>" + "<p><font size=3>" + EASResource.getString((String)RES, (String)"dateSpeak2") + "</font></p>" + "<p><font size=3>" + EASResource.getString((String)RES, (String)"dateSpeak3") + "</font></p></html>");
    }

    protected void setThelper() {
        this.setQueryPreference(true);
    }

    protected boolean isOrderByIDForBill() {
        return false;
    }

    private void initBaseInfo() throws Exception {
        this.txtName.setSelectedLanguage(new LanguageInfo(SysContext.getSysContext().getLocale()));
        String title = this.resHelper.getString("pnlRight.border.title");
        this.unitTypeString = TimeServerUtils.getTimeAttendanceType(null);
        title = title.replaceFirst(title.substring(6, 7), this.unitTypeString);
        this.pnlRight.setBorder((Border)new TitledBorder(BorderFactory.createLineBorder(new Color(192, 192, 192), 1), title));
        String title1 = this.kDLabelContainer19.getBoundLabelText();
        title1 = title1.replaceAll(title1.substring(title1.length() - 2, title1.length() - 1), this.unitTypeString);
        this.kDLabelContainer19.setBoundLabelText(title1);
        String title2 = this.kDLabelContainer18.getBoundLabelText();
        title2 = title2.replaceAll(title2.substring(title2.length() - 2, title2.length() - 1), this.unitTypeString);
        this.kDLabelContainer18.setBoundLabelText(title2);
        SpinnerNumberModel model = (SpinnerNumberModel)this.spinnerPrecisionLength.getModel();
        model.setMaximum(Integer.valueOf(8));
        model.setMinimum(Integer.valueOf(0));
        model = (SpinnerNumberModel)this.kDSpinnerCarryPrecision.getModel();
        model.setMaximum(Integer.valueOf(8));
        model = (SpinnerNumberModel)this.kDSpinnerCarryPrecision.getModel();
        model.setMinimum(Integer.valueOf(0));
        model = (SpinnerNumberModel)this.kDSpinnerQuanAllDay.getModel();
        model.setMaximum(Integer.valueOf(31));
        model = (SpinnerNumberModel)this.kDSpinnerQuanAllDay.getModel();
        model.setMinimum(Integer.valueOf(0));
        this.kDSpinnerCarryPrecision.setValue((Object)2);
        this.kDSpinnerQuanAllDay.setValue((Object)0);
        this.spinnerPrecisionLength.setValue((Object)0);
        this.txtWorkTime.setDataType(4);
        this.txtWorkTime.setPrecision(1);
        this.txtWorkTime.setHorizontalAlignment(4);
        this.txtWorkTime.putClientProperty((Object)"OriginValue", (Object)Boolean.TRUE);
        this.txtWorkTime.setDataVerifierType(12);
        this.txtWorkTime.setMaximumValue((Comparable)new Float(24.0));
        this.txtWorkTime.setMinimumValue((Comparable)new Float(0.0));
        this.txtCarryObtainDays.setDataType(0);
        this.txtCarryObtainDays.setHorizontalAlignment(4);
        this.txtCarryObtainDays.putClientProperty((Object)"OriginValue", (Object)Boolean.TRUE);
        this.txtCarryObtainDays.setDataVerifierType(12);
        this.txtCarryObtainDays.setMaximumValue((Comparable)Integer.valueOf(1000));
        this.txtCarryObtainDays.setMinimumValue((Comparable)Integer.valueOf(0));
        this.txtCarryObtainDays.setGroupingUsed(false);
        this.txtCarryReservationValue.setDataType(4);
        this.txtCarryReservationValue.setPrecision(1);
        this.txtCarryReservationValue.setHorizontalAlignment(4);
        this.txtCarryReservationValue.putClientProperty((Object)"OriginValue", (Object)Boolean.TRUE);
        this.txtCarryReservationValue.setDataVerifierType(12);
        this.txtCarryReservationValue.setMaximumValue((Comparable)new Float(1000.0));
        this.txtCarryReservationValue.setMinimumValue((Comparable)new Float(0.0));
        this.txtCarryReservationValue.setGroupingUsed(false);
        this.tblAgeQuanSegment.checkParsed();
        String colName = this.tblAgeQuanSegment.getHeadRow(0).getCell("colCounts").getValue().toString();
        colName = colName.replaceFirst(colName.substring(2, 3), this.unitTypeString);
        this.tblAgeQuanSegment.getHeadRow(0).getCell("colCounts").setValue((Object)colName);
        KDFormattedTextField integerField = new KDFormattedTextField(0);
        integerField.setHorizontalAlignment(4);
        integerField.putClientProperty((Object)"OriginValue", (Object)Boolean.TRUE);
        integerField.setDataVerifierType(12);
        integerField.setMaximumValue((Comparable)Integer.valueOf(65535));
        integerField.setMinimumValue((Comparable)Integer.valueOf(0));
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)integerField);
        this.tblAgeQuanSegment.getColumn("colSegment").setEditor((ICellEditor)cellEditor);
        KDFormattedTextField floatField = new KDFormattedTextField(4);
        floatField.setPrecision(2);
        floatField.setMinimumValue((Comparable)new Float(0.0));
        floatField.setMaximumValue((Comparable)new Float(65535.0));
        this.tblAgeQuanSegment.getColumn("colCounts").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)floatField));
        this.tblAgeQuanSegment.getColumn("colSign").getStyleAttributes().setWeight(10.0f);
        this.loadAllEnumForComboBox();
        this.initSegmentTable();
        this.btnRadioQuanDay_stateChanged(null);
        this.btnRadioCarryNOTerm_stateChanged(null);
    }

    private void loadAllEnumForComboBox() {
        DefaultComboBoxModel<IntEnum> model = null;
        Iterator ter = null;
        ter = ObtainVacationDateEnum.iterator();
        model = new DefaultComboBoxModel<IntEnum>();
        while (ter.hasNext()) {
            model.addElement((ObtainVacationDateEnum)((Object)ter.next()));
        }
        this.cboObtainVacationDate.setModel(model);
        model = new DefaultComboBoxModel();
        ter = UseVacationDateEnum.iterator();
        while (ter.hasNext()) {
            model.addElement((UseVacationDateEnum)((Object)ter.next()));
        }
        this.cboUseVacationDate.setModel(model);
        model = new DefaultComboBoxModel();
        ter = ConvertMethodEnum.iterator();
        while (ter.hasNext()) {
            model.addElement((ConvertMethodEnum)((Object)ter.next()));
        }
        this.cboQuanMonths.setModel(model);
        model = new DefaultComboBoxModel();
        ter = ServiceYearTypeEnum.iterator();
        while (ter.hasNext()) {
            model.addElement((ServiceYearTypeEnum)((Object)ter.next()));
        }
        this.cboServiceYearType.setModel(model);
        model = new DefaultComboBoxModel();
        ter = PrecisionTypeCarryEnum.iterator();
        while (ter.hasNext()) {
            model.addElement((PrecisionTypeCarryEnum)((Object)ter.next()));
        }
        this.cboCarryPrecisionType.setModel(model);
        model = new DefaultComboBoxModel();
        ter = ReservationTypeEnum.iterator();
        while (ter.hasNext()) {
            model.addElement((ReservationTypeEnum)((Object)ter.next()));
        }
        this.cboCarryReservationType.setModel(model);
        DefaultComboBoxModel<String> modelSign = new DefaultComboBoxModel<String>();
        modelSign.addElement("<=");
        modelSign.addElement("<");
        modelSign.addElement("=");
        KDComboBox combo = new KDComboBox(modelSign);
        this.tblAgeQuanSegment.getColumn("colSign").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)combo));
    }

    private void initYearPerson() throws Exception {
        this.tblPerson.checkParsed();
        this.tblPerson.getSelectManager().setSelectMode(10);
        this.tblPerson.getStyleAttributes().setLocked(true);
        KDTSortManager sortManager = new KDTSortManager(this.tblPerson);
        sortManager.setSortAuto(true);
        this.tblPerson.setSortMange(sortManager);
        int n = this.tblPerson.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.tblPerson.getColumn(i).setSortable(true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemAddNew.setEnabled(true);
        this.menuItemEdit.setEnabled(true);
        this.menuItemRemove.setEnabled(true);
        this.setButtonDefaultStyl(this.btnSave);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemInitRule.setIcon(EASResource.getIcon((String)"imgTbtn_ruleinitialize"));
    }

    private void setInitState() throws Exception {
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
            this.diplayViewData();
        } else {
            this.setOprtState(OprtState.ADDNEW);
            this.createNewData();
            this.loadFields();
            this.btnRadioQuanDay_stateChanged(null);
            this.btnRadioCarryNOTerm_stateChanged(null);
            this.btnSave.setEnabled(true);
        }
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        try {
            this.setInitState();
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
    }

    private void initSegmentTable() throws Exception {
        this.tblAgeQuanSegment.checkParsed();
        this.btnRadionQuanMonth_stateChanged(null);
        this.btnRadioCarryNOTerm_stateChanged(null);
    }

    private void createNewData() {
        this.yearVacationRule = new YearVacationRuleInfo();
        YearVacationQuantityInfo quantityInfo = new YearVacationQuantityInfo();
        quantityInfo.setObtainVacationDate(ObtainVacationDateEnum.ENTER_DATE);
        quantityInfo.setUseVacationDate(UseVacationDateEnum.ENTER_DATE);
        quantityInfo.setWorkTime(0.0f);
        quantityInfo.setVacationStartDate("01/01");
        quantityInfo.setServiceYearType(ServiceYearTypeEnum.COMPANY_YEARS);
        quantityInfo.setPrecisionLength(0);
        quantityInfo.setPrecisionType(PrecisionTypeEnum.EVERY_DAY);
        quantityInfo.setConvertTypeValue(0);
        quantityInfo.setConvertType(ConvertTypeEnum.EQUAL_DAY);
        this.yearVacationRule.setQuantity(quantityInfo);
        YearVacationCarryforwardInfo carryInfo = new YearVacationCarryforwardInfo();
        carryInfo.setReservationType(ReservationTypeEnum.FIX_DAYS);
        carryInfo.setPrecisionType(PrecisionTypeCarryEnum.FOUR_AND_FIVE);
        carryInfo.setAbandonDate(null);
        carryInfo.setObtainDays(0);
        carryInfo.setReservationValue(Float.valueOf("0").floatValue());
        this.yearVacationRule.setCarryforward(carryInfo);
    }

    public void loadFields() {
        try {
            this.txtNumber.setText(this.yearVacationRule.getNumber());
            UIHelper.loadMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)this.yearVacationRule, (String)"name");
            this.txtDesrc.setText(this.yearVacationRule.getDescription());
            this.loadQuantityFields(this.yearVacationRule.getQuantity());
            this.loadCarryforwardFields(this.yearVacationRule.getCarryforward());
            this.loadYVPersonFields(this.yearVacationRule);
            if (this.getOprtState().equals(LIST)) {
                this.setPanelIsEnabled(false);
            } else {
                this.setPanelIsEnabled(true);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private void loadQuantityFields(YearVacationQuantityInfo quantityInfo) {
        if (quantityInfo == null) {
            return;
        }
        if (quantityInfo.getVacationStartDate() == null) {
            this.txtVacationStartDate.setText("");
        } else {
            this.txtVacationStartDate.setText(quantityInfo.getVacationStartDate());
        }
        this.cboObtainVacationDate.setSelectedItem((Object)quantityInfo.getObtainVacationDate());
        this.cboUseVacationDate.setSelectedItem((Object)quantityInfo.getUseVacationDate());
        this.txtWorkTime.setValue((Object)new Float(quantityInfo.getWorkTime()));
        if (quantityInfo.getPrecisionType() == PrecisionTypeEnum.EVERY_MONTH) {
            this.btnRadionQuanMonth.setSelected(true);
            this.btnRadioQuanDay.setSelected(false);
            if (quantityInfo.getConvertType() == ConvertTypeEnum.EQUAL_DAY) {
                this.btnRadioQuanAllDay.setSelected(true);
                this.btnRadioQuanMorths.setSelected(false);
            } else {
                this.btnRadioQuanAllDay.setSelected(false);
                this.btnRadioQuanMorths.setSelected(true);
            }
        } else {
            this.btnRadionQuanMonth.setSelected(false);
            this.btnRadioQuanDay.setSelected(true);
        }
        if (quantityInfo.getConvertType() != null && quantityInfo.getConvertType().getValue() == 10) {
            this.kDSpinnerQuanAllDay.setValue((Object)quantityInfo.getConvertTypeValue());
            this.btnRadioQuanAllDay.setSelected(true);
        } else if (quantityInfo.getConvertTypeValue() == 20) {
            this.cboQuanMonths.setSelectedItem((Object)ConvertMethodEnum.EVERY_DAY);
            this.kDSpinnerQuanAllDay.setValue((Object)0);
        } else {
            this.cboQuanMonths.setSelectedItem((Object)ConvertMethodEnum.STANDARD_DAY);
        }
        this.spinnerPrecisionLength.setValue((Object)quantityInfo.getPrecisionLength());
        this.kDCheckBox1.setSelected(quantityInfo.isIsChecked());
        this.cboServiceYearType.setSelectedItem((Object)quantityInfo.getServiceYearType());
        this.loadSegmentTable(quantityInfo.getServiceYearSet());
    }

    private void loadSegmentTable(String str) {
        if (str == null || str.equals("")) {
            this.tblAgeQuanSegment.removeRows();
            return;
        }
        this.tblAgeQuanSegment.removeRows();
        String[] items = str.split("&");
        IRow curRow = null;
        String[] subItems = null;
        String[] subItemss = null;
        for (int i = 0; i < items.length; ++i) {
            curRow = this.tblAgeQuanSegment.addRow();
            subItems = items[i].split("=");
            if (subItems.length == 2 && items[i].indexOf("_") == -1) {
                curRow.getCell("colSign").setValue((Object)"<=");
                curRow.getCell("colSegment").setValue((Object)Integer.valueOf(subItems[0].trim()));
                curRow.getCell("colCounts").setValue((Object)new Float(subItems[1].trim()));
            }
            if (items[i].indexOf("_") == -1 || (subItemss = items[i].split("_")).length != 3) continue;
            if (subItemss[0].trim().equals("==")) {
                curRow.getCell("colSign").setValue((Object)"=");
            } else {
                curRow.getCell("colSign").setValue((Object)subItemss[0].trim());
            }
            curRow.getCell("colSegment").setValue((Object)Integer.valueOf(subItemss[1].trim()));
            curRow.getCell("colCounts").setValue((Object)new Float(subItemss[2].trim()));
        }
        Interpreter interpreter = new Interpreter();
        HashMap<String, Float> context = new HashMap<String, Float>();
        context.put(LIST, new Float(2.3));
        String text = "if(list<1){return 5.5;}if(list<3){return 7.6;}if(list<5){return 10.2;}";
        try {
            interpreter.eval(text, context);
        }
        catch (InterpreterException e) {
            logger.error((Object)e.getMessage());
        }
        catch (ParserException e) {
            logger.error((Object)e.getMessage());
        }
    }

    private void loadCarryforwardFields(YearVacationCarryforwardInfo vyCarryInfo) {
        if (vyCarryInfo == null) {
            return;
        }
        if (vyCarryInfo.isIsAbandon()) {
            this.btnRadioCarryNOTerm.setSelected(false);
            this.btnRadioCarryYesTerm.setSelected(true);
            this.cboCarryReservationType.setSelectedItem((Object)vyCarryInfo.getReservationType());
            this.txtCarryReservationValue.setValue((Object)new Float(vyCarryInfo.getReservationValue()));
            this.txtCarryAbandonDate.setText(vyCarryInfo.getAbandonDate());
            this.txtCarryObtainDays.setValue((Object)0);
            this.kDSpinnerCarryPrecision.setValue((Object)0);
            this.cboCarryPrecisionType.setSelectedItem((Object)PrecisionTypeEnum.EVERY_DAY);
        } else {
            this.btnRadioCarryNOTerm.setSelected(true);
            this.btnRadioCarryYesTerm.setSelected(false);
            this.txtCarryObtainDays.setValue((Object)vyCarryInfo.getObtainDays());
            this.kDSpinnerCarryPrecision.setValue((Object)vyCarryInfo.getPrecision());
            this.cboCarryPrecisionType.setSelectedItem((Object)vyCarryInfo.getPrecisionType());
            this.cboCarryReservationType.setSelectedItem((Object)ReservationTypeEnum.FIX_DAYS);
            this.txtCarryReservationValue.setValue((Object)new Float("0.0"));
            this.txtCarryAbandonDate.setText(null);
        }
    }

    private void setPanelIsEnabled(boolean isEnabled) {
        this.btnRadioCarryNOTerm.setEnabled(isEnabled);
        this.btnRadioCarryYesTerm.setEnabled(isEnabled);
        this.btnRadionQuanMonth.setEnabled(isEnabled);
        this.btnRadioQuanAllDay.setEnabled(isEnabled);
        this.btnRadioQuanDay.setEnabled(isEnabled);
        this.btnRadioQuanMorths.setEnabled(isEnabled);
        this.txtCarryAbandonDate.setEnabled(isEnabled);
        this.txtCarryReservationValue.setEnabled(isEnabled);
        this.txtDesrc.setEnabled(isEnabled);
        this.txtName.setEnabled(isEnabled);
        this.txtNumber.setEnabled(isEnabled);
        this.txtWorkTime.setEnabled(isEnabled);
        this.tblAgeQuanSegment.setEnabled(isEnabled);
        this.tblPerson.setEnabled(isEnabled);
        this.btnWorkInsert.setEnabled(isEnabled);
        this.btnWorkDelete.setEnabled(isEnabled);
        this.btnWorkDeleteYear.setEnabled(isEnabled);
        this.btnWorkInsertYear.setEnabled(isEnabled);
        this.spinnerPrecisionLength.setEnabled(isEnabled);
        this.kDCheckBox1.setEnabled(isEnabled);
        this.kDSpinnerCarryPrecision.setEnabled(isEnabled);
        this.kDSpinnerQuanAllDay.setEnabled(isEnabled);
        this.cboCarryPrecisionType.setEnabled(isEnabled);
        this.cboCarryReservationType.setEnabled(isEnabled);
        this.cboObtainVacationDate.setEnabled(isEnabled);
        this.cboQuanMonths.setEnabled(isEnabled);
        this.cboServiceYearType.setEnabled(isEnabled);
        this.cboUseVacationDate.setEnabled(isEnabled);
        this.txtCarryObtainDays.setEnabled(isEnabled);
    }

    private void storeSegment() {
        YearVacationQuantityInfo quantityInfo = this.yearVacationRule.getQuantity();
        StringBuffer strBuffer = new StringBuffer();
        String strSegment = null;
        String strCounts = null;
        String colSign = null;
        int n = this.tblAgeQuanSegment.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (this.tblAgeQuanSegment.getRow(i).getCell("colSegment").getValue() == null || this.tblAgeQuanSegment.getRow(i).getCell("colCounts").getValue() == null) continue;
            strSegment = this.tblAgeQuanSegment.getRow(i).getCell("colSegment").getValue().toString();
            strCounts = this.tblAgeQuanSegment.getRow(i).getCell("colCounts").getValue().toString();
            colSign = this.tblAgeQuanSegment.getRow(i).getCell("colSign").getValue().toString();
            if (strSegment.trim().equals("") || strCounts.trim().equals("")) continue;
            if (colSign.trim().equals("=")) {
                strBuffer.append("== _ ");
            } else {
                strBuffer.append(colSign + " _ ");
            }
            strBuffer.append(strSegment + " _ " + strCounts);
            strBuffer.append(" & ");
        }
        quantityInfo.setServiceYearSet(strBuffer.toString().trim());
    }

    private void loadPersons(YearVacationRuleInfo ruleInfo) throws BOSException {
        YearVacationPersonCollection yearVactionPersonColl = ruleInfo.getPersons();
        yearVactionPersonColl.clear();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("yvRule.id", (Object)ruleInfo.getId().toString()));
        viewInfo.setFilter(filter);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.time.app", "YearPersonQuery");
        IQueryExecutor iqexec = this.getQueryExecutor((IMetaDataPK)queryPK, viewInfo);
        IRowSet rowSet = iqexec.executeQuery();
        YearVacationPersonInfo yearVactationPersonInfo = null;
        PersonInfo person = null;
        String ID = null;
        String personID = null;
        String gender = null;
        try {
            while (rowSet.next()) {
                yearVactationPersonInfo = new YearVacationPersonInfo();
                ID = rowSet.getString("id");
                yearVactationPersonInfo.setId(BOSUuid.read((String)ID));
                personID = rowSet.getString("person.id");
                person = new PersonInfo();
                person.setId(BOSUuid.read((String)personID));
                person.put("primaryAdminOrg", (Object)rowSet.getString("AdminOrgUnit.displayName"));
                person.put("primaryPosition", (Object)rowSet.getString("Position.name"));
                person.put("YVId", (Object)rowSet.getString("id"));
                person.put("YVName", (Object)rowSet.getString("yvRule.name"));
                person.put("YVNumber", (Object)rowSet.getString("yvRule.number"));
                person.setNumber(rowSet.getString("person.number"));
                person.setName(rowSet.getString("person.name"));
                gender = rowSet.getString("person.gender");
                if (gender != null) {
                    if (Genders.Male.toString().equals(gender)) {
                        person.setGender(Genders.Male);
                    } else {
                        person.setGender(Genders.Female);
                    }
                }
                yearVactationPersonInfo.setPerson(person);
                yearVactationPersonInfo.setYvRule(ruleInfo);
                yearVactionPersonColl.add(yearVactationPersonInfo);
            }
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
    }

    private void loadYVPersonFields(YearVacationRuleInfo ruleInfo) throws Exception {
        this.tblPerson.removeRows();
        YearVacationPersonCollection yearVactionPersonColl = ruleInfo.getPersons();
        if (yearVactionPersonColl == null || yearVactionPersonColl.size() == 0) {
            return;
        }
        int counts = yearVactionPersonColl.size();
        YearVacationPersonInfo yvPersonInfo = null;
        PersonInfo person = null;
        IRow curRow = null;
        for (int i = 0; i < counts; ++i) {
            yvPersonInfo = yearVactionPersonColl.get(i);
            person = yvPersonInfo.getPerson();
            curRow = this.tblPerson.addRow();
            curRow.getCell("itemId").setValue((Object)yvPersonInfo.getId());
            curRow.getCell("id").setValue((Object)person.getId().toString());
            curRow.getCell("colNumber").setValue((Object)person.getNumber());
            curRow.getCell("colName").setValue((Object)person.getName());
            curRow.getCell("colSex").setValue((Object)person.getGender());
            curRow.getCell("colOrg").setValue(person.get("primaryAdminOrg"));
            curRow.getCell("colPosition").setValue(person.get("primaryPosition"));
            curRow.getCell("colSourceID").setValue(person.get("YVId"));
            curRow.getCell("colSourceName").setValue(person.get("YVName"));
            curRow.getCell("colSourceNumber").setValue(person.get("YVNumber"));
        }
    }

    private PersonCollection getPersonYVInfo(PersonCollection pInfos) throws Exception {
        PersonInfo newInfo = null;
        HashMap<String, String> personToCollectionMap = new HashMap<String, String>();
        HashSet<String> set = new HashSet<String>();
        int n = pInfos.size();
        for (int i = 0; i < n; ++i) {
            newInfo = pInfos.get(i);
            personToCollectionMap.put(newInfo.getId().toString(), "" + i);
            set.add(newInfo.getId().toString());
            newInfo.put("YVName", null);
            newInfo.put("YVId", null);
            newInfo.put("YVNumber", null);
            newInfo.put("yvRuleId", null);
            pInfos.add(newInfo);
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.time.app", "PersonToYVQuery");
        IRowSet rowSet = null;
        if (set.size() < 500) {
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("person.id", set, CompareType.INCLUDE));
            evi.setFilter(fi);
            exec.setObjectView(evi);
            rowSet = exec.executeQuery();
        } else {
            IYearVacationBalance iyvBalance = YearVacationBalanceFactory.getRemoteInstance();
            rowSet = iyvBalance.getSelectPersonRowSet("com.kingdee.eas.hr.time.app.PersonToYVQuery", set, "person.id");
        }
        String personId = null;
        while (rowSet.next()) {
            personId = rowSet.getString("person.id");
            newInfo = pInfos.get(Integer.parseInt(personToCollectionMap.get(personId).toString()));
            newInfo.put("YVName", (Object)rowSet.getString("yvRule.name"));
            newInfo.put("YVId", (Object)rowSet.getString("id"));
            newInfo.put("YVNumber", (Object)rowSet.getString("yvRule.number"));
            newInfo.put("yvRuleId", (Object)rowSet.getString("yvRule.id"));
        }
        return pInfos;
    }

    private void storeYVPersonFields() {
        YearVacationPersonCollection yearPersonColl = this.yearVacationRule.getPersons();
        try {
            int i;
            YearVacationPersonInfo yvPersonInfo = null;
            int n = this.tblPerson.getRowCount();
            for (i = 0; i < n; ++i) {
                if (this.tblPerson.getRow(i).getCell("itemId").getValue() != null) continue;
                yvPersonInfo = new YearVacationPersonInfo();
                PersonInfo personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)this.tblPerson.getRow(i).getCell("id").getValue().toString()));
                if (this.tblPerson.getRow(i).getCell("colSourceID").getValue() != null) {
                    personInfo.put("YVId", (Object)this.tblPerson.getRow(i).getCell("colSourceID").getValue().toString());
                } else {
                    personInfo.put("YVId", null);
                }
                yvPersonInfo.setPerson(personInfo);
                yearPersonColl.add(yvPersonInfo);
            }
            for (i = 0; i < this.delList.size(); ++i) {
                for (int j = 0; j < yearPersonColl.size(); ++j) {
                    if (yearPersonColl.get(j).getId() == null || !((String)this.delList.get(i)).equals(yearPersonColl.get(j).getId().toString())) continue;
                    yearPersonColl.removeObject(j);
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void storeYVCarryforwardFields() {
        YearVacationCarryforwardInfo carryInfo = this.yearVacationRule.getCarryforward();
        if (this.btnRadioCarryNOTerm.isSelected()) {
            carryInfo.setIsAbandon(Boolean.FALSE);
            String ObtainDays = null;
            if (this.txtCarryObtainDays.getText() != null && this.txtCarryObtainDays.getText().trim().length() > 0) {
                ObtainDays = this.txtCarryObtainDays.getText();
                if (ObtainDays.indexOf(".") != -1) {
                    ObtainDays = ObtainDays.substring(0, this.txtCarryObtainDays.getText().indexOf("."));
                }
                carryInfo.setObtainDays(Integer.parseInt(ObtainDays));
            } else {
                carryInfo.setObtainDays(Integer.parseInt("0"));
            }
            carryInfo.setPrecision(this.kDSpinnerCarryPrecision.getIntegerVlaue());
            carryInfo.setPrecisionType((PrecisionTypeCarryEnum)((Object)this.cboCarryPrecisionType.getSelectedItem()));
        } else {
            carryInfo.setIsAbandon(Boolean.TRUE);
            carryInfo.setAbandonDate(this.txtCarryAbandonDate.getText());
            carryInfo.setReservationType((ReservationTypeEnum)((Object)this.cboCarryReservationType.getSelectedItem()));
            if (this.txtCarryReservationValue.getText() != null && !this.txtCarryReservationValue.getText().equals("") && this.txtCarryReservationValue.getText().trim().length() != 0) {
                carryInfo.setReservationValue(Float.parseFloat(this.txtCarryReservationValue.getText()));
            } else {
                carryInfo.setReservationValue(Float.parseFloat("0"));
            }
        }
    }

    public void storeFields() {
        this.storeYVPersonFields();
    }

    private void storeYVQuantityFields() {
        YearVacationQuantityInfo quantityInfo = this.yearVacationRule.getQuantity();
        quantityInfo.setVacationStartDate(this.txtVacationStartDate.getText());
        quantityInfo.setObtainVacationDate((ObtainVacationDateEnum)((Object)this.cboObtainVacationDate.getSelectedItem()));
        quantityInfo.setUseVacationDate((UseVacationDateEnum)((Object)this.cboUseVacationDate.getSelectedItem()));
        if (this.txtWorkTime.getText() == null || this.txtWorkTime.getText().trim().length() == 0) {
            quantityInfo.setWorkTime(Float.parseFloat("0"));
        } else {
            quantityInfo.setWorkTime(Float.parseFloat(this.txtWorkTime.getText()));
        }
        if (this.btnRadionQuanMonth.isSelected()) {
            quantityInfo.setPrecisionType(PrecisionTypeEnum.EVERY_MONTH);
            if (this.btnRadioQuanAllDay.isSelected()) {
                quantityInfo.setConvertType(ConvertTypeEnum.EQUAL_DAY);
                quantityInfo.setConvertTypeValue(this.kDSpinnerQuanAllDay.getIntegerVlaue());
            } else {
                quantityInfo.setConvertType(ConvertTypeEnum.CONVERT_MONTHS);
                quantityInfo.setConvertTypeValue(((ConvertMethodEnum)((Object)this.cboQuanMonths.getSelectedItem())).getValue());
            }
        } else {
            quantityInfo.setConvertType(ConvertTypeEnum.CONVERT_MONTHS);
            quantityInfo.setConvertTypeValue(0);
            quantityInfo.setPrecisionType(PrecisionTypeEnum.EVERY_DAY);
        }
        quantityInfo.setPrecisionLength(this.spinnerPrecisionLength.getIntegerVlaue());
        quantityInfo.setIsChecked(this.kDCheckBox1.isSelected());
        quantityInfo.setServiceYearType((ServiceYearTypeEnum)((Object)this.cboServiceYearType.getSelectedItem()));
        this.storeSegment();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) {
        if (this.getSelectedKeyValue() != null) {
            this.btnSave.setEnabled(false);
            try {
                this.diplayViewData();
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
    }

    private void diplayViewData() throws Exception {
        this.setOprtState(LIST);
        this.btnSave.setEnabled(false);
        this.actionSave.setEnabled(false);
        this.actionAddNew.setEnabled(true);
        this.actionEdit.setEnabled(true);
        this.actionRemove.setEnabled(true);
        this.getSelectRuleValue();
        this.loadFields();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.setOprtState(OprtState.ADDNEW);
        this.btnSave.setEnabled(true);
        this.actionInitRule.setEnabled(false);
        this.createNewData();
        this.loadFields();
        this.btnRadioQuanDay_stateChanged(null);
        this.btnRadioCarryNOTerm_stateChanged(null);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.diplayViewData();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.setOprtState(OprtState.EDIT);
        this.actionSave.setEnabled(true);
        this.actionEdit.setEnabled(false);
        this.btnSave.setEnabled(true);
        this.btnEdit.setEnabled(false);
        this.getSelectRuleValue();
        this.loadFields();
        this.btnRadioQuanMorths_stateChanged(null);
        this.btnRadioCarryNOTerm_stateChanged(null);
        this.btnRadioCarryYesTerm_stateChanged(null);
        this.btnRadioQuanAllDay_stateChanged(null);
        this.btnRadioQuanDay_stateChanged(null);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        if (this.getSelectedKeyValue() != null) {
            this.diplayViewData();
        } else {
            this.setOprtState(OprtState.ADDNEW);
            this.createNewData();
            this.loadFields();
            this.btnRadioQuanDay_stateChanged(null);
            this.btnRadioCarryNOTerm_stateChanged(null);
        }
    }

    private void getSelectRuleValue() throws BOSException, EASBizException {
        String id = super.getSelectedKeyValue();
        if (id != null) {
            IYearVacationRule iRule = YearVacationRuleFactory.getRemoteInstance();
            this.yearVacationRule = iRule.getSimpleValue(id);
            if (this.yearVacationRule != null) {
                this.loadPersons(this.yearVacationRule);
            }
            this.actionInitRule.setEnabled(true);
        } else {
            this.actionInitRule.setEnabled(false);
        }
        this.selectedID = id;
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.yearVacationRule.setNumber(this.txtNumber.getText());
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)this.yearVacationRule, (String)"name");
        this.yearVacationRule.setDescription(this.txtDesrc.getText());
        this.storeYVQuantityFields();
        this.storeYVCarryforwardFields();
        this.checkInput();
        this.storeFields();
        IYearVacationRule iRule = YearVacationRuleFactory.getRemoteInstance();
        if (this.yearVacationRule != null && this.yearVacationRule.getId() != null && this.getOprtState().equals(OprtState.EDIT)) {
            iRule.update((IObjectPK)new ObjectUuidPK(this.yearVacationRule.getId()), (CoreBaseInfo)this.yearVacationRule);
        } else if (this.yearVacationRule != null) {
            this.yearVacationRule.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
            IObjectPK pk = iRule.addnew((CoreBaseInfo)this.yearVacationRule);
            this.yearVacationRule.setId(BOSUuid.read((String)pk.toString()));
        }
        this.showSubmitSuccess();
        this.setOprtState(LIST);
        this.actionSave.setEnabled(false);
        this.actionEdit.setEnabled(true);
        this.btnSave.setEnabled(false);
        this.btnEdit.setEnabled(true);
        this.refreshList();
        this.setPanelIsEnabled(false);
    }

    private void checkInput() throws YVRuleException {
        if (this.yearVacationRule == null) {
            return;
        }
        if (this.yearVacationRule.getNumber() == null || this.yearVacationRule.getNumber().length() == 0) {
            throw new YVRuleException(YVRuleException.RULE_NUMBER_NOT_NULL);
        }
        if (this.yearVacationRule.getName() == null || this.yearVacationRule.getName().length() == 0) {
            throw new YVRuleException(YVRuleException.RULE_NAME_NOT_NULL);
        }
        if (this.yearVacationRule.getQuantity() == null || this.yearVacationRule.getQuantity().getVacationStartDate() == null || this.yearVacationRule.getQuantity().getVacationStartDate().length() == 0 || this.yearVacationRule.getQuantity().getVacationStartDate().equals("/")) {
            throw new YVRuleException(YVRuleException.STARTDATE_NOT_NULL);
        }
        if (this.yearVacationRule.getQuantity() == null || this.yearVacationRule.getQuantity().getObtainVacationDate() == null) {
            throw new YVRuleException(YVRuleException.YV_STARTDATE_NOT_NULL);
        }
        if (this.yearVacationRule.getQuantity() == null || this.yearVacationRule.getQuantity().getObtainVacationDate() == null) {
            throw new YVRuleException(YVRuleException.VACATIONDATE_NOT_NULL);
        }
        if (this.yearVacationRule.getQuantity() == null || this.yearVacationRule.getQuantity().getUseVacationDate() == null) {
            throw new YVRuleException(YVRuleException.UV_DATE_NOT_NULL);
        }
        if (this.spinnerPrecisionLength.getValue() == null) {
            throw new YVRuleException(YVRuleException.PRECISIONLENGTH_NOT_NULL);
        }
        if (this.txtCarryAbandonDate.isEnabled() && this.txtCarryAbandonDate != null) {
            String abandonDate = this.txtCarryAbandonDate.getText();
            this.verifyCarryAbandonDate(abandonDate);
        }
        this.checkTableInput();
    }

    private void verifyCarryAbandonDate(String abandonDate) throws YVRuleException {
        if (abandonDate.trim().length() > 0) {
            String afterStr;
            int index = abandonDate.indexOf("/");
            if (index < 1) {
                throw new YVRuleException(YVRuleException.CARRYABANDONDATE_WRONG);
            }
            if (index != abandonDate.lastIndexOf("/") || index == abandonDate.length() - 1) {
                throw new YVRuleException(YVRuleException.CARRYABANDONDATE_WRONG);
            }
            String frontStr = abandonDate.substring(0, index);
            String str = frontStr.concat(afterStr = abandonDate.substring(index + 1));
            if (!this.isNumeric(str)) {
                throw new YVRuleException(YVRuleException.CARRYABANDONDATE_WRONG);
            }
            int month = Integer.parseInt(frontStr);
            this.verifyMonth(month);
            int day = Integer.parseInt(afterStr);
            this.verifyDay(month, day);
        }
    }

    private boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    private void verifyMonth(int month) throws YVRuleException {
        if (month < 1 || month > 12) {
            throw new YVRuleException(YVRuleException.CARRYABANDONDATE_WRONG);
        }
    }

    private void verifyDay(int month, int day) throws YVRuleException {
        if (day < 1 || day > 31) {
            throw new YVRuleException(YVRuleException.CARRYABANDONDATE_WRONG);
        }
        if (month == 2 && day > 29) {
            throw new YVRuleException(YVRuleException.CARRYABANDONDATE_WRONG);
        }
        if ((month == 4 || month == 6 || month == 9 || month == 11) && day > 30) {
            throw new YVRuleException(YVRuleException.CARRYABANDONDATE_WRONG);
        }
    }

    public void beforeActionPerformed(ActionEvent e) {
        try {
            super.beforeActionPerformed(e);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void checkTableInput() throws YVRuleException {
        int counts = this.tblAgeQuanSegment.getRowCount();
        if (counts == 0) {
            throw new YVRuleException(YVRuleException.MUST_ONE_ROW_SEGMENT);
        }
        BigDecimal segCounts = null;
        BigDecimal iCounts = null;
        BigDecimal segOldCounts = null;
        for (int i = 0; i < counts; ++i) {
            if (this.tblAgeQuanSegment.getRow(i).getCell("colSegment").getValue() != null && this.tblAgeQuanSegment.getRow(i).getCell("colCounts").getValue() != null) {
                segCounts = new BigDecimal(this.tblAgeQuanSegment.getRow(i).getCell("colSegment").getValue().toString());
                iCounts = new BigDecimal(this.tblAgeQuanSegment.getRow(i).getCell("colCounts").getValue().toString());
                if (segCounts.compareTo(new BigDecimal("999")) > 0) {
                    throw new YVRuleException(YVRuleException.SEGMENT_NOT_RIGHT);
                }
                if (this.unitTypeString.equals(UnitTypeEnum.DAY.toString())) {
                    if (iCounts.compareTo(new BigDecimal("100")) > 0) {
                        throw new YVRuleException(YVRuleException.GET_DAYS_TIMES);
                    }
                } else if (iCounts.compareTo(new BigDecimal("800")) > 0) {
                    throw new YVRuleException(YVRuleException.EXCEPTION17, new Object[]{this.unitTypeString, "800"});
                }
                if (i == 0) continue;
                segOldCounts = new BigDecimal(this.tblAgeQuanSegment.getRow(i - 1).getCell("colSegment").getValue().toString());
                if (segOldCounts.compareTo(segCounts) > 0) {
                    throw new YVRuleException(YVRuleException.MUST_LESS_NEXT_ROW);
                }
                if (segOldCounts.compareTo(segCounts) != 0 || this.tblAgeQuanSegment.getRow(i - 1).getCell("colSign").getValue().toString().equals("<") && this.tblAgeQuanSegment.getRow(i).getCell("colSign").getValue().toString().equals("=")) continue;
                throw new YVRuleException(YVRuleException.MUST_LESS_NEXT_ROW1);
            }
            throw new YVRuleException(YVRuleException.MUST_INPUT_SEGMENT_ALL);
        }
    }

    protected void showSubmitSuccess() {
        this.setMessageText(this.getClassAlise() + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        this.showMessage();
    }

    private String getClassAlise() {
        String className = FrameWorkUtils.getClassAlias((CoreBaseInfo)this.yearVacationRule);
        return className;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return YearVacationRuleFactory.getRemoteInstance();
    }

    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.actionSave.setEnabled(true);
        this.actionInitRule.setEnabled(false);
        EmployeeClientUtils.initTableBtn((JButton)this.btnWorkInsert, (JButton)this.btnWorkDelete);
        this.btnWorkInsert.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.btnWorkInsert.setText(null);
        this.btnWorkDelete.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.btnWorkDelete.setText(null);
        this.btnInitRule.setIcon(EASResource.getIcon((String)"imgTbtn_ruleinitialize"));
        EmployeeClientUtils.initTableBtn((JButton)this.btnWorkInsertYear, (JButton)this.btnWorkDeleteYear);
    }

    public void actionDeleteYear_actionPerformed(ActionEvent e) throws Exception {
        int selectRow = KDTableUtil.getSelectedRow((KDTable)this.tblAgeQuanSegment);
        if (selectRow != -1) {
            this.tblAgeQuanSegment.removeRow(selectRow);
        }
    }

    public void actionInsertYear_actionPerformed(ActionEvent e) throws Exception {
        IRow curRow = this.tblAgeQuanSegment.addRow();
        curRow.getCell("colSign").setValue((Object)"<=");
    }

    protected void btnRadionQuanMonth_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnRadionQuanMonth.isSelected()) {
            this.btnRadioQuanMorths.setEnabled(true);
            this.btnRadioQuanAllDay.setEnabled(true);
            this.kDSpinnerQuanAllDay.setEnabled(true);
        }
    }

    protected void btnRadioQuanAllDay_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnRadioQuanAllDay.isSelected()) {
            this.cboQuanMonths.setEnabled(false);
            this.kDSpinnerQuanAllDay.setEnabled(true);
        }
    }

    protected void btnRadioCarryNOTerm_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnRadioCarryNOTerm.isSelected()) {
            this.txtCarryObtainDays.setEnabled(true);
            this.cboCarryPrecisionType.setEnabled(true);
            this.kDSpinnerCarryPrecision.setEnabled(true);
            this.txtCarryAbandonDate.setEnabled(false);
            this.cboCarryReservationType.setEnabled(false);
            this.txtCarryReservationValue.setEnabled(false);
        }
    }

    protected void btnRadioCarryYesTerm_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnRadioCarryYesTerm.isSelected()) {
            this.txtCarryObtainDays.setEnabled(false);
            this.cboCarryPrecisionType.setEnabled(false);
            this.kDSpinnerCarryPrecision.setEnabled(false);
            this.txtCarryAbandonDate.setEnabled(true);
            this.cboCarryReservationType.setEnabled(true);
            this.txtCarryReservationValue.setEnabled(true);
        }
    }

    protected void btnRadioQuanDay_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnRadioQuanDay.isSelected()) {
            this.btnRadioQuanMorths.setEnabled(false);
            this.btnRadioQuanAllDay.setEnabled(false);
            this.cboQuanMonths.setEnabled(false);
            this.kDSpinnerQuanAllDay.setValue((Object)0);
            this.kDSpinnerQuanAllDay.setEnabled(false);
        }
    }

    protected void btnRadioQuanMorths_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnRadioQuanMorths.isSelected()) {
            this.cboQuanMonths.setEnabled(true);
            this.kDSpinnerQuanAllDay.setEnabled(false);
        }
    }

    protected void btnWorkDelete_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRowIndex = KDTableUtil.getSelectedRows((KDTable)this.tblPerson);
        int currentDelRowIndex = 0;
        if (selectRowIndex.length > 0) {
            if (this.confirmRemove()) {
                for (int i = selectRowIndex.length - 1; i >= 0; --i) {
                    currentDelRowIndex = selectRowIndex[i];
                    if (this.tblPerson.getRow(currentDelRowIndex).getCell("itemId").getValue() != null) {
                        this.delList.add(this.tblPerson.getRow(currentDelRowIndex).getCell("itemId").getValue().toString());
                    }
                    this.tblPerson.removeRow(currentDelRowIndex);
                }
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"79_YearVacationEditUI"));
        }
    }

    protected void btnWorkInsert_actionPerformed(ActionEvent e) throws Exception {
        EmployeeMultiF7PromptBox personPrompt = new EmployeeMultiF7PromptBox((IUIObject)this);
        this.setF7Filter(personPrompt);
        personPrompt.setModal(true);
        personPrompt.setIsSingleSelect(false);
        personPrompt.showNoPositionPerson(true);
        personPrompt.setUserOrgRangeFilter(true);
        personPrompt.setReturnPositionAndUnit(false);
        HashSet<BOSUuid> set = new HashSet<BOSUuid>();
        set.add(SysContext.getSysContext().getCurrentHRUnit().getId());
        personPrompt.setHROFilter(set);
        personPrompt.setIsSingleSelect(false);
        personPrompt.setModal(true);
        personPrompt.setIsPluralityIsChooseContral(false);
        personPrompt.show();
        if (personPrompt.isCanceled()) {
            return;
        }
        if (personPrompt.getData() instanceof Object[]) {
            int con;
            int i;
            Object[] obj = (Object[])personPrompt.getData();
            PersonCollection personCollection = new PersonCollection();
            int n = obj.length;
            for (int i2 = 0; i2 < n; ++i2) {
                personCollection.add((PersonInfo)obj[i2]);
            }
            PersonCollection pInfos = this.getPersonYVInfo(personCollection);
            int counts = pInfos.size();
            PersonInfo infoPerson = null;
            int existCounts = 0;
            StringBuffer sb = new StringBuffer();
            for (i = 0; i < counts; ++i) {
                infoPerson = pInfos.get(i);
                if (infoPerson.get("YVId") == null || this.selectedID.equals(infoPerson.get("yvRuleId"))) continue;
                sb.append(infoPerson.getName());
                sb.append(",");
                ++existCounts;
            }
            if (existCounts > 0 && (con = MsgBox.showConfirm3a((String)(sb.substring(0, sb.indexOf(",")) + "\u7b49\u4eba\u5458" + EASResource.getString((String)RES, (String)"otherRule")), (String)("\u4eba\u5458\u5305\u62ec\uff1a" + sb.substring(0, sb.length() - 1)))) != 0) {
                for (int i3 = counts - 1; i3 >= 0; --i3) {
                    infoPerson = pInfos.get(i3);
                    if (infoPerson.get("YVId") == null) continue;
                    pInfos.remove(infoPerson);
                }
            }
            for (i = 0; i < pInfos.size(); ++i) {
                infoPerson = pInfos.get(i);
                this.addPersonInfo(infoPerson);
            }
        }
    }

    private void setF7Filter(EmployeeMultiF7PromptBox pmt) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        IUserPermission iup = UserPermissionFactory.getRemoteInstance();
        UserPermissionCollection collection = iup.getUserPermissionCollection(viewInfo);
        String filterString = null;
        if (collection != null && collection.size() > 0) {
            filterString = collection.get(0).getFilter();
        }
        if (filterString == null) {
            return;
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.emp.app", "EmpInfoQuery");
        IQueryExecutor iQe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        filter = new FilterInfo(filterString);
        viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(sic);
        iQe.setObjectView(viewInfo);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)iQe.getSQL(), CompareType.INNER));
        pmt.setNopositionPersonFilter(filter);
    }

    private void addPersonInfo(PersonInfo infoPerson) {
        if (!this.checkExistInTable(infoPerson)) {
            IRow curRow = this.tblPerson.addRow();
            curRow.getCell("id").setValue((Object)infoPerson.getId().toString());
            curRow.getCell("colNumber").setValue((Object)infoPerson.getNumber());
            curRow.getCell("colName").setValue((Object)infoPerson.getName());
            curRow.getCell("colSex").setValue((Object)infoPerson.getGender());
            curRow.getCell("colOrg").setValue(infoPerson.get("primaryAdminOrg"));
            curRow.getCell("colPosition").setValue(infoPerson.get("primaryPosition"));
            curRow.getCell("colSourceID").setValue(infoPerson.get("YVId"));
            curRow.getCell("colSourceName").setValue(infoPerson.get("YVName"));
            curRow.getCell("colSourceNumber").setValue(infoPerson.get("YVNumber"));
        }
    }

    private boolean checkExistInTable(PersonInfo pInfo) {
        int counts = this.tblPerson.getRowCount();
        boolean isExist = false;
        for (int i = 0; i < counts; ++i) {
            if (!pInfo.getId().toString().equals(this.tblPerson.getRow(i).getCell("id").getValue().toString())) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    public void actionInitRule_actionPerformed(ActionEvent e) throws Exception {
        if (this.yearVacationRule == null || this.yearVacationRule.getId() == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("yvRule.id", (Object)this.yearVacationRule.getId().toString()));
        if (!YearVacationPersonFactory.getRemoteInstance().exists(filter)) {
            return;
        }
        IProgTask prog = new IProgTask(){

            public Object exec() throws Exception {
                int year = YearVacationEditUI.this.getInitYear();
                if (year == -1) {
                    MsgBox.showInfo((String)EASResource.getString((String)YearVacationEditUI.RES, (String)"FIRST_INIT_YEAR"));
                    SysUtil.abort();
                }
                IObjectPK logPK = LogUtil.beginLog(null, (String)"", (BOSObjectType)new YearVacationRuleInfo().getBOSType(), null, (String)(YearVacationEditUI.this.yearVacationRule.getName() + ""), (String)"YearManager_initRule");
                IYearVacationBalance iyvBalance = YearVacationBalanceFactory.getRemoteInstance();
                iyvBalance.initYearVacation(YearVacationEditUI.this.yearVacationRule.getId().toString(), year, true);
                LogUtil.afterLog(null, (IObjectPK)logPK);
                return "";
            }

            public void afterExec(Object result) throws Exception {
                MsgBox.showInfo((String)EASResource.getString((String)YearVacationEditUI.RES, (String)"ININ_RULE_OK"));
            }
        };
        ProgDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new ProgDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new ProgDialog((Dialog)win);
        } else {
            throw new Exception("win's type is unknown!");
        }
        dialog.setLongTimeTask(prog);
        dialog.show();
    }

    private int getInitYear() throws EASBizException, BOSException {
        IHRInit iHR = HRInitFactory.getRemoteInstance();
        return iHR.getInitYear();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        return filter;
    }
}

