/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.time.IYearVacationRule;
import com.kingdee.eas.hr.time.YearVacationRuleFactory;
import com.kingdee.eas.hr.time.YearVacationRuleInfo;
import com.kingdee.eas.hr.time.client.AbstractYearVacationQueryPanel;
import com.kingdee.eas.hr.time.client.YearVacationQueryParm;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class YearVacationQueryPanel
extends AbstractYearVacationQueryPanel {
    private static final Logger logger = CoreUIObject.getLogger(YearVacationQueryPanel.class);
    private static Vector vectYear = new Vector(110);
    private boolean blnInit = false;

    public YearVacationQueryPanel() throws Exception {
        this.combYear.addItems(vectYear);
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() {
        if (this.blnInit) {
            return;
        }
        this.blnInit = true;
        this.pmptRule.setQueryInfo("com.kingdee.eas.hr.time.app.YearVacationRuleQuery");
        this.pmptRule.setCommitFormat("$number$");
        this.pmptRule.setDisplayFormat("$name$");
        this.pmptRule.setEditFormat("$number$");
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)HRSchemeUtils.getClientHROrgUnitInfo().getId().toString()));
        ev.setFilter(filter);
        this.pmptRule.setEntityViewInfo(ev);
        this.clear();
    }

    public Object getParam() {
        YearVacationQueryParm param = new YearVacationQueryParm();
        if (this.radPersonNumber.isSelected()) {
            String number = this.txtNumber.getText().trim();
            if (number == null || number.length() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource", (String)"INPUT_QUERYPERSON_NUMBER"));
                SysUtil.abort();
            }
            param.setPersonNumber(number);
            param.setYear(-1);
            param.setRuleInfo(null);
            param.setAllPerson(false);
        } else if (this.radPersonName.isSelected()) {
            String name = this.txtName.getText().trim();
            if (name == null || name.length() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource", (String)"INPUT_QUERYPERSON_NAME"));
                SysUtil.abort();
            }
            param.setPersonName(name);
            param.setYear(-1);
            param.setRuleInfo(null);
            param.setAllPerson(false);
        } else if (this.radAllPerson.isSelected()) {
            param.setAllPerson(true);
            if (this.combYear.getSelectedItem() != null) {
                param.setYear((Integer)this.combYear.getSelectedItem());
            }
            if (this.pmptRule.getData() != null) {
                if (!(this.pmptRule.getData() instanceof YearVacationRuleInfo)) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource", (String)"SELECT_YVRULE"));
                    SysUtil.abort();
                }
                YearVacationRuleInfo ruleInfo = (YearVacationRuleInfo)this.pmptRule.getData();
                param.setRuleInfo(ruleInfo);
            }
        }
        return param;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        cp.addCustomerParam("name", this.txtName.getText());
        cp.addCustomerParam("number", this.txtNumber.getText());
        cp.putBoolean("radPersonNumber", this.radPersonNumber.isSelected());
        cp.putBoolean("radPersonName", this.radPersonName.isSelected());
        cp.putBoolean("all", this.radAllPerson.isSelected());
        if (this.radPersonNumber.isSelected()) {
            cp.putInt("year", -1);
        } else if (this.radPersonName.isSelected()) {
            cp.putInt("year", -1);
        } else if (this.radAllPerson.isSelected()) {
            if (this.combYear.getSelectedItem() != null) {
                cp.putInt("year", ((Integer)this.combYear.getSelectedItem()).intValue());
            }
            if (this.pmptRule.getData() != null) {
                cp.addCustomerParam("ruleInfo", ((YearVacationRuleInfo)this.pmptRule.getData()).getId().toString());
            }
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        this.clear();
        this.radPersonNumber.setSelected(cp.getBoolean("radPersonNumber"));
        this.radPersonName.setSelected(cp.getBoolean("radPersonName"));
        this.txtName.setText(cp.getCustomerParam("name"));
        this.txtNumber.setText(cp.getCustomerParam("number"));
        this.radAllPerson.setSelected(cp.getBoolean("all"));
        int index = vectYear.indexOf(cp.getInt("year"));
        this.combYear.size();
        this.combYear.setSelectedIndex(index);
        try {
            if (cp.getCustomerParam("ruleInfo") != null) {
                IYearVacationRule iYearVacationRule = YearVacationRuleFactory.getRemoteInstance();
                YearVacationRuleInfo info = iYearVacationRule.getYearVacationRuleInfo((IObjectPK)new ObjectUuidPK(cp.getCustomerParam("ruleInfo").toString()));
                this.pmptRule.setData((Object)info);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
    }

    public void setParam(Object param) {
        if (!(param instanceof YearVacationQueryParm)) {
            return;
        }
        YearVacationQueryParm yvParam = (YearVacationQueryParm)param;
        if (!yvParam.isAllPerson()) {
            if (yvParam.getPersonNumber() != null) {
                this.radPersonNumber.setSelected(true);
                this.txtNumber.setText(yvParam.getPersonNumber());
                this.txtName.setText("");
            }
            if (yvParam.getPersonName() != null) {
                this.radPersonName.setSelected(true);
                this.txtName.setText(yvParam.getPersonName());
                this.txtNumber.setText("");
            }
        } else {
            this.radAllPerson.setSelected(true);
            int index = vectYear.indexOf(yvParam.getYear());
            if (index == -1) {
                index = 0;
            }
            this.combYear.size();
            this.combYear.setSelectedIndex(index);
            if (yvParam.getRuleInfo() != null) {
                this.pmptRule.setValue((Object)yvParam.getRuleInfo());
            }
        }
    }

    protected void radAllPerson_stateChanged(ChangeEvent e) throws Exception {
        super.radAllPerson_stateChanged(e);
        if (this.radAllPerson.isSelected()) {
            this.txtName.setEnabled(false);
            this.txtNumber.setEnabled(false);
            this.combYear.setEnabled(true);
            this.pmptRule.setEnabled(true);
            this.txtName.setText("");
            this.txtNumber.setText("");
        } else {
            this.txtName.setEnabled(true);
            this.txtNumber.setEnabled(true);
            this.combYear.setEnabled(false);
            this.pmptRule.setEnabled(false);
        }
    }

    protected void radPersonName_stateChanged(ChangeEvent e) throws Exception {
        if (this.radPersonName.isSelected()) {
            this.txtName.setEnabled(true);
            this.txtNumber.setEnabled(false);
            this.txtNumber.setText("");
        }
    }

    protected void radPersonNumber_stateChanged(ChangeEvent e) throws Exception {
        if (this.radPersonNumber.isSelected()) {
            this.txtName.setEnabled(false);
            this.txtNumber.setEnabled(true);
            this.txtName.setText("");
        }
    }

    public void clear() {
        this.pmptRule.setData(null);
        this.radAllPerson.setSelected(true);
        this.txtNumber.setText("");
        this.txtName.setText("");
        this.combYear.setSelectedIndex(-1);
    }

    static {
        for (int i = 2000; i <= 2100; ++i) {
            vectYear.add(i);
        }
    }
}

