/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.common.client.CommonUtil;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.time.IYearVacationBalance;
import com.kingdee.eas.hr.time.YearVacationBalanceFactory;
import com.kingdee.eas.hr.time.YearVacationRuleCollection;
import com.kingdee.eas.hr.time.YearVacationRuleInfo;
import com.kingdee.eas.hr.time.client.AbstractYearVactionListUI;
import com.kingdee.eas.hr.time.client.IProgTask;
import com.kingdee.eas.hr.time.client.ProgDialog;
import com.kingdee.eas.hr.time.client.TimeUtil;
import com.kingdee.eas.hr.time.client.YVCalCondParam;
import com.kingdee.eas.hr.time.client.YVCalculateCondPanel;
import com.kingdee.eas.hr.time.client.YearVacationUIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class YearVactionListUI
extends AbstractYearVactionListUI {
    private static final long serialVersionUID = -61166L;
    private static final String resPath = "com.kingdee.eas.hr.time.TimeResource";
    private static final String FILTER_YEAR = "year";
    private static final String FILTER_RULE = "YVRule.id";
    private static final String FILTER_PERSON = "personID";
    private static final int ACTION_CAL = 1;
    private static final int ACTION_CARRY = 2;
    private List lstChangedRow = null;
    private Vector vectYear = new Vector(110);
    private int rowIndex = 0;
    private int year = Calendar.getInstance().get(1);
    private YVCalculateCondPanel pnlCalCond = null;
    private int actionType = 1;
    private boolean combRuleRefresh = false;
    private boolean combYearRefresh = false;
    private Map mapRule = new HashMap(16);
    private boolean isFirstDefaultQuery = true;
    private boolean isFirst = true;
    private boolean isCarr = false;
    private YVCalCondParam calParam = null;
    private EntityViewInfo customerEnv = null;
    private boolean blnSetFilterParam = true;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initComboYear();
        this.lstChangedRow = new ArrayList(128);
        this.loadYearVactionRuleList();
        this.yearManageVacationQuery = new EntityViewInfo();
        this.checkTableParsed();
        this.showQueryPanel();
        TimeUtil.setKDTableUISort(this.tblMain);
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent kde) {
                int year;
                int rowIndex = kde.getSelectBlock().getTop();
                IRow iRow = YearVactionListUI.this.tblMain.getRow(rowIndex);
                if (iRow == null) {
                    return;
                }
                String personID = iRow.getCell("personId").getValue().toString();
                int result = YearVactionListUI.this.setActionEnable(personID, year = ((Integer)YearVactionListUI.this.combYear.getSelectedItem()).intValue());
                if (result == 1) {
                    iRow.getStyleAttributes().setLocked(true);
                    iRow.getCell("currQuantity").getStyleAttributes().setLocked(true);
                    iRow.getCell("lastRest").getStyleAttributes().setLocked(true);
                    iRow.getCell("overdue").getStyleAttributes().setLocked(true);
                    YearVactionListUI.this.actionCalculate.setEnabled(false);
                    YearVactionListUI.this.actionCarryforward.setEnabled(false);
                } else {
                    YearVactionListUI.this.actionCalculate.setEnabled(true);
                    YearVactionListUI.this.actionCarryforward.setEnabled(true);
                }
            }
        });
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                YearVactionListUI.this.lstChangedRow.clear();
            }
        });
        this.tblMain.setColumnMoveable(true);
    }

    private void initComboYear() {
        for (int i = 2000; i < 2100; ++i) {
            this.vectYear.add(i);
        }
        this.combYear.addItems(this.vectYear);
        this.year = Calendar.getInstance().get(1);
        int index = this.vectYear.indexOf(this.year);
        if (index == -1) {
            index = 0;
        }
        this.combYear.setSelectedIndex(index);
        this.combYearRefresh = true;
    }

    protected int setActionEnable(String personID, int year) {
        String sql = "select FStatus from T_HR_YVBalance where FPersonID = '" + personID + "' AND FYear = " + year;
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = null;
        try {
            rs = exec.executeSQL();
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        int zero = 0;
        try {
            if (rs != null && rs.next()) {
                return rs.getInt("FStatus");
            }
        }
        catch (SQLException e) {
            this.handleException(e);
        }
        return zero;
    }

    protected void checkTableParsed() {
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.addKDTEditListener((KDTEditListener)new YearRuleKDTEditAdapter());
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)this.getNumberTextField());
        this.tblMain.getColumn("currQuantity").setEditor((ICellEditor)editor);
        this.tblMain.getColumn("currAvailable").setEditor((ICellEditor)editor);
        this.tblMain.getColumn("lastRest").setEditor((ICellEditor)editor);
        this.tblMain.getColumn("overdue").setEditor((ICellEditor)editor);
        this.tblMain.getColumn("used").setEditor((ICellEditor)editor);
    }

    private KDNumberTextField getNumberTextField() {
        KDNumberTextField txtField = new KDNumberTextField();
        txtField.setDataType(4);
        txtField.setPrecision(3);
        return txtField;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnUpdate);
        this.btnUpdate.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnUpdate.setEnabled(false);
        this.setButtonDefaultStyl(this.btnRefresh);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnCarryforward.setIcon(EASResource.getIcon((String)"imgTbtn_holscarryforward"));
        this.btnCalculate.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPrieve.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPrintPrieve);
        this.menuRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuCarrayforward.setIcon(EASResource.getIcon((String)"imgTbtn_holscarryforward"));
        this.menuCalculate.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    private void loadYearVactionRuleList() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("quantity.id"));
        sic.add(new SelectorItemInfo("quantity.precisionLength"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)("select fid,fname_l2,fnumber from T_HR_YVRule where FHROrgUnitID='" + SysContext.getSysContext().getCurrentHRUnit().getId().toString() + "'"));
        IRowSet rs = null;
        rs = exec.executeSQL();
        if (rs == null) {
            return;
        }
        YearVacationRuleCollection coll = new YearVacationRuleCollection();
        YearVacationRuleInfo info = null;
        while (rs.next()) {
            info = new YearVacationRuleInfo();
            info.setId(BOSUuid.read((String)rs.getString("fid")));
            info.setNumber(rs.getString("fnumber"));
            info.setName(rs.getString("fname_l2"));
            coll.add(info);
        }
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            info = coll.get(i);
            this.mapRule.put(info.getId().toString(), i + 1);
        }
        if (coll.size() > 0) {
            this.combRule.addItem((Object)new YearVacationRuleInfo());
            this.combRule.addItems(coll.toArray());
            this.combRule.setSelectedIndex(0);
            this.txtRuleName.setText(coll.get(0).getNumber());
        }
        this.combRuleRefresh = true;
    }

    private void changeCombRuleSelected() {
        YearVacationRuleInfo info = (YearVacationRuleInfo)this.combRule.getSelectedItem();
        if (info == null) {
            return;
        }
        this.txtRuleName.setText(info.getNumber());
        if (this.calParam == null) {
            return;
        }
        this.calParam.setRuleInfo(info);
    }

    private void getCurrSelectedYear() {
        try {
            this.year = (Integer)this.combYear.getSelectedItem();
        }
        catch (Exception ee) {
            this.year = Calendar.getInstance().get(1);
        }
    }

    private void setCalFilter() throws BOSException {
        if (this.blnSetFilterParam) {
            this.calParam = (YVCalCondParam)this.pnlCalCond.getParam();
            this.blnSetFilterParam = true;
        }
        HashSet setPerson = this.getPersonSet(this.calParam.getSelectedPesonType());
        FilterInfo filterCus = new FilterInfo();
        FilterItemCollection fcoll = filterCus.getFilterItems();
        fcoll.add(new FilterItemInfo(FILTER_YEAR, (Object)this.year));
        YearVacationRuleInfo ruleInfo = null;
        ruleInfo = !this.isFirst ? this.getRuleInfo() : this.calParam.getRuleInfo();
        if (ruleInfo != null && ruleInfo.getId() != null) {
            fcoll.add(new FilterItemInfo(FILTER_RULE, (Object)ruleInfo.getId().toString()));
            this.txtRuleName.setText(ruleInfo.getNumber());
        }
        if (!(setPerson.size() <= 0 || setPerson.size() == 1 && setPerson.contains("0"))) {
            fcoll.add(new FilterItemInfo(FILTER_PERSON, (Object)setPerson, CompareType.INCLUDE));
        }
        if (this.customerEnv != null) {
            FilterInfo srcFilter = this.customerEnv.getFilter();
            FilterInfo hrFilter = null;
            try {
                hrFilter = TimeUtil.getHRAndAdminRangeFilterInfo(null, "adminorgunit.id");
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
            if (FilterUtility.hasFilterItem((FilterInfo)srcFilter)) {
                filterCus.mergeFilter(srcFilter, "and");
            }
            if (FilterUtility.hasFilterItem((FilterInfo)hrFilter)) {
                filterCus.mergeFilter(hrFilter, "and");
            }
        }
        this.clearLastFilter();
        this.yearManageVacationQuery.setFilter(filterCus);
    }

    private HashSet getSelectedPerson() {
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        if (blocks == null || blocks.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)resPath, (String)"SELECT_PERSON"));
            SysUtil.abort();
        }
        int size = blocks.size();
        HashSet<String> setPerson = new HashSet<String>(2 * size);
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
            int end = block.getEndRow();
            for (int begin = block.getBeginRow(); begin <= end; ++begin) {
                IRow row = this.tblMain.getRow(begin);
                String personId = row.getCell("personId").getValue().toString();
                setPerson.add(personId);
            }
        }
        return setPerson;
    }

    private List getChangedPerson() {
        int size = this.lstChangedRow.size();
        ArrayList<Map> lst = new ArrayList<Map>(size);
        for (int i = 0; i < size; ++i) {
            int index = (Integer)this.lstChangedRow.get(i);
            if (index == -1) continue;
            IRow row = this.tblMain.getRow(index);
            lst.add(this.getChangedValue(row));
        }
        return lst;
    }

    private Map getChangedValue(IRow row) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("fpersonid", row.getCell("personId").getValue());
        Float currQuantity = this.getFieldValue(row, "currQuantity");
        Float balance = this.getFieldValue(row, "lastRest");
        Float overdue = this.getFieldValue(row, "overdue");
        Float used = this.getFieldValue(row, "used");
        float avail = currQuantity.floatValue() + balance.floatValue() - (used.floatValue() + overdue.floatValue());
        if (avail >= 1000.0f || avail <= -1000.0f) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"80_YearVactionListUI"));
            SysUtil.abort();
        }
        map.put("fcurrquantity", currQuantity);
        map.put("flastbalance", balance);
        map.put("foverdue", overdue);
        map.put("fused", used);
        map.put("fyear", this.year);
        map.put("fcurravaiable", new Float(avail));
        return map;
    }

    private Float getFieldValue(IRow row, String fieldName) {
        String value = null;
        value = row.getCell(fieldName).getValue() != null ? row.getCell(fieldName).getValue().toString() : "0.0";
        return new Float(value);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.changeCombRuleSelected();
        this.refresh();
    }

    public void actionUpdateBalance_actionPerformed(ActionEvent e) throws Exception {
        super.actionUpdateBalance_actionPerformed(e);
        List lstChangedValue = this.getChangedPerson();
        if (lstChangedValue.size() == 0) {
            return;
        }
        IYearVacationBalance iyvBalance = YearVacationBalanceFactory.getRemoteInstance();
        iyvBalance.updateBalacne(this.year, lstChangedValue);
        this.lstChangedRow.clear();
        this.refresh();
    }

    private void refresh() throws Exception {
        this.tblMain.removeRows();
        YearVacationUIHelper.formatTable(this.tblMain);
    }

    private void showQueryPanel() throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = this.yearManageVacationQueryPK.getFullName();
        this.pnlCalCond = new YVCalculateCondPanel();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            if (solution.getQueryPanelInfo().size() <= 1 || solution.getQueryPanelInfo().get(1).getParam() == null) {
                this.showFilterDialog();
            } else if (solution.getQueryPanelInfo().size() > 1 && solution.getQueryPanelInfo().get(1).getParam() != null) {
                YVCalCondParam param = (YVCalCondParam)CommonUtil.getObject((byte[])solution.getQueryPanelInfo().get(1).getParam());
                if (param.getSelectedPesonType() == 2) {
                    this.showFilterDialog();
                } else {
                    this.pnlCalCond.setParam(param);
                    if (this.actionType == 1) {
                        this.calculate();
                    } else {
                        this.carryforwad();
                    }
                    this.refresh();
                }
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.showFilterDialog();
        }
    }

    private void showFilterDialog() throws Exception {
        CommonQueryDialog dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        dialog.setEntityViewInfo(new EntityViewInfo());
        dialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.time.app", "YearVacationQuery"));
        dialog.setTitle(EASResource.getString((String)resPath, (String)"TITLE_YVMANGERMENT"));
        dialog.setShowFilter(true);
        dialog.setShowSorter(false);
        dialog.setWidth(450);
        dialog.setHeight(300);
        if (this.isCarr) {
            this.pnlCalCond.pnlEndDate.setVisible(false);
        }
        if (this.isFirst) {
            this.pnlCalCond.radSelectedPerson.setEnabled(false);
        }
        dialog.addUserPanel((KDPanel)this.pnlCalCond);
        this.pnlCalCond.setRuleInfo(this.getRuleInfo());
        if (dialog.show()) {
            this.customerEnv = dialog.getEntityViewInfoResult();
            if (this.actionType == 1) {
                this.calculate();
            } else {
                this.carryforwad();
            }
        } else {
            SysUtil.abort();
        }
    }

    private YearVacationRuleInfo getRuleInfo() {
        return (YearVacationRuleInfo)this.combRule.getSelectedItem();
    }

    private void calculate() throws Exception {
        IProgTask prog = new IProgTask(){

            public Object exec() throws Exception {
                YearVactionListUI.this.calParam = (YVCalCondParam)YearVactionListUI.this.pnlCalCond.getParam();
                HashSet setPerson = YearVactionListUI.this.getPersonSet(YearVactionListUI.this.calParam.getSelectedPesonType());
                ArrayList lstPerson = new ArrayList(setPerson);
                YearVacationRuleInfo ruleInfo = YearVactionListUI.this.calParam.getRuleInfo();
                int type = YearVactionListUI.this.calParam.getSelectedDateType();
                IYearVacationBalance iyvBalacne = YearVacationBalanceFactory.getRemoteInstance();
                if (ruleInfo == null) {
                    iyvBalacne.calculate(YearVactionListUI.this.year, lstPerson, type, YearVactionListUI.this.calParam.getEndDate(), YearVactionListUI.this.calParam.getSelectedDateType());
                } else {
                    iyvBalacne.calculate(YearVactionListUI.this.year, ruleInfo.getId().toString(), type, YearVactionListUI.this.calParam.getEndDate(), YearVactionListUI.this.calParam.getSelectedDateType());
                    YearVactionListUI.this.selectRule(ruleInfo.getId().toString());
                }
                if (YearVactionListUI.this.calParam.getSelectedPesonType() == 1) {
                    YearVactionListUI.this.txtRuleName.setText("");
                    YearVactionListUI.this.combRule.setSelectedIndex(-1);
                }
                YearVactionListUI.this.setCurrCondition();
                YearVactionListUI.this.setCalFilter();
                return "";
            }

            public void afterExec(Object result) throws Exception {
            }
        };
        ProgDialog progDialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        progDialog = win instanceof Frame ? new ProgDialog((Frame)win) : (win instanceof Dialog ? new ProgDialog((Dialog)win) : new ProgDialog((Frame)this.getUIContext().get("OwnerWindow")));
        progDialog.setLongTimeTask(prog);
        progDialog.show();
    }

    private void carryforwad() throws EASBizException, BOSException {
        IProgTask prog = new IProgTask(){

            public Object exec() throws Exception {
                YearVactionListUI.this.calParam = (YVCalCondParam)YearVactionListUI.this.pnlCalCond.getParam();
                HashSet setPerson = YearVactionListUI.this.getPersonSet(YearVactionListUI.this.calParam.getSelectedPesonType());
                ArrayList lstPerson = new ArrayList(setPerson);
                YearVacationRuleInfo ruleInfo = YearVactionListUI.this.calParam.getRuleInfo();
                int type = YearVactionListUI.this.calParam.getSelectedDateType();
                IYearVacationBalance iyvBalacne = YearVacationBalanceFactory.getRemoteInstance();
                if (ruleInfo == null) {
                    iyvBalacne.carryforwardBalance(lstPerson, YearVactionListUI.this.year, type, YearVactionListUI.this.calParam.getEndDate());
                    iyvBalacne.calculate(YearVactionListUI.this.year + 1, lstPerson, type, YearVactionListUI.this.calParam.getEndDate(), YearVactionListUI.this.calParam.getSelectedDateType());
                } else {
                    iyvBalacne.carryforwardBalance(ruleInfo.getId().toString(), YearVactionListUI.this.year, type, YearVactionListUI.this.calParam.getEndDate());
                    iyvBalacne.calculate(YearVactionListUI.this.year + 1, ruleInfo.getId().toString(), type, YearVactionListUI.this.calParam.getEndDate(), YearVactionListUI.this.calParam.getSelectedDateType());
                    YearVactionListUI.this.selectRule(ruleInfo.getId().toString());
                }
                if (YearVactionListUI.this.calParam.getSelectedPesonType() == 1) {
                    YearVactionListUI.this.txtRuleName.setText("");
                    YearVactionListUI.this.combRule.setSelectedIndex(-1);
                }
                ++YearVactionListUI.this.year;
                YearVactionListUI.this.setCurrCondition();
                YearVactionListUI.this.setCalFilter();
                return "";
            }

            public void afterExec(Object result) throws Exception {
            }
        };
        ProgDialog progDialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        progDialog = win instanceof Frame ? new ProgDialog((Frame)win) : (win instanceof Dialog ? new ProgDialog((Dialog)win) : new ProgDialog((Frame)this.getUIContext().get("OwnerWindow")));
        progDialog.setLongTimeTask(prog);
        progDialog.show();
    }

    private void setCurrCondition() {
        YearVacationRuleInfo ruleInfo;
        int index = this.vectYear.indexOf(this.year);
        if (index != -1) {
            this.combYear.setSelectedIndex(index);
        }
        if ((ruleInfo = this.calParam.getRuleInfo()) == null) {
            return;
        }
        this.combRule.setSelectedItem((Object)ruleInfo);
        this.txtRuleName.setText(ruleInfo.getNumber());
    }

    private HashSet getPersonSet(int type) {
        HashSet setPerson = new HashSet(1024);
        if (type == 2) {
            setPerson = this.getSelectedPerson();
        } else if (type == 1) {
            setPerson.add("0");
        }
        return setPerson;
    }

    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
        this.isCarr = false;
        this.isFirst = false;
        super.actionCalculate_actionPerformed(e);
        this.actionType = 1;
        this.showQueryPanel();
        this.refresh();
    }

    public void actionCarryforward_actionPerformed(ActionEvent e) throws Exception {
        this.isCarr = true;
        this.isFirst = false;
        super.actionCarryforward_actionPerformed(e);
        this.actionType = 2;
        this.showQueryPanel();
        this.blnSetFilterParam = false;
        this.setCalFilter();
        this.refresh();
    }

    private void clearLastFilter() {
        FilterInfo filter = this.yearManageVacationQuery.getFilter();
        if (filter == null) {
            return;
        }
        FilterItemCollection fcoll = filter.getFilterItems();
        fcoll.clear();
    }

    protected void combRule_itemStateChanged(ItemEvent e) throws Exception {
        if (!this.combRuleRefresh) {
            return;
        }
        this.changeCombRuleSelected();
        if (this.calParam != null && this.calParam.getSelectedPesonType() == 2) {
            this.calParam.setSelectedPesonType(1);
        }
        this.blnSetFilterParam = false;
        this.setCalFilter();
        this.refresh();
    }

    protected void combYear_itemStateChanged(ItemEvent e) throws Exception {
        if (!this.combYearRefresh) {
            return;
        }
        this.getCurrSelectedYear();
        if (this.calParam != null && this.calParam.getSelectedPesonType() == 2) {
            this.calParam.setSelectedPesonType(1);
        }
        this.blnSetFilterParam = false;
        this.setCalFilter();
        this.refresh();
    }

    private void selectRule(String id) {
        if (!this.mapRule.containsKey(id)) {
            return;
        }
        int index = (Integer)this.mapRule.get(id);
        this.combRule.setSelectedIndex(index);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    public void actionPrintPrieve_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPrieve_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    class YearRuleKDTEditAdapter
    extends KDTEditAdapter {
        YearRuleKDTEditAdapter() {
        }

        public void editStopped(KDTEditEvent e) {
            int year;
            String personID;
            Float value;
            YearVactionListUI.this.rowIndex = e.getRowIndex();
            int col = e.getColIndex();
            ICell cell = YearVactionListUI.this.tblMain.getCell(YearVactionListUI.this.rowIndex, col);
            Object obj = cell.getValue();
            if (obj == null) {
                return;
            }
            if (StringUtils.isEmpty((String)cell.getValue().toString())) {
                value = new Float("0.0");
                cell.setValue((Object)"0.0");
            } else {
                value = new Float(cell.getValue().toString());
            }
            if (value.floatValue() >= 1000.0f || value.floatValue() <= -1000.0f) {
                cell.setValue((Object)"0.0");
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"81_YearVactionListUI"));
                return;
            }
            Integer key = YearVactionListUI.this.rowIndex;
            if (key == -1) {
                return;
            }
            if (YearVactionListUI.this.lstChangedRow.indexOf(key) == -1) {
                YearVactionListUI.this.lstChangedRow.add(key);
            }
            if (YearVactionListUI.this.setActionEnable(personID = YearVactionListUI.this.tblMain.getRow(YearVactionListUI.this.rowIndex).getCell("personId").getValue().toString(), year = ((Integer)YearVactionListUI.this.combYear.getSelectedItem()).intValue()) == 1) {
                YearVactionListUI.this.btnUpdate.setEnabled(false);
                cell.setValue(e.getOldValue());
            } else {
                YearVactionListUI.this.btnUpdate.setEnabled(true);
            }
        }
    }
}

