/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class YearVactionListUIHelper {
    private KDTable tblList = null;
    private String language = "L2";

    public YearVactionListUIHelper(int year, String ruleId, KDTable tbl) {
        this.tblList = tbl;
        this.language = SysContext.getSysContext().getLocale().getLanguage();
    }

    public void displayList() throws BOSException, SQLException {
        IRowSet rowSet = this.getYearVacationList();
        this.fillDataToTable(rowSet);
    }

    private IRowSet getYearVacationList() throws BOSException {
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)"");
        return exec.executeSQL();
    }

    private void fillDataToTable(IRowSet rowSet) throws SQLException {
        while (rowSet.next()) {
            IRow row = this.tblList.addRow();
            this.fillDataToRow(rowSet, row);
        }
    }

    private void fillDataToRow(IRowSet rowSet, IRow row) throws SQLException {
        row.getCell("deptName").setValue((Object)rowSet.getString("FDeptName_" + this.language));
        row.getCell("personId").setValue((Object)rowSet.getString("FPersonId"));
        row.getCell("personNumber").setValue((Object)rowSet.getString("FPersonNumber"));
        row.getCell("personName").setValue((Object)rowSet.getString("FPersonName_" + this.language));
        row.getCell("position").setValue((Object)rowSet.getString("FPositionName_" + this.language));
        row.getCell("enterDate").setValue((Object)rowSet.getString("FEnterDate"));
        row.getCell("ruleNumber").setValue((Object)rowSet.getString("FruleNumber"));
        row.getCell("currQuantity").setValue((Object)rowSet.getString("FCurrQuantity"));
        row.getCell("currAvailable").setValue((Object)rowSet.getString("FCurrAvailable"));
        row.getCell("lastRest").setValue((Object)rowSet.getString("FLastBalance"));
        row.getCell("overdue").setValue((Object)rowSet.getString("FOverdue"));
        row.getCell("used").setValue((Object)rowSet.getString("FUsed"));
    }
}

