/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.compensation.util.HRReportUtils;
import com.kingdee.eas.hr.time.YearVacationRuleInfo;
import com.kingdee.eas.hr.time.client.AbstractYearVactionQueryListUI;
import com.kingdee.eas.hr.time.client.TimeUtil;
import com.kingdee.eas.hr.time.client.YearVacationQueryPanel;
import com.kingdee.eas.hr.time.client.YearVacationQueryParm;
import com.kingdee.eas.hr.time.client.YearVacationUIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class YearVactionQueryListUI
extends AbstractYearVactionQueryListUI {
    private static Logger logger = Logger.getLogger(YearVactionQueryListUI.class);
    private static final long serialVersionUID = -61166L;
    private static String title = EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource", (String)"YEAR_RULE_LIST");
    private YearVacationQueryPanel pnlYV = null;
    private boolean isFirstDefaultQuery = true;
    private EntityViewInfo customerEnv = null;
    private CommonQueryDialog dialog = null;
    private KDTSortManager sortManager = new KDTSortManager(this.tblYVList);
    private String commonParams = null;

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnQuery);
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.setButtonDefaultStyl(this.btnRefresh);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPrintView);
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintView.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    protected void checkTableParsed() {
        this.tblYVList.checkParsed();
        this.tblYVList.getStyleAttributes().setLocked(true);
        this.tblYVList.removeRows();
        this.tblYVList.getSelectManager().setSelectMode(2);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        title = EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource", (String)"TITLEYVREPORT");
        this.setUITitle(title);
        this.yearVacationQuery = new EntityViewInfo();
        this.showQueryUI();
        this.tblYVList.setColumnMoveable(true);
    }

    private void display() throws Exception {
        this.setCustomerFilter();
        this.tblYVList.removeRows();
        YearVacationUIHelper.formatTable(this.tblYVList);
        if (this.tblYVList.getRowCount() > 0) {
            this.calculateTotalRow(true);
        } else {
            int size = this.tblYVList.getColumnCount();
            for (int i = 0; i < size; ++i) {
                this.tblYVList.getColumn(i).setSortable(false);
            }
            this.sortManager.setSortAuto(false);
        }
    }

    private void setCustomerFilter() throws BOSException {
        YearVacationQueryParm queryParam = (YearVacationQueryParm)this.pnlYV.getParam();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection fcoll = filterInfo.getFilterItems();
        if (this.commonParams != null && this.isFirstDefaultQuery) {
            try {
                FilterInfo commonFilter = new FilterInfo(this.commonParams);
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                entityViewInfo.setFilter(commonFilter);
                this.customerEnv = entityViewInfo;
            }
            catch (ParserException e) {
                logger.error((Object)e.getMessage());
            }
        }
        if (!queryParam.isAllPerson()) {
            if (queryParam.getPersonNumber() != null) {
                fcoll.add(new FilterItemInfo("personNumber", (Object)queryParam.getPersonNumber(), CompareType.LIKE));
            } else if (queryParam.getPersonName() != null) {
                fcoll.add(new FilterItemInfo("personName", (Object)queryParam.getPersonName(), CompareType.LIKE));
            }
        } else {
            YearVacationRuleInfo ruleInfo = queryParam.getRuleInfo();
            int year = queryParam.getYear();
            if (ruleInfo == null && year != 0) {
                fcoll.add(new FilterItemInfo("year", (Object)new Integer(queryParam.getYear())));
            }
            if (ruleInfo != null && year != 0) {
                fcoll.add(new FilterItemInfo("year", (Object)new Integer(queryParam.getYear())));
            }
            if (queryParam.getRuleInfo() != null) {
                String ruleId = queryParam.getRuleInfo().getId().toString();
                fcoll.add(new FilterItemInfo("YVRule.id", (Object)ruleId));
            }
        }
        if (this.customerEnv != null) {
            FilterInfo srcFilter = this.customerEnv.getFilter();
            FilterInfo hrFilter = null;
            try {
                hrFilter = TimeUtil.getHRAndAdminRangeFilterInfo(null, "adminorgunit.id");
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
            if (FilterUtility.hasFilterItem((FilterInfo)srcFilter)) {
                filterInfo.mergeFilter(srcFilter, "and");
            }
            if (FilterUtility.hasFilterItem((FilterInfo)hrFilter)) {
                filterInfo.mergeFilter(hrFilter, "and");
            }
        } else {
            FilterInfo hrFilter = null;
            try {
                hrFilter = TimeUtil.getHRAndAdminRangeFilterInfo(null, "adminorgunit.id");
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
            if (FilterUtility.hasFilterItem((FilterInfo)hrFilter)) {
                filterInfo.mergeFilter(hrFilter, "and");
            }
        }
        this.yearVacationQuery.setFilter(filterInfo);
    }

    private void showQueryUI() throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        String queryName = loader.getQuery(this.yearVacationQueryPK).getFullName();
        if (this.pnlYV == null) {
            this.pnlYV = new YearVacationQueryPanel();
        }
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            QueryPanelCollection queryPanelCollection = solution.getQueryPanelInfo();
            boolean rightDefaultQuery = false;
            if (queryPanelCollection != null && queryPanelCollection.size() > 0) {
                CustomerParams customerParam = null;
                int n = queryPanelCollection.size();
                for (int i = 0; i < n; ++i) {
                    queryPanelCollection.get(i).getFilterInfo();
                    if (queryPanelCollection.get(i).getPanelClassName() == null || this.pnlYV.getMetaDataPK().getFullName().equalsIgnoreCase(queryPanelCollection.get(i).getPanelClassName())) {
                        customerParam = CustomerParams.getCustomerParams2((String)queryPanelCollection.get(i).getCustomerParams());
                        continue;
                    }
                    this.commonParams = queryPanelCollection.get(i).getFilterInfo();
                }
                this.pnlYV.setCustomerParams(customerParam);
                rightDefaultQuery = true;
            }
            if (rightDefaultQuery) {
                this.display();
            } else {
                this.showFilterDialog();
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.showFilterDialog();
        }
    }

    private void showFilterDialog() throws Exception {
        if (this.dialog == null) {
            this.dialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.dialog.setOwner((Component)((Object)this));
            }
            this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.dialog.setEntityViewInfo(new EntityViewInfo());
            this.dialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.time.app", "YearVacationQuery"));
            title = EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource", (String)"TITLE_YVREPORT");
            this.dialog.setTitle(title);
            this.dialog.setShowFilter(true);
            this.dialog.setShowSorter(false);
            this.dialog.setWidth(400);
            this.dialog.setHeight(300);
            if (this.pnlYV == null) {
                this.pnlYV = new YearVacationQueryPanel();
            }
            this.dialog.addUserPanel((KDPanel)this.pnlYV);
        }
        if (this.dialog.show()) {
            this.customerEnv = this.dialog.getEntityViewInfoResult();
            this.display();
        } else {
            SysUtil.abort();
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.dialog != null && this.getUIContext() != null && "report".equals(this.getUIContext().get("UIClassParam"))) {
            this.dialog.changeOwner((Component)((Object)this));
        }
        super.actionQuery_actionPerformed(e);
        this.showQueryUI();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.tblYVList.removeRows();
        YearVacationUIHelper.formatTable(this.tblYVList);
        if (this.tblYVList.getRowCount() > 0) {
            this.calculateTotalRow(true);
        }
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.tblYVList);
        this.tblYVList.getPrintManager().print();
    }

    public void actionPrintView_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintView_actionPerformed(e);
        this.preparePrintPage(this.tblYVList);
        this.tblYVList.getPrintManager().printPreview();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblYVList;
    }

    private void calculateTotalRow(boolean needAddRow) {
        int i;
        IRow totalRow = null;
        if (needAddRow) {
            totalRow = this.tblYVList.addRow();
            totalRow.getStyleAttributes().setBackground(HRReportUtils.TOTAL_COLOR);
            if (totalRow.getCell("deptName") != null) {
                totalRow.getCell("deptName").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.time.LeaveDetailCheckResource", (String)"totalValue"));
            }
        } else {
            return;
        }
        double currQuantity = 0.0;
        double currAvailable = 0.0;
        double lastRest = 0.0;
        double overdue = 0.0;
        double used = 0.0;
        IRow row = null;
        int rowCount = this.tblYVList.getRowCount() - 1;
        for (i = 0; i < rowCount; ++i) {
            row = this.tblYVList.getRow(i);
            if (row.getCell("currQuantity").getValue() != null) {
                currQuantity += Double.parseDouble(row.getCell("currQuantity").getValue().toString());
            }
            if (row.getCell("currAvailable").getValue() != null) {
                currAvailable += Double.parseDouble(row.getCell("currAvailable").getValue().toString());
            }
            if (row.getCell("lastRest").getValue() != null) {
                lastRest += Double.parseDouble(row.getCell("lastRest").getValue().toString());
            }
            if (row.getCell("overdue").getValue() != null) {
                overdue += Double.parseDouble(row.getCell("overdue").getValue().toString());
            }
            if (row.getCell("used").getValue() == null) continue;
            used += Double.parseDouble(row.getCell("used").getValue().toString());
        }
        totalRow.getCell("currQuantity").setValue((Object)(currQuantity + ""));
        totalRow.getCell("currAvailable").setValue((Object)(currAvailable + ""));
        totalRow.getCell("lastRest").setValue((Object)(lastRest + ""));
        totalRow.getCell("overdue").setValue((Object)(overdue + ""));
        totalRow.getCell("used").setValue((Object)(used + ""));
        if (this.tblYVList.getRowCount() > 2) {
            this.sortManager.setSortAuto(true);
            TimeUtil.enableTableHeadSortNotNeedSortManager(this.tblYVList, 0, this.tblYVList.getRowCount() - 2, this.sortManager);
            this.tblYVList.setSortMange(this.sortManager);
        } else {
            int size = this.tblYVList.getColumnCount();
            for (i = 0; i < size; ++i) {
                this.tblYVList.getColumn(i).setSortable(false);
            }
            this.sortManager.setSortAuto(false);
            this.sortManager.clear();
            if (this.tblYVList.getSortMange() != null) {
                this.tblYVList.getSortMange().setEnableSortable(false);
                this.tblYVList.setSortMange(null);
            }
        }
    }
}

