/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.json.org.JSONObject;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.hr.time.LeaveBillEntryFactory;
import com.kingdee.eas.hr.time.LeaveBillEntryInfo;
import com.kingdee.eas.hr.time.UnitTypeEnum;
import com.kingdee.eas.hr.time.web.MyVacationActionHelper;
import com.kingdee.eas.hr.time.web.SelectItem;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class MyVacationAction
extends DispatchAction {
    protected Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.time.web.MyVacationAction");
    private String RES = "com.kingdee.eas.hr.emp.MyVacationResource";
    private List leaveBillInfos = new ArrayList();
    private BigDecimal hasLeavedDate = new BigDecimal("0.00");
    private SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
    private DecimalFormat decimalFormat = new DecimalFormat("0.00");
    private MyVacationActionHelper actionHelper = new MyVacationActionHelper();

    public ActionForward loadPortletContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String queryDateStr = request.getParameter("queryDate");
        try {
            java.util.Date queryDate = new java.util.Date();
            if (!StringUtils.isEmpty((String)queryDateStr)) {
                queryDate = DateTimeUtils.parseDate((String)queryDateStr);
            }
            String resultMsg = this.getVacationMap(queryDate, ctx).toString();
            this.handleResult(response, resultMsg);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
        return null;
    }

    private void handleResult(HttpServletResponse response, String resultMsg) {
        try {
            response.setContentType("text/json;charset=utf-8");
            response.getWriter().write(resultMsg);
            response.getWriter().flush();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
    }

    private JSONObject getVacationMap(java.util.Date date, Context ctx) {
        PersonInfo curPerson = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        this.hasLeavedDate = new BigDecimal("0.00");
        this.leaveBillInfos = new ArrayList();
        if (curPerson != null) {
            Date monthStartDate = DateUtil.getSQLBegin((java.util.Date)DateUtil.getFirstDayOfMonth((java.util.Date)date));
            Date monthEndDate = DateUtil.getSQLBegin((java.util.Date)DateUtil.getLastDayOfMonth((java.util.Date)date));
            JSONObject outerMap = new JSONObject();
            JSONObject map = new JSONObject();
            JSONObject wfMap = new JSONObject();
            HashMap<java.util.Date, String> dateMap = new HashMap<java.util.Date, String>();
            ArrayList<java.util.Date> dateList = new ArrayList<java.util.Date>();
            try {
                ArrayList infoList = new ArrayList();
                MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.time.app", "LeaveDetailCheckQuery");
                IQueryExecutor queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)curPerson.getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("startDateReal", (Object)monthEndDate, CompareType.LESS_EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("endDateReal", (Object)monthStartDate, CompareType.GREATER_EQUALS));
                evi.setFilter(filter);
                queryExecutor.setObjectView(evi);
                IRowSet set2 = queryExecutor.executeQuery();
                set2.beforeFirst();
                while (set2.next()) {
                    HashMap<String, Object> infoMap = new HashMap<String, Object>();
                    String type = set2.getString("timeAttendance.name");
                    infoMap.put("type", type);
                    String unitType = UnitTypeEnum.getEnum(set2.getInt("timeAttendance.unitType")).getAlias();
                    infoMap.put("unitType", unitType);
                    BigDecimal totalRegReal = set2.getBigDecimal("totalRegReal");
                    infoMap.put("totalRegReal", totalRegReal);
                    String billEntryId = set2.getString("leaveDetailEntryId");
                    String billId = "";
                    if (!StringUtil.isEmptyString((String)billEntryId)) {
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("bill"));
                        sic.add(new SelectorItemInfo("bill.id"));
                        LeaveBillEntryInfo leaveBillEntry = LeaveBillEntryFactory.getRemoteInstance().getLeaveBillEntryInfo((IObjectPK)new ObjectUuidPK(billEntryId), sic);
                        if (leaveBillEntry.getBill() != null) {
                            billId = leaveBillEntry.getBill().getId().toString();
                        }
                    }
                    infoMap.put("billId", billId);
                    Date beginDate = DateUtil.getSQLBegin((java.util.Date)set2.getDate("startDateReg"));
                    infoMap.put("beginDate", beginDate);
                    Date endDate = DateUtil.getSQLBegin((java.util.Date)set2.getDate("endDateReg"));
                    infoMap.put("endDate", endDate);
                    BigDecimal leaveLength = set2.getBigDecimal("totalReg");
                    infoMap.put("leaveLength", leaveLength);
                    Date lpBeginDate = DateUtil.getSQLBegin((java.util.Date)set2.getDate("startDateReal"));
                    infoMap.put("lpBeginDate", lpBeginDate);
                    Date lpEndDate = DateUtil.getSQLBegin((java.util.Date)set2.getDate("endDateReal"));
                    infoMap.put("lpEndDate", lpEndDate);
                    BigDecimal lpLeaveLength = set2.getBigDecimal("totalRegReal");
                    infoMap.put("lpLeaveLength", lpLeaveLength);
                    infoList.add(infoMap);
                }
                IRowSet set = this.actionHelper.getDataRows(ctx, curPerson.getId().toString(), monthEndDate, monthStartDate, CompareType.LESS_EQUALS, CompareType.GREATER_EQUALS);
                infoList.addAll(this.actionHelper.getInfoMap(set));
                int size = infoList.size();
                for (int i = 0; i < size; ++i) {
                    SelectItem leaveInfo;
                    String title;
                    String descrption;
                    BigDecimal leaveLength;
                    java.util.Date endDate;
                    java.util.Date beginDate;
                    Map infoMap = (Map)infoList.get(i);
                    String type = (String)infoMap.get("type");
                    String unitType = (String)infoMap.get("unitType");
                    BigDecimal totalRegReal = (BigDecimal)infoMap.get("totalRegReal");
                    String billId = (String)infoMap.get("billId");
                    if (totalRegReal == null) {
                        beginDate = (java.util.Date)infoMap.get("beginDate");
                        endDate = (java.util.Date)infoMap.get("endDate");
                        leaveLength = (BigDecimal)infoMap.get("leaveLength");
                        this.hasLeavedDate = this.hasLeavedDate.add(leaveLength);
                        descrption = ResourceBase.getString((String)this.RES, (String)"has", (Locale)ctx.getLocale()) + type + this.decimalFormat.format(leaveLength) + unitType;
                        title = DateTimeUtils.getMonth((java.util.Date)beginDate) + ResourceBase.getString((String)this.RES, (String)"month", (Locale)ctx.getLocale()) + DateTimeUtils.getDay((java.util.Date)beginDate) + ResourceBase.getString((String)this.RES, (String)"date", (Locale)ctx.getLocale()) + "~" + DateTimeUtils.getMonth((java.util.Date)endDate) + ResourceBase.getString((String)this.RES, (String)"month", (Locale)ctx.getLocale()) + DateTimeUtils.getDay((java.util.Date)endDate) + ResourceBase.getString((String)this.RES, (String)"date", (Locale)ctx.getLocale()) + descrption;
                        leaveInfo = new SelectItem(billId, title);
                        if (!this.actionHelper.hasInfo(this.leaveBillInfos, leaveInfo)) {
                            this.leaveBillInfos.add(leaveInfo);
                        }
                        wfMap.put(leaveInfo.getLabel(), leaveInfo.getValue());
                        while (!beginDate.after(endDate)) {
                            if (!dateList.contains(beginDate)) {
                                dateList.add(beginDate);
                                dateMap.put(beginDate, descrption);
                            }
                            beginDate = DateUtil.getSQLBegin((java.util.Date)DateUtil.getAfterDay((java.util.Date)beginDate));
                        }
                        continue;
                    }
                    beginDate = (java.util.Date)infoMap.get("lpBeginDate");
                    endDate = (java.util.Date)infoMap.get("lpEndDate");
                    leaveLength = (BigDecimal)infoMap.get("lpLeaveLength");
                    this.hasLeavedDate = this.hasLeavedDate.add(leaveLength);
                    descrption = ResourceBase.getString((String)this.RES, (String)"has", (Locale)ctx.getLocale()) + type + this.decimalFormat.format(leaveLength) + unitType;
                    title = DateTimeUtils.getMonth((java.util.Date)beginDate) + ResourceBase.getString((String)this.RES, (String)"month", (Locale)ctx.getLocale()) + DateTimeUtils.getDay((java.util.Date)beginDate) + ResourceBase.getString((String)this.RES, (String)"date", (Locale)ctx.getLocale()) + "~" + DateTimeUtils.getMonth((java.util.Date)endDate) + ResourceBase.getString((String)this.RES, (String)"month", (Locale)ctx.getLocale()) + DateTimeUtils.getDay((java.util.Date)endDate) + ResourceBase.getString((String)this.RES, (String)"date", (Locale)ctx.getLocale()) + descrption;
                    leaveInfo = new SelectItem(billId, title);
                    if (!this.actionHelper.hasInfo(this.leaveBillInfos, leaveInfo)) {
                        this.leaveBillInfos.add(leaveInfo);
                    }
                    wfMap.put(leaveInfo.getLabel(), leaveInfo.getValue());
                    while (!beginDate.after(endDate)) {
                        if (!dateList.contains(beginDate)) {
                            dateList.add(beginDate);
                            dateMap.put(beginDate, descrption);
                        }
                        beginDate = DateUtil.getSQLBegin((java.util.Date)DateUtil.getAfterDay((java.util.Date)beginDate));
                    }
                }
                while (!monthStartDate.after(monthEndDate)) {
                    if (dateList.contains(monthStartDate)) {
                        map.put(this.sf.format(monthStartDate), dateMap.get(monthStartDate));
                    }
                    monthStartDate = DateUtil.getSQLBegin((java.util.Date)DateUtil.getAfterDay((java.util.Date)monthStartDate));
                }
            }
            catch (BOSException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (SQLException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (EASBizException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            outerMap.put("detail", (Object)map);
            outerMap.put("wf", (Object)wfMap);
            return outerMap;
        }
        return null;
    }

    public ActionForward getAnnualData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        JSONObject outerMap = new JSONObject();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String queryDateStr = request.getParameter("queryDate");
        try {
            java.util.Date queryDate = new java.util.Date();
            if (!StringUtils.isEmpty((String)queryDateStr)) {
                queryDate = DateTimeUtils.parseDate((String)queryDateStr);
            }
            String dayRes = ResourceBase.getString((String)"com.kingdee.eas.hr.time.TimeWebResource", (String)"DAY", (Locale)ctx.getLocale());
            outerMap.put("thisMonHad", (Object)(this.decimalFormat.format(this.getLeavedDate()) + dayRes));
            outerMap.put("yearLeaveMax", (Object)(this.decimalFormat.format(this.getAnnualDate(queryDate, ctx)) + dayRes));
            outerMap.put("hasLeave", (Object)(this.decimalFormat.format(this.getSurplusDate(queryDate, ctx)) + dayRes));
            this.handleResult(response, outerMap.toString());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
        return null;
    }

    private BigDecimal getLeavedDate() {
        return this.hasLeavedDate;
    }

    private BigDecimal getAnnualDate(java.util.Date date, Context ctx) {
        try {
            PersonInfo curPerson = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.time.app.YearVacationQuery");
            IQueryExecutor queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("personID", (Object)curPerson.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("year", (Object)this.sf.format(date).substring(0, 4)));
            evi.setFilter(filter);
            queryExecutor.setObjectView(evi);
            IRowSet set = queryExecutor.executeQuery();
            set.beforeFirst();
            BigDecimal currQuantity = new BigDecimal("0.00");
            if (set.next()) {
                currQuantity = set.getBigDecimal("currQuantity");
            }
            return currQuantity;
        }
        catch (BOSException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private BigDecimal getSurplusDate(java.util.Date date, Context ctx) {
        try {
            PersonInfo curPerson = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.time.app.YearVacationQuery");
            IQueryExecutor queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("personID", (Object)curPerson.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("year", (Object)this.sf.format(date).substring(0, 4)));
            evi.setFilter(filter);
            queryExecutor.setObjectView(evi);
            IRowSet set = queryExecutor.executeQuery();
            set.beforeFirst();
            BigDecimal currAvailable = new BigDecimal("0.00");
            if (set.next()) {
                currAvailable = set.getBigDecimal("currAvailable");
            }
            return currAvailable;
        }
        catch (BOSException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

