/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.time.UnitTypeEnum;
import com.kingdee.eas.hr.time.web.SelectItem;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MyVacationActionHelper {
    private static Logger logger = Logger.getLogger(MyVacationActionHelper.class);

    public IRowSet getDataRows(Context ctx, String personid, Date beginDate, Date endDate, CompareType beginType, CompareType endType) throws BOSException, EASBizException {
        IRowSet iRowSet = null;
        if (personid == null) {
            return iRowSet;
        }
        if (beginDate == null) {
            beginDate = new Date();
        }
        if (endDate == null) {
            endDate = new Date();
        }
        endDate = DateTimeUtils.truncateDate((Date)endDate);
        beginDate = DateTimeUtils.truncateDate((Date)beginDate);
        beginDate = DateTimeUtils.addDay((Date)DateTimeUtils.addSecond((Date)beginDate, (long)-1L), (long)1L);
        StringBuffer strBuffer = new StringBuffer("SELECT \"LEAVEBILLENTRY\".FBillID AS \"LEAVEBILLENTRY.BillID\",\"HRTYPE\".FID AS \"HRTYPE.ID\",  \"LEAVEREPORTBILL\".FReportToState AS \"LEAVEREPORTBILL.FReportToState\", \"HRTYPE\".FName");
        strBuffer.append(this.getLocal(ctx));
        strBuffer.append(" AS \"HRTYPE.NAME\", \"HRTYPE\".FUnitType AS \"HRTYPE.UNITTYPE\", \"PERSON\".FID AS \"PERSON.ID\", ");
        strBuffer.append(" \"LEAVEBILLENTRY\".FBeginTime AS \"BEGINTIME\", \"LEAVEBILLENTRY\".FEndTime AS \"ENDTIME\", \"LEAVEBILLENTRY\".FLeaveLength AS \"LEAVELENGTH\",");
        strBuffer.append(" \"LPBILLENTRY\".FBeginTime AS \"LPBILLENTRY.BEGINTIME\", \"LPBILLENTRY\".FEndTime AS \"LPBILLENTRY.ENDTIME\", \"LPBILLENTRY\".FLeaveLength AS \"LPBILLENTRY.LEAVELENGTH\"");
        strBuffer.append(" FROM T_HR_LeaveBillEntry AS \"LEAVEBILLENTRY\" LEFT OUTER JOIN T_HR_LeaveReportBillEntry AS ");
        strBuffer.append(" \"LPBILLENTRY\" ON \"LEAVEBILLENTRY\".FID = \"LPBILLENTRY\".FLeaveBillEntryID");
        strBuffer.append(" INNER JOIN T_BD_Person AS \"PERSON\" ");
        strBuffer.append(" ON \"LEAVEBILLENTRY\".FPersonID = \"PERSON\".FID ");
        strBuffer.append(" INNER JOIN T_HR_TimeAttendance AS \"HRTYPE\" ");
        strBuffer.append(" ON \"LEAVEBILLENTRY\".FTypeID = \"HRTYPE\".FID ");
        strBuffer.append(" INNER JOIN T_HR_TimeAttendance AS \"REPORTTYPE\" ");
        strBuffer.append(" ON \"LPBILLENTRY\".FTypeID = \"REPORTTYPE\".FID ");
        strBuffer.append(" LEFT OUTER JOIN T_HR_LEAVEREPORTBILL AS \"LEAVEREPORTBILL\" ");
        strBuffer.append(" ON \"LPBILLENTRY\".FBillID = \"LEAVEREPORTBILL\".FID ");
        strBuffer.append(" WHERE (\"HRTYPE\".FID=\"REPORTTYPE\".FID OR \"REPORTTYPE\".FID IS NULL) and ");
        strBuffer.append("  (\"LEAVEREPORTBILL\".FReportToState != 0 AND \"LEAVEREPORTBILL\".FReportToState != 1) ");
        strBuffer.append("AND \"LPBILLENTRY\".FBeginTime ");
        strBuffer.append(beginType.getName());
        strBuffer.append(this.getSqlDate(beginDate));
        strBuffer.append(" and \"LPBILLENTRY\".FEndTime ");
        strBuffer.append(endType.getName());
        strBuffer.append(this.getSqlDate(endDate));
        strBuffer.append(" and \"PERSON\".FID = '");
        strBuffer.append(personid);
        strBuffer.append("'");
        strBuffer.append(" UNION ");
        strBuffer.append(" SELECT ");
        strBuffer.append(" \"LEAVEBILLENTRY\".FBillID AS \"LEAVEBILLENTRY.BillID\",\"REPORTTYPE\".FID AS \"HRTYPE.ID\", \"LEAVEREPORTBILL\".FReportToState AS \"LEAVEREPORTBILL.FReportToState\",");
        strBuffer.append(" \"REPORTTYPE\".FName");
        strBuffer.append(this.getLocal(ctx));
        strBuffer.append(" AS \"HRTYPE.NAME\", ");
        strBuffer.append("  \"REPORTTYPE\".FUnitType AS \"HRTYPE.UNITTYPE\", ");
        strBuffer.append(" \"PERSON\".FID AS \"PERSON.ID\", ");
        strBuffer.append(" TO_DATE(NULL) AS \"BEGINTIME\", ");
        strBuffer.append(" TO_DATE(NULL) AS \"ENDTIME\", ");
        strBuffer.append(" TO_DECIMAL(NULL) AS \"LEAVELENGTH\", ");
        strBuffer.append(" \"LPBILLENTRY\".FBeginTime AS \"LPBILLENTRY.BEGINTIME\", ");
        strBuffer.append(" \"LPBILLENTRY\".FEndTime AS \"LPBILLENTRY.ENDTIME\", ");
        strBuffer.append(" \"LPBILLENTRY\".FLeaveLength AS \"LPBILLENTRY.LEAVELENGTH\" ");
        strBuffer.append(" FROM T_HR_LeaveBillEntry AS \"LEAVEBILLENTRY\" ");
        strBuffer.append(" LEFT OUTER JOIN T_HR_LeaveReportBillEntry AS \"LPBILLENTRY\" ");
        strBuffer.append(" ON \"LEAVEBILLENTRY\".FID = \"LPBILLENTRY\".FLeaveBillEntryID ");
        strBuffer.append(" INNER JOIN T_BD_Person AS \"PERSON\" ");
        strBuffer.append(" ON \"LEAVEBILLENTRY\".FPersonID = \"PERSON\".FID ");
        strBuffer.append(" LEFT OUTER JOIN T_HR_TimeAttendance AS \"HRTYPE\" ");
        strBuffer.append(" ON \"LEAVEBILLENTRY\".FTypeID = \"HRTYPE\".FID ");
        strBuffer.append(" INNER JOIN T_HR_TimeAttendance AS \"REPORTTYPE\" ");
        strBuffer.append(" ON \"LPBILLENTRY\".FTypeID = \"REPORTTYPE\".FID ");
        strBuffer.append(" LEFT OUTER JOIN T_HR_LEAVEREPORTBILL AS \"LEAVEREPORTBILL\" ");
        strBuffer.append(" ON \"LPBILLENTRY\".FBillID = \"LEAVEREPORTBILL\".FID ");
        strBuffer.append(" WHERE ((\"HRTYPE\".FID<>\"REPORTTYPE\".FID AND \"REPORTTYPE\".FID IS NOT NULL) OR \"HRTYPE\".FID IS NULL) and ");
        strBuffer.append(" (\"LEAVEREPORTBILL\".FReportToState != 0 AND \"LEAVEREPORTBILL\".FReportToState != 1) and \"LPBILLENTRY\".FBeginTime ");
        strBuffer.append(beginType.getName());
        strBuffer.append(this.getSqlDate(beginDate));
        strBuffer.append(" and \"LPBILLENTRY\".FEndTime ");
        strBuffer.append(endType.getName());
        strBuffer.append(this.getSqlDate(endDate));
        strBuffer.append(" and \"PERSON\".FID = '");
        strBuffer.append(personid);
        strBuffer.append("'");
        strBuffer.append(" UNION ");
        strBuffer.append(" SELECT ");
        strBuffer.append(" \"LEAVEBILLENTRY\".FBillID AS \"LEAVEBILLENTRY.BillID\",\"HRTYPE\".FID AS \"HRTYPE.ID\", TO_INT(NULL) AS \"LEAVEREPORTBILL.FReportToState\", ");
        strBuffer.append(" \"HRTYPE\".FName");
        strBuffer.append(this.getLocal(ctx));
        strBuffer.append(" AS \"HRTYPE.NAME\", ");
        strBuffer.append(" \"HRTYPE\".FUnitType AS \"HRTYPE.UNITTYPE\", ");
        strBuffer.append(" \"PERSON\".FID AS \"PERSON.ID\", ");
        strBuffer.append(" \"LEAVEBILLENTRY\".FBeginTime AS \"BEGINTIME\", ");
        strBuffer.append(" \"LEAVEBILLENTRY\".FEndTime AS \"ENDTIME\", ");
        strBuffer.append(" \"LEAVEBILLENTRY\".FLeaveLength AS \"LEAVELENGTH\", ");
        strBuffer.append(" TO_DATE(NULL) AS \"LPBILLENTRY.BEGINTIME\", ");
        strBuffer.append(" TO_DATE(NULL) AS \"LPBILLENTRY.ENDTIME\", ");
        strBuffer.append(" TO_DECIMAL(NULL) AS \"LPBILLENTRY.LEAVELENGTH\" ");
        strBuffer.append(" FROM T_HR_LeaveBillEntry AS \"LEAVEBILLENTRY\" ");
        strBuffer.append(" LEFT OUTER JOIN T_HR_LeaveReportBillEntry AS \"LPBILLENTRY\" ");
        strBuffer.append(" ON \"LEAVEBILLENTRY\".FID = \"LPBILLENTRY\".FLeaveBillEntryID ");
        strBuffer.append(" INNER JOIN T_BD_Person AS \"PERSON\" ");
        strBuffer.append(" ON \"LEAVEBILLENTRY\".FPersonID = \"PERSON\".FID ");
        strBuffer.append(" INNER JOIN T_HR_TimeAttendance AS \"HRTYPE\" ");
        strBuffer.append(" ON \"LEAVEBILLENTRY\".FTypeID = \"HRTYPE\".FID ");
        strBuffer.append(" LEFT OUTER JOIN T_HR_TimeAttendance AS \"REPORTTYPE\" ");
        strBuffer.append(" ON \"LPBILLENTRY\".FTypeID = \"REPORTTYPE\".FID ");
        strBuffer.append(" WHERE ((\"HRTYPE\".FID<>\"REPORTTYPE\".FID AND \"HRTYPE\".FID IS NOT NULL) OR \"REPORTTYPE\".FID IS NULL) ");
        strBuffer.append(" AND \"LEAVEBILLENTRY\".FBeginTime ");
        strBuffer.append(beginType.getName());
        strBuffer.append(this.getSqlDate(beginDate));
        strBuffer.append(" and \"LEAVEBILLENTRY\".FEndTime ");
        strBuffer.append(endType.getName());
        strBuffer.append(this.getSqlDate(endDate));
        strBuffer.append(" and \"PERSON\".FID = '");
        strBuffer.append(personid);
        strBuffer.append("'");
        return DbUtil.executeQuery((Context)ctx, (String)strBuffer.toString());
    }

    private String getSqlDate(Date date) throws BOSException {
        String strTime = DateTimeUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
        String strKSQLTime = "{ts '" + strTime + "'}";
        return strKSQLTime;
    }

    private String getLocal(Context ctx) {
        String localString = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        return localString;
    }

    public List getInfoMap(IRowSet set) {
        ArrayList list = new ArrayList();
        try {
            set.beforeFirst();
            while (set.next()) {
                HashMap<String, Object> infoMap = new HashMap<String, Object>();
                String type = set.getString("hrtype.name");
                infoMap.put("type", type);
                String unitType = UnitTypeEnum.getEnum(set.getInt("hrtype.unittype")).getAlias();
                infoMap.put("unitType", unitType);
                BigDecimal totalRegReal = set.getBigDecimal("lpbillentry.leavelength");
                infoMap.put("totalRegReal", totalRegReal);
                String billId = set.getString("leavebillentry.billid");
                infoMap.put("billId", billId);
                java.sql.Date beginDate = DateUtil.getSQLBegin((Date)set.getDate("begintime"));
                infoMap.put("beginDate", beginDate);
                java.sql.Date endDate = DateUtil.getSQLBegin((Date)set.getDate("endtime"));
                infoMap.put("endDate", endDate);
                BigDecimal leaveLength = set.getBigDecimal("leavelength");
                infoMap.put("leaveLength", leaveLength);
                if (set.getDate("lpbillentry.begintime") != null) {
                    java.sql.Date lpBeginDate = DateUtil.getSQLBegin((Date)set.getDate("lpbillentry.begintime"));
                    infoMap.put("lpBeginDate", lpBeginDate);
                }
                if (set.getDate("lpbillentry.endtime") != null) {
                    java.sql.Date lpEndDate = DateUtil.getSQLBegin((Date)set.getDate("lpbillentry.endtime"));
                    infoMap.put("lpEndDate", lpEndDate);
                }
                BigDecimal lpLeaveLength = set.getBigDecimal("lpbillentry.leavelength");
                infoMap.put("lpLeaveLength", lpLeaveLength);
                list.add(infoMap);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return list;
    }

    public boolean hasInfo(List infos, SelectItem leaveInfo) {
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            SelectItem info = (SelectItem)infos.get(i);
            if (!info.getValue().toString().equals(leaveInfo.getValue().toString())) continue;
            return true;
        }
        return false;
    }
}

