/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.BgPeriodYearEnum;
import com.kingdee.eas.ma.base.BgSelfDefinedPeriodInfo;
import com.kingdee.eas.ma.base.IBgPeriodDisp;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.STConverter;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgPeriodInfoFactory {
    private static final Logger logger = CoreUIObject.getLogger(BgPeriodInfoFactory.class);
    public static final int DEFALT_BENGINDYEAR = 2000;
    public static final int DEFALT_ENDYEAR = 2099;
    private BgPeriodTypeInfo bgPeriodTypeInfo;
    public int startTime = 1;
    public static final int DEFAULT_STARTTIME = 1;
    private boolean isStrideYear = false;
    protected CalendarHelper helper = new CalendarHelper();
    private Map<Integer, Map<Integer, BgPeriodInfo>> periodsFromDB;
    public List<BgSelfDefinedPeriodInfo> selfDefinedInfo;
    private int showlevel = 1;
    private Context ctx;
    List<BgPeriodInfo> resultVal = new ArrayList<BgPeriodInfo>();
    private Locale locale = null;
    protected Locale eLocale = new Locale("l1");
    protected Locale sLocale = new Locale("l2");
    protected Locale tLocale = new Locale("l3");
    private int sequence;
    protected DecimalFormat df = new DecimalFormat("00");
    protected Map<String, BgPeriodInfo> periodMap = new HashMap<String, BgPeriodInfo>();

    public Map<Integer, Map<Integer, BgPeriodInfo>> getPeriodsFromDB() {
        return this.periodsFromDB;
    }

    public void setPeriodsFromDB(Map<Integer, Map<Integer, BgPeriodInfo>> periodsFromDB) {
        this.periodsFromDB = periodsFromDB;
    }

    public BgPeriodInfoFactory(BgPeriodTypeInfo bgPeriodTypeInfo, Locale locale) {
        this.setBgPeriodTypeInfo(bgPeriodTypeInfo);
        this.locale = locale;
    }

    public BgPeriodInfoFactory(BgPeriodTypeInfo bgPeriodTypeInfo, Locale locale, int startTime, boolean isStrideYear) {
        this(bgPeriodTypeInfo, locale);
        this.startTime = startTime;
        this.isStrideYear = isStrideYear;
    }

    public BgPeriodInfoFactory(Context ctx, BgPeriodTypeInfo bgPeriodTypeInfo, List<BgSelfDefinedPeriodInfo> selfDefinedInfo, Locale locale) throws BOSException {
        this.setBgPeriodTypeInfo(bgPeriodTypeInfo);
        this.ctx = ctx;
        this.locale = locale;
        this.selfDefinedInfo = selfDefinedInfo;
        this.sequence = 1;
        if (BgNPeriodHelper.isOnlySelfDefinedPeriod(bgPeriodTypeInfo)) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection coll = new SelectorItemCollection();
            coll.add("number");
            coll.add("longnumber");
            coll.add("showlevel");
            coll.add("id");
            coll.add("bgPeriod.id");
            coll.add("bgPeriod.number");
            coll.add("bgPeriod.longnumber");
            view.setSelector(coll);
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("type.id", (Object)bgPeriodTypeInfo.getId());
            view.getSorter().add(new SorterItemInfo("number"));
            view.setFilter(filter);
            IBgPeriodDisp instance = null;
            instance = ctx == null ? BgPeriodDispFactory.getRemoteInstance() : BgPeriodDispFactory.getLocalInstance(ctx);
            BgPeriodDispCollection bgPeriodCollection = instance.getBgPeriodDispCollection(view);
            if (bgPeriodCollection != null && !bgPeriodCollection.isEmpty()) {
                for (int i = bgPeriodCollection.size() - 1; i >= 0; --i) {
                    BgPeriodDispInfo bgPeriodDispInfo = bgPeriodCollection.get(i);
                    if (!bgPeriodDispInfo.getNumber().equals(bgPeriodDispInfo.getLongNumber())) continue;
                    String substring = bgPeriodDispInfo.getNumber().substring(11);
                    this.sequence = Integer.parseInt(substring) + 1;
                    break;
                }
                this.showlevel = bgPeriodCollection.get(bgPeriodCollection.size() - 1).getShowLevel();
            }
        }
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public List<BgPeriodInfo> createBgPeriodInfos(int startYear, int endYear, boolean hasPersonal) {
        this.resultVal.clear();
        for (int year = startYear; year <= endYear; ++year) {
            this.processYear(year, hasPersonal);
        }
        return this.resultVal;
    }

    protected void processYear(int selYear, boolean hasPersonal) {
        String YearNumber = null;
        boolean isLeaf = this.bgPeriodTypeInfo.isYear() && !this.bgPeriodTypeInfo.isHalfYear() && !this.bgPeriodTypeInfo.isQuarter() && !this.bgPeriodTypeInfo.isMonth() && !this.bgPeriodTypeInfo.isDay() && !this.bgPeriodTypeInfo.isYearWeek() && !this.bgPeriodTypeInfo.isMothWeek() && !this.bgPeriodTypeInfo.isTenday();
        BgPeriodInfo bgPeriodYear = null;
        if (this.bgPeriodTypeInfo.isYear()) {
            YearNumber = this.bgPeriodTypeInfo.getNumber() + "." + selYear + "Y";
            bgPeriodYear = this.periodMap.get(YearNumber);
            if (bgPeriodYear == null) {
                bgPeriodYear = new BgPeriodInfo();
                bgPeriodYear.setId(BOSUuid.create((BOSObjectType)bgPeriodYear.getBOSType()));
                bgPeriodYear.setNumber(YearNumber);
                bgPeriodYear.setLongNumber(YearNumber);
                bgPeriodYear.setName(selYear + this.getString("Year", this.eLocale), this.eLocale);
                bgPeriodYear.setName(selYear + this.getString("Year", this.sLocale), this.sLocale);
                bgPeriodYear.setName(STConverter.sc2tc((String)bgPeriodYear.getName(this.sLocale)), this.tLocale);
                if (this.bgPeriodTypeInfo.getBelongYear() != null && BgPeriodYearEnum.getEnumList().contains((Object)this.bgPeriodTypeInfo.getBelongYear())) {
                    int currentYear;
                    int n = currentYear = BgPeriodYearEnum.lastYear.equals((Object)this.bgPeriodTypeInfo.getBelongYear()) ? selYear - 1 : selYear;
                    if (this.getPeriodsFromDB() != null) {
                        bgPeriodYear.setBeginDate(this.getPeriodsFromDB().get(currentYear).get(this.bgPeriodTypeInfo.getStartMonth().getValue()).getBeginDate());
                        bgPeriodYear.setEndDate(this.getPeriodsFromDB().get(currentYear + 1).get(this.bgPeriodTypeInfo.getStartMonth().getValue() - 1).getEndDate());
                    } else {
                        bgPeriodYear.setBeginDate(this.getCalHelper().getStartDate(this.getCalHelper().getFirstDayOfMonth(currentYear, this.bgPeriodTypeInfo.getStartMonth().getValue())));
                        bgPeriodYear.setEndDate(this.getCalHelper().getBeoverDate(this.getCalHelper().getLastDayOfMonth(currentYear + 1, this.bgPeriodTypeInfo.getStartMonth().getValue() - 1)));
                    }
                } else {
                    bgPeriodYear.setBeginDate(this.getCalHelper().getStartDate(this.getCalHelper().getFirstDayOfYear(selYear, this.startTime, this.isStrideYear)));
                    bgPeriodYear.setEndDate(this.getCalHelper().getBeoverDate(this.getCalHelper().getLastDayOfYear(selYear, this.startTime, this.isStrideYear)));
                    bgPeriodYear.setIsStrideYear(this.isStrideYear);
                    bgPeriodYear.setStartTime(this.startTime);
                }
                if (hasPersonal) {
                    bgPeriodYear.setPeriodType(BgPeriodEnum.PERSONAL_YEAE);
                } else {
                    bgPeriodYear.setPeriodType(BgPeriodEnum.YEAR);
                }
                bgPeriodYear.setYear(selYear);
                bgPeriodYear.setMonth(this.getCalHelper().getMonthsOfYear());
                bgPeriodYear.setLevel(1);
                bgPeriodYear.setShowLevel(1000000);
            }
            bgPeriodYear.setIsLeaf(isLeaf);
            this.resultVal.add(bgPeriodYear);
            if (this.bgPeriodTypeInfo.isHalfYear()) {
                this.processHalfYear(selYear, bgPeriodYear, hasPersonal);
            }
            if (this.bgPeriodTypeInfo.isYearWeek()) {
                this.processYearWeek(selYear, bgPeriodYear, hasPersonal);
            }
            if (this.bgPeriodTypeInfo.isYear() && !this.bgPeriodTypeInfo.isHalfYear() && this.bgPeriodTypeInfo.isSelfDefined()) {
                this.processSelfDefined(selYear, bgPeriodYear, BgPeriodEnum.PERSONAL_YEAE, false);
            }
        }
    }

    private void processSelfDefined(int selYear, BgPeriodInfo bgPeriodInfo, BgPeriodEnum enumType, boolean isNeedParentName) {
        if (this.selfDefinedInfo == null || this.selfDefinedInfo.isEmpty()) {
            return;
        }
        int level = 0;
        int showLevel = this.showlevel;
        String longNumber2 = "";
        if (bgPeriodInfo != null) {
            bgPeriodInfo.setIsLeaf(false);
            level = bgPeriodInfo.getLevel();
            longNumber2 = bgPeriodInfo.getLongNumber();
            showLevel = bgPeriodInfo.getShowLevel();
        }
        BgPeriodInfo bgSelfDefPeriod = null;
        ArrayList<BgPeriodInfo> bgSelfDefPeriods = new ArrayList<BgPeriodInfo>();
        ArrayList<BgSelfDefinedPeriodInfo> template = new ArrayList<BgSelfDefinedPeriodInfo>();
        for (BgSelfDefinedPeriodInfo bgSelfDefinedPeriodInfo : this.selfDefinedInfo) {
            template.add((BgSelfDefinedPeriodInfo)bgSelfDefinedPeriodInfo.deepClone());
        }
        for (BgSelfDefinedPeriodInfo bgSelfDefinedPeriodInfo : template) {
            if (longNumber2 != null && !"".equals(longNumber2.trim())) {
                bgSelfDefinedPeriodInfo.setLongNumber(longNumber2 + "!" + bgSelfDefinedPeriodInfo.getLongNumber());
            }
            bgSelfDefPeriod = new BgPeriodInfo();
            bgSelfDefPeriod.setId(BOSUuid.create((BOSObjectType)bgSelfDefPeriod.getBOSType()));
            bgSelfDefPeriod.setPeriodType(enumType);
            bgSelfDefPeriod.setYear(selYear);
            bgSelfDefPeriod.setIsLeaf(bgSelfDefinedPeriodInfo.isIsleaf());
            bgSelfDefPeriod.setName(bgSelfDefinedPeriodInfo.getName());
            bgSelfDefPeriod.setLevel(bgSelfDefinedPeriodInfo.getLevel());
            bgSelfDefPeriod.setNumber(bgSelfDefinedPeriodInfo.getNumber().replace("[Year]", selYear + "Y"));
            bgSelfDefPeriod.setLongNumber(bgSelfDefinedPeriodInfo.getLongNumber().replace("[Year]", selYear + "Y"));
            bgSelfDefPeriod.setSimpleName(selYear + "");
            bgSelfDefPeriods.add(bgSelfDefPeriod);
            if (BgNPeriodHelper.isOnlySelfDefinedPeriod(this.bgPeriodTypeInfo)) {
                bgSelfDefPeriod.setBeginDate(this.helper.getFirstDayOfYear(2000));
                bgSelfDefPeriod.setEndDate(this.helper.getLastDayOfYear(2099));
                continue;
            }
            if (bgPeriodInfo == null) continue;
            bgSelfDefPeriod.setBeginDate(bgPeriodInfo.getBeginDate());
            bgSelfDefPeriod.setEndDate(bgPeriodInfo.getEndDate());
        }
        int i = 1;
        for (BgPeriodInfo bgPeriodInfo2 : bgSelfDefPeriods) {
            if (bgPeriodInfo2.getLevel() == 1) {
                this.modifySelfRootNumber(level, showLevel, bgSelfDefPeriods, bgPeriodInfo2);
            }
            bgPeriodInfo2.setShowLevel(showLevel + i);
            ++i;
        }
        HashMap<String, BgPeriodInfo> hashMap = new HashMap<String, BgPeriodInfo>();
        for (BgPeriodInfo bgPeriodInfo2 : bgSelfDefPeriods) {
            hashMap.put(bgPeriodInfo2.getLongNumber(), bgPeriodInfo2);
        }
        String string = "";
        String longNumber = "";
        BgPeriodInfo parent = null;
        int count = 0;
        HashMap<BgPeriodInfo, Integer> pCountMap = new HashMap<BgPeriodInfo, Integer>();
        for (BgPeriodInfo info : bgSelfDefPeriods) {
            String string2;
            longNumber = info.getLongNumber();
            if (longNumber.contains("!") && hashMap.containsKey(string2 = longNumber.substring(0, longNumber.lastIndexOf("!")))) {
                if (((BgPeriodInfo)hashMap.get(string2)).equals(parent)) {
                    parent = (BgPeriodInfo)hashMap.get(string2);
                    info.setParent(parent);
                    this.modifyNumber(level, ++count, bgSelfDefPeriods, info, parent);
                    pCountMap.put(parent, count);
                } else {
                    parent = (BgPeriodInfo)hashMap.get(string2);
                    info.setParent(parent);
                    count = pCountMap.containsKey(parent) ? (Integer)pCountMap.get(parent) + 1 : 0;
                    this.modifyNumber(level, count, bgSelfDefPeriods, info, parent);
                    pCountMap.put(parent, count);
                }
            }
            if (!longNumber.equals(longNumber2 + "!" + info.getNumber())) continue;
            info.setParent(bgPeriodInfo);
        }
        for (BgPeriodInfo info : bgSelfDefPeriods) {
            String _longNumber = info.getLongNumber();
            if (!_longNumber.contains("!")) continue;
            info.setLongNumber(info.getParent().getLongNumber() + "!" + info.getNumber());
            if (!isNeedParentName) continue;
            info.setName(info.getParent().getName() + info.getName());
        }
        this.resultVal.addAll(bgSelfDefPeriods);
    }

    private void modifyNumber(int level, int count, List<BgPeriodInfo> bgSelfDefPeriods, BgPeriodInfo bgPeriodInfo2, BgPeriodInfo p) {
        String number = bgPeriodInfo2.getNumber();
        String index = number.substring(11);
        String newIndex = this.getNumberSuffix(p.getNumber()) + "." + this.getFormatStr(count);
        bgPeriodInfo2.setNumber(number.replace(index, newIndex));
        bgPeriodInfo2.setLevel(level + bgPeriodInfo2.getLevel());
    }

    private void modifySelfRootNumber(int level, int showLevel, List<BgPeriodInfo> bgSelfDefPeriods, BgPeriodInfo bgPeriodInfo2) {
        String number = bgPeriodInfo2.getNumber();
        String index = number.substring(number.lastIndexOf("["));
        String newIndex = this.getFormatNumberIndex();
        bgPeriodInfo2.setLevel(level + bgPeriodInfo2.getLevel());
        for (BgPeriodInfo bgPeriodInfo3 : bgSelfDefPeriods) {
            bgPeriodInfo3.setNumber(bgPeriodInfo3.getNumber().replace(index, newIndex));
            bgPeriodInfo3.setLongNumber(bgPeriodInfo3.getLongNumber().replace(index, newIndex));
        }
    }

    private String getFormatStr(int i) {
        String str = "";
        str = i < 9 ? str + "00" + (i + 1) : (i >= 9 && i < 99 ? str + "0" + (i + 1) : str + (i + 1));
        return str;
    }

    private String getNumberSuffix(String number) {
        return number.substring(11);
    }

    private String getFormatNumberIndex() {
        String str = "";
        str = this.sequence <= 9 ? str + "00" + this.sequence : (this.sequence >= 10 && this.sequence <= 99 ? str + "0" + this.sequence : str + this.sequence);
        ++this.sequence;
        return str;
    }

    private void processYearWeek(int Year, BgPeriodInfo bgPeriodYear, boolean hasPersonal) {
        String Week = null;
        BgPeriodInfo bgPeriodWeek = null;
        int w = BgPeriodHelper.getWeek(Year, true);
        for (int i = 1; i <= w; ++i) {
            Week = this.df.format(i);
            String WeekNumber = new StringBuffer(bgPeriodYear.getNumber() + "." + Week + "W").toString();
            bgPeriodWeek = this.periodMap.get(WeekNumber);
            if (bgPeriodWeek == null) {
                bgPeriodWeek = new BgPeriodInfo();
                bgPeriodWeek.setId(BOSUuid.create((BOSObjectType)bgPeriodWeek.getBOSType()));
                bgPeriodWeek.setNumber(WeekNumber);
                bgPeriodWeek.setLongNumber(bgPeriodYear.getLongNumber() + "!" + WeekNumber);
                bgPeriodWeek.setName(bgPeriodYear.getName(this.eLocale) + Week + this.getString("Week", this.eLocale), this.eLocale);
                bgPeriodWeek.setName(bgPeriodYear.getName(this.sLocale) + Week + this.getString("Week", this.sLocale), this.sLocale);
                bgPeriodWeek.setName(STConverter.sc2tc((String)bgPeriodWeek.getName(this.sLocale)), this.tLocale);
                bgPeriodWeek.setBeginDate(this.helper.getStartDate(BgPeriodHelper.getFirstDayOfWeek(Year, i)));
                bgPeriodWeek.setEndDate(this.helper.getBeoverDate(BgPeriodHelper.getLastDayOfWeek(Year, i)));
                if (hasPersonal) {
                    bgPeriodWeek.setPeriodType(BgPeriodEnum.PERSONAL_YWEEK);
                } else {
                    bgPeriodWeek.setPeriodType(BgPeriodEnum.YWEEK);
                }
                bgPeriodWeek.setYear(Year);
                bgPeriodWeek.setMonth(this.helper.getCurrentlyMonth(bgPeriodWeek.getEndDate()));
                bgPeriodWeek.setWeek(i);
                bgPeriodWeek.setLevel(2);
                bgPeriodWeek.setShowLevel(bgPeriodYear.getShowLevel() + 10 * i);
                bgPeriodWeek.setIsLeaf(!this.bgPeriodTypeInfo.isDay());
                bgPeriodWeek.setParent(bgPeriodYear);
            }
            this.resultVal.add(bgPeriodWeek);
            if (!this.bgPeriodTypeInfo.isDay() || !this.bgPeriodTypeInfo.isYearWeek() || this.bgPeriodTypeInfo.isTenday() || this.bgPeriodTypeInfo.isMothWeek()) continue;
            int currentlyMonth0 = this.helper.getCurrentlyMonth(bgPeriodWeek.getBeginDate());
            int currentlyMonth1 = this.helper.getCurrentlyMonth(bgPeriodWeek.getEndDate());
            if (currentlyMonth1 == currentlyMonth0) {
                this.processDay(Year, (currentlyMonth1 + 2) / 3, currentlyMonth1, bgPeriodWeek, hasPersonal);
                continue;
            }
            this.processDay(Year, (currentlyMonth0 + 2) / 3, currentlyMonth0, bgPeriodWeek, hasPersonal);
            this.processDay(Year, (currentlyMonth1 + 2) / 3, currentlyMonth1, bgPeriodWeek, hasPersonal);
        }
    }

    private String getHalfYearName(int i, Locale locale) {
        String s = "";
        if (i == 1) {
            s = this.getString("firstHalf", locale);
        } else if (i == 2) {
            s = this.getString("secondhalf", locale);
        }
        return s;
    }

    protected void processHalfYear(int year, BgPeriodInfo bgPeriodYear, boolean hasPersonal) {
        String halfYear = null;
        String halfYearNumber = null;
        BgPeriodInfo bgPeriodHalfYear = null;
        boolean isLeaf = true;
        if (this.bgPeriodTypeInfo.isQuarter()) {
            isLeaf = false;
        }
        for (int i = 1; i <= 2; ++i) {
            halfYear = this.df.format(i);
            halfYearNumber = new StringBuffer(bgPeriodYear.getNumber() + "." + halfYear + "HY").toString();
            bgPeriodHalfYear = this.periodMap.get(halfYearNumber);
            if (bgPeriodHalfYear == null) {
                bgPeriodHalfYear = new BgPeriodInfo();
                bgPeriodHalfYear.setId(BOSUuid.create((BOSObjectType)bgPeriodHalfYear.getBOSType()));
                bgPeriodHalfYear.setNumber(halfYearNumber);
                bgPeriodHalfYear.setLongNumber(bgPeriodYear.getLongNumber() + "!" + halfYearNumber);
                bgPeriodHalfYear.setName(bgPeriodYear.getName(this.eLocale) + this.getHalfYearName(i, this.eLocale), this.eLocale);
                bgPeriodHalfYear.setName(bgPeriodYear.getName(this.sLocale) + this.getHalfYearName(i, this.sLocale), this.sLocale);
                bgPeriodHalfYear.setName(STConverter.sc2tc((String)bgPeriodHalfYear.getName(this.sLocale)), this.tLocale);
                if (this.bgPeriodTypeInfo.getBelongYear() != null && BgPeriodYearEnum.getEnumList().contains((Object)this.bgPeriodTypeInfo.getBelongYear())) {
                    int currentYear;
                    int n = currentYear = BgPeriodYearEnum.lastYear.equals((Object)this.bgPeriodTypeInfo.getBelongYear()) ? year - 1 : year;
                    if (this.getPeriodsFromDB() != null) {
                        this.setBgPeriodHalfYearBeginDateByDB(currentYear, bgPeriodHalfYear, i);
                        this.setBgPeriodHalfYearEndDateByDB(currentYear, bgPeriodHalfYear, i);
                    } else {
                        bgPeriodHalfYear.setBeginDate(this.getCalHelper().getStartDate(BgPeriodHelper.getHalfYearFirstDayBySelfDefined(currentYear, i, this.bgPeriodTypeInfo.getStartMonth().getValue())));
                        bgPeriodHalfYear.setEndDate(this.getCalHelper().getBeoverDate(BgPeriodHelper.getHalfYearLastDayBySelfDefined(currentYear, i, this.bgPeriodTypeInfo.getStartMonth().getValue())));
                    }
                } else {
                    bgPeriodHalfYear.setBeginDate(this.getCalHelper().getStartDate(BgPeriodHelper.getHalfYearFirstDay(year, i, this.startTime, this.isStrideYear)));
                    bgPeriodHalfYear.setEndDate(this.getCalHelper().getBeoverDate(BgPeriodHelper.getHalfYearLastDay(year, i, this.startTime, this.isStrideYear)));
                    bgPeriodHalfYear.setIsStrideYear(this.isStrideYear);
                    bgPeriodHalfYear.setStartTime(this.startTime);
                }
                if (hasPersonal) {
                    bgPeriodHalfYear.setPeriodType(BgPeriodEnum.PERSONAL_HALFYEAR);
                } else {
                    bgPeriodHalfYear.setPeriodType(BgPeriodEnum.HALFYEAR);
                }
                bgPeriodHalfYear.setYear(year);
                bgPeriodHalfYear.setHalfYear(i);
                bgPeriodHalfYear.setMonth(i * 6);
                bgPeriodHalfYear.setLevel(2);
                bgPeriodHalfYear.setShowLevel(bgPeriodYear.getShowLevel() + i * 100000);
                bgPeriodHalfYear.setParent(bgPeriodYear);
            }
            bgPeriodHalfYear.setIsLeaf(isLeaf);
            this.resultVal.add(bgPeriodHalfYear);
            if (this.bgPeriodTypeInfo.isQuarter()) {
                this.processQuarter(year, bgPeriodYear, bgPeriodHalfYear, hasPersonal);
            }
            if (!this.bgPeriodTypeInfo.isHalfYear() || this.bgPeriodTypeInfo.isQuarter() || !this.bgPeriodTypeInfo.isSelfDefined()) continue;
            this.processSelfDefined(year, bgPeriodHalfYear, BgPeriodEnum.PERSONAL_HALFYEAR, true);
        }
    }

    private void setBgPeriodHalfYearEndDateByDB(int year, BgPeriodInfo bgPeriodHalfYear, int halfYear) {
        int startMonth = this.bgPeriodTypeInfo.getStartMonth().getValue();
        switch (halfYear) {
            case 1: {
                int start = -1;
                if (startMonth + 5 > 12) {
                    start = startMonth - 7;
                    bgPeriodHalfYear.setEndDate(this.getPeriodsFromDB().get(year + 1).get(start).getEndDate());
                    break;
                }
                start = startMonth + 5;
                bgPeriodHalfYear.setEndDate(this.getPeriodsFromDB().get(year).get(start).getEndDate());
                break;
            }
            case 2: {
                if (startMonth + 11 > 12) {
                    int start = startMonth - 1;
                    bgPeriodHalfYear.setEndDate(this.getPeriodsFromDB().get(year + 1).get(start).getEndDate());
                    break;
                }
                int start = startMonth + 11;
                bgPeriodHalfYear.setEndDate(this.getPeriodsFromDB().get(year).get(start).getEndDate());
                break;
            }
        }
    }

    private void setBgPeriodHalfYearBeginDateByDB(int year, BgPeriodInfo bgPeriodHalfYear, int halfYear) {
        int startMonth = this.bgPeriodTypeInfo.getStartMonth().getValue();
        switch (halfYear) {
            case 1: {
                bgPeriodHalfYear.setBeginDate(this.getPeriodsFromDB().get(year).get(startMonth).getBeginDate());
                break;
            }
            case 2: {
                int start = -1;
                if (startMonth + 6 > 12) {
                    start = startMonth + 6 - 12;
                    bgPeriodHalfYear.setBeginDate(this.getPeriodsFromDB().get(year + 1).get(start).getBeginDate());
                    break;
                }
                start = startMonth + 6;
                bgPeriodHalfYear.setBeginDate(this.getPeriodsFromDB().get(year).get(start).getBeginDate());
                break;
            }
        }
    }

    protected void processQuarter(int Year, BgPeriodInfo bgPeriodYear, BgPeriodInfo bgPeriodHalfYear, boolean hasPersonal) {
        boolean isLeaf = true;
        if (this.bgPeriodTypeInfo.isMonth()) {
            isLeaf = false;
        }
        int index = 0;
        String quearter = null;
        String number = null;
        BgPeriodInfo bgPeriodQuarter = null;
        int q = 2;
        for (int i = 1; i <= q; ++i) {
            index = (bgPeriodHalfYear.getHalfYear() - 1) * 2 + i;
            quearter = this.df.format(index);
            number = new StringBuffer(bgPeriodYear.getNumber() + "." + quearter + "Q").toString();
            bgPeriodQuarter = this.periodMap.get(number);
            if (bgPeriodQuarter == null) {
                bgPeriodQuarter = new BgPeriodInfo();
                bgPeriodQuarter.setId(BOSUuid.create((BOSObjectType)bgPeriodQuarter.getBOSType()));
                bgPeriodQuarter.setNumber(number);
                bgPeriodQuarter.setLongNumber(bgPeriodHalfYear.getLongNumber() + "!" + number);
                bgPeriodQuarter.setName(bgPeriodYear.getName(this.eLocale) + quearter + this.getString("Quarter", this.eLocale), this.eLocale);
                bgPeriodQuarter.setName(bgPeriodYear.getName(this.sLocale) + quearter + this.getString("Quarter", this.sLocale), this.sLocale);
                bgPeriodQuarter.setName(STConverter.sc2tc((String)bgPeriodQuarter.getName(this.sLocale)), this.tLocale);
                if (this.bgPeriodTypeInfo.getBelongYear() != null && BgPeriodYearEnum.getEnumList().contains((Object)this.bgPeriodTypeInfo.getBelongYear())) {
                    int currentYear;
                    int n = currentYear = BgPeriodYearEnum.lastYear.equals((Object)this.bgPeriodTypeInfo.getBelongYear()) ? Year - 1 : Year;
                    if (this.getPeriodsFromDB() != null) {
                        this.setBgPeriodQuarterBeginDateByDB(currentYear, bgPeriodQuarter, index);
                        this.setBgPeriodQuarterEndDateByDB(currentYear, bgPeriodQuarter, index);
                    } else {
                        bgPeriodQuarter.setBeginDate(this.getCalHelper().getStartDate(this.getCalHelper().getFirstDayOfQuarterBySelfDefined(currentYear, index, this.bgPeriodTypeInfo.getStartMonth().getValue())));
                        bgPeriodQuarter.setEndDate(this.getCalHelper().getBeoverDate(this.getCalHelper().getLastDayOfQuarterBySelfDefined(currentYear, index, this.bgPeriodTypeInfo.getStartMonth().getValue())));
                    }
                } else {
                    bgPeriodQuarter.setBeginDate(this.helper.getStartDate(this.getCalHelper().getFirstDayOfQuarter(Year, index, this.startTime, this.isStrideYear)));
                    bgPeriodQuarter.setEndDate(this.helper.getBeoverDate(this.getCalHelper().getLastDayOfQuarter(Year, index, this.startTime, this.isStrideYear)));
                    bgPeriodQuarter.setIsStrideYear(this.isStrideYear);
                    bgPeriodQuarter.setStartTime(this.startTime);
                }
                if (hasPersonal) {
                    bgPeriodQuarter.setPeriodType(BgPeriodEnum.PERSONAL_QUARTER);
                } else {
                    bgPeriodQuarter.setPeriodType(BgPeriodEnum.QUARTER);
                }
                bgPeriodQuarter.setYear(Year);
                bgPeriodQuarter.setHalfYear(bgPeriodHalfYear.getHalfYear());
                bgPeriodQuarter.setQuarter(index);
                bgPeriodQuarter.setLevel(3);
                bgPeriodQuarter.setShowLevel(bgPeriodHalfYear.getShowLevel() + i * 10000);
                bgPeriodQuarter.setParent(bgPeriodHalfYear);
            }
            bgPeriodQuarter.setIsLeaf(isLeaf);
            this.resultVal.add(bgPeriodQuarter);
            if (!isLeaf) {
                this.processMonth(Year, index, bgPeriodYear, bgPeriodQuarter, hasPersonal);
            }
            if (!this.bgPeriodTypeInfo.isQuarter() || this.bgPeriodTypeInfo.isMonth() || !this.bgPeriodTypeInfo.isSelfDefined()) continue;
            this.processSelfDefined(Year, bgPeriodQuarter, BgPeriodEnum.PERSONAL_QUARTER, true);
        }
    }

    private void setBgPeriodQuarterEndDateByDB(int year, BgPeriodInfo bgPeriodQuarter, int quarter) {
        int startMonth = this.bgPeriodTypeInfo.getStartMonth().getValue();
        switch (quarter) {
            case 1: {
                int start = -1;
                if (startMonth + 3 > 12) {
                    bgPeriodQuarter.setEndDate(this.getPeriodsFromDB().get(year + 1).get((start = startMonth + 3 - 12) - 1 == 0 ? 12 : start - 1).getEndDate());
                    break;
                }
                start = startMonth + 3;
                bgPeriodQuarter.setEndDate(this.getPeriodsFromDB().get(year).get(start - 1).getEndDate());
                break;
            }
            case 2: {
                if (startMonth + 6 > 12) {
                    int start;
                    bgPeriodQuarter.setEndDate(this.getPeriodsFromDB().get(year + 1).get((start = startMonth + 6 - 12) - 1 == 0 ? 12 : start - 1).getEndDate());
                    break;
                }
                int start = startMonth + 6;
                bgPeriodQuarter.setEndDate(this.getPeriodsFromDB().get(year).get(start - 1).getEndDate());
                break;
            }
            case 3: {
                if (startMonth + 9 > 12) {
                    int start;
                    bgPeriodQuarter.setEndDate(this.getPeriodsFromDB().get(year + 1).get((start = startMonth + 9 - 12) - 1 == 0 ? 12 : start - 1).getEndDate());
                    break;
                }
                int start = startMonth + 9;
                bgPeriodQuarter.setEndDate(this.getPeriodsFromDB().get(year).get(start - 1).getEndDate());
                break;
            }
            default: {
                if (startMonth + 12 > 12) {
                    int start;
                    bgPeriodQuarter.setEndDate(this.getPeriodsFromDB().get(year + 1).get((start = startMonth + 12 - 12) - 1 == 0 ? 12 : start - 1).getEndDate());
                    break;
                }
                int start = startMonth + 12;
                bgPeriodQuarter.setEndDate(this.getPeriodsFromDB().get(year).get(start - 1).getEndDate());
            }
        }
    }

    private void setBgPeriodQuarterBeginDateByDB(int year, BgPeriodInfo bgPeriodQuarter, int quarter) {
        int startMonth = this.bgPeriodTypeInfo.getStartMonth().getValue();
        switch (quarter) {
            case 1: {
                bgPeriodQuarter.setBeginDate(this.getPeriodsFromDB().get(year).get(startMonth).getBeginDate());
                break;
            }
            case 2: {
                int start = -1;
                if (startMonth + 3 > 12) {
                    start = startMonth + 3 - 12;
                    bgPeriodQuarter.setBeginDate(this.getPeriodsFromDB().get(year + 1).get(start).getBeginDate());
                    break;
                }
                start = startMonth + 3;
                bgPeriodQuarter.setBeginDate(this.getPeriodsFromDB().get(year).get(start).getBeginDate());
                break;
            }
            case 3: {
                if (startMonth + 6 > 12) {
                    int start = startMonth + 6 - 12;
                    bgPeriodQuarter.setBeginDate(this.getPeriodsFromDB().get(year + 1).get(start).getBeginDate());
                    break;
                }
                int start = startMonth + 6;
                bgPeriodQuarter.setBeginDate(this.getPeriodsFromDB().get(year).get(start).getBeginDate());
                break;
            }
            default: {
                if (startMonth + 9 > 12) {
                    int start = startMonth + 9 - 12;
                    bgPeriodQuarter.setBeginDate(this.getPeriodsFromDB().get(year + 1).get(start).getBeginDate());
                    break;
                }
                int start = startMonth + 9;
                bgPeriodQuarter.setBeginDate(this.getPeriodsFromDB().get(year).get(start).getBeginDate());
            }
        }
    }

    private void processMonth(int Year, int Quarter, BgPeriodInfo bgPeriodYear, BgPeriodInfo bgPeriodQuarter, boolean hasPersonal) {
        int month = 1;
        boolean isLeaf = true;
        isLeaf = !this.bgPeriodTypeInfo.isMothWeek() && !this.bgPeriodTypeInfo.isDay() && !this.bgPeriodTypeInfo.isTenday();
        String sMonth = null;
        String MonthNumber = null;
        BgPeriodInfo bgPeriodMonth = null;
        int m = 3;
        for (int i = 1; i <= m; ++i) {
            month = (Quarter - 1) * 3 + i;
            sMonth = this.df.format(month);
            MonthNumber = new StringBuffer(bgPeriodYear.getNumber() + "." + sMonth + "M").toString();
            bgPeriodMonth = this.periodMap.get(MonthNumber);
            if (bgPeriodMonth == null) {
                bgPeriodMonth = new BgPeriodInfo();
                bgPeriodMonth.setId(BOSUuid.create((BOSObjectType)bgPeriodMonth.getBOSType()));
                bgPeriodMonth.setNumber(MonthNumber);
                bgPeriodMonth.setLongNumber(bgPeriodQuarter.getLongNumber() + "!" + MonthNumber);
                bgPeriodMonth.setName(bgPeriodYear.getName(this.eLocale) + sMonth + this.getString("Month", this.eLocale), this.eLocale);
                bgPeriodMonth.setName(bgPeriodYear.getName(this.sLocale) + sMonth + this.getString("Month", this.sLocale), this.sLocale);
                bgPeriodMonth.setName(STConverter.sc2tc((String)bgPeriodMonth.getName(this.sLocale)), this.tLocale);
                if (this.bgPeriodTypeInfo.getBelongYear() != null && BgPeriodYearEnum.getEnumList().contains((Object)this.bgPeriodTypeInfo.getBelongYear())) {
                    int currentYear;
                    int startMonth = this.bgPeriodTypeInfo.getStartMonth().getValue();
                    int n = currentYear = BgPeriodYearEnum.lastYear.equals((Object)this.bgPeriodTypeInfo.getBelongYear()) ? Year - 1 : Year;
                    if (startMonth - 1 + month <= 12) {
                        if (this.getPeriodsFromDB() != null) {
                            bgPeriodMonth.setBeginDate(this.getPeriodsFromDB().get(currentYear).get(startMonth - 1 + month).getBeginDate());
                            bgPeriodMonth.setEndDate(this.getPeriodsFromDB().get(currentYear).get(startMonth - 1 + month).getEndDate());
                        } else {
                            bgPeriodMonth.setBeginDate(this.helper.getStartDate(this.helper.getFirstDayOfMonth(currentYear, startMonth - 1 + month)));
                            bgPeriodMonth.setEndDate(this.helper.getBeoverDate(this.helper.getLastDayOfMonth(currentYear, startMonth - 1 + month)));
                        }
                    } else if (this.getPeriodsFromDB() != null) {
                        bgPeriodMonth.setBeginDate(this.getPeriodsFromDB().get(currentYear + 1).get(startMonth - 1 + month - 12).getBeginDate());
                        bgPeriodMonth.setEndDate(this.getPeriodsFromDB().get(currentYear + 1).get(startMonth - 1 + month - 12).getEndDate());
                    } else {
                        bgPeriodMonth.setBeginDate(this.helper.getStartDate(this.helper.getFirstDayOfMonth(currentYear + 1, startMonth - 1 + month - 12)));
                        bgPeriodMonth.setEndDate(this.helper.getBeoverDate(this.helper.getLastDayOfMonth(currentYear + 1, startMonth - 1 + month - 12)));
                    }
                } else {
                    bgPeriodMonth.setBeginDate(this.helper.getStartDate(this.helper.getFirstDayOfMonth(Year, month, this.startTime, this.isStrideYear)));
                    bgPeriodMonth.setEndDate(this.helper.getBeoverDate(this.helper.getLastDayOfMonth(Year, month, this.startTime, this.isStrideYear)));
                    bgPeriodMonth.setStartTime(this.startTime);
                    bgPeriodMonth.setIsStrideYear(this.isStrideYear);
                }
                if (hasPersonal) {
                    bgPeriodMonth.setPeriodType(BgPeriodEnum.PERSONAL_MONTH);
                } else {
                    bgPeriodMonth.setPeriodType(BgPeriodEnum.MONTH);
                }
                bgPeriodMonth.setYear(Year);
                bgPeriodMonth.setHalfYear(bgPeriodQuarter.getHalfYear());
                bgPeriodMonth.setQuarter(Quarter);
                bgPeriodMonth.setMonth(month);
                bgPeriodMonth.setLevel(4);
                bgPeriodMonth.setShowLevel(bgPeriodQuarter.getShowLevel() + i * 1000);
                bgPeriodMonth.setParent(bgPeriodQuarter);
            }
            bgPeriodMonth.setIsLeaf(isLeaf);
            this.resultVal.add(bgPeriodMonth);
            if (this.bgPeriodTypeInfo.isMothWeek()) {
                this.processMonthWeek(Year, Quarter, month, bgPeriodMonth, hasPersonal);
            }
            if (this.bgPeriodTypeInfo.isTenday()) {
                this.processTenDays(Year, Quarter, month, bgPeriodMonth, hasPersonal);
            }
            if (this.bgPeriodTypeInfo.isDay() && !this.bgPeriodTypeInfo.isTenday() && !this.bgPeriodTypeInfo.isMothWeek()) {
                this.processDay(Year, Quarter, month, bgPeriodMonth, hasPersonal);
            }
            if (!this.bgPeriodTypeInfo.isMonth() || !this.bgPeriodTypeInfo.isSelfDefined()) continue;
            this.processSelfDefined(Year, bgPeriodMonth, BgPeriodEnum.PERSONAL_MONTH, true);
        }
    }

    private void processMonthWeek(int year, int Quarter, int Month, BgPeriodInfo bgPeriodMonth, boolean hasPersonal) {
        String WeekNumber;
        String Week = null;
        BgPeriodInfo bgPeriodMonthWeek = null;
        ArrayList<BgPeriodInfo> tmpBgPeriods = new ArrayList<BgPeriodInfo>();
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(new CalendarHelper().getLastDayOfMonth(year, Month));
        int w = calendar.get(4);
        for (int i = 1; i <= w; ++i) {
            Week = this.df.format(i);
            WeekNumber = new StringBuffer(bgPeriodMonth.getNumber() + "." + Week + "MW").toString();
            bgPeriodMonthWeek = this.periodMap.get(WeekNumber);
            if (bgPeriodMonthWeek == null) {
                bgPeriodMonthWeek = new BgPeriodInfo();
                bgPeriodMonthWeek.setId(BOSUuid.create((BOSObjectType)bgPeriodMonthWeek.getBOSType()));
                bgPeriodMonthWeek.setNumber(WeekNumber);
                bgPeriodMonthWeek.setLongNumber(bgPeriodMonth.getLongNumber() + "!" + WeekNumber);
                bgPeriodMonthWeek.setName(bgPeriodMonth.getName(this.eLocale) + Week + this.getString("Week", this.eLocale), this.eLocale);
                bgPeriodMonthWeek.setName(bgPeriodMonth.getName(this.sLocale) + Week + this.getString("Week", this.sLocale), this.sLocale);
                bgPeriodMonthWeek.setName(STConverter.sc2tc((String)bgPeriodMonthWeek.getName(this.sLocale)), this.tLocale);
                bgPeriodMonthWeek.setBeginDate(this.helper.getStartDate(BgPeriodHelper.getMonthWeekFirstDay(year, Month, i)));
                bgPeriodMonthWeek.setEndDate(this.helper.getBeoverDate(BgPeriodHelper.getMonthWeekLastDay(year, Month, i)));
                if (hasPersonal) {
                    bgPeriodMonthWeek.setPeriodType(BgPeriodEnum.PERSONAL_MWEEK);
                } else {
                    bgPeriodMonthWeek.setPeriodType(BgPeriodEnum.MWEEK);
                }
                bgPeriodMonthWeek.setYear(year);
                bgPeriodMonthWeek.setHalfYear(bgPeriodMonth.getHalfYear());
                bgPeriodMonthWeek.setMonth(Month);
                bgPeriodMonthWeek.setWeek(i);
                bgPeriodMonthWeek.setLevel(5);
                bgPeriodMonthWeek.setShowLevel(bgPeriodMonth.getShowLevel() + 100 + (i - 1) * 8);
                bgPeriodMonthWeek.setIsLeaf(!this.bgPeriodTypeInfo.isDay());
                bgPeriodMonthWeek.setParent(bgPeriodMonth);
            }
            if (this.bgPeriodTypeInfo.isSelfDefineRule()) {
                tmpBgPeriods.add(bgPeriodMonthWeek);
            } else {
                this.resultVal.add(bgPeriodMonthWeek);
            }
            if (!this.bgPeriodTypeInfo.isDay()) continue;
            this.processDay(year, Quarter, Month, bgPeriodMonthWeek, hasPersonal);
        }
        ArrayList<BgPeriodInfo> mergeResult = new ArrayList<BgPeriodInfo>(tmpBgPeriods.size());
        boolean spinnerState = false;
        int in = tmpBgPeriods.size();
        for (int i = 0; i < in; ++i) {
            int spinnerDay;
            long days;
            bgPeriodMonthWeek = (BgPeriodInfo)tmpBgPeriods.get(i);
            if (i == 0 && (days = 1L + (bgPeriodMonthWeek.getEndDate().getTime() - bgPeriodMonthWeek.getBeginDate().getTime()) / 1000L / 3600L / 24L) < (long)(spinnerDay = this.bgPeriodTypeInfo.getSpinnerDay())) {
                spinnerState = true;
                continue;
            }
            if (i == tmpBgPeriods.size() - 1 && (days = 1L + (bgPeriodMonthWeek.getEndDate().getTime() - bgPeriodMonthWeek.getBeginDate().getTime()) / 1000L / 3600L / 24L) < (long)(spinnerDay = this.bgPeriodTypeInfo.getSpinnerDay())) {
                BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)mergeResult.get(mergeResult.size() - 1);
                bgPeriodInfo.setEndDate(bgPeriodMonthWeek.getEndDate());
                break;
            }
            if (spinnerState) {
                Week = this.df.format(i);
                WeekNumber = new StringBuffer(bgPeriodMonth.getNumber() + "." + Week + "MW").toString();
                bgPeriodMonthWeek.setNumber(WeekNumber);
                bgPeriodMonthWeek.setWeek(i);
                bgPeriodMonthWeek.setLongNumber(bgPeriodMonth.getLongNumber() + "!" + WeekNumber);
                bgPeriodMonthWeek.setName(bgPeriodMonth.getName(this.eLocale) + Week + this.getString("Week", this.eLocale), this.eLocale);
                bgPeriodMonthWeek.setName(bgPeriodMonth.getName(this.sLocale) + Week + this.getString("Week", this.sLocale), this.sLocale);
                bgPeriodMonthWeek.setName(STConverter.sc2tc((String)bgPeriodMonthWeek.getName(this.sLocale)), this.tLocale);
                bgPeriodMonthWeek.setShowLevel(bgPeriodMonth.getShowLevel() + 100 + (i - 1) * 8);
                if (i - 1 == 0) {
                    bgPeriodMonthWeek.setBeginDate(((BgPeriodInfo)tmpBgPeriods.get(i - 1)).getBeginDate());
                }
            }
            mergeResult.add(bgPeriodMonthWeek);
        }
        if (!mergeResult.isEmpty()) {
            this.resultVal.addAll(mergeResult);
        }
    }

    protected void processDay(int Year, int Quarter, int Month, BgPeriodInfo bgPeriodMonth, boolean hasPersonal) {
        String day = null;
        String dayNumber = null;
        BgPeriodInfo bgPeriodDay = null;
        int d = this.helper.getDaysOfMonth(Year, Month);
        for (int i = 1; i <= d; ++i) {
            int dayOfWeek;
            Date day2 = BgPeriodHelper.getDay(Year, Month, i);
            if (this.bgPeriodTypeInfo.isTenday() && this.isMemberOfTheTenDays(Year, Month, this.getTenDaysIndex(bgPeriodMonth), i)) {
                day = this.df.format(i);
                dayNumber = new StringBuffer(bgPeriodMonth.getNumber() + "." + day + "D").toString();
                bgPeriodDay = this.periodMap.get(dayNumber);
                if (bgPeriodDay == null) {
                    bgPeriodDay = new BgPeriodInfo();
                    bgPeriodDay.setId(BOSUuid.create((BOSObjectType)bgPeriodDay.getBOSType()));
                    bgPeriodDay.setNumber(dayNumber);
                    bgPeriodDay.setLongNumber(bgPeriodMonth.getLongNumber() + "!" + dayNumber);
                    bgPeriodDay.setName(bgPeriodMonth.getName(this.eLocale) + day + this.getString("Day", this.eLocale), this.eLocale);
                    bgPeriodDay.setName(bgPeriodMonth.getName(this.sLocale) + day + this.getString("Day", this.sLocale), this.sLocale);
                    bgPeriodDay.setName(STConverter.sc2tc((String)bgPeriodMonth.getName(this.sLocale)), this.tLocale);
                    bgPeriodDay.setBeginDate(this.helper.getStartDate(day2));
                    bgPeriodDay.setEndDate(this.helper.getBeoverDate(day2));
                    if (hasPersonal) {
                        bgPeriodDay.setPeriodType(BgPeriodEnum.PERSONAL_DAY);
                    } else {
                        bgPeriodDay.setPeriodType(BgPeriodEnum.DAY);
                    }
                    bgPeriodDay.setYear(Year);
                    bgPeriodDay.setQuarter(Quarter);
                    bgPeriodDay.setMonth(Month);
                    bgPeriodDay.setLevel(6);
                    int dayOfTenDays = 1;
                    dayOfTenDays = i <= 10 ? i : (i > 10 && i <= 20 ? i - 10 : i - 20);
                    bgPeriodDay.setShowLevel(bgPeriodMonth.getShowLevel() + dayOfTenDays);
                    bgPeriodDay.setIsLeaf(true);
                    bgPeriodDay.setParent(bgPeriodMonth);
                }
                this.resultVal.add(bgPeriodDay);
                continue;
            }
            if (this.bgPeriodTypeInfo.isMothWeek() && this.isMemberOfTheMonthWeeks(Year, Month, this.getMonthWeekIndex(bgPeriodMonth), i)) {
                day = this.df.format(i);
                dayNumber = new StringBuffer(bgPeriodMonth.getNumber() + "." + day + "D").toString();
                bgPeriodDay = this.periodMap.get(dayNumber);
                if (bgPeriodDay == null) {
                    bgPeriodDay = new BgPeriodInfo();
                    bgPeriodDay.setId(BOSUuid.create((BOSObjectType)bgPeriodDay.getBOSType()));
                    bgPeriodDay.setNumber(dayNumber);
                    bgPeriodDay.setLongNumber(bgPeriodMonth.getLongNumber() + "!" + dayNumber);
                    bgPeriodDay.setName(bgPeriodMonth.getName(this.eLocale) + day + this.getString("Day", this.eLocale), this.eLocale);
                    bgPeriodDay.setName(bgPeriodMonth.getName(this.sLocale) + day + this.getString("Day", this.sLocale), this.sLocale);
                    bgPeriodDay.setName(STConverter.sc2tc((String)bgPeriodMonth.getName(this.sLocale)), this.tLocale);
                    bgPeriodDay.setBeginDate(this.helper.getStartDate(day2));
                    bgPeriodDay.setEndDate(this.helper.getBeoverDate(day2));
                    bgPeriodDay.setPeriodType(BgPeriodEnum.DAY);
                    bgPeriodDay.setYear(Year);
                    bgPeriodDay.setQuarter(Quarter);
                    bgPeriodDay.setMonth(Month);
                    bgPeriodDay.setLevel(6);
                    dayOfWeek = BgPeriodHelper.getDayOfWeek(Year, Month, i);
                    dayOfWeek = dayOfWeek - 1 == 0 ? 7 : dayOfWeek - 1;
                    bgPeriodDay.setShowLevel(bgPeriodMonth.getShowLevel() + dayOfWeek);
                    bgPeriodDay.setIsLeaf(true);
                    bgPeriodDay.setParent(bgPeriodMonth);
                }
                this.resultVal.add(bgPeriodDay);
                continue;
            }
            if (this.bgPeriodTypeInfo.isYearWeek() && this.isMemberOfTheYearWeeks(Year, Month, i, bgPeriodMonth)) {
                day = this.df.format(i);
                dayNumber = new StringBuffer(bgPeriodMonth.getNumber() + "." + day + "D").toString();
                bgPeriodDay = this.periodMap.get(dayNumber);
                if (bgPeriodDay == null) {
                    bgPeriodDay = new BgPeriodInfo();
                    bgPeriodDay.setId(BOSUuid.create((BOSObjectType)bgPeriodDay.getBOSType()));
                    bgPeriodDay.setNumber(dayNumber);
                    bgPeriodDay.setLongNumber(bgPeriodMonth.getLongNumber() + "!" + dayNumber);
                    bgPeriodDay.setName(bgPeriodMonth.getName(this.eLocale) + day + this.getString("Day", this.eLocale), this.eLocale);
                    bgPeriodDay.setName(bgPeriodMonth.getName(this.sLocale) + day + this.getString("Day", this.sLocale), this.sLocale);
                    bgPeriodDay.setName(STConverter.sc2tc((String)bgPeriodMonth.getName(this.sLocale)), this.tLocale);
                    bgPeriodDay.setBeginDate(this.helper.getStartDate(day2));
                    bgPeriodDay.setEndDate(this.helper.getBeoverDate(day2));
                    bgPeriodDay.setPeriodType(BgPeriodEnum.DAY);
                    bgPeriodDay.setYear(Year);
                    bgPeriodDay.setQuarter(Quarter);
                    bgPeriodDay.setMonth(this.helper.getCurrentlyMonth(bgPeriodMonth.getEndDate()));
                    bgPeriodDay.setLevel(3);
                    dayOfWeek = BgPeriodHelper.getDayOfWeek(Year, Month, i);
                    dayOfWeek = dayOfWeek - 1 == 0 ? 7 : dayOfWeek - 1;
                    bgPeriodDay.setShowLevel(bgPeriodMonth.getShowLevel() + dayOfWeek);
                    bgPeriodDay.setIsLeaf(true);
                    bgPeriodDay.setParent(bgPeriodMonth);
                }
                this.resultVal.add(bgPeriodDay);
                continue;
            }
            if (!this.bgPeriodTypeInfo.isDay() || this.bgPeriodTypeInfo.isYearWeek() || this.bgPeriodTypeInfo.isMothWeek() || this.bgPeriodTypeInfo.isTenday()) continue;
            day = this.df.format(i);
            dayNumber = new StringBuffer(bgPeriodMonth.getNumber() + "." + day + "D").toString();
            bgPeriodDay = this.periodMap.get(dayNumber);
            if (bgPeriodDay == null) {
                bgPeriodDay = new BgPeriodInfo();
                bgPeriodDay.setId(BOSUuid.create((BOSObjectType)bgPeriodDay.getBOSType()));
                bgPeriodDay.setNumber(dayNumber);
                bgPeriodDay.setLongNumber(bgPeriodMonth.getLongNumber() + "!" + dayNumber);
                bgPeriodDay.setName(bgPeriodMonth.getName(this.eLocale) + day + this.getString("Day", this.eLocale), this.eLocale);
                bgPeriodDay.setName(bgPeriodMonth.getName(this.sLocale) + day + this.getString("Day", this.sLocale), this.sLocale);
                bgPeriodDay.setName(STConverter.sc2tc((String)bgPeriodMonth.getName(this.sLocale)), this.tLocale);
                bgPeriodDay.setBeginDate(this.helper.getStartDate(day2));
                bgPeriodDay.setEndDate(this.helper.getBeoverDate(day2));
                bgPeriodDay.setPeriodType(BgPeriodEnum.DAY);
                bgPeriodDay.setYear(Year);
                bgPeriodDay.setQuarter(Quarter);
                bgPeriodDay.setMonth(Month);
                bgPeriodDay.setLevel(5);
                bgPeriodDay.setShowLevel(bgPeriodMonth.getShowLevel() + i);
                bgPeriodDay.setIsLeaf(true);
                bgPeriodDay.setParent(bgPeriodMonth);
            }
            this.resultVal.add(bgPeriodDay);
        }
    }

    private int getTenDaysIndex(BgPeriodInfo bgPeriodMonth) {
        int lastIndexOf = bgPeriodMonth.getNumber().lastIndexOf(".");
        return Integer.parseInt(bgPeriodMonth.getNumber().substring(lastIndexOf + 2, lastIndexOf + 3).toString());
    }

    private int getMonthWeekIndex(BgPeriodInfo bgPeriodMonth) {
        int lastIndexOf = bgPeriodMonth.getNumber().lastIndexOf(".");
        return Integer.parseInt(bgPeriodMonth.getNumber().substring(lastIndexOf + 2, lastIndexOf + 3).toString());
    }

    private boolean isMemberOfTheTenDays(int Year, int Month, int tenDays, int Day) {
        Date tenDaysFirstDay = BgPeriodHelper.getTenDaysFirstDay(Year, Month, tenDays);
        Date tenDaysLastDay = BgPeriodHelper.getTenDaysLastDay(Year, Month, tenDays);
        Date day2 = BgPeriodHelper.getDay(Year, Month, Day);
        return day2.compareTo(tenDaysFirstDay) >= 0 && day2.compareTo(tenDaysLastDay) <= 0;
    }

    private boolean isMemberOfTheYearWeeks(int year, int month, int index, BgPeriodInfo PeriodInfo) {
        Date firstDay = PeriodInfo.getBeginDate();
        Date lastDay = PeriodInfo.getEndDate();
        Date day = BgPeriodHelper.getDay(year, month, index);
        return day.compareTo(firstDay) >= 0 && day.compareTo(lastDay) <= 0;
    }

    private boolean isMemberOfTheMonthWeeks(int year, int month, int index, int Day) {
        Date firstDay = BgPeriodHelper.getMonthWeekFirstDay(year, month, index);
        Date lastDay = BgPeriodHelper.getMonthWeekLastDay(year, month, index);
        Date day = BgPeriodHelper.getDay(year, month, Day);
        return day.compareTo(firstDay) >= 0 && day.compareTo(lastDay) <= 0;
    }

    protected void processTenDays(int Year, int Quarter, int Month, BgPeriodInfo bgPeriodMonth, boolean hasPersonal) {
        String tenDay = null;
        String dayNumber = null;
        BgPeriodInfo bgPeriodTenDay = null;
        int d = 3;
        for (int i = 1; i <= d; ++i) {
            tenDay = this.df.format(i);
            dayNumber = new StringBuffer(bgPeriodMonth.getNumber() + "." + tenDay + "TD").toString();
            bgPeriodTenDay = this.periodMap.get(dayNumber);
            if (bgPeriodTenDay == null) {
                bgPeriodTenDay = new BgPeriodInfo();
                bgPeriodTenDay.setId(BOSUuid.create((BOSObjectType)bgPeriodTenDay.getBOSType()));
                bgPeriodTenDay.setNumber(dayNumber);
                bgPeriodTenDay.setLongNumber(bgPeriodMonth.getLongNumber() + "!" + dayNumber);
                String tenDaysKey = tenDay.equals("01") ? "the_first_ten_days_of_a_month" : (tenDay.equals("02") ? "the_middle_ten_days_of_a_month" : "the_last_ten_day_of_a_month");
                bgPeriodTenDay.setName(bgPeriodMonth.getName(this.eLocale) + this.getString(tenDaysKey, this.eLocale), this.eLocale);
                bgPeriodTenDay.setName(bgPeriodMonth.getName(this.sLocale) + this.getString(tenDaysKey, this.sLocale), this.sLocale);
                bgPeriodTenDay.setName(STConverter.sc2tc((String)bgPeriodMonth.getName(this.sLocale)), this.tLocale);
                bgPeriodTenDay.setBeginDate(BgPeriodHelper.getTenDaysFirstDay(Year, Month, i));
                bgPeriodTenDay.setEndDate(BgPeriodHelper.getTenDaysLastDay(Year, Month, i));
                if (hasPersonal) {
                    bgPeriodTenDay.setPeriodType(BgPeriodEnum.PERSONAL_TENDAYS);
                } else {
                    bgPeriodTenDay.setPeriodType(BgPeriodEnum.TENDAYS);
                }
                bgPeriodTenDay.setYear(Year);
                bgPeriodTenDay.setQuarter(Quarter);
                bgPeriodTenDay.setMonth(Month);
                bgPeriodTenDay.setLevel(5);
                bgPeriodTenDay.setShowLevel(bgPeriodMonth.getShowLevel() + 80 + (i - 1) * 12);
                bgPeriodTenDay.setIsLeaf(!this.bgPeriodTypeInfo.isDay());
                bgPeriodTenDay.setParent(bgPeriodMonth);
            }
            this.resultVal.add(bgPeriodTenDay);
            if (!this.bgPeriodTypeInfo.isDay()) continue;
            this.processDay(Year, Quarter, Month, bgPeriodTenDay, hasPersonal);
        }
    }

    public void setBgPeriodTypeInfo(BgPeriodTypeInfo bgPeriodTypeInfo) {
        if (bgPeriodTypeInfo == null) {
            throw new IllegalArgumentException("bgPeriodTypeInfo must not null");
        }
        this.bgPeriodTypeInfo = bgPeriodTypeInfo;
    }

    public BgPeriodTypeInfo getBgPeriodTypeInfo() {
        return this.bgPeriodTypeInfo;
    }

    public CalendarHelper getCalHelper() {
        return this.helper;
    }

    public List<BgPeriodInfo> createBgPeriod(int selYear, boolean hasPersonal) {
        this.resultVal.clear();
        if (BgNPeriodHelper.isOnlySelfDefinedPeriod(this.bgPeriodTypeInfo)) {
            if (selYear != this.getLastestYear()) {
                this.setSequence(1);
            }
            this.processSelfDefined(selYear, null, BgPeriodEnum.PERSONAL, false);
        } else {
            this.setSequence(1);
            this.processYear(selYear, hasPersonal);
        }
        for (BgPeriodInfo info : this.resultVal) {
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        }
        return this.resultVal;
    }

    private int getLastestYear() {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("number");
        coll.add("id");
        coll.add("bgPeriod.year");
        view.setSelector(coll);
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("type.id", (Object)this.bgPeriodTypeInfo.getId());
        view.getSorter().add(new SorterItemInfo("bgPeriod.year"));
        view.setFilter(filter);
        BgPeriodDispCollection bgPeriodCollection = null;
        try {
            IBgPeriodDisp remoteInstance = null;
            remoteInstance = this.ctx == null ? BgPeriodDispFactory.getRemoteInstance() : BgPeriodDispFactory.getLocalInstance(this.ctx);
            bgPeriodCollection = remoteInstance.getBgPeriodDispCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)" get bgperiod error");
        }
        if (bgPeriodCollection != null && !bgPeriodCollection.isEmpty()) {
            HashSet<Integer> yearSet = new HashSet<Integer>();
            int lastestYear = 0;
            for (int i = 0; i < bgPeriodCollection.size(); ++i) {
                yearSet.add(bgPeriodCollection.get(i).getBgPeriod().getYear());
            }
            Iterator iterator = yearSet.iterator();
            while (iterator.hasNext()) {
                int year = (Integer)iterator.next();
                if (lastestYear >= year) continue;
                lastestYear = year;
            }
            return lastestYear;
        }
        return 0;
    }

    public List<BgPeriodInfo> createBgPeriod(int selYear, List<BgSelfDefinedPeriodInfo> infos) {
        this.resultVal.clear();
        if (!this.bgPeriodTypeInfo.isSelfDefined()) {
            return null;
        }
        this.processYear(selYear, true);
        if (this.bgPeriodTypeInfo.isYear() && !this.bgPeriodTypeInfo.isHalfYear() && this.bgPeriodTypeInfo.isSelfDefined()) {
            for (BgSelfDefinedPeriodInfo bgSelfDefinedPeriodInfo : infos) {
            }
        } else if (this.bgPeriodTypeInfo.isHalfYear() && !this.bgPeriodTypeInfo.isQuarter() || this.bgPeriodTypeInfo.isQuarter() && !this.bgPeriodTypeInfo.isMonth() || this.bgPeriodTypeInfo.isMonth()) {
            // empty if block
        }
        for (BgPeriodInfo info : this.resultVal) {
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        }
        return this.resultVal;
    }

    protected String getString(String msgKey, Locale locale) {
        return ResourceBase.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)msgKey, (Locale)locale);
    }
}

