/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountGroupInfo;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgAccountViewCollection;
import com.kingdee.eas.ma.base.BgAccountViewFactory;
import com.kingdee.eas.ma.base.BgAccountViewInfo;
import com.kingdee.eas.ma.base.BgAccountVirtualModelFacadeFactory;
import com.kingdee.eas.ma.base.BgPeriodSumEnum;
import com.kingdee.eas.ma.base.BgUpperGatherEnum;
import com.kingdee.eas.ma.base.OrgUnitVirtualModelFacadeFactory;
import com.kingdee.eas.ma.base.RptSrcTypeEnum;
import com.kingdee.eas.ma.base.client.AbstractBgAccountDistributeUI;
import com.kingdee.eas.ma.base.client.utils.BgAccountDistributeClientHelper;
import com.kingdee.eas.ma.base.client.utils.NumberExpandHelper;
import com.kingdee.eas.ma.base.client.utils.OrgUnitVirtualModeHelper;
import com.kingdee.eas.ma.base.utils.BgAccountVirtualModeHelper;
import com.kingdee.eas.ma.base.utils.BgAccountVritaulModelFilterParam;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.OrgUnitVirtualModelFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BgAccountDistributeUI
extends AbstractBgAccountDistributeUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgAccountDistributeUI.class);
    private static final String COL_isEnable = "isEnable";
    private static final String COL_id = "id";
    private static final String COL_number = "number";
    private static final String COL_name = "name";
    private static final String COL_longNumber = "longNumber";
    private static final String COL_choose = "choose";
    private static final String COL_polAlgorithm = "polAlgorithm";
    private static final String COL_periodAlgorithm = "periodAlgorithm";
    private static final String COL_LEVEL = "level";
    private BgAccountViewInfo curSelectedAccountView = null;
    private static final int NUMBER_INDEX = 0;
    private static final int PARENTNUMBER_INDEX = 1;
    private OrgUnitInfo curOrgUnitInfo = null;
    private BgAccountGroupInfo[] groups = null;
    private NumberExpandHelper numberHelper = null;
    private OrgUnitVirtualModeHelper orgVirtualHelper = null;
    private BgAccountVirtualModeHelper accVirtualHelper = null;

    public BgAccountGroupInfo[] getGroups() {
        return this.groups;
    }

    public void setGroups(Object[] groups) {
        ArrayList<BgAccountGroupInfo> list = new ArrayList<BgAccountGroupInfo>();
        if (groups != null && groups.length > 0) {
            BgAccountGroupInfo group = null;
            for (int i = 0; i < groups.length; ++i) {
                if (!(groups[i] instanceof BgAccountGroupInfo)) continue;
                group = (BgAccountGroupInfo)groups[i];
                list.add(group);
            }
        }
        if (!list.isEmpty()) {
            this.groups = list.toArray(new BgAccountGroupInfo[0]);
        }
    }

    private NumberExpandHelper getNumberExpandHelper() {
        if (this.numberHelper == null) {
            this.numberHelper = new NumberExpandHelper(this, this.tblCostCenter);
        }
        return this.numberHelper;
    }

    public BgAccountViewInfo getCurSelectedAccountView() {
        return this.curSelectedAccountView;
    }

    public void setCurSelectedAccountView(BgAccountViewInfo curSelectedAccountView) {
        this.curSelectedAccountView = curSelectedAccountView;
    }

    public OrgUnitInfo getCurOrgUnitInfo() {
        return this.curOrgUnitInfo;
    }

    public void setCurOrgUnitInfo(OrgUnitInfo curOrgUnitInfo) {
        this.curOrgUnitInfo = curOrgUnitInfo;
    }

    public void onLoad() throws Exception {
        Object viewInfo;
        this.loadSearchType(this.tblCostCenter, this.combFilterOrg);
        this.loadSearchType(this.tblAccountMember, this.combFilterMem);
        this.getNumberExpandHelper();
        super.onLoad();
        this.btnAntiDistribute.setEnabled(false);
        this.prmtAccview.setEditable(false);
        Object unitInfo = this.getUIContext().get("unitInfo");
        if (unitInfo != null && unitInfo instanceof OrgUnitInfo) {
            this.curOrgUnitInfo = (OrgUnitInfo)unitInfo;
        }
        if ((viewInfo = this.getUIContext().get("viewInfo")) != null && viewInfo instanceof BgAccountViewInfo) {
            this.curSelectedAccountView = (BgAccountViewInfo)viewInfo;
        }
        this.init();
    }

    private void initGroupF7() {
        if (this.prmtAccview.getData() instanceof BgAccountViewInfo) {
            this.prmtGroup.setQueryInfo("com.kingdee.eas.ma.base.BgAccountGroupQuery");
            this.prmtGroup.setEditFormat("$number$");
            this.prmtGroup.setDisplayFormat("$name$");
            this.prmtGroup.setCommitFormat("$name$");
            this.prmtGroup.setEnabledMultiSelection(true);
            this.prmtGroup.setEditable(false);
            EntityViewInfo evi = this.prmtGroup.getEntityViewInfo();
            evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId.id", (Object)((BgAccountViewInfo)this.prmtAccview.getData()).getId().toString(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo(COL_number, (Object)"ACG", CompareType.EQUALS));
            evi.getFilter().setMaskString("#0 or #1");
            this.prmtGroup.setEntityViewInfo(evi);
            this.prmtGroup.getQueryAgent().resetRuntimeEntityView();
        }
    }

    @Override
    protected void prmtGroup_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtGroup_dataChanged(e);
        Object newValue = e.getNewValue();
        Object oldValue = e.getOldValue();
        if (newValue != null && !newValue.equals(oldValue) && newValue instanceof Object[]) {
            this.setGroups((Object[])newValue);
            this.queryBgAccount();
        }
    }

    private void loadSearchType(KDTable table, KDComboBox comboBox) {
        table.checkParsed();
        IColumn col = null;
        for (int i = 0; i < table.getColumnCount(); ++i) {
            col = table.getColumn(i);
            if (col.getStyleAttributes().isHided() || COL_choose.equals(col.getKey())) continue;
            comboBox.addItem((Object)new SearchType(col.getKey(), (String)table.getHeadRow(0).getCell(i).getValue()));
        }
    }

    private void init() throws EASBizException, BOSException {
        this.queryOrgUnit();
        this.initAccountViewF7();
        this.loadAccountMember();
        this.initGroupF7();
        this.btnSelectAllOrg.addAssistMenuItem((Action)((Object)this.actionIncludeDirectSub));
        this.btnSelectAllOrg.addAssistMenuItem((Action)((Object)this.actionIncludeAddSub));
        this.btnSelectAllOrg.addAssistMenuItem((Action)((Object)this.actionAssignedOrg));
    }

    private void queryOrgUnit() throws EASBizException, BOSException {
        this.orgVirtualHelper.getFilterParam().setSearchValue(this.txtFilterOrg.getText().trim());
        this.orgVirtualHelper.getFilterParam().setSearchKey(((SearchType)this.combFilterOrg.getSelectedItem()).number);
        this.orgVirtualHelper.getFilterParam().setOrgUnitId(this.getCurOrgUnitInfo().getId().toString());
        this.orgVirtualHelper.doQuery(this.orgVirtualHelper.getFilterParam());
    }

    private void loadAccountMember() {
    }

    private void initAccountViewF7() {
        if (this.getCurSelectedAccountView() != null) {
            this.prmtAccview.setData((Object)this.getCurSelectedAccountView());
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getCurOrgUnitInfo().getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("sourceType", (Object)((RptSrcTypeEnum)((Object)this.getUIContext().get("sourceType"))).getValue(), CompareType.EQUALS));
        this.prmtAccview.setEntityViewInfo(evi);
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblCostCenter.checkParsed();
        BgCommHelper.removeEditHelper(this.tblCostCenter);
        try {
            this.orgVirtualHelper = new OrgUnitVirtualModeHelper(this, this.tblCostCenter, OrgUnitVirtualModelFacadeFactory.getRemoteInstance(), new OrgUnitVirtualModelFilterParam(this.getCostCenterSelector()));
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            this.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        this.tblCostCenter.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                BgAccountDistributeUI.this.tblCostCenter_afterDataFill(e);
            }
        });
        BgCommHelper.removeEditHelper(this.tblAccountMember);
        this.lockColumn(this.tblAccountMember);
        try {
            this.accVirtualHelper = new BgAccountVirtualModeHelper(this, this.tblAccountMember, BgAccountVirtualModelFacadeFactory.getRemoteInstance(), new BgAccountVritaulModelFilterParam());
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            this.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        this.tblAccountMember.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                BgAccountDistributeUI.this.tblAccountMember_afterDataFill(e);
            }
        });
        this.tblAccountMember.getIndexColumn().getStyleAttributes().setHided(true);
    }

    private void lockColumn(KDTable tblAccountMember) {
        if (tblAccountMember != null) {
            tblAccountMember.getColumn(COL_number).getStyleAttributes().setLocked(true);
            tblAccountMember.getColumn(COL_name).getStyleAttributes().setLocked(true);
            tblAccountMember.getColumn(COL_polAlgorithm).getStyleAttributes().setLocked(true);
            tblAccountMember.getColumn(COL_periodAlgorithm).getStyleAttributes().setLocked(true);
            tblAccountMember.getColumn("orgUnit").getStyleAttributes().setLocked(true);
        }
    }

    protected void tblAccountMember_afterDataFill(KDTDataRequestEvent e) {
        IRow row = null;
        Object value = null;
        String searchKey = ((SearchType)this.combFilterMem.getSelectedItem()).number;
        String searchValue = this.txtFilterMem.getText().trim();
        for (int r = e.getFirstRow(); r <= e.getLastRow(); ++r) {
            row = this.tblAccountMember.getRow(r);
            row.getCell(COL_choose).setValue((Object)Boolean.FALSE);
            value = row.getCell(COL_periodAlgorithm).getValue();
            if (value instanceof Number) {
                row.getCell(COL_periodAlgorithm).setValue((Object)BgPeriodSumEnum.getEnum(((Number)value).intValue()).getAlias());
            }
            if ((value = row.getCell(COL_polAlgorithm).getValue()) instanceof Number) {
                row.getCell(COL_polAlgorithm).setValue((Object)BgUpperGatherEnum.getEnum(((Number)value).intValue()).getAlias());
            }
            if (StringUtils.isEmpty((String)searchValue) || String.valueOf(row.getCell(searchKey).getValue()).contains(searchValue)) continue;
            row.getStyleAttributes().setHided(true);
        }
    }

    protected void tblCostCenter_afterDataFill(KDTDataRequestEvent e) {
        for (int r = e.getFirstRow(); r <= e.getLastRow(); ++r) {
            if (((Number)this.tblCostCenter.getCell(r, COL_isEnable).getValue()).intValue() != 1) {
                this.tblCostCenter.getRow(r).getStyleAttributes().setLocked(true);
                this.tblCostCenter.getCell(r, COL_choose).setValue((Object)" ");
                continue;
            }
            this.tblCostCenter.getCell(r, COL_choose).setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    protected void btnSearchOrg_actionPerformed(ActionEvent e) throws Exception {
        this.queryOrgUnit();
    }

    @Override
    protected void btnClearAllOrg_actionPerformed(ActionEvent e) throws Exception {
        this.clearAll(this.tblCostCenter);
        this.queryBgAccount();
    }

    private void clearAll(KDTable table) {
        IRow row = null;
        for (int r = 0; r < table.getRowCount(); ++r) {
            row = table.getRow2(r);
            if (row == null || row.getStyleAttributes().isLocked()) continue;
            row.getCell(COL_choose).setValue((Object)false);
        }
    }

    @Override
    protected void btnSelectAllOrg_actionPerformed(ActionEvent e) throws Exception {
        this.selectAll(this.tblCostCenter);
        this.queryBgAccount();
    }

    private void selectAll(KDTable table) {
        IRow row = null;
        for (int r = 0; r < table.getRowCount(); ++r) {
            row = table.getRow(r);
            if (row.getStyleAttributes().isLocked() || row.getStyleAttributes().isHided()) continue;
            row.getCell(COL_choose).setValue((Object)true);
        }
    }

    @Override
    public void actionIncludeDirectSub_actionPerformed(ActionEvent e) throws Exception {
        this.selectOrgUnit(false, false);
    }

    @Override
    public void actionIncludeAddSub_actionPerformed(ActionEvent e) throws Exception {
        this.selectOrgUnit(true, false);
    }

    @Override
    public void actionAssignedOrg_actionPerformed(ActionEvent e) throws Exception {
        this.selectOrgUnit(true, true);
    }

    private void selectOrgUnit(boolean isAll, boolean isAssigned) throws EASBizException, BOSException {
        if (this.tblCostCenter.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        if (isAssigned && this.prmtAccview.getData() == null) {
            return;
        }
        IRow row = this.tblCostCenter.getRow(this.tblCostCenter.getSelectManager().getActiveRowIndex());
        String longNumber = (String)row.getCell(COL_longNumber).getValue();
        HashSet<String> assignIds = new HashSet<String>();
        if (isAssigned) {
            BgAccountViewInfo viewinfo = (BgAccountViewInfo)this.prmtAccview.getData();
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("orgUnit.id");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.longNumber", (Object)(longNumber + "%"), CompareType.LIKE));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("distributeViewRootId", (Object)("Select FDistributeViewRootId FROM T_MBG_BgAccountView Where FID = '" + viewinfo.getId() + "'"), CompareType.INNER));
            BgAccountViewCollection col = BgAccountViewFactory.getRemoteInstance().getBgAccountViewCollection(evi);
            if (col == null || col.isEmpty()) {
                return;
            }
            for (int i = 0; i < col.size(); ++i) {
                assignIds.add(col.get(i).getOrgUnit().getId().toString());
            }
        }
        String thisLongNumber = null;
        for (int r = this.tblCostCenter.getSelectManager().getActiveRowIndex(); r < this.tblCostCenter.getRowCount() && ((thisLongNumber = (String)(row = this.tblCostCenter.getRow(r)).getCell(COL_longNumber).getValue()).equals(longNumber) || thisLongNumber.startsWith(longNumber + "!")); ++r) {
            if (row.getStyleAttributes().isHided() || row.getStyleAttributes().isLocked() || isAssigned && !assignIds.contains(row.getCell(COL_id).getValue()) || !thisLongNumber.equals(longNumber) && !isAll && thisLongNumber.substring(longNumber.length() + 1).indexOf("!") > 0) continue;
            row.getCell(COL_choose).setValue((Object)true);
        }
        this.queryBgAccount();
    }

    @Override
    protected void tblCostCenter_editValueChanged(KDTEditEvent e) throws Exception {
        IRow row = this.tblCostCenter.getRow(e.getRowIndex());
        row.getCell(COL_choose).setValue((Object)(!Boolean.TRUE.equals(row.getCell(COL_choose).getValue()) ? 1 : 0));
        this.queryBgAccount();
    }

    @Override
    protected void tblAccountMember_editValueChanged(KDTEditEvent e) throws Exception {
        block8: {
            block9: {
                if (!this.rdoNoDistributedMem.isSelected()) break block9;
                String longNumber = (String)this.tblAccountMember.getRow(e.getRowIndex()).getCell(COL_longNumber).getValue();
                IRow row = null;
                String[] lns = null;
                if (Boolean.TRUE.equals(e.getValue())) {
                    HashSet<String> lnSet = new HashSet<String>(Arrays.asList(longNumber.split("!")));
                    if (lnSet.size() == 1) {
                        return;
                    }
                    for (int r = e.getRowIndex() - 1; r >= 0; --r) {
                        row = this.tblAccountMember.getRow(r);
                        longNumber = (String)row.getCell(COL_longNumber).getValue();
                        lns = longNumber.split("!");
                        if (lnSet.contains(lns[lns.length - 1])) {
                            row.getCell(COL_choose).setValue((Object)true);
                            row.getStyleAttributes().setHided(false);
                            continue;
                        }
                        if (lnSet.contains(lns[0])) {
                            continue;
                        }
                        break block8;
                    }
                } else {
                    for (int r = e.getRowIndex() + 1; r < this.tblAccountMember.getRowCount() && ((String)(row = this.tblAccountMember.getRow(r)).getCell(COL_longNumber).getValue()).startsWith(longNumber + "!"); ++r) {
                        row.getCell(COL_choose).setValue((Object)false);
                    }
                }
                break block8;
            }
            if (!this.rdoDistributedMem.isSelected() || !Boolean.TRUE.equals(e.getValue())) break block8;
            String longNumber = (String)this.tblAccountMember.getRow(e.getRowIndex()).getCell(COL_longNumber).getValue();
            IRow row = null;
            Object lns = null;
            int in = this.tblAccountMember.getRowCount();
            for (int i = 0; i < in; ++i) {
                row = this.tblAccountMember.getRow(i);
                if (!((String)row.getCell(COL_longNumber).getValue()).startsWith(longNumber + "!")) continue;
                row.getCell(COL_choose).setValue((Object)true);
            }
        }
    }

    @Override
    protected void btnSearchMem_actionPerformed(ActionEvent e) throws Exception {
        this.queryBgAccount();
    }

    @Override
    protected void btnSelectAllMem_actionPerformed(ActionEvent e) throws Exception {
        this.selectAll(this.tblAccountMember);
    }

    @Override
    protected void btnClearAllMem_actionPerformed(ActionEvent e) throws Exception {
        this.clearAll(this.tblAccountMember);
    }

    @Override
    public void actionAssigned_actionPerformed(ActionEvent e) throws Exception {
        super.actionAssigned_actionPerformed(e);
        if (Boolean.TRUE.equals(this.accVirtualHelper.getFilterParam().getIsAssigned())) {
            return;
        }
        this.btnAntiDistribute.setEnabled(true);
        this.queryBgAccount();
    }

    @Override
    public void actionNotAssigned_actionPerformed(ActionEvent e) throws Exception {
        super.actionNotAssigned_actionPerformed(e);
        if (Boolean.FALSE.equals(this.accVirtualHelper.getFilterParam().getIsAssigned())) {
            return;
        }
        this.btnAntiDistribute.setEnabled(false);
        this.queryBgAccount();
    }

    public void queryBgAccount() throws EASBizException, BOSException {
        if (!this.rdoDistributedMem.isSelected() && !this.rdoNoDistributedMem.isSelected() || this.prmtAccview.getData() == null) {
            return;
        }
        this.accVirtualHelper.getFilterParam().setAccountViewId(((BgAccountViewInfo)this.prmtAccview.getData()).getId().toString());
        this.accVirtualHelper.getFilterParam().setSearchValue(this.txtFilterOrg.getText());
        this.accVirtualHelper.getFilterParam().setSearchKey(((SearchType)this.combFilterOrg.getSelectedItem()).number);
        this.accVirtualHelper.getFilterParam().setIsAssigned(this.rdoDistributedMem.isSelected());
        this.accVirtualHelper.getFilterParam().getOrgUnitIds().clear();
        this.accVirtualHelper.getFilterParam().getOrgUnitIds().addAll(this.getSelectIds(this.tblCostCenter));
        if (this.getGroups() != null) {
            this.accVirtualHelper.getFilterParam().setGroups(this.getGroups());
        }
        this.accVirtualHelper.doQuery(this.accVirtualHelper.getFilterParam());
    }

    @Override
    protected void prmtAccview_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == null) {
            this.prmtAccview.setDataNoNotify(e.getOldValue());
        } else {
            this.initGroupF7();
            this.prmtGroup.setDataNoNotify(null);
            this.queryBgAccount();
        }
    }

    @Override
    public void actionDistribute_actionPerformed(ActionEvent e) throws Exception {
        this.distribute(false);
    }

    @Override
    public void actionAntiDistribute_actionPerformed(ActionEvent e) throws Exception {
        this.distribute(true);
    }

    @Override
    protected void rdoDistributedMem_itemStateChanged(ItemEvent e) throws Exception {
        this.queryBgAccount();
        this.switchButton();
    }

    private void switchButton() {
        if (this.rdoDistributedMem.isSelected()) {
            this.btnAntiDistribute.setEnabled(true);
        } else {
            this.btnDistribute.setEnabled(true);
        }
    }

    @Override
    protected void rdoNoDistributedMem_stateChanged(ChangeEvent e) throws Exception {
    }

    private void distribute(boolean isAntiDistribute) throws EASBizException, BOSException {
        if (this.prmtAccview.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)BgAccountDistributeClientHelper.getString("selectBgAccountView"));
            return;
        }
        List<TreeBaseInfo> orgs = this.getSelectTreeBase(this.tblCostCenter, CostCenterOrgUnitInfo.class);
        List<TreeBaseInfo> accts = this.getSelectTreeBase(this.tblAccountMember, BgAccountInfo.class);
        if (!isAntiDistribute) {
            this.checkTblAccountMember(this.tblAccountMember, orgs);
        }
        if (orgs.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)BgAccountDistributeClientHelper.getString("selectCostCenter"));
            return;
        }
        if (accts.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)BgAccountDistributeClientHelper.getString("selectBgAccount"));
            return;
        }
        BgAccountDistributeClientHelper.distribute(this, (BgAccountViewInfo)this.prmtAccview.getData(), orgs, accts, isAntiDistribute, this.getGroups());
        logger.error((Object)"start queryBgAccount");
    }

    private void checkTblAccountMember(KDTable table, List<TreeBaseInfo> orgs) throws BOSException {
        IRow row = null;
        ArrayList<String> numberList = new ArrayList<String>();
        StringBuffer errorDetail = new StringBuffer();
        int in = table.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = table.getRow2(i);
            if (row == null || row.getStyleAttributes().isLocked() || row.getStyleAttributes().isHided() || !Boolean.TRUE.equals(row.getCell(COL_choose).getValue())) continue;
            numberList.add(row.getCell(COL_number).getValue().toString());
        }
        Set<String> distributeAccountNumber = this.addDistributeAccountNumber(orgs, ((BgAccountViewInfo)this.prmtAccview.getData()).getDistributeViewRootId().toString());
        numberList.addAll(distributeAccountNumber);
        int in2 = table.getRowCount();
        for (int i = 0; i < in2; ++i) {
            String[] split;
            String parentNumber;
            String longNumber;
            row = table.getRow2(i);
            if (row == null || row.getStyleAttributes().isLocked() || row.getStyleAttributes().isHided() || !Boolean.TRUE.equals(row.getCell(COL_choose).getValue()) || (longNumber = row.getCell(COL_longNumber).getValue().toString()) == null || !longNumber.contains("!") || numberList.contains(parentNumber = (split = longNumber.split("!"))[split.length - 2])) continue;
            String number = split[split.length - 1];
            Object[] str = new String[]{number, parentNumber};
            errorDetail.append(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountDistributeResource", (String)"distributeHierarchyMsg", (Object[])str)).append("\n");
        }
        if (errorDetail.toString().length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)BgAccountDistributeClientHelper.getString("distributeHierarchy"), (String)errorDetail.toString(), (int)0);
            SysUtil.abort();
        }
    }

    private Set<String> addDistributeAccountNumber(List<TreeBaseInfo> orgs, String accountviewId) throws BOSException {
        HashSet<String> distributeNums = new HashSet<String>();
        HashSet<String> orgIds = new HashSet<String>();
        for (TreeBaseInfo info : orgs) {
            orgIds.add(info.getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(COL_number);
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", orgIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bgAccountView.distributeViewRootId", (Object)accountviewId, CompareType.EQUALS));
        view.setFilter(filter);
        BgAccountInfo info = null;
        BgAccountCollection accColl = BgAccountFactory.getRemoteInstance().getBgAccountCollection(view);
        if (accColl != null && !accColl.isEmpty()) {
            int in = accColl.size();
            for (int i = 0; i < in; ++i) {
                info = accColl.get(i);
                distributeNums.add(info.getNumber());
            }
        }
        return distributeNums;
    }

    @Override
    protected void txtFilterMem_focusLost(FocusEvent e) throws Exception {
        super.txtFilterMem_focusLost(e);
        this.queryBgAccount();
    }

    @Override
    protected void txtFilterOrg_focusLost(FocusEvent e) throws Exception {
        super.txtFilterOrg_focusLost(e);
        this.queryOrgUnit();
    }

    private List<TreeBaseInfo> getSelectTreeBase(KDTable table, Class<? extends TreeBaseInfo> cls) throws BOSException {
        ArrayList<TreeBaseInfo> result = new ArrayList<TreeBaseInfo>();
        IRow row = null;
        TreeBaseInfo info = null;
        for (int r = 0; r < table.getRowCount(); ++r) {
            row = table.getRow2(r);
            if (row == null || row.getStyleAttributes().isLocked() || row.getStyleAttributes().isHided() || !Boolean.TRUE.equals(row.getCell(COL_choose).getValue())) continue;
            try {
                info = cls.newInstance();
            }
            catch (InstantiationException e) {
                throw new BOSException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new BOSException((Throwable)e);
            }
            info.setId(BOSUuid.read((String)row.getCell(COL_id).getValue().toString()));
            info.setNumber(row.getCell(COL_number) == null ? null : row.getCell(COL_number).getValue().toString());
            info.setName(row.getCell(COL_name) == null || row.getCell(COL_name).getValue() == null ? null : row.getCell(COL_name).getValue().toString());
            info.setLongNumber(row.getCell(COL_longNumber) == null ? null : row.getCell(COL_longNumber).getValue().toString());
            result.add(info);
        }
        return result;
    }

    private List<String> getSelectIds(KDTable table) {
        ArrayList<String> ids = new ArrayList<String>();
        IRow row = null;
        for (int r = 0; r < table.getRowCount(); ++r) {
            row = table.getRow2(r);
            if (row == null || row.getStyleAttributes().isLocked() || row.getStyleAttributes().isHided() || !Boolean.TRUE.equals(row.getCell(COL_choose).getValue())) continue;
            ids.add((String)row.getCell(COL_id).getValue());
        }
        return ids;
    }

    private SelectorItemCollection getCostCenterSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(COL_id);
        sic.add(COL_number);
        sic.add(COL_name);
        sic.add("simpleName");
        sic.add("code");
        sic.add(COL_LEVEL);
        sic.add(COL_longNumber);
        sic.add("isLeaf");
        sic.add(COL_isEnable);
        return sic;
    }

    private class SearchType {
        String number = null;
        String name = null;

        public SearchType(String number, String name) {
            this.number = number;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

