/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountDataTypeEnum;
import com.kingdee.eas.ma.base.BgAccountException;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountGroupInfo;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgAccountTypeEnum;
import com.kingdee.eas.ma.base.BgAccountViewInfo;
import com.kingdee.eas.ma.base.BgDecreditAlgorithmEnum;
import com.kingdee.eas.ma.base.BgPeriodSumEnum;
import com.kingdee.eas.ma.base.BgPropertyCollection;
import com.kingdee.eas.ma.base.BgPropertyInfo;
import com.kingdee.eas.ma.base.BgUpperGatherEnum;
import com.kingdee.eas.ma.base.IPropertyRefSource;
import com.kingdee.eas.ma.base.PropertyRefSourceFactory;
import com.kingdee.eas.ma.base.PropertyRefSourceInfo;
import com.kingdee.eas.ma.base.client.AbstractBgAccountEditUI;
import com.kingdee.eas.ma.base.client.BgAccountListDialog;
import com.kingdee.eas.ma.base.client.BgAccountListUI;
import com.kingdee.eas.ma.base.client.BgAccountSortDialog;
import com.kingdee.eas.ma.base.client.BgPropertyDialog;
import com.kingdee.eas.ma.base.utils.BgAccountHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCodeNumberCHelper;
import com.kingdee.eas.ma.base.utils.BgCodeNumberHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAccountEditUI
extends AbstractBgAccountEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgAccountEditUI.class);
    private static final int MIGRETION = 1;
    private static final int CANCEL = 2;
    private static final int NO_BGDATA = 3;
    private boolean isRelease = false;
    private OrgUnitInfo curOrgUnitInfo = null;
    private BgAccountViewInfo curAccViewInfo = null;
    private CostCenterOrgUnitInfo costCenterInfo = null;
    private BgPropertyCollection propertyCols = null;
    private BgAccountGroupInfo group = null;
    private BgCodeNumberHelper numberCodeHelper = new BgCodeNumberHelper(null, null, null);
    private IPropertyRefSource iProRef = PropertyRefSourceFactory.getRemoteInstance();

    public BgAccountGroupInfo getGroup() {
        return this.group;
    }

    public void setGroup(BgAccountGroupInfo group) {
        this.group = group;
    }

    public BgPropertyCollection getPropertyCols() {
        return this.propertyCols;
    }

    public void setPropertyCols(BgPropertyCollection propertyCols) {
        this.propertyCols = propertyCols;
    }

    public CostCenterOrgUnitInfo getCostCenterInfo() {
        return this.costCenterInfo;
    }

    public void setCostCenterInfo(CostCenterOrgUnitInfo costCenterInfo) {
        this.costCenterInfo = costCenterInfo;
    }

    public BgAccountViewInfo getCurAccViewInfo() {
        return this.curAccViewInfo;
    }

    public void setCurAccViewInfo(BgAccountViewInfo curAccViewInfo) {
        this.curAccViewInfo = curAccViewInfo;
    }

    public OrgUnitInfo getCurOrgUnitInfo() {
        return this.curOrgUnitInfo;
    }

    public void setCurOrgUnitInfo(OrgUnitInfo curOrgUnitInfo) {
        this.curOrgUnitInfo = curOrgUnitInfo;
    }

    @Override
    public void storeFields() {
        super.storeFields();
        Object parentObj = this.prmtParent.getData();
        if (parentObj != null && parentObj instanceof BgAccountInfo) {
            BgAccountInfo parentInfo = null;
            parentInfo = (BgAccountInfo)parentObj;
            if (!parentInfo.isIsEnabled()) {
                this.editData.setIsEnabled(false);
            }
            if (this.editData.getDisplayName() != null && !this.editData.getDisplayName().equals(parentInfo.getDisplayName() + "_" + this.editData.getName()) || OprtState.ADDNEW.equals(this.getOprtState()) && this.editData.getName() != null) {
                this.editData.setDisplayName(parentInfo.getDisplayName() + "_" + this.editData.getName());
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        if (OprtState.ADDNEW.equals(this.getOprtState()) && this.getUIContext().get("SELECTED_ACCOUNT") instanceof BgAccountInfo) {
            BgAccountInfo info = (BgAccountInfo)this.getUIContext().get("SELECTED_ACCOUNT");
            this.prmtParent.setData((Object)info);
            if (this.getGroup() == null && info != null && info.getGroup() != null) {
                this.setGroup(info.getGroup());
                this.prmtBgAccountGroup.setDataNoNotify((Object)info.getGroup());
                this.editData.setGroup(info.getGroup());
            }
        }
    }

    private void init() throws Exception {
        this.initContextValue();
        this.initDefaultValue();
        this.initParentMember();
        this.initProp(this.getPropertyCols());
        this.initCurMemParentInfo(null);
        this.reFillPropertyByCurMem();
        this.initGroupF7();
        this.initCreatOrg();
    }

    private void initGroupF7() {
        this.prmtBgAccountGroup.setQueryInfo("com.kingdee.eas.ma.base.BgAccountGroupQuery");
        this.prmtBgAccountGroup.setEditFormat("$number$");
        this.prmtBgAccountGroup.setDisplayFormat("$name$");
        this.prmtBgAccountGroup.setCommitFormat("$name$");
        this.prmtBgAccountGroup.setEditable(false);
        EntityViewInfo evi = this.prmtBgAccountGroup.getEntityViewInfo();
        if (evi == null) {
            evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
        }
        if (this.getCurAccViewInfo() != null) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId.id", (Object)this.getCurAccViewInfo().getId().toString(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)"ACG", CompareType.EQUALS));
            evi.getFilter().setMaskString("#0 or #1");
            this.prmtBgAccountGroup.setEntityViewInfo(evi);
            this.prmtBgAccountGroup.getQueryAgent().resetRuntimeEntityView();
        }
    }

    @Override
    protected void prmtBgAccountGroup_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgAccountGroup_dataChanged(e);
        Object newValue = e.getNewValue();
        Object oldValue = e.getOldValue();
        if (oldValue != null && newValue == null) {
            this.prmtBgAccountGroup.setDataNoNotify(oldValue);
        } else if (!newValue.equals(oldValue) && newValue instanceof BgAccountGroupInfo) {
            this.setGroup((BgAccountGroupInfo)newValue);
            this.initParentMember();
            if (oldValue != null) {
                if (((BgAccountGroupInfo)newValue).getId().equals((Object)this.editData.getGroup().getId())) {
                    this.prmtParent.setDataNoNotify((Object)this.editData.getParent());
                } else {
                    this.prmtParent.setDataNoNotify(null);
                }
            }
        }
    }

    public void initCreatOrg() throws EASBizException, BOSException {
        if (!OprtState.ADDNEW.equals(this.getOprtState()) && !this.editData.getDistributeRootID().equals((Object)this.editData.getId())) {
            BgAccountInfo baseInfo = (BgAccountInfo)BgAccountFactory.getRemoteInstance().getDataBaseInfo("select orgunit.name, orgunit.id,orgunit.number  where id ='" + this.editData.getDistributeRootID() + "'");
            OrgUnitInfo unitInfo = new OrgUnitInfo();
            unitInfo.setId(baseInfo.getOrgUnit().getId());
            unitInfo.setName(baseInfo.getOrgUnit().getName());
            unitInfo.setNumber(baseInfo.getOrgUnit().getNumber());
            this.prmtOrgUnit.setData((Object)unitInfo);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.setDefaultSettings();
    }

    protected void loadData() throws Exception {
        super.loadData();
        this.applyCodeNumber();
    }

    protected void applyCodeNumber() {
        BgAccountInfo info = (BgAccountInfo)this.getDataObject();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String orgId = info.getOrgUnit().getId().toString();
            try {
                this.numberCodeHelper.init((IObjectValue)info, orgId);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIExceptionAndAbort(e);
            }
            if (info.getNumber() == null) {
                this.getNumberByCodingRule((IObjectValue)this.editData, orgId);
            }
        }
    }

    private void setDefaultSettings() {
        if (this.comboPolAlgorithm.getSelectedItem() == null) {
            this.comboPolAlgorithm.setSelectedItem((Object)BgUpperGatherEnum.add);
        }
        if (this.combAccountType.getSelectedItem() == null) {
            this.combAccountType.setSelectedItem((Object)BgUpperGatherEnum.add);
        }
        if (this.comboPeriodAlgorithm.getSelectedItem() == null) {
            this.comboPeriodAlgorithm.setSelectedItem((Object)BgPeriodSumEnum.sum);
        }
        if (this.comboBgAccountDataType.getSelectedItem() == null) {
            this.comboBgAccountDataType.setSelectedItem((Object)BgAccountDataTypeEnum.CURRENCY);
        }
        if (this.comboBgDecreditAlgorithm.getSelectedItem() == null) {
            this.comboBgDecreditAlgorithm.setSelectedItem((Object)BgDecreditAlgorithmEnum.DECREDIT);
        }
    }

    private void initDefaultValue() throws EASBizException, BOSException {
        if (this.combAccountType.getItemCount() == 0) {
            this.combAccountType.addItem((Object)BgAccountTypeEnum.empty);
            this.combAccountType.addItem((Object)BgAccountTypeEnum.property);
            this.combAccountType.addItem((Object)BgAccountTypeEnum.liability);
            this.combAccountType.addItem((Object)BgAccountTypeEnum.profit_and_loss);
            this.combAccountType.addItem((Object)BgAccountTypeEnum.equity);
            this.combAccountType.addItem((Object)BgAccountTypeEnum.balance);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.comboPolAlgorithm.setSelectedItem((Object)BgUpperGatherEnum.add);
            this.comboPeriodAlgorithm.setSelectedItem((Object)BgPeriodSumEnum.sum);
            this.comboBgAccountDataType.setSelectedItem((Object)BgAccountDataTypeEnum.CURRENCY);
            this.comboBgDecreditAlgorithm.setSelectedItem((Object)BgDecreditAlgorithmEnum.DECREDIT);
            this.prmtOrgUnit.setData((Object)this.getCurOrgUnitInfo());
            this.txtNumber.setEnabled(true);
        } else {
            Object _obj = this.getUIContext().get("bgAccountType");
            if (_obj != null && _obj instanceof BizEnumValueDTO) {
                this.combAccountType.setSelectedItem((Object)BgAccountTypeEnum.getEnum(Integer.parseInt(((BizEnumValueDTO)_obj).getValue().toString())));
            }
            this.txtNumber.setEnabled(false);
        }
        BgAccountSortDialog accSortDialog = this.createAccSortF7();
        accSortDialog.setOrgUnit(this.curOrgUnitInfo);
        accSortDialog.setOldData(this.prmtBgAccountSort.getData());
        this.prmtBgAccountSort.setSelector((KDPromptSelector)accSortDialog);
        this.editData.setBgAccountView(this.getCurAccViewInfo());
    }

    protected BgAccountSortDialog createAccSortF7() {
        BgAccountSortDialog accSortDialog = new BgAccountSortDialog((IUIObject)this);
        return accSortDialog;
    }

    private void initParentMember() throws Exception {
        BgAccountListDialog parentAccDialog = new BgAccountListDialog();
        if (this.getCurAccViewInfo() != null && this.getCurAccViewInfo() instanceof BgAccountViewInfo) {
            parentAccDialog.setBgAccountViewID(this.getCurAccViewInfo().getId().toString());
        }
        parentAccDialog.setOldData(parentAccDialog.getData());
        parentAccDialog.setLongNumber(this.getCurLongNumber());
        if (this.getGroup() != null) {
            parentAccDialog.setGroupId(this.getGroup().getId().toString());
        }
        this.prmtParent.setSelector((KDPromptSelector)parentAccDialog);
        this.prmtParent.setEditable(false);
        this.prmtParent.setDataNoNotify((Object)this.editData.getParent());
        this.initCurMemParentInfo(null);
    }

    private String getCurLongNumber() {
        IObjectValue curObject = this.getDataObject();
        BgAccountInfo bgAccountInfo = null;
        if (curObject != null) {
            bgAccountInfo = (BgAccountInfo)curObject;
            return bgAccountInfo.getLongNumber();
        }
        return null;
    }

    private void initContextValue() {
        Object _group;
        Object _objProCols;
        Object _objCostCenterInfo;
        Object _objView;
        Object _objOrg = this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        if (_objOrg != null && _objOrg instanceof OrgUnitInfo) {
            this.setCurOrgUnitInfo((OrgUnitInfo)_objOrg);
        }
        if ((_objView = this.getUIContext().get("viewInfo")) != null && _objView instanceof BgAccountViewInfo) {
            this.setCurAccViewInfo((BgAccountViewInfo)_objView);
        }
        if ((_objCostCenterInfo = this.getUIContext().get("costCenterInfo")) != null && _objCostCenterInfo instanceof CostCenterOrgUnitInfo) {
            this.setCostCenterInfo((CostCenterOrgUnitInfo)_objCostCenterInfo);
        }
        if ((_objProCols = this.getUIContext().get("propertyInfo")) != null && _objProCols instanceof BgPropertyCollection) {
            this.setPropertyCols((BgPropertyCollection)((Object)_objProCols));
        }
        if ((_group = this.getUIContext().get("ACCGROUP")) != null && _group instanceof BgAccountGroupInfo && OprtState.ADDNEW.equals(this.getOprtState())) {
            BgAccountGroupInfo _group2 = (BgAccountGroupInfo)_group;
            this.setGroup(this.editData.getGroup());
            this.prmtBgAccountGroup.setDataNoNotify((Object)_group2);
        }
    }

    private void initProp(BgPropertyCollection curProColls) {
        BgPropertyDialog dialogProperty = new BgPropertyDialog((IUIObject)this);
        dialogProperty.setCostCenterInfo(this.getCostCenterInfo());
        dialogProperty.setOrgUnitInfo(this.getCurOrgUnitInfo());
        dialogProperty.setSortSourceType("E68E9293");
        dialogProperty.setMbgDimID(null);
        dialogProperty.setMbgViewInfo(null);
        dialogProperty.setOldData((Object)curProColls);
        dialogProperty.setHadSelectedProperty(curProColls);
        this.kDBizPromptBox1.setSelector((KDPromptSelector)dialogProperty);
        if (curProColls != null && curProColls.size() != 0) {
            dialogProperty.setOldData((Object)curProColls);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.getUIWindow() instanceof IUIWindow) {
            ((UINewFrame)this.getUIWindow()).setSize(new Dimension(620, 520));
        }
        this.getUIMenuBar().removeAll();
    }

    public void afterShow() {
        this.txtNumber.requestFocus();
    }

    @Override
    public void initUIMenuBarLayout() {
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.txtLevel.setEnabled(false);
        this.prmtOrgUnit.setEnabled(false);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
        }
    }

    protected IObjectValue createNewData() {
        Object _group;
        BgAccountInfo accountInfo = new BgAccountInfo();
        accountInfo.setId(BOSUuid.create((BOSObjectType)accountInfo.getBOSType()));
        accountInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        accountInfo.setOrgUnit((CostCenterOrgUnitInfo)this.getUIContext().get("costCenterInfo"));
        accountInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        accountInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        accountInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        accountInfo.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        accountInfo.setIsEnabled(true);
        Object _obj = this.getUIContext().get("viewInfo");
        if (_obj != null && _obj instanceof BgAccountViewInfo) {
            accountInfo.setBgAccountView((BgAccountViewInfo)_obj);
        }
        if (this.getUIContext().get("SELECTED_ACCOUNT") instanceof BgAccountInfo) {
            BgAccountInfo info = (BgAccountInfo)this.getUIContext().get("SELECTED_ACCOUNT");
            accountInfo.setParent(info);
        }
        if ((_group = this.getUIContext().get("ACCGROUP")) != null && _group instanceof BgAccountGroupInfo) {
            this.setGroup((BgAccountGroupInfo)_group);
        }
        accountInfo.setGroup(this.getGroup());
        return accountInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgAccountFactory.getRemoteInstance();
    }

    @Override
    protected void prmtParent_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtParent_dataChanged(e);
        this.initCurMemParentInfo(e.getOldValue());
    }

    private void initCurMemParentInfo(Object object) throws EASBizException, BOSException {
        Object parentObj = this.prmtParent.getData();
        if (parentObj == null) {
            this.editData.setParent(null);
            this.editData.setLongNumber(this.txtNumber.getText());
            this.editData.setLevel(1);
        } else {
            BgAccountInfo parentInfo = null;
            if (parentObj instanceof BgAccountInfo) {
                parentInfo = (BgAccountInfo)parentObj;
                this.editData.setParent(parentInfo);
                if (OprtState.EDIT.equals(this.getOprtState()) && (this.prmtParent.getData() != null && !this.prmtParent.getData().equals(object) || object != null && this.prmtParent.getData() == null)) {
                    this.checkParentHasBgData(parentInfo, "accountParent_hasData", object);
                }
                this.checkParentIsSelf(parentInfo);
                this.editData.setLongNumber(parentInfo.getLongNumber() + "!" + this.txtNumber.getText());
                this.editData.setLevel(parentInfo.getLevel() + 1);
                if (this.prmtBgAccountGroup.getData() == null) {
                    this.prmtBgAccountGroup.setDataNoNotify((Object)parentInfo.getGroup());
                }
            }
        }
    }

    private int checkParentHasBgData(BgAccountInfo parentInfo, String msg) throws EASBizException, BOSException {
        if (parentInfo == null || parentInfo.getId() == null) {
            return 3;
        }
        HashSet<String> parentIds = new HashSet<String>();
        parentIds.add(parentInfo.getId().toString());
        Set bgDataIds = null;
        try {
            this.editData.setParent(parentInfo);
            if (this.editData.getParent().isIsLeaf()) {
                this.isExistTmpData();
                bgDataIds = BgAccountFactory.getRemoteInstance().checkBgData((IObjectValue)this.editData, false);
            }
        }
        catch (Exception e) {
            logger.error((Object)"get refData error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (bgDataIds != null && bgDataIds.size() != 0) {
            int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)msg, (Object[])new Object[]{parentInfo.getNumber(), parentInfo.getName()}));
            if (result == 0) {
                return 1;
            }
            return 2;
        }
        return 3;
    }

    private void checkParentHasBgData(BgAccountInfo parentInfo, String msg, Object oldValue) throws BOSException {
        Set bgDataIds = null;
        try {
            if (this.editData.getParent().isIsLeaf()) {
                bgDataIds = BgAccountFactory.getRemoteInstance().checkBgData((IObjectValue)this.editData, false);
            }
        }
        catch (Exception e) {
            logger.error((Object)"get refData error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (bgDataIds != null && bgDataIds.size() != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)msg, (Object[])new Object[]{parentInfo.getNumber(), parentInfo.getName()}));
            this.prmtParent.setDataNoNotify(oldValue);
            SysUtil.abort();
        }
    }

    private void checkParentIsSelf(BgAccountInfo parentInfo) {
        if (parentInfo == null) {
            return;
        }
        if (this.getDataObject() != null) {
            BgAccountInfo memInfo = (BgAccountInfo)this.getDataObject();
            if (parentInfo.getNumber().equals(memInfo.getNumber())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"hasExistSameNum", (Object[])new Object[]{parentInfo.getNumber()}));
                SysUtil.abort();
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        IUIActionPostman post;
        if (this.getActionFromActionEvent(e) == null && !this.checkClickTime()) {
            return;
        }
        this.checkCanEdit();
        IObjectPK pk = null;
        this.doBeforeSubmit(e);
        int activeFlag = 3;
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            activeFlag = this.isExistData();
        }
        if (UtilRequest.isPrepare((String)"ActionSubmit", (CoreUIObject)this) && (post = this.prepareSubmit()) != null) {
            post.callHandler();
        }
        BgAccountHelper.setCancelDate(this.editData);
        if (OprtState.ADDNEW.equals(this.getOprtState()) && activeFlag == 1) {
            pk = BgAccountFactory.getRemoteInstance().submitforDataMigration((IObjectValue)this.editData, activeFlag == 1);
        } else if (activeFlag != 2) {
            if (OprtState.EDIT.equals(this.getOprtState())) {
                String id = this.editData.getId().toString();
                BgAccountCollection bgAcct = BgAccountFactory.getRemoteInstance().getBgAccountCollection("where id = '" + id + "'");
                if (!bgAcct.isEmpty() && bgAcct.get(0).getGroup() != null) {
                    BgAccountCollection bgAccountCollection;
                    String longNumber = bgAcct.get(0).getLongNumber();
                    BOSUuid groupId = bgAcct.get(0).getGroup().getId();
                    BOSUuid viewId = bgAcct.get(0).getBgAccountView().getId();
                    if (this.editData.getGroup() != null && !groupId.equals((Object)this.editData.getGroup().getId()) && !(bgAccountCollection = BgAccountFactory.getRemoteInstance().getBgAccountCollection("where longNumber like '" + longNumber + "!%' and bgAccountView ='" + viewId + "'")).isEmpty()) {
                        int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"isUpdateDownLevelGroup"));
                        if (result == 0) {
                            CoreBaseCollection updateColls = new CoreBaseCollection();
                            for (int i = 0; i < bgAccountCollection.size(); ++i) {
                                BgAccountInfo bgAccountInfo = bgAccountCollection.get(i);
                                bgAccountInfo.setGroup(this.editData.getGroup());
                                updateColls.add((CoreBaseInfo)bgAccountInfo);
                            }
                            if (!updateColls.isEmpty()) {
                                BgAccountFactory.getRemoteInstance().updateBatchData(updateColls);
                                pk = this.runSubmit();
                            }
                        } else {
                            return;
                        }
                    }
                }
                pk = this.runSubmit();
            } else {
                pk = this.runSubmit();
            }
        }
        if (pk != null) {
            this.saveProperty(pk.toString());
            this.doAfterSubmit(pk);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(true);
            this.prmtParent.setEnabled(true);
            this.applyCodeNumber();
        }
        if (this.getUIContext().get("Owner") instanceof BgAccountListUI) {
            ((BgAccountListUI)((Object)this.getUIContext().get("Owner"))).reSetIsFirstLoadData();
        }
        this.initCreatOrg();
    }

    private void isExistTmpData() throws EASBizException, BOSException {
        boolean checkTmpData = BgAccountFactory.getRemoteInstance().checkTmpData((IObjectValue)this.editData);
        if (checkTmpData) {
            throw new BgAccountException(BgAccountException.ISEXISTTMPDATA, new Object[]{this.editData.getParent().getNumber(), this.editData.getParent().getName()});
        }
    }

    private int isExistData() throws EASBizException, BOSException {
        if (this.prmtParent.getData() != null) {
            BgAccountInfo accountInfo = null;
            accountInfo = this.getParentData(accountInfo);
            int checkParentHasBgData = this.checkParentHasBgData(accountInfo, "acountIsUpdate");
            return checkParentHasBgData;
        }
        return 3;
    }

    private BgAccountInfo getParentData(BgAccountInfo accountInfo) throws BgAccountException {
        if (this.prmtParent.getData() instanceof BgAccountInfo) {
            accountInfo = (BgAccountInfo)this.prmtParent.getData();
        } else if (this.prmtParent.getData() instanceof String) {
            boolean hasMember = true;
            try {
                accountInfo = (BgAccountInfo)BgAccountFactory.getRemoteInstance().getValue("select id,number ,name, parent.id,parent.name,parent.level,isLeaf,longnumber,isEnabled,disabledDate where number = '" + this.prmtParent.getData().toString() + "' and bgaccountview.id = '" + this.getCurAccViewInfo().getId().toString() + "'");
            }
            catch (Exception e1) {
                hasMember = false;
                throw new BgAccountException(BgAccountException.PARENTNOTEXIST);
            }
            finally {
                if (!hasMember) {
                    this.prmtParent.setData(null);
                }
            }
        }
        return accountInfo;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        LanguageInfo currLang = this.getCurrentLanguage();
        if (!this.numberCodeHelper.isHasCodeNumber() && StringUtils.isEmpty((String)this.txtNumber.getText())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"numberIsNull"));
            SysUtil.abort();
        } else if (this.numberCodeHelper.isHasCodeNumber() && this.txtNumber.getText() != null && this.txtNumber.getText().length() > this.txtNumber.getMaxLength()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"numberToLong"));
            SysUtil.abort();
        }
        if (!BgNumberHelper.checkNumber(this.txtNumber.getText())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"specialCharInNumber"));
            SysUtil.abort();
        }
        if (this.txtName.getItemBy(currLang).getData() == null || StringUtils.isEmpty((String)this.txtName.getItemBy(currLang).getData().toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"NameIsNull"));
            SysUtil.abort();
        }
        if (!StringUtils.isEmpty((String)this.editData.getDisplayName()) && this.editData.getDisplayName().length() > 255) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"displayNameOverSize"));
            SysUtil.abort();
        }
        this.checkRootMemAglIsAdd();
        if (this.prmtParent.getData() != null) {
            BgAccountInfo accountInfo = null;
            accountInfo = this.getParentData(accountInfo);
            this.checkParentIsSelf(accountInfo);
            this.prmtParent.setData((Object)accountInfo);
        }
    }

    protected LanguageInfo getCurrentLanguage() {
        return new LanguageInfo(this.getCurrentLocale());
    }

    private void checkRootMemAglIsAdd() {
        Object parentObj = this.prmtParent.getData();
        Object polAgl = this.comboPolAlgorithm.getSelectedItem();
        if (parentObj == null && polAgl != null && polAgl instanceof BgUpperGatherEnum && (BgUpperGatherEnum)((Object)polAgl) != BgUpperGatherEnum.add) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"rootMemAglOnlybeAdd"));
            SysUtil.abort();
        }
    }

    private void saveProperty(String memberId) throws EASBizException, BOSException {
        Object propertyCols = this.kDBizPromptBox1.getData();
        BgPropertyCollection perCols = null;
        CoreBaseCollection saveCols = new CoreBaseCollection();
        if (propertyCols != null && propertyCols instanceof BgPropertyCollection) {
            perCols = (BgPropertyCollection)((Object)propertyCols);
            int len = perCols.size();
            for (int i = 0; i < len; ++i) {
                BgPropertyInfo propertyInfo = perCols.get(i);
                PropertyRefSourceInfo sourceInfo = new PropertyRefSourceInfo();
                sourceInfo.setSourceID(memberId);
                sourceInfo.setPropertyID(propertyInfo.getId().toString());
                saveCols.add((CoreBaseInfo)sourceInfo);
            }
        }
        if (!saveCols.isEmpty()) {
            PropertyRefSourceFactory.getRemoteInstance().saveBatchData(saveCols);
        } else {
            PropertyRefSourceFactory.getRemoteInstance().delete("where sourceID = '" + memberId + "'");
        }
        if (BgAccountHelper.hasPropValueChangeOnRow(this.getPropertyCols(), perCols)) {
            final BgAccountViewInfo curAccViewInfo = this.getCurAccViewInfo();
            final HashMap<String, BgPropertyCollection> updateData = new HashMap<String, BgPropertyCollection>(1);
            updateData.put("Acc".concat(BgBaseConstants.SEP_FOUR_STR).concat(this.editData.getNumber()), perCols);
            new Thread(){

                @Override
                public void run() {
                    try {
                        Class<?> aClass = Class.forName("com.kingdee.eas.ma.mbg.utils.MbgQingAnalyseHelper");
                        Method updateMemberPropToQingAnalyse = aClass.getMethod("updateMemberPropToQingAnalyse", Map.class, String.class, String.class);
                        updateMemberPropToQingAnalyse.invoke(aClass.newInstance(), updateData, curAccViewInfo.getId().toString(), "BG_Account");
                    }
                    catch (Exception var) {
                        logger.error((Object)"", (Throwable)var);
                    }
                }
            }.start();
        }
        this.setPropertyCols(perCols);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.txtNumber.setEnabled(true);
        this.initParentMember();
        this.initCreatOrg();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanEdit();
        super.actionEdit_actionPerformed(e);
        this.txtNumber.setEnabled(false);
        this.initCreatOrg();
    }

    private void checkCanEdit() {
        BgAccountInfo curDataObject = (BgAccountInfo)this.getDataObject();
        if (curDataObject.getId() == null) {
            return;
        }
        String id = curDataObject.getId().toString();
        if (curDataObject.getDistributeRootID() == null) {
            return;
        }
        String distributeId = curDataObject.getDistributeRootID().toString();
        if (!id.equals(distributeId)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"cantUpdateDistributeMem", (Object[])new Object[]{curDataObject.getNumber()}));
            SysUtil.abort();
        }
    }

    private void reFillPropertyByCurMem() {
        BgAccountInfo curDataObject = (BgAccountInfo)this.getDataObject();
        if (curDataObject.getId() == null) {
            return;
        }
        String curMemId = curDataObject.getId().toString();
        BgPropertyCollection bgProColls = null;
        HashSet<String> memberId = new HashSet<String>();
        memberId.add(curMemId);
        Map refPro = null;
        try {
            refPro = this.iProRef.queryPropertysByIds(memberId);
            bgProColls = (BgPropertyCollection)((Object)refPro.get(curMemId));
            this.initProp(bgProColls);
            this.kDBizPromptBox1.setData((Object)bgProColls);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.reFillPropertyByCurMem();
        this.initParentMember();
        this.initCreatOrg();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.reFillPropertyByCurMem();
        this.initParentMember();
        this.initCreatOrg();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.reFillPropertyByCurMem();
        this.initParentMember();
        this.initCreatOrg();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.reFillPropertyByCurMem();
        this.initParentMember();
        this.initCreatOrg();
    }

    public boolean checkBeforeWindowClosing() {
        BgAccountInfo obj;
        boolean bclose = super.checkBeforeWindowClosing();
        if (bclose && this.isRelease && (obj = (BgAccountInfo)this.getDataObject()).getId() != null) {
            BgAccountHelper.releaseMutexService(obj.getId().toString());
        }
        return bclose;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return BgAccountEditUI.getAccountSelector();
    }

    public static SelectorItemCollection getAccountSelector() {
        return BgAccountHelper.getAccountSelector();
    }

    protected void getNumberByCodingRule(IObjectValue caller, String orgId) {
        try {
            BgCodeNumberCHelper.getNumberByCodingRule(this.txtNumber, caller, orgId, this.numberCodeHelper);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIException(e);
        }
    }

    public boolean isModify() {
        return super.isModify();
    }
}

