/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountDataTypeEnum;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountGroupCollection;
import com.kingdee.eas.ma.base.BgAccountGroupFactory;
import com.kingdee.eas.ma.base.BgAccountGroupInfo;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgAccountSortCollection;
import com.kingdee.eas.ma.base.BgAccountSortFactory;
import com.kingdee.eas.ma.base.BgAccountSortInfo;
import com.kingdee.eas.ma.base.BgAccountTypeEnum;
import com.kingdee.eas.ma.base.BgAccountViewInfo;
import com.kingdee.eas.ma.base.BgDecreditAlgorithmEnum;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.BgPeriodSumEnum;
import com.kingdee.eas.ma.base.BgPropertyCollection;
import com.kingdee.eas.ma.base.BgPropertyFactory;
import com.kingdee.eas.ma.base.BgPropertySortCollection;
import com.kingdee.eas.ma.base.BgPropertySortFactory;
import com.kingdee.eas.ma.base.BgUpperGatherEnum;
import com.kingdee.eas.ma.base.IBgAccount;
import com.kingdee.eas.ma.base.IBgProperty;
import com.kingdee.eas.ma.base.IBgPropertySort;
import com.kingdee.eas.ma.base.IPropertyRefSource;
import com.kingdee.eas.ma.base.MbgDimException;
import com.kingdee.eas.ma.base.PropertyRefSourceFactory;
import com.kingdee.eas.ma.base.PropertyRefSourceInfo;
import com.kingdee.eas.ma.base.RptSrcTypeEnum;
import com.kingdee.eas.ma.base.client.BGReportUI;
import com.kingdee.eas.ma.base.client.BgBaseImportUI;
import com.kingdee.eas.ma.base.utils.BgAccountHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.ma.base.utils.Tree;
import com.kingdee.eas.ma.base.utils.TreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.awt.Component;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAccountImportUI
extends BgBaseImportUI {
    private static final long serialVersionUID = -2034525193057517865L;
    private static final Logger logger = CoreUIObject.getLogger(BgAccountImportUI.class);
    public static final String res = "com.kingdee.eas.ma.base.BgAccountResource";
    public static final String ROOT = "root";
    public static final String ALL_RIGHT = "ALL-RIGHT";
    private BgPropertySortCollection sortCol = null;
    Map<Integer, List<String>> errorMap = new HashMap<Integer, List<String>>();
    private IPropertyRefSource iPropSource = PropertyRefSourceFactory.getRemoteInstance();
    private IBgProperty iProperty = BgPropertyFactory.getRemoteInstance();
    private IBgPropertySort iPropertySort = BgPropertySortFactory.getRemoteInstance();
    private CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
    private UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
    private Timestamp time = new Timestamp(System.currentTimeMillis());
    private BgAccountViewInfo viewInfo = null;
    private CostCenterOrgUnitInfo ccOrgUnit = null;
    private HashMap<String, String> sheetAccounts = null;
    private HashSet<String> existAccountIds = null;
    private HashMap<String, BgAccountInfo> existAccounts = null;
    private HashMap<String, BgAccountInfo> existtmpMembers = null;
    private Set<String> groupSet = null;
    private Map<String, BgAccountGroupInfo> groupMap = null;
    private Map<String, BgAccountSortInfo> accountSortMapp = null;
    private List<String> accountSortLst = null;
    private Map<String, List<PropertyRefSourceInfo>> existProRefMap = null;

    @Override
    public String getImportTitle() {
        return EASResource.getString((String)res, (String)"importTitle");
    }

    private boolean recordIsEnable(KDSSheet sheet, int colDesc, int i, List<HashMap<String, String>> errorLst, String accountNumber) {
        return sheet.getCell(i, colDesc + 1, false).getValue() != null ? "".equals(sheet.getCell(i, colDesc + 1, false).getValue().toString().trim()) || EASResource.getString((String)res, (String)"true").equals(sheet.getCell(i, colDesc + 1, false).getValue().toString().trim()) : true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void importData(KDSSheet sheet) {
        int i;
        if (this.getViewID() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)res, (String)"selectView"));
            SysUtil.abort();
        }
        try {
            this.sortCol = this.getAllSortsByType("E68E9293");
        }
        catch (Exception e1) {
            logger.error((Object)("getAllSortsByType err:" + e1));
        }
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        int row_0 = 0;
        int row_1 = 1;
        int row_2 = 2;
        int row_3 = 3;
        int row_4 = 4;
        int row_5 = 5;
        int row_6 = 6;
        int row_7 = 7;
        int row_8 = 8;
        int row_9 = 9;
        int row_10 = 10;
        int row_12 = 12;
        int row_13 = 13;
        int row_description = this.sortCol != null ? this.sortCol.size() * 2 + 14 : -1;
        String accountNumber = null;
        String accountName = null;
        String parentNumber = null;
        Object parentName = null;
        Object level = null;
        Object polyAlgorithm = null;
        Object periodAlgorithm = null;
        Object bgAccountType = null;
        Object bgAccDateType = null;
        Object bgAccDereType = null;
        Object bgAccSortNumber = null;
        Object groupNumber = null;
        Object groupName = null;
        String description = null;
        boolean isEnable = false;
        HashSet<String> repeatNumbers = new HashSet<String>();
        boolean canAddNew = RptSrcTypeEnum.PT_BUDGET_REPORT.equals(this.getUIContext().get("sourceType"));
        CoreBaseCollection colls = new CoreBaseCollection();
        this.getExistAccounts();
        this.getSheetAccounts(sheet);
        this.getBgAccountSortColl();
        this.getGroupSet();
        HashMap<String, String> accNumber2GroupNumber = new HashMap<String, String>();
        HashMap<String, String> accNumber2ParentNumber = new HashMap<String, String>();
        this.initGroupAndParnetMap(sheet, row_12, row_2, accNumber2GroupNumber, accNumber2ParentNumber);
        HashMap<String, Boolean> accNumberBoolean = new HashMap<String, Boolean>();
        for (Map.Entry entry : accNumber2GroupNumber.entrySet()) {
            String acct = (String)entry.getKey();
            this.getFailedGroupByAcct(accNumber2GroupNumber, accNumber2ParentNumber, accNumberBoolean, acct);
        }
        int errorNum = this.getErrorNum();
        ArrayList<HashMap<String, String>> errorLst = new ArrayList<HashMap<String, String>>();
        HashMap<String, String> map = new HashMap<String, String>();
        List<String> errorItem = new ArrayList<String>();
        BgAccountInfo accountInfo = null;
        LinkedHashMap<String, ArrayList<BgAccountInfo>> parentMap = new LinkedHashMap<String, ArrayList<BgAccountInfo>>();
        int forCount = 0;
        int noWorkLine = 0;
        ArrayList<String> deleteProRefSource = new ArrayList<String>();
        this.progressBar.setMaximum(sheet.getRowCount());
        HashMap<String, Integer> numberRowMap = new HashMap<String, Integer>();
        try {
            Map refMap = this.getBizInteface().checkRef(this.existAccountIds);
            HashSet refDataSet = refMap != null && refMap.containsKey("ref_data") ? (Set)refMap.get("ref_data") : new HashSet();
            int in = sheet.getRowCount();
            for (i = 1; i < in; ++i) {
                HashSet<String> sortRefSourceSet;
                HashSet<String> sortNameSet;
                HashSet<String> numsSet;
                boolean isExist;
                boolean isNull;
                int sortSize;
                block109: {
                    block105: {
                        block104: {
                            block106: {
                                block108: {
                                    block107: {
                                        this.progressBar.setValue(i);
                                        ++forCount;
                                        accountNumber = this.getNumber(sheet.getCell(i, row_0, false).getValue());
                                        accountName = sheet.getCell(i, row_1, false).getValue() != null ? sheet.getCell(i, row_1, false).getValue().toString().trim() : null;
                                        parentNumber = this.getNumber(sheet.getCell(i, row_2, false).getValue());
                                        parentName = sheet.getCell(i, row_3, false).getValue();
                                        level = sheet.getCell(i, row_4, false).getValue();
                                        polyAlgorithm = sheet.getCell(i, row_5, false).getValue();
                                        periodAlgorithm = sheet.getCell(i, row_6, false).getValue();
                                        bgAccountType = sheet.getCell(i, row_7, false).getValue();
                                        bgAccDateType = sheet.getCell(i, row_8, false).getValue();
                                        bgAccDereType = sheet.getCell(i, row_9, false).getValue();
                                        bgAccSortNumber = sheet.getCell(i, row_10, false).getValue();
                                        groupNumber = sheet.getCell(i, row_12, false).getValue();
                                        groupName = sheet.getCell(i, row_13, false).getValue();
                                        description = sheet.getCell(i, row_description, false).getValue() != null ? sheet.getCell(i, row_description, false).getValue().toString().trim() : null;
                                        isEnable = this.recordIsEnable(sheet, row_description, i, errorLst, accountNumber);
                                        numberRowMap.put(accountNumber, i);
                                        if (!(sheet.getCell(i, row_description + 1, false).getValue() == null || EASResource.getString((String)res, (String)"true").equals(sheet.getCell(i, row_description + 1, false).getValue().toString().trim()) || EASResource.getString((String)res, (String)"false").equals(sheet.getCell(i, row_description + 1, false).getValue().toString().trim()) || "".equals(sheet.getCell(i, row_description + 1, false).getValue().toString().trim()))) {
                                            errorItem = new ArrayList();
                                            errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.MbgDimResource", "disableState"), i + 1, accountNumber));
                                            this.addError(errorItem, i);
                                            if (this.getErrorNum() == 1) break;
                                            if (!this.existtmpMembers.containsKey(accountNumber)) continue;
                                            isEnable = this.existtmpMembers.get(accountNumber).isIsEnabled();
                                        }
                                        accountInfo = new BgAccountInfo();
                                        accountInfo.importIndex = i;
                                        BgAccountInfo parentInfo = null;
                                        accountInfo.setIsEnabled(isEnable);
                                        if (!isEnable) {
                                            Date date = new Date();
                                            accountInfo.setDisabledDate(date);
                                        }
                                        if (row_description != -1 && description instanceof String) {
                                            accountInfo.setDescription(description);
                                        }
                                        if (!this.isNull(accountNumber) && !BgNumberHelper.checkNumber(accountNumber)) {
                                            errorItem = new ArrayList();
                                            errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError10"), i + 1, accountNumber));
                                            this.addError(errorItem, i);
                                            if (errorNum != 1) continue;
                                            break;
                                        }
                                        if (!this.isNull(accountNumber) && accountNumber != null && BgDBUtils.length(accountNumber) > 80) {
                                            errorItem = new ArrayList();
                                            errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError11"), i + 1, accountNumber, 80));
                                            this.addError(errorItem, i);
                                            if (errorNum != 1) continue;
                                            break;
                                        }
                                        if (!this.isNull(accountNumber) && accountNumber != null && repeatNumbers.contains(accountNumber)) {
                                            errorItem = new ArrayList();
                                            errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError18"), i + 1, accountNumber));
                                            this.addError(errorItem, i);
                                            if (errorNum != 1) continue;
                                            break;
                                        }
                                        if (!canAddNew && !this.existAccounts.containsKey(accountNumber)) {
                                            errorItem = new ArrayList();
                                            errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError17"), i + 1, accountNumber, 80));
                                            this.addError(errorItem, i);
                                            if (errorNum != 1) continue;
                                            break;
                                        }
                                        if (this.existAccounts.containsKey(accountNumber) && !this.existAccounts.get(accountNumber).getId().equals((Object)this.existAccounts.get(accountNumber).getDistributeRootID())) {
                                            errorItem = new ArrayList();
                                            errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError16"), i + 1, accountNumber));
                                            this.addError(errorItem, i);
                                            if (errorNum != 1) continue;
                                            break;
                                        }
                                        if (this.isNull(accountNumber) || this.isNull(accountName)) break block105;
                                        if (accountNumber != null) {
                                            accountInfo.setNumber(accountNumber);
                                        }
                                        if (accountName != null) {
                                            accountInfo.setName(accountName.toString());
                                        }
                                        if (this.isNull(parentNumber) || parentNumber == null || parentNumber.equals(accountNumber)) break block106;
                                        if (this.existAccounts.containsKey(parentNumber)) {
                                            parentInfo = this.existAccounts.get(parentNumber);
                                            if (parentInfo.isIsLeaf() && refDataSet.contains(parentInfo.getId().toString())) {
                                                errorItem = new ArrayList();
                                                errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError13"), i + 1, accountNumber));
                                                this.addError(errorItem, i);
                                                if (errorNum != 1) continue;
                                                break;
                                            }
                                            accountInfo.setParent(parentInfo);
                                            if (accountNumber != null) {
                                                accountInfo.setLongNumber(parentInfo.getLongNumber() + "!" + accountNumber);
                                                if (!this.isNull(accountName)) {
                                                    accountInfo.setDisplayName(parentInfo.getDisplayName() + "_" + accountName);
                                                }
                                            }
                                            accountInfo.setLevel(parentInfo.getLevel() + 1);
                                            accountInfo.setIsLeaf(false);
                                        } else if (!this.sheetAccounts.containsKey(parentNumber)) {
                                            errorItem = new ArrayList();
                                            errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError2"), i + 1, accountNumber));
                                            this.addError(errorItem, i);
                                            if (errorNum != 1) continue;
                                            break;
                                        }
                                        if (!this.isNull(polyAlgorithm)) break block107;
                                        accountInfo.setPolAlgorithm(BgUpperGatherEnum.add);
                                        break block104;
                                    }
                                    if (!polyAlgorithm.toString().trim().equals(BgUpperGatherEnum.add.getAlias())) break block108;
                                    accountInfo.setPolAlgorithm(BgUpperGatherEnum.add);
                                    break block104;
                                }
                                if (polyAlgorithm.toString().trim().equals(BgUpperGatherEnum.subtract.getAlias())) {
                                    accountInfo.setPolAlgorithm(BgUpperGatherEnum.subtract);
                                    break block104;
                                } else if (polyAlgorithm.toString().trim().equals(BgUpperGatherEnum.ignore.getAlias())) {
                                    accountInfo.setPolAlgorithm(BgUpperGatherEnum.ignore);
                                    break block104;
                                } else {
                                    errorItem = new ArrayList();
                                    errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError3"), i + 1, accountNumber));
                                    this.addError(errorItem, i);
                                    if (errorNum != 1) continue;
                                    break;
                                }
                            }
                            if (parentNumber != null && parentNumber.equals(accountNumber)) {
                                errorItem = new ArrayList();
                                errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError9"), i + 1, accountNumber));
                                this.addError(errorItem, i);
                                if (errorNum != 1) continue;
                                break;
                            }
                            accountInfo.setParent(null);
                            if (accountNumber != null) {
                                accountInfo.setLongNumber(accountNumber);
                                if (!this.isNull(accountName) && accountName != null) {
                                    accountInfo.setDisplayName(accountName.toString());
                                }
                            }
                            accountInfo.setLevel(1);
                            accountInfo.setIsLeaf(true);
                            accountInfo.setPolAlgorithm(BgUpperGatherEnum.add);
                        }
                        if (this.isNull(groupNumber)) {
                            errorItem = new ArrayList();
                            errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "groupIsNull"), i + 1, accountNumber));
                            this.addError(errorItem, i);
                            if (errorNum != 1) continue;
                            break;
                        }
                        if (!this.groupSet.contains(groupNumber)) {
                            errorItem = new ArrayList();
                            errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "accGroupnotExists"), i + 1, accountNumber));
                            this.addError(errorItem, i);
                            if (errorNum != 1) continue;
                            break;
                        }
                        if (!accNumberBoolean.isEmpty() && Boolean.FALSE.equals(accNumberBoolean.get(accountNumber))) {
                            errorItem = new ArrayList();
                            errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "notSameGroup"), i + 1, accountNumber));
                            this.addError(errorItem, i);
                            if (errorNum != 1) continue;
                            break;
                        }
                        BgAccountGroupInfo bgAccountGroupInfo = this.groupMap.get(groupNumber);
                        accountInfo.setGroup(bgAccountGroupInfo);
                        if (this.isNull(periodAlgorithm)) {
                            accountInfo.setPeriodAlgorithm(BgPeriodSumEnum.sum);
                        } else if (periodAlgorithm.toString().trim().equals(BgPeriodSumEnum.sum.getAlias())) {
                            accountInfo.setPeriodAlgorithm(BgPeriodSumEnum.sum);
                        } else if (periodAlgorithm.toString().trim().equals(BgPeriodSumEnum.opening.getAlias())) {
                            accountInfo.setPeriodAlgorithm(BgPeriodSumEnum.opening);
                        } else if (periodAlgorithm.toString().trim().equals(BgPeriodSumEnum.ending.getAlias())) {
                            accountInfo.setPeriodAlgorithm(BgPeriodSumEnum.ending);
                        } else {
                            errorItem = new ArrayList();
                            errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError4"), i + 1, accountNumber));
                            this.addError(errorItem, i);
                            if (errorNum != 1) continue;
                            break;
                        }
                        if (this.isNull(bgAccountType)) {
                            accountInfo.setBgAccountType(BgAccountTypeEnum.empty);
                        } else if (bgAccountType.toString().trim().equals(BgAccountTypeEnum.empty.getAlias())) {
                            accountInfo.setBgAccountType(BgAccountTypeEnum.empty);
                        } else if (bgAccountType.toString().trim().equals(BgAccountTypeEnum.property.getAlias())) {
                            accountInfo.setBgAccountType(BgAccountTypeEnum.property);
                        } else if (bgAccountType.toString().trim().equals(BgAccountTypeEnum.liability.getAlias())) {
                            accountInfo.setBgAccountType(BgAccountTypeEnum.liability);
                        } else if (bgAccountType.toString().trim().equals(BgAccountTypeEnum.profit_and_loss.getAlias())) {
                            accountInfo.setBgAccountType(BgAccountTypeEnum.profit_and_loss);
                        } else if (bgAccountType.toString().trim().equals(BgAccountTypeEnum.equity.getAlias())) {
                            accountInfo.setBgAccountType(BgAccountTypeEnum.equity);
                        } else if (bgAccountType.toString().trim().equals(BgAccountTypeEnum.balance.getAlias())) {
                            accountInfo.setBgAccountType(BgAccountTypeEnum.balance);
                        } else {
                            errorItem = new ArrayList();
                            errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError5"), i + 1, accountNumber));
                            this.addError(errorItem, i);
                            if (errorNum != 1) continue;
                            break;
                        }
                        if (this.isNull(bgAccDateType)) {
                            accountInfo.setBgAccountDataType(BgAccountDataTypeEnum.CURRENCY);
                        } else if (bgAccDateType.toString().trim().equals(BgAccountDataTypeEnum.CURRENCY.getAlias())) {
                            accountInfo.setBgAccountDataType(BgAccountDataTypeEnum.CURRENCY);
                        } else if (bgAccDateType.toString().trim().equals(BgAccountDataTypeEnum.NONMONETARY.getAlias())) {
                            accountInfo.setBgAccountDataType(BgAccountDataTypeEnum.NONMONETARY);
                        } else if (bgAccDateType.toString().trim().equals(BgAccountDataTypeEnum.RATE.getAlias())) {
                            accountInfo.setBgAccountDataType(BgAccountDataTypeEnum.RATE);
                        } else {
                            errorItem = new ArrayList();
                            errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError6"), i + 1, accountNumber));
                            this.addError(errorItem, i);
                            if (errorNum != 1) continue;
                            break;
                        }
                        if (this.isNull(bgAccDereType)) {
                            accountInfo.setBgDecreditAlgorithm(BgDecreditAlgorithmEnum.DECREDIT);
                        } else if (bgAccDereType.toString().trim().equals(BgDecreditAlgorithmEnum.DECREDIT.getAlias())) {
                            accountInfo.setBgDecreditAlgorithm(BgDecreditAlgorithmEnum.DECREDIT);
                        } else if (bgAccDereType.toString().trim().equals(BgDecreditAlgorithmEnum.CREDEDIT.getAlias())) {
                            accountInfo.setBgDecreditAlgorithm(BgDecreditAlgorithmEnum.CREDEDIT);
                        } else {
                            errorItem = new ArrayList();
                            errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError7"), i + 1, accountNumber));
                            this.addError(errorItem, i);
                            if (errorNum != 1) continue;
                            break;
                        }
                        if (this.isNull(bgAccSortNumber)) {
                            accountInfo.setBgAccountSort(null);
                        } else if (this.accountSortLst.contains(bgAccSortNumber.toString().trim())) {
                            accountInfo.setBgAccountSort(this.accountSortMapp.get(bgAccSortNumber.toString().trim()));
                        } else {
                            errorItem = new ArrayList();
                            errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError8"), i + 1, accountNumber));
                            this.addError(errorItem, i);
                            if (errorNum != 1) continue;
                            break;
                        }
                        if (this.existAccounts.containsKey(accountInfo.getNumber())) {
                            accountInfo.setId(this.existAccounts.get(accountInfo.getNumber()).getId());
                        }
                        if (accountInfo.getId() == null) {
                            accountInfo.setId(BOSUuid.create((BOSObjectType)accountInfo.getBOSType()));
                        }
                        sortSize = this.sortCol.size();
                        int begin = 12;
                        int count = sheet.getColumnCount();
                        isNull = false;
                        isExist = false;
                        numsSet = new HashSet<String>();
                        sortNameSet = new HashSet<String>();
                        sortRefSourceSet = new HashSet<String>();
                        break block109;
                    }
                    if (this.existAccounts.containsKey(accountNumber)) {
                        if (this.existAccounts.get(accountNumber).getId().equals((Object)this.existAccounts.get(accountNumber).getDistributeRootID())) continue;
                        errorItem = new ArrayList();
                        errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError16"), i + 1, accountNumber));
                        this.addError(errorItem, i);
                        if (errorNum != 1) continue;
                        break;
                    }
                    if (this.isNull(accountNumber) && this.isNull(accountName) && this.isNull(parentNumber) && this.isNull(polyAlgorithm) && this.isNull(periodAlgorithm) && this.isNull(bgAccDateType) && this.isNull(bgAccDereType) && this.isNull(bgAccSortNumber)) {
                        ++noWorkLine;
                        continue;
                    }
                    errorItem = new ArrayList();
                    errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError1"), i + 1));
                    this.addError(errorItem, i);
                    if (errorNum != 1) continue;
                    break;
                }
                for (int index = 0; index < sortSize * 2; index += 2) {
                    String headName = sheet.getCell(0, 14 + index, false).getValue().toString();
                    String sortName = headName.substring(0, headName.length() - 4);
                    if (!this.isSortExist(sortName)) continue;
                    Object propertyNum = sheet.getCell(i, 14 + index, false).getValue();
                    Object propertyName = sheet.getCell(i, 14 + index + 1, false).getValue();
                    if (this.isNull(propertyNum) && !this.isNull(propertyName)) {
                        errorItem = new ArrayList();
                        errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError14"), i + 1, accountNumber, sortName));
                        this.addError(errorItem, i);
                        isNull = true;
                        break;
                    }
                    if (!this.isNull(propertyNum)) {
                        if (!this.isPropInSort(sortName, propertyNum.toString())) {
                            errorItem = new ArrayList();
                            errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError15"), i + 1, accountNumber, sortName, propertyNum.toString()));
                            this.addError(errorItem, i);
                            isExist = true;
                            break;
                        }
                        numsSet.add(propertyNum.toString());
                        sortNameSet.add(sortName);
                        sortRefSourceSet.add(sortName + ":" + propertyNum.toString());
                        continue;
                    }
                    if (this.isNull(propertyName) && !this.isNull(propertyNum)) continue;
                }
                if (isNull || isExist) {
                    if (errorNum != 1) continue;
                    break;
                }
                BgPropertyCollection propCol = this.getPropertyCol(sortNameSet, numsSet);
                PropertyRefSourceInfo sourceInfo = null;
                CoreBaseCollection sourceColls = new CoreBaseCollection();
                if (propCol != null && !propCol.isEmpty()) {
                    for (int j = 0; j < propCol.size(); ++j) {
                        String propId = propCol.get(j).getId().toString();
                        String key = propCol.get(j).getBgPropertySort().getName() + ":" + propCol.get(j).getNumber();
                        if (!sortRefSourceSet.contains(key)) continue;
                        sourceInfo = new PropertyRefSourceInfo();
                        sourceInfo.setPropertyID(propId);
                        sourceInfo.setSourceID(accountInfo.getId().toString());
                        sourceColls.add((CoreBaseInfo)sourceInfo);
                    }
                } else if (accountInfo.getId() != null && this.getExistProRefMap().containsKey(accountInfo.getId().toString())) {
                    deleteProRefSource.add(accountInfo.getId().toString());
                }
                try {
                    if (!sourceColls.isEmpty()) {
                        this.iPropSource.saveBatchData(sourceColls);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("insert into PropSource err" + e.getMessage()));
                }
                this.addOthersToAccount(accountInfo);
                if (parentNumber == null || StringUtils.isEmpty((String)parentNumber.toString())) {
                    parentNumber = ROOT;
                }
                if (parentNumber != null && !parentMap.containsKey(parentNumber)) {
                    parentMap.put(parentNumber.toString(), new ArrayList());
                }
                ((ArrayList)parentMap.get(parentNumber)).add(accountInfo);
                repeatNumbers.add(accountInfo.getNumber());
            }
            this.processParent(parentMap, colls, errorLst);
            this.processColls(colls);
            this.filterByDisplayName(colls, numberRowMap, errorItem);
            if (!colls.isEmpty()) {
                BgAccountFactory.getRemoteInstance().importBatchData(colls);
            }
            if (!deleteProRefSource.isEmpty()) {
                this.iPropSource.deleteBatchBySourceIds(deleteProRefSource);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        ArrayList<HashMap<String, String>> txtlst = new ArrayList<HashMap<String, String>>();
        map = new HashMap();
        map.put(" ", MessageFormat.format(BgCommCHelper.getMessageStr(res, "importMsg_1"), forCount - this.errorMap.keySet().size() - noWorkLine));
        txtlst.add(map);
        if (sheet.getRowCount() - colls.size() != 1 || !this.errorMap.isEmpty()) {
            map = new HashMap();
            if (errorNum == 1) {
                map.put(" ", BgCommCHelper.getMessageStr(res, "importMsg_2", new String[]{String.valueOf(forCount - colls.size())}));
            } else if (this.errorMap.size() > 0) {
                map.put(" ", BgCommCHelper.getMessageStr(res, "importMsg_2", new String[]{String.valueOf(this.errorMap.keySet().size())}));
            }
            txtlst.add(map);
        }
        if (this.errorMap.keySet() != null) {
            Object[] array = this.errorMap.keySet().toArray();
            Arrays.sort((Object[])array);
            for (i = 0; i < array.length; ++i) {
                errorItem = this.errorMap.get(array[i]);
                if (errorItem == null) continue;
                for (int j = 0; j < errorItem.size(); ++j) {
                    map = new HashMap();
                    map.put(" ", errorItem.get(j));
                    errorLst.add(map);
                }
            }
        }
        txtlst.addAll(errorLst);
        ArrayList<String> listHeadTitle = new ArrayList<String>();
        listHeadTitle.add(" ");
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"LIST_CONTENT", txtlst);
        ctx.put((Object)"LIST_HEAD_TITLE", listHeadTitle);
        String invokeTime = BgNationalFormatUIUtil.getNationalDateTimeFormat().format(new Date());
        ctx.put((Object)"INVOKE_TIME", (Object)invokeTime);
        ctx.put((Object)"UI_OWNER_TITLE", (Object)BgCommCHelper.getMessageStr(res, "importTitle"));
        if (!canAddNew) {
            ctx.put((Object)"ORG_DETAIL", (Object)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.ProgressDialogResource", "accountDetail"));
        }
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BGReportUI.class.getName(), (Map)ctx);
            uiWindow.show();
            return;
        }
        catch (UIException e) {
            logger.error((Object)e);
        }
    }

    private void getFailedGroupByAcct(Map<String, String> accNumber2GroupNumber, Map<String, String> accNumber2ParentNumber, Map<String, Boolean> accNumberBoolean, String acct) {
        if (!accNumber2ParentNumber.containsKey(acct)) {
            return;
        }
        if (accNumber2ParentNumber.get(acct) == null) {
            String parnetNumber = accNumber2ParentNumber.get(acct);
            String group = accNumber2GroupNumber.get(acct);
            if (accNumber2GroupNumber.containsKey(parnetNumber)) {
                String parentGroup = accNumber2GroupNumber.get(parnetNumber);
                if (group != null && !group.equals(parentGroup)) {
                    accNumberBoolean.put(acct, Boolean.FALSE);
                }
            }
            return;
        }
        String parnetNumber = accNumber2ParentNumber.get(acct);
        String group = accNumber2GroupNumber.get(acct);
        if (acct.equals(parnetNumber)) {
            return;
        }
        if (accNumber2GroupNumber.containsKey(parnetNumber)) {
            String parentGroup = accNumber2GroupNumber.get(parnetNumber);
            if (group != null && !group.equals(parentGroup)) {
                accNumberBoolean.put(acct, Boolean.FALSE);
            } else {
                acct = parnetNumber;
                this.getFailedGroupByAcct(accNumber2GroupNumber, accNumber2ParentNumber, accNumberBoolean, acct);
            }
        }
    }

    private void initGroupAndParnetMap(KDSSheet sheet, int row_11, int row_2, Map<String, String> accNumber2GroupNumber, Map<String, String> accNumber2ParentNumber) {
        if (this.existtmpMembers != null) {
            for (Map.Entry<String, BgAccountInfo> entry : this.existtmpMembers.entrySet()) {
                accNumber2GroupNumber.put(entry.getKey(), entry.getValue().getGroup() != null ? entry.getValue().getGroup().getNumber() : null);
                accNumber2ParentNumber.put(entry.getKey(), entry.getValue().getParent() != null ? entry.getValue().getParent().getNumber() : null);
            }
            String _number = null;
            String _groupNumber = null;
            String _pnumber = null;
            int in = sheet.getRowCount();
            for (int i = 1; i < in; ++i) {
                _number = sheet.getCell(i, 0, false).getValue() != null ? sheet.getCell(i, 0, false).getValue().toString() : null;
                _groupNumber = sheet.getCell(i, row_11, false).getValue() != null ? sheet.getCell(i, row_11, false).getValue().toString() : null;
                String string = _pnumber = sheet.getCell(i, row_2, false).getValue() != null ? sheet.getCell(i, row_2, false).getValue().toString() : null;
                if (_number != null && _number.trim().isEmpty()) continue;
                accNumber2GroupNumber.put(_number, _groupNumber);
                accNumber2ParentNumber.put(_number, _pnumber);
            }
        }
    }

    private void filterByDisplayName(CoreBaseCollection colls, Map<String, Integer> numberRowMap, List<String> errorItem) {
        Iterator iterator = colls.iterator();
        while (iterator.hasNext()) {
            BgAccountInfo info = (BgAccountInfo)iterator.next();
            String displayName = info.getDisplayName(null);
            if (displayName.length() <= 255) continue;
            Integer row = numberRowMap.get(info.getNumber());
            errorItem = new ArrayList<String>();
            errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError20"), row + 1, info.getNumber()));
            this.addError(errorItem, row);
            iterator.remove();
        }
    }

    private void addError(List<String> errorItem, int i) {
        if (this.errorMap.containsKey(i + 1)) {
            this.errorMap.get(i + 1).addAll(errorItem);
        } else {
            this.errorMap.put(i + 1, errorItem);
        }
    }

    private void processColls(CoreBaseCollection colls) throws MbgDimException {
        BgAccountInfo accountInfo = null;
        Tree tree = this.getTree();
        Date date = new Date();
        String lookForDisableParent = null;
        for (String numberExist : this.existtmpMembers.keySet()) {
            if (this.sheetAccounts.keySet().contains(numberExist)) continue;
            accountInfo = this.existtmpMembers.get(numberExist);
            lookForDisableParent = tree.getNode(numberExist).lookForDisableParent();
            if (ALL_RIGHT.equals(lookForDisableParent) || numberExist.equals(lookForDisableParent)) continue;
            if (accountInfo.isIsEnabled()) {
                accountInfo.setDisabledDate(date);
            }
            accountInfo.setIsEnabled(false);
            colls.add((CoreBaseInfo)accountInfo);
        }
    }

    private Tree getTree() throws MbgDimException {
        Tree tree = new Tree();
        TreeNode treeNode = null;
        Iterator<String> iterator = this.existAccounts.keySet().iterator();
        while (iterator.hasNext()) {
            String number;
            String memberNumber = number = iterator.next();
            BgAccountInfo bgAccountInfo = this.existAccounts.get(number);
            if (bgAccountInfo == null) continue;
            String parentNumber = bgAccountInfo.getParent() == null ? null : bgAccountInfo.getParent().getNumber();
            boolean isEnable = bgAccountInfo.isIsEnabled();
            treeNode = new TreeNode(parentNumber, memberNumber, new HashMap(), tree);
            treeNode.setEnable(isEnable);
            tree.addNode(treeNode);
        }
        return tree;
    }

    private BgPropertyCollection getPropertyCol(Set<String> sortName, Set<String> set) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bgPropertySort.name", sortName, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bgPropertySort.sourceType", (Object)"E68E9293", CompareType.EQUALS));
        view.setFilter(filter);
        BgPropertyCollection col = null;
        try {
            IBgProperty iProperty = BgPropertyFactory.getRemoteInstance();
            col = iProperty.getBgPropertyCollection(view);
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
        }
        return col;
    }

    private boolean isSortExist(String name) {
        HashSet<String> set = new HashSet<String>();
        if (this.sortCol == null || this.sortCol.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.sortCol.size(); ++i) {
            set.add(this.sortCol.get(i).getName());
        }
        return set.contains(name);
    }

    private boolean isPropInSort(String sortName, String propertyNumber) {
        Object sortInfo = null;
        BgPropertyCollection col = null;
        Object propertyInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)propertyNumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgPropertySort.name", (Object)sortName, CompareType.EQUALS));
        view.setFilter(filter);
        try {
            col = this.iProperty.getBgPropertyCollection(view);
            if (col == null || col.isEmpty()) {
                return false;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
        }
        return true;
    }

    private BgPropertySortCollection getAllSortsByType(String type) throws BOSException, EASBizException {
        if (type == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourcetype", (Object)type, CompareType.EQUALS));
        view.setFilter(filter);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("number"));
        view.setSorter(sort);
        return BgPropertySortFactory.getRemoteInstance().getBgPropertySortCollection(view);
    }

    private void processParent(Map<String, ArrayList<BgAccountInfo>> parentMap, CoreBaseCollection coll, List<HashMap<String, String>> errorLst) {
        block21: {
            if (parentMap.isEmpty()) {
                return;
            }
            ArrayList<String> errorItem = null;
            boolean canImport = true;
            String parentNumber2 = null;
            BgAccountInfo info2 = null;
            List rootLst = parentMap.get(ROOT);
            Date date = new Date();
            if (parentMap.containsKey(ROOT)) {
                rootLst = parentMap.get(ROOT);
                for (BgAccountInfo info2 : rootLst) {
                    canImport = true;
                    info2.setParent(null);
                    info2.setLevel(1);
                    info2.setLongNumber(info2.getNumber());
                    info2.setDisplayName(info2.getName());
                    if (parentMap.containsKey(info2.getNumber())) {
                        info2.setIsLeaf(false);
                    } else {
                        info2.setIsLeaf(true);
                    }
                    if (!info2.isIsEnabled()) {
                        if (this.existtmpMembers.containsKey(info2.getNumber()) && !this.existtmpMembers.get(info2.getNumber()).isIsEnabled() && !info2.isIsEnabled()) {
                            info2.setDisabledDate(this.existtmpMembers.get(info2.getNumber()).getDisabledDate());
                        } else {
                            info2.setDisabledDate(date);
                        }
                    } else {
                        info2.setDisabledDate(null);
                    }
                    if (info2.getLongNumber() != null) {
                        String[] _pNumber = info2.getLongNumber().split(BgBaseConstants.SEP_ONE_STR);
                        for (int x = 0; x < _pNumber.length - 1; ++x) {
                            if (!info2.getNumber().equals(_pNumber[x])) continue;
                            errorItem = new ArrayList();
                            errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.MbgDimResource", "importError20"), info2.importIndex + 1, info2.getNumber()));
                            if (!this.checkErrors(this.errorMap, errorItem, info2.importIndex)) continue;
                            canImport = false;
                            break;
                        }
                    }
                    if (!canImport) continue;
                    this.existAccounts.put(info2.getNumber(), info2);
                    coll.add((CoreBaseInfo)info2);
                    this.processChild(info2, parentMap, coll, errorLst, date);
                }
            }
            ArrayList allAccounts = new ArrayList();
            Iterator<String> iit = parentMap.keySet().iterator();
            while (iit.hasNext()) {
                allAccounts.addAll(parentMap.get(iit.next()));
            }
            if (allAccounts.size() == coll.size()) break block21;
            if (!coll.isEmpty()) {
                ArrayList<String> numLst = new ArrayList<String>();
                for (int i = 0; i < coll.size(); ++i) {
                    if (numLst.contains(((BgAccountInfo)coll.get(i)).getNumber())) continue;
                    numLst.add(((BgAccountInfo)coll.get(i)).getNumber());
                }
                for (String parentNumber2 : parentMap.keySet()) {
                    if (numLst.contains(parentNumber2) || ROOT.equals(parentNumber2)) continue;
                    if (this.existAccounts.containsKey(parentNumber2)) {
                        this.processChild(this.existAccounts.get(parentNumber2), parentMap, coll, errorLst, date);
                        continue;
                    }
                    List lst = parentMap.get(parentNumber2);
                    for (int index = 0; index < lst.size(); ++index) {
                        info2 = (BgAccountInfo)lst.get(index);
                        errorItem = new ArrayList();
                        errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError19"), info2.importIndex + 1, info2.getNumber()));
                        this.addError(errorItem, info2.importIndex);
                    }
                }
            } else {
                for (String parentNumber2 : parentMap.keySet()) {
                    if (this.existAccounts.containsKey(parentNumber2)) {
                        this.processChild(this.existAccounts.get(parentNumber2), parentMap, coll, errorLst, date);
                        continue;
                    }
                    List lst = parentMap.get(parentNumber2);
                    for (int index = 0; index < lst.size(); ++index) {
                        info2 = (BgAccountInfo)lst.get(index);
                        errorItem = new ArrayList<String>();
                        errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(res, "importError19"), info2.importIndex + 1, info2.getNumber()));
                        this.addError(errorItem, info2.importIndex);
                    }
                }
            }
        }
    }

    private void processChild(BgAccountInfo parent, Map<String, ArrayList<BgAccountInfo>> parentMap, CoreBaseCollection coll, List<HashMap<String, String>> errorLst, Date date) {
        String parentNumber = parent.getNumber();
        boolean canImport = true;
        BgAccountInfo info2 = null;
        List lst = null;
        ArrayList<String> errorItem = null;
        if (parentMap.containsKey(parentNumber)) {
            lst = parentMap.get(parentNumber);
            for (BgAccountInfo info2 : lst) {
                if (!this.existAccounts.containsKey(parentNumber)) continue;
                if (!parent.isIsEnabled() && info2.isIsEnabled()) {
                    info2.setIsEnabled(parent.isIsEnabled());
                    errorItem = new ArrayList<String>();
                    errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.MbgDimResource", "parentDisable"), info2.importIndex + 1, info2.getNumber(), parent.getNumber()));
                    this.addError(errorItem, info2.importIndex);
                    if (this.getErrorNum() == 1) break;
                }
                String infoNumber = info2.getNumber();
                info2.setParent(parent);
                info2.setLevel(parent.getLevel() + 1);
                info2.setLongNumber(parent.getLongNumber() + "!" + infoNumber);
                info2.setDisplayName(parent.getDisplayName() + "_" + info2.getName());
                if (parentMap.containsKey(infoNumber)) {
                    info2.setIsLeaf(false);
                } else {
                    info2.setIsLeaf(true);
                }
                if (this.existAccounts.containsKey(infoNumber)) {
                    info2.setId(this.existAccounts.get(infoNumber).getId());
                }
                if (!info2.isIsEnabled()) {
                    if (this.existtmpMembers.containsKey(info2.getNumber()) && !this.existtmpMembers.get(info2.getNumber()).isIsEnabled()) {
                        info2.setDisabledDate(this.existtmpMembers.get(info2.getNumber()).getDisabledDate());
                    } else {
                        info2.setDisabledDate(date);
                    }
                } else {
                    info2.setDisabledDate(null);
                }
                this.existAccounts.put(infoNumber, info2);
                if (info2.getLongNumber() != null) {
                    String[] _pNumber = info2.getLongNumber().split(BgBaseConstants.SEP_ONE_STR);
                    for (int x = 0; x < _pNumber.length - 1; ++x) {
                        if (!info2.getNumber().equals(_pNumber[x])) continue;
                        errorItem = new ArrayList();
                        errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.MbgDimResource", "importError20"), info2.importIndex + 1, info2.getNumber()));
                        if (!this.checkErrors(this.errorMap, errorItem, info2.importIndex)) continue;
                        canImport = false;
                        break;
                    }
                }
                if (!canImport) continue;
                if (this.existtmpMembers.containsKey(info2.getNumber()) && !this.existtmpMembers.get(info2.getNumber()).isIsEnabled() && !info2.isIsEnabled()) {
                    info2.setDisabledDate(this.existtmpMembers.get(info2.getNumber()).getDisabledDate());
                } else if (this.existtmpMembers.containsKey(info2.getNumber()) && !this.existtmpMembers.get(info2.getNumber()).isIsEnabled() && info2.isIsEnabled()) {
                    info2.setDisabledDate(null);
                } else if (this.existtmpMembers.containsKey(info2.getNumber()) && this.existtmpMembers.get(info2.getNumber()).isIsEnabled() && !info2.isIsEnabled()) {
                    info2.setDisabledDate(date);
                }
                coll.add((CoreBaseInfo)info2);
                this.processChild(info2, parentMap, coll, errorLst, date);
            }
        }
    }

    private boolean findParentHasDisable(BgAccountInfo info) {
        if (info.getParent() != null && !info.isIsEnabled() || info.getParent() == null) {
            return false;
        }
        return this.findParentHasDisable(info.getParent());
    }

    private boolean checkErrors(Map<Integer, List<String>> errorMap2, List<String> errorItem, int i) {
        boolean re = false;
        if (errorMap2 == null || errorItem == null) {
            return re;
        }
        boolean check = false;
        String key = errorItem.get(0);
        block0: for (List<String> tmpList : errorMap2.values()) {
            for (int j = 0; j < tmpList.size(); ++j) {
                if (!tmpList.get(j).equals(key)) continue;
                check = true;
                continue block0;
            }
        }
        if (!check) {
            this.addError(errorItem, i);
            re = true;
        }
        return re;
    }

    private void addOthersToAccount(BgAccountInfo info) throws EASBizException, BOSException {
        if (info == null || this.getViewID() == null) {
            return;
        }
        info.setCreator(this.user);
        info.setLastUpdateUser(this.user);
        info.setLastUpdateTime(this.time);
        info.setCreateTime(this.time);
        info.setCU(this.cu);
        if (this.viewInfo == null) {
            this.viewInfo = new BgAccountViewInfo();
            this.viewInfo.setId(BOSUuid.read((String)this.getViewID()));
        }
        info.setBgAccountView(this.viewInfo);
        if (this.ccOrgUnit == null && this.getOrgUnitId() != null) {
            this.ccOrgUnit = new CostCenterOrgUnitInfo();
            this.ccOrgUnit = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.getOrgUnitId()));
        }
        if (info.getOrgUnit() == null || info.getOrgUnit().getId() == null) {
            info.setOrgUnit(this.ccOrgUnit);
        }
    }

    private boolean isNull(Object obj) {
        return obj == null || obj.toString().equals("");
    }

    private HashMap<String, String> getSheetAccounts(KDSSheet sheet) {
        if (this.sheetAccounts == null || this.sheetAccounts.isEmpty()) {
            this.sheetAccounts = new HashMap();
            String number = null;
            String parentNumber = null;
            int in = sheet.getRowCount();
            for (int i = 1; i < in; ++i) {
                number = sheet.getCell(i, 0, false).getValue() != null ? sheet.getCell(i, 0, false).getValue().toString() : "null";
                parentNumber = sheet.getCell(i, 2, false).getValue() != null ? sheet.getCell(i, 2, false).getValue().toString() : "null";
                this.sheetAccounts.put(number, parentNumber);
            }
        }
        return this.sheetAccounts;
    }

    private HashMap<String, BgAccountInfo> getExistAccounts() {
        if (this.getViewID() == null) {
            return null;
        }
        if (this.existAccounts == null || this.existAccounts.isEmpty()) {
            this.existAccountIds = new HashSet();
            this.existAccounts = new HashMap();
            this.existtmpMembers = new HashMap();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bgAccountView.id", (Object)this.getViewID()));
            evi.setFilter(filter);
            evi.getSelector().add("*");
            evi.getSelector().add("parent.*");
            evi.getSelector().add("group.*");
            BgAccountCollection colls = null;
            try {
                colls = BgAccountFactory.getRemoteInstance().getBgAccountCollection(evi);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
            if (colls == null) {
                return this.existAccounts;
            }
            int size = colls.size();
            if (size > 0) {
                BgAccountInfo info = null;
                for (int i = 0; i < size; ++i) {
                    info = colls.get(i);
                    this.existAccounts.put(info.getNumber(), info);
                    this.existtmpMembers.put(info.getNumber(), info);
                    this.existAccountIds.add(info.getId().toString());
                }
            }
        }
        return this.existAccounts;
    }

    private Set<String> getGroupSet() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("viewId.id", (Object)this.getViewID()));
        filter.getFilterItems().add(new FilterItemInfo("orgunit.id", (Object)this.getOrgUnitId()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"ACG"));
        filter.setMaskString("#0 and #1 or #2");
        evi.setFilter(filter);
        BgAccountGroupCollection colls = null;
        try {
            colls = BgAccountGroupFactory.getRemoteInstance().getBgAccountGroupCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        if (colls != null && colls.size() != 0) {
            this.groupSet = new HashSet<String>();
            this.groupMap = new HashMap<String, BgAccountGroupInfo>();
            for (int i = 0; i < colls.size(); ++i) {
                BgAccountGroupInfo bgAccountGroupInfo = colls.get(i);
                this.groupSet.add(bgAccountGroupInfo.getNumber());
                this.groupMap.put(bgAccountGroupInfo.getNumber(), bgAccountGroupInfo);
            }
        }
        return this.groupSet;
    }

    private void getBgAccountSortColl() {
        if (this.accountSortMapp == null) {
            this.accountSortMapp = new HashMap<String, BgAccountSortInfo>();
            this.accountSortLst = new ArrayList<String>();
            try {
                BgAccountSortCollection coll = BgAccountSortFactory.getRemoteInstance().getBgAccountSortCollection();
                if (coll != null && coll.size() != 0) {
                    for (int i = 0; i < coll.size(); ++i) {
                        BgAccountSortInfo info = coll.get(i);
                        this.accountSortMapp.put(info.getNumber(), info);
                        this.accountSortLst.add(info.getNumber().toString());
                    }
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    @Override
    protected String getTemplateTitle() {
        return EASResource.getString((String)res, (String)"bgAccountImportTemplate");
    }

    protected IBgAccount getBizInteface() throws BOSException {
        return BgAccountFactory.getRemoteInstance();
    }

    private Map<String, List<PropertyRefSourceInfo>> getExistProRefMap() throws BOSException {
        if (this.existProRefMap == null) {
            this.existProRefMap = BgAccountHelper.getPropertyRefMap(this.existAccountIds);
        }
        return this.existProRefMap;
    }
}

