/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.popup.PopupMenuManager;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.client.AbstractBgAccountListF7UI;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.NumberExpendRender;
import com.kingdee.eas.ma.base.utils.BgAccountHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class BgAccountListF7UI
extends AbstractBgAccountListF7UI {
    private static final long serialVersionUID = 1420741767679556469L;
    private static final Logger logger = CoreUIObject.getLogger(BgAccountListF7UI.class);
    protected NumberExpendRender render = new NumberExpendRender(1);
    private boolean isCancel = true;
    private String bgAccountViewID = null;
    private String longNumber = null;
    private String groupId = null;
    private BgAccountCollection result = new BgAccountCollection();

    public boolean isCancel() {
        return this.isCancel;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getLongNumber() {
        return this.longNumber;
    }

    public void setLongNumber(String longNumber) {
        this.longNumber = longNumber;
    }

    public String getBgAccountViewID() {
        return this.bgAccountViewID;
    }

    public void setBgAccountViewID(String bgAccountViewID) {
        this.bgAccountViewID = bgAccountViewID;
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(2);
        if (this.getUIContext().get("bgAccountView.id") != null) {
            this.setBgAccountViewID(this.getUIContext().get("bgAccountView.id").toString());
        }
        if (this.getUIContext().get("longNumber") != null) {
            this.setLongNumber(this.getUIContext().get("longNumber").toString());
        }
        if (this.getUIContext().get("ACCGROUP") != null) {
            this.setGroupId(this.getUIContext().get("ACCGROUP").toString());
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (viewInfo == null) {
            viewInfo = new EntityViewInfo();
        }
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        viewInfo.setFilter(this.getTxtFilter());
        BgCommHelper.addFilterItem(viewInfo.getFilter(), new FilterItemInfo("bgAccountView.id", (Object)this.getBgAccountViewID()));
        if (this.getGroupId() != null) {
            BgCommHelper.addFilterItem(viewInfo.getFilter(), new FilterItemInfo("group.id", (Object)this.getGroupId()));
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    private FilterInfo getTxtFilter() {
        String filterText = this.txtAccountSearch.getText().trim().toString();
        int filterSize = 0;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + filterText + "%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + filterText + "%"), CompareType.LIKE));
        if (filterSize == 0) {
            filter.setMaskString(" (#0 OR #1)");
        } else {
            filter.setMaskString("  ((#" + filterSize + " OR #" + (filterSize + 1) + " ))");
        }
        this.txtAccountSearch.setSelectAllOnFocus(true);
        return filter;
    }

    @Override
    protected void btnAccountSearch_actionPerformed(ActionEvent e) throws Exception {
        this.refreshList();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        this.afterConfirm();
    }

    private void afterConfirm() throws Exception {
        this.checkSelected();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        this.getResult().clear();
        int currRow = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow iRow = this.tblMain.getRow(currRow);
        String id = iRow.getCell("id").getValue().toString();
        try {
            this.getResult().add((BgAccountInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), BgAccountHelper.getAccountSelector()));
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        catch (EASBizException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        this.isCancel = false;
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancle_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancle_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    public void checkSelected() {
        int rowIndex;
        boolean isHided;
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (isHided = this.tblMain.getRow(rowIndex = this.tblMain.getSelectManager().getActiveRowIndex()).getStyleAttributes().isHided()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected BgAccountCollection getResult() {
        return this.result;
    }

    protected BgAccountInfo getResultOne() {
        if (!this.result.isEmpty()) {
            return this.result.get(0);
        }
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgAccountFactory.getRemoteInstance();
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblMain.checkParsed();
        this.tblMain.getColumn("number").setRenderer((IBasicRender)this.render);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            return;
        }
        if (e.getType() == 1) {
            NumberExpandInfo expandInfo;
            IRow row;
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            int clickCount = e.getClickCount();
            if (clickCount == 1 && (row = this.tblMain.getRow(rowIndex)) != null && colIndex == this.tblMain.getColumn("number").getColumnIndex() && this.render.inRect(expandInfo = (NumberExpandInfo)row.getCell("number").getValue(), e.getX(), e.getY())) {
                try {
                    this.setTreeDisplayStyle(row, expandInfo);
                }
                catch (Exception e1) {
                    logger.error((Object)"", (Throwable)e1);
                    this.handUIExceptionAndAbort(e1);
                }
            }
        }
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 2 && e.getType() == 1) {
            this.afterConfirm();
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int start = e.getFirstRow();
                int end = e.getLastRow();
                BgAccountListF7UI.this.setTableDisplayStyle(start, end);
            }
        });
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) throws Exception {
        boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
        if (!isLeaf) {
            this.tblMain.setRefresh(false);
            this.expandTable(row, expandInfo, expandInfo.isExpandStatus());
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo, boolean isExpandStatus) throws Exception {
        int rowIndex;
        if (row == null) {
            return;
        }
        IRow child = null;
        int parentLevel = parentExpandInfo.getLevel();
        String longNumber = null;
        String parentLongNumber = parentExpandInfo.getLongNumber();
        NumberExpandInfo expandInfo = null;
        int rowCount = this.tblMain.getRowCount3();
        if (isExpandStatus) {
            parentExpandInfo.setExpandStatus(false);
            for (rowIndex = row.getRowIndex() + 1; rowIndex < rowCount; ++rowIndex) {
                child = this.tblMain.getRow(rowIndex);
                if (child == null || child.getCell("number") == null) {
                    return;
                }
                expandInfo = (NumberExpandInfo)child.getCell("number").getValue();
                longNumber = expandInfo.getLongNumber();
                if (longNumber.startsWith(parentLongNumber + "!")) {
                    expandInfo.setExpandStatus(false);
                    child.getStyleAttributes().setHided(true);
                    continue;
                }
                break;
            }
        } else {
            parentExpandInfo.setExpandStatus(true);
            while (rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell("number").getValue()).getLongNumber()).startsWith(parentLongNumber + "!")) {
                if (expandInfo.getLevel() - parentLevel == 1) {
                    child.getStyleAttributes().setHided(false);
                    if (!expandInfo.isLeaf()) {
                        expandInfo.setExpandStatus(false);
                    }
                }
                ++rowIndex;
            }
        }
    }

    private void setTableDisplayStyle(int startup, int end) {
        IRow row = null;
        int level = 0;
        Object obj = null;
        NumberExpandInfo expandInfo = null;
        int count = end;
        for (int i = startup; i <= count; ++i) {
            row = this.tblMain.getRow(i);
            if (row == null) continue;
            String id = (String)row.getCell("id").getValue();
            obj = row.getCell("number").getValue();
            if (!(obj instanceof String)) {
                return;
            }
            String number = (String)obj;
            String longNumber = row.getCell("longNumber").getValue().toString();
            level = (Integer)row.getCell("level").getValue();
            boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
            this.hideSelfAndChilds(row, longNumber, this.getLongNumber());
            expandInfo = new NumberExpandInfo();
            expandInfo.setId(id);
            expandInfo.setNumber(number);
            expandInfo.setLongNumber(longNumber);
            expandInfo.setLevel(level);
            expandInfo.setLeaf(isLeaf);
            expandInfo.setExpandStatus(true);
            row.getCell("number").setValue((Object)expandInfo);
        }
    }

    private void hideSelfAndChilds(IRow row, String longNumber, String curMemLongNumber) {
        if (row == null || StringUtils.isEmpty((String)longNumber) || StringUtils.isEmpty((String)curMemLongNumber)) {
            return;
        }
        if (longNumber.equals(curMemLongNumber) || longNumber.startsWith(curMemLongNumber + "!")) {
            row.getStyleAttributes().setHided(true);
        }
    }

    @Override
    protected void txtAccountSearch_focusLost(FocusEvent e) throws Exception {
        super.txtAccountSearch_focusLost(e);
        this.tblMain.removeRows();
        if (StringUtils.isEmpty((String)this.txtAccountSearch.getText())) {
            return;
        }
        this.putDataToKDTable();
    }

    private void putDataToKDTable() {
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
        }
        this.tblMain.removeRows();
        this.mainQuery.setFilter(this.getTxtFilter());
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected boolean isSupportEASPivot() {
        return false;
    }

    public void registerPopupMenuManager(JComponent comp, PopupMenuManager mgr) {
        mgr = new PopupMenuManager();
    }
}

