/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgAccountSortCollection;
import com.kingdee.eas.ma.base.BgAccountSortFactory;
import com.kingdee.eas.ma.base.BgAccountSortInfo;
import com.kingdee.eas.ma.base.IBgAccountSort;
import com.kingdee.eas.ma.base.client.AbstractBgAccountSortF7UI;
import com.kingdee.eas.ma.base.client.BgAccountEditUI;
import com.kingdee.eas.ma.base.client.BgAccountSortEditUI;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BgAccountSortF7UI
extends AbstractBgAccountSortF7UI {
    private static final long serialVersionUID = 1813536452907252602L;
    private static final Logger logger = CoreUIObject.getLogger(BgAccountSortF7UI.class);
    public static final String res = "com.kingdee.eas.ma.base.client.BgAccountSortResource";
    public static final String NUMBER_COLUMN = "number";
    public static final String ID_COLUMN = "id";
    private boolean isCancel = true;
    private BgAccountSortCollection result = new BgAccountSortCollection();

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    protected BgAccountSortInfo getResultOne() {
        if (!this.result.isEmpty()) {
            return this.result.get(0);
        }
        return null;
    }

    protected String getEditUIName() {
        return BgAccountSortEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgAccountSortFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return ID_COLUMN;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.afterConfirm();
        }
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        this.refreshList();
    }

    @Override
    protected void kDSearch_focusLost(FocusEvent e) throws Exception {
        super.kDSearch_focusLost(e);
        this.refreshList();
    }

    @Override
    protected void btnCancle_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancle_actionPerformed(e);
        this.isCancel = true;
        this.removeNotExistAccountSort();
        this.getUIWindow().close();
    }

    private void removeNotExistAccountSort() throws EASBizException, BOSException, Exception {
        if ((UINewFrame)this.getUIContext().get("Owner") == null) {
            return;
        }
        IUIObject uiObject = ((UINewFrame)this.getUIContext().get("Owner")).getUIObject();
        if (uiObject != null && uiObject instanceof BgAccountEditUI) {
            Object _accountSort = ((BgAccountEditUI)uiObject).prmtBgAccountSort.getData();
            boolean isExist = true;
            if (_accountSort != null && _accountSort instanceof BgAccountSortInfo) {
                ObjectUuidPK pk = new ObjectUuidPK(((BgAccountSortInfo)_accountSort).getId());
                isExist = this.getBizInterface().exists((IObjectPK)pk);
            }
            if (!isExist) {
                ((BgAccountEditUI)uiObject).prmtBgAccountSort.setData(null);
            }
        }
    }

    private void afterConfirm() throws Exception {
        this.checkSelected();
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        this.getResult().clear();
        int currRow = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow iRow = this.tblMain.getRow(currRow);
        String id = iRow.getCell(ID_COLUMN).getValue().toString();
        try {
            IBgAccountSort iElement = BgAccountSortFactory.getRemoteInstance();
            this.getResult().add((BgAccountSortInfo)iElement.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id))));
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        catch (EASBizException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        this.isCancel = false;
        this.getUIWindow().close();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec;
        if ((viewInfo = viewInfo == null ? new EntityViewInfo() : (EntityViewInfo)viewInfo.clone()).getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        int filterSize = viewInfo.getFilter().getFilterItems().size();
        String filterText = this.kDSearch.getText().trim().toString();
        if (!StringUtils.isEmpty((String)filterText)) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo(NUMBER_COLUMN, (Object)("%" + filterText + "%"), CompareType.LIKE));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("name", (Object)("%" + filterText + "%"), CompareType.LIKE));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("description", (Object)("%" + filterText + "%"), CompareType.LIKE));
            if (filterSize == 0) {
                viewInfo.getFilter().setMaskString(" #0 OR #1 OR #2");
            } else {
                viewInfo.getFilter().setMaskString("  (#" + filterSize + " OR #" + (filterSize + 1) + " OR #" + (filterSize + 2) + " )");
            }
            this.kDSearch.setSelectAllOnFocus(true);
        }
        if ((exec = super.getQueryExecutor(queryPK, viewInfo)) != null && exec.option() != null) {
            exec.option().isAutoIgnoreZero = false;
        }
        return exec;
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        this.afterConfirm();
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.mainQueryPK != null) {
            int start = (Integer)e.getParam1();
            int length = (Integer)e.getParam2() - start + 1;
            try {
                IQueryExecutor exec = this.getQueryExecutor(this.mainQueryPK, this.mainQuery);
                IRowSet rowSet = exec.executeQuery(start, length);
                e.setRowSet(rowSet);
                this.onGetRowSet(rowSet);
            }
            catch (Exception ee) {
                this.handUIException(ee);
            }
        }
    }

    public void handUIException(Throwable exc) {
        if (exc != null && CanNotDeleteException.class.getName().equals(exc.getClass().getName())) {
            MsgBox.showError((Component)((Object)this), (String)exc.getCause().getMessage());
        } else {
            super.handUIException(exc);
        }
    }

    protected BgAccountSortCollection getResult() {
        return this.result;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int re = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)res, (String)"confirmDelete"));
        if (re == 1 || re == 2) {
            return;
        }
        ArrayList removeIds = new ArrayList();
        ArrayList idLst = this.getSelectedIdValues();
        ArrayList refLst = (ArrayList)BgAccountSortFactory.getRemoteInstance().getRefIDs(idLst);
        if (idLst != null && idLst.size() > 0) {
            for (int i = 0; i < idLst.size(); ++i) {
                if (refLst.contains(idLst.get(i))) continue;
                removeIds.add(idLst.get(i));
            }
        }
        if (idLst != null && removeIds.size() == idLst.size()) {
            MsgBox.showInfo((String)EASResource.getString((String)res, (String)"removeSuc"));
        } else {
            this.forbidRemoveRefAccountSort(idLst, refLst);
        }
        if (removeIds != null && removeIds.size() > 0) {
            ObjectUuidPK[] pks = new ObjectUuidPK[removeIds.size()];
            for (int i = 0; i < removeIds.size(); ++i) {
                pks[i] = new ObjectUuidPK((String)removeIds.get(i));
            }
            BgAccountSortFactory.getRemoteInstance().deleteBatchData((IObjectPK[])pks);
        }
        this.refreshList();
    }

    private void forbidRemoveRefAccountSort(ArrayList<String> idLst, ArrayList<String> refLst) throws EASBizException, BOSException {
        ArrayList<String> selectedList = this.getSelectedNumbers();
        HashMap<String, String> map = this.getIdAndNumberMap();
        ArrayList<String> numLst = new ArrayList<String>();
        if (refLst != null && refLst.size() > 0) {
            for (int i = 0; i < refLst.size(); ++i) {
                numLst.add(map.get(refLst.get(i)));
            }
        }
        if (numLst != null) {
            this.showMsg(idLst, numLst);
        }
    }

    private void showMsg(ArrayList<String> listAll, ArrayList<String> list) {
        StringBuffer str = null;
        StringBuffer msg = new StringBuffer();
        String arr = null;
        if (!list.isEmpty()) {
            if (msg.length() > 0) {
                msg.append("\r\n");
            }
            str = new StringBuffer();
            int in = list.size();
            for (int i = 0; i < in; ++i) {
                arr = list.get(i).toString();
                str.append(arr + ", ");
            }
            str.delete(str.length() - 2, str.length());
            msg.append(EASResource.getString((String)res, (String)"removeFailDetail", (Object[])new String[]{str.toString()}));
        }
        MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)res, (String)"removeFail", (Object[])new String[]{String.valueOf(listAll.size()), String.valueOf(list.size())}), (String)msg.toString(), (int)1);
    }

    private ArrayList<String> getSelectedNumbers() {
        ArrayList<String> list = new ArrayList<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            list.add(this.tblMain.getRow(selectRows[i]).getCell(NUMBER_COLUMN).getValue().toString());
        }
        return list;
    }

    private HashMap<String, String> getIdAndNumberMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            String id = this.tblMain.getRow(selectRows[i]).getCell(ID_COLUMN).getValue().toString();
            String number = this.tblMain.getRow(selectRows[i]).getCell(NUMBER_COLUMN).getValue().toString();
            map.put(id, number);
        }
        return map;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO) != null) {
            return new ObjectUuidPK(((OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO)).getId());
        }
        return super.getOrgPK(action);
    }
}

