/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.Account_ControlCollection;
import com.kingdee.eas.basedata.master.account.Account_ControlFactory;
import com.kingdee.eas.basedata.master.account.Account_ControlInfo;
import com.kingdee.eas.basedata.master.account.IAccountTable;
import com.kingdee.eas.basedata.master.account.IAccount_Control;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.ma.base.BgAccountDataTypeEnum;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountGroupInfo;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgAccountViewInfo;
import com.kingdee.eas.ma.base.BgDecreditAlgorithmEnum;
import com.kingdee.eas.ma.base.BgDimSourceCollection;
import com.kingdee.eas.ma.base.BgDimSourceFactory;
import com.kingdee.eas.ma.base.BgDimSourceInfo;
import com.kingdee.eas.ma.base.BgImportSourceEnum;
import com.kingdee.eas.ma.base.BgPeriodSumEnum;
import com.kingdee.eas.ma.base.BgUpperGatherEnum;
import com.kingdee.eas.ma.base.IBgAccount;
import com.kingdee.eas.ma.base.IBgDimSource;
import com.kingdee.eas.ma.base.client.AbstractBgAccountSysImportUI;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.utils.BgAccountHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.ma.base.utils.OrgUnitUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAccountSysImportUI
extends AbstractBgAccountSysImportUI {
    private static final long serialVersionUID = -2383251976403278563L;
    private static final Logger logger = CoreUIObject.getLogger(BgAccountSysImportUI.class);
    private boolean isNeedCheckRf = true;
    private HashSet<String> refDataIds = null;
    private HashSet<String> rightIDSet = new HashSet();
    private TreeBaseCollection bizColls = null;
    private TreeBaseCollection rightAccountColls = null;
    private TreeBaseCollection rightAllAccountColls = null;
    private HashMap<String, BgAccountInfo> addAccountMap = new HashMap();

    public TreeBaseCollection getBizColls() {
        return this.bizColls;
    }

    public TreeBaseCollection getRightAccountColls() {
        return this.rightAccountColls;
    }

    public TreeBaseCollection getRightALLAccountColls() {
        return this.rightAccountColls;
    }

    public HashMap<String, BgAccountInfo> getAddAccountColls() {
        return this.addAccountMap;
    }

    @Override
    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblRight.checkParsed();
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblRight.getSelectManager().setSelectMode(2);
        this.prmtSourceMember.setRequired(true);
        this.prmtCostCenter.setEditable(false);
    }

    @Override
    protected void init() {
        super.init();
        this.kDCBSource.setEditable(false);
        this.kDCBSource.setEnabled(false);
        this.kDCBSource.addItem((Object)BgImportSourceEnum.systemData);
        this.initTblRight();
        this.enableKdCheckOrg(false);
        this.initPrmtSourceMember();
        this.initKDAccountList();
        this.initDefaultSourceMember();
        this.initGroupF7();
    }

    private void initGroupF7() {
        Object view = this.getUIContext().get("viewInfo");
        Object groupObject = this.getUIContext().get("ACCGROUP");
        if (view != null && view instanceof BgAccountViewInfo) {
            BgAccountGroupInfo group = (BgAccountGroupInfo)groupObject;
            this.prmtGroup.setQueryInfo("com.kingdee.eas.ma.base.BgAccountGroupQuery");
            this.prmtGroup.setEditFormat("$number$");
            this.prmtGroup.setDisplayFormat("$name$");
            this.prmtGroup.setCommitFormat("$name$");
            this.prmtGroup.setEditable(false);
            EntityViewInfo evi = this.prmtGroup.getEntityViewInfo();
            if (evi == null) {
                evi = new EntityViewInfo();
                evi.setFilter(new FilterInfo());
            }
            evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId.id", (Object)((BgAccountViewInfo)view).getId().toString(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)"ACG", CompareType.EQUALS));
            evi.getFilter().setMaskString("#0 or #1");
            this.prmtGroup.setEntityViewInfo(evi);
            this.prmtGroup.getQueryAgent().resetRuntimeEntityView();
            if (groupObject instanceof BgAccountGroupInfo) {
                this.prmtGroup.setData((Object)group);
            }
        }
    }

    private void initDefaultSourceMember() {
        if (this.getDefaultTableName() != null) {
            try {
                BgDimSourceCollection sources = BgDimSourceFactory.getRemoteInstance().getBgDimSourceCollection("where bizTable = '" + this.getDefaultTableName() + "'");
                if (sources != null && !sources.isEmpty()) {
                    this.prmtSourceMember.setData((Object)sources.get(0));
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected IObjectValue getRowUserObject(IRow row) {
        return (BgAccountInfo)row.getUserObject();
    }

    protected void initTblRight() {
        Object view = this.getUIContext().get("viewInfo");
        Object groupObject = this.getUIContext().get("ACCGROUP");
        if (view != null && view instanceof BgAccountViewInfo && groupObject instanceof BgAccountGroupInfo) {
            try {
                BgAccountGroupInfo group = (BgAccountGroupInfo)groupObject;
                this.prmtGroup.setDataNoNotify((Object)group);
                this.rightAccountColls = this.getAccountInterface().getTreeBaseCollection("where bgAccountView.id = '" + ((BgAccountViewInfo)view).getId().toString() + "'  and group.id ='" + group.getId().toString() + "' order by longNumber ASC");
                this.rightAllAccountColls = this.getAccountInterface().getTreeBaseCollection("where bgAccountView.id = '" + ((BgAccountViewInfo)view).getId().toString() + "'  order by longNumber ASC");
                this.parseRightCol();
                this.putDataToTable(this.rightAccountColls, this.tblRight, false);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    private void excuteAction(KDWorkButton btnComn) {
        ActionEvent evt = new ActionEvent(btnComn, 0, "Clicked");
        ItemAction act = this.getActionFromActionEvent(evt);
        act.actionPerformed(evt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void prmtGroup_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtGroup_dataChanged(e);
        Object newValue = e.getNewValue();
        Object oldValue = e.getOldValue();
        if (oldValue != null && newValue == null) {
            this.prmtGroup.setDataNoNotify(oldValue);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"groupNotNull"));
            SysUtil.abort();
            return;
        }
        if (newValue.equals(oldValue) || !(newValue instanceof BgAccountGroupInfo)) return;
        if (!this.getAddAccountColls().isEmpty()) {
            int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"isSave4Update"));
            if (result == 0) {
                this.prmtGroup.setDataNoNotify(oldValue);
                this.excuteAction(this.btnSave);
                this.prmtGroup.setDataNoNotify(newValue);
                this.prmtSourceMember.setData(this.prmtSourceMember.getData());
                BgAccountGroupInfo group = (BgAccountGroupInfo)newValue;
                Object view = this.getUIContext().get("viewInfo");
                if (!(view instanceof BgAccountViewInfo)) return;
                try {
                    this.rightAccountColls = this.getAccountInterface().getTreeBaseCollection("where bgAccountView.id = '" + ((BgAccountViewInfo)view).getId().toString() + "'  and group.id ='" + group.getId().toString() + "' order by longNumber ASC");
                    this.parseRightCol();
                    this.putDataToTable(this.rightAccountColls, this.tblRight, false);
                    return;
                }
                catch (BOSException e1) {
                    this.handUIException(e1);
                }
                return;
            }
            this.prmtGroup.setDataNoNotify(oldValue);
            return;
        }
        BgAccountGroupInfo group = (BgAccountGroupInfo)newValue;
        Object view = this.getUIContext().get("viewInfo");
        if (!(view instanceof BgAccountViewInfo)) return;
        try {
            this.rightAccountColls = this.getAccountInterface().getTreeBaseCollection("where bgAccountView.id = '" + ((BgAccountViewInfo)view).getId().toString() + "'  and group.id ='" + group.getId().toString() + "' order by longNumber ASC");
            this.parseRightCol();
            this.putDataToTable(this.rightAccountColls, this.tblRight, false);
            return;
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
    }

    public void parseRightCol() {
        int i;
        this.rightMap.clear();
        TreeBaseInfo info = null;
        if (this.rightAccountColls != null && !this.rightAccountColls.isEmpty()) {
            for (i = 0; i < this.rightAccountColls.size(); ++i) {
                info = this.rightAccountColls.get(i);
                this.rightMap.put(info.getLongNumber(), (BgAccountInfo)info);
                if (!this.rightNumSet.contains(info.getNumber())) {
                    this.rightNumSet.add(info.getNumber());
                }
                this.rightIDSet.add(info.getId().toString());
            }
        }
        if (this.rightAllAccountColls != null && !this.rightAllAccountColls.isEmpty()) {
            for (i = 0; i < this.rightAllAccountColls.size(); ++i) {
                info = this.rightAllAccountColls.get(i);
                if (this.rightNumSet.contains(info.getNumber())) continue;
                this.rightNumSet.add(info.getNumber());
            }
        }
    }

    protected void initPrmtSourceMember() {
        this.prmtSourceMember.setMyCommonUseEnabled(false);
        this.prmtSourceMember.setQueryInfo("com.kingdee.eas.ma.base.BgAccountSourceQuery");
        this.prmtSourceMember.setEditFormat("$bizName$");
        this.prmtSourceMember.setDisplayFormat("$bizName$");
        this.prmtSourceMember.setCommitFormat("$bizName$");
        this.prmtSourceMember.setEditable(false);
        Set<String> tableNames = this.getTableNames();
        if (tableNames != null && !tableNames.isEmpty()) {
            EntityViewInfo evi = this.prmtSourceMember.getEntityViewInfo();
            if (evi == null) {
                evi = new EntityViewInfo();
                evi.setFilter(new FilterInfo());
            }
            BgCommHelper.addFilterItem(evi.getFilter(), new FilterItemInfo("bizTable", tableNames, CompareType.INCLUDE));
            this.prmtSourceMember.setEntityViewInfo(evi);
        }
    }

    protected String getDefaultTableName() {
        return null;
    }

    protected Set<String> getTableNames() {
        return null;
    }

    private void initKDAccountList() {
        this.kDCBAccountList.setEditable(false);
        this.enablekDCBAccountList(false);
        this.kDCBAccountList.removeAllItems();
        this.kdCheckOrg.setSelected(false);
        if (this.prmtSourceMember.getData() != null) {
            if (!this.kdCheckOrg.isSelected()) {
                this.getATColls(this.getUnitInfo());
            } else {
                this.enablekDCBAccountList(false);
                if (this.kDCBAccountList.getItemCount() > 0) {
                    this.kDCBAccountList.setSelectedIndex(0);
                }
            }
        }
    }

    @Override
    protected void prmtSourceMember_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtSourceMember_dataChanged(e);
        this.enablekDCBAccountList(false);
        this.kDCBAccountList.removeAllItems();
        this.enableKdCheckOrg(false);
        this.kdCheckOrg.setSelected(false);
        this.getAddAccountColls().clear();
        this.putDataToTable(this.rightAccountColls, this.tblRight, false);
        if (e.getNewValue() instanceof BgDimSourceInfo) {
            BgDimSourceInfo info = (BgDimSourceInfo)e.getNewValue();
            if (info.getBizTable().equalsIgnoreCase("T_BD_AccountView")) {
                this.tblMain.removeRows();
                this.accountChange();
            } else {
                this.tblMain.removeRows();
                this.bizColls = (TreeBaseCollection)this.getBizInterface().getBizCollection(info.getId().toString(), null, this.getUnitInfo());
                this.leftMap.clear();
                if (this.bizColls != null && !this.bizColls.isEmpty()) {
                    for (int i = 0; i < this.bizColls.size(); ++i) {
                        this.leftMap.put(this.bizColls.get(i).getLongNumber(), (BgAccountInfo)this.bizColls.get(i));
                    }
                }
                this.putDataToTable(this.bizColls, this.tblMain, true);
            }
        } else {
            this.tblMain.removeRows();
        }
    }

    private void accountChange() {
        this.enablekDCBAccountList(true);
        this.kdCheckOrg.setSelected(false);
        this.enableKdCheckOrg(true);
        if (!this.kdCheckOrg.isSelected()) {
            this.getATColls(this.getUnitInfo());
        } else {
            this.enablekDCBAccountList(false);
            if (this.kDCBAccountList.getItemCount() > 0) {
                this.kDCBAccountList.setSelectedIndex(0);
            }
        }
    }

    private void getATColls(CostCenterOrgUnitInfo cost) {
        if (cost == null || cost.getId() == null) {
            return;
        }
        try {
            CompanyOrgUnitInfo company = OrgUnitUtils.getCompanyOrgUnit(null, (IObjectValue)cost);
            if (company == null) {
                return;
            }
            ArrayList<String> tableIdList = new ArrayList<String>();
            IAccount_Control acctCtrl = Account_ControlFactory.getRemoteInstance();
            EntityViewInfo eviForCtrl = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)company.getId().toString()));
            eviForCtrl.setFilter(filter);
            eviForCtrl.getSelector().add("accountTableID.id");
            Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(eviForCtrl);
            if (acctCtrlCols != null) {
                int count = acctCtrlCols.size();
                for (int i = 0; i < count; ++i) {
                    Account_ControlInfo acctCtrlInfo = acctCtrlCols.get(i);
                    tableIdList.add(acctCtrlInfo.getAccountTableID().getId().toString());
                }
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("*"));
            evi.getSelector().add(new SelectorItemInfo("userLevel.*"));
            IAccountTable iAccountTable = AccountTableFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
            AccountTableCollection tableInfos = iAccountTable.getAccountTableCollection(evi);
            Iterator ter = tableInfos.iterator();
            this.kDCBAccountList.removeAllItems();
            this.kDCBAccountList.addItem((Object)"");
            while (ter.hasNext()) {
                AccountTableInfo tableInfo = (AccountTableInfo)ter.next();
                if (!tableIdList.contains(tableInfo.getId().toString())) continue;
                this.kDCBAccountList.addItem((Object)tableInfo);
                if (this.kDCBAccountList.getItemCount() <= 0) continue;
                this.kDCBAccountList.setSelectedIndex(0);
            }
        }
        catch (BOSException e1) {
            this.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        catch (EASBizException e2) {
            this.handUIExceptionAndAbort((Exception)((Object)e2));
        }
    }

    @Override
    protected void kDCBAccountList_itemStateChanged(ItemEvent e) throws Exception {
        super.kDCBAccountList_itemStateChanged(e);
        if (e.getStateChange() == 1) {
            return;
        }
        if (this.kDCBAccountList.getSelectedItem() instanceof AccountTableInfo && this.getBgASInfo() != null) {
            AccountTableInfo atinfo = (AccountTableInfo)this.kDCBAccountList.getSelectedItem();
            BgDimSourceInfo sourceInfo = this.getBgASInfo();
            this.bizColls = (TreeBaseCollection)this.getBizInterface().getBizCollection(sourceInfo.getId().toString(), atinfo.getId().toString(), this.getUnitInfo());
            this.leftMap.clear();
            if (this.bizColls != null && !this.bizColls.isEmpty()) {
                for (int i = 0; i < this.bizColls.size(); ++i) {
                    this.leftMap.put(this.bizColls.get(i).getLongNumber(), (BgAccountInfo)this.bizColls.get(i));
                }
            }
            this.putDataToTable(this.bizColls, this.tblMain, true);
        } else {
            this.tblMain.removeRows();
        }
    }

    @Override
    protected void prmtCostCenter_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCostCenter_dataChanged(e);
        Object oldValue = e.getOldValue();
        Object newValue = e.getNewValue();
        if ((oldValue == null && newValue != null || oldValue != null && newValue != null && !oldValue.equals(newValue)) && this.getBgASInfo() != null && this.getBgASInfo().getBizTable().equalsIgnoreCase("T_BD_AccountView")) {
            this.getATColls((CostCenterOrgUnitInfo)newValue);
        }
        this.selectData();
    }

    @Override
    protected void kDCBAccountList_actionPerformed(ActionEvent e) throws Exception {
        super.kDCBAccountList_actionPerformed(e);
    }

    private void enablekDCBAccountList(Boolean enable) {
        this.kDCBAccountList.setEnabled(enable.booleanValue());
    }

    private void enableKdCheckOrg(Boolean enable) {
        this.kdCheckOrg.setEditable(enable.booleanValue());
        this.kdCheckOrg.setEnabled(enable.booleanValue());
    }

    @Override
    protected void kdCheckOrg_itemStateChanged(ItemEvent e) throws Exception {
        super.kdCheckOrg_itemStateChanged(e);
        this.selectData();
    }

    protected void selectData() throws BOSException, EASBizException {
        if (this.kdCheckOrg.isSelected()) {
            this.enablekDCBAccountList(false);
            BgDimSourceInfo sourceInfo = this.getBgASInfo();
            this.bizColls = (TreeBaseCollection)this.getBizInterface().getBizCollection(sourceInfo.getId().toString(), null, this.getUnitInfo());
            this.leftMap.clear();
            if (this.bizColls != null && !this.bizColls.isEmpty()) {
                for (int i = 0; i < this.bizColls.size(); ++i) {
                    this.leftMap.put(this.bizColls.get(i).getLongNumber(), (BgAccountInfo)this.bizColls.get(i));
                }
            }
            if (this.kDCBAccountList.getItemCount() > 0) {
                this.kDCBAccountList.setSelectedIndex(0);
            }
            this.putDataToTable(this.bizColls, this.tblMain, true);
        } else {
            this.tblMain.removeRows();
            if (this.getBgASInfo() != null && this.getBgASInfo().getBizTable().equalsIgnoreCase("T_BD_AccountView")) {
                this.enablekDCBAccountList(true);
                if (this.kDCBAccountList.getItemCount() > 0) {
                    this.kDCBAccountList.setSelectedIndex(0);
                }
            } else {
                this.enablekDCBAccountList(false);
                this.kDCBAccountList.removeAllItems();
                BgDimSourceInfo sourceInfo = this.getBgASInfo();
                if (sourceInfo != null) {
                    this.bizColls = (TreeBaseCollection)this.getBizInterface().getBizCollection(sourceInfo.getId().toString(), null, this.getUnitInfo());
                    this.leftMap.clear();
                    if (this.bizColls != null && !this.bizColls.isEmpty()) {
                        for (int i = 0; i < this.bizColls.size(); ++i) {
                            this.leftMap.put(this.bizColls.get(i).getLongNumber(), (BgAccountInfo)this.bizColls.get(i));
                        }
                    }
                    if (this.kDCBAccountList.getItemCount() > 0) {
                        this.kDCBAccountList.setSelectedIndex(0);
                    }
                    this.putDataToTable(this.bizColls, this.tblMain, true);
                }
            }
        }
    }

    @Override
    protected void kdCheckOrg_actionPerformed(ActionEvent e) throws Exception {
        super.kdCheckOrg_actionPerformed(e);
    }

    private void putDataToTable(TreeBaseCollection bizColls, KDTable table, boolean isLeftTable) {
        table.removeRows();
        if (bizColls == null || bizColls.isEmpty()) {
            return;
        }
        IRow row = null;
        BgAccountInfo bgAccountInfo = null;
        NumberExpandInfo numberExpandInfo = null;
        boolean isAllAccount = false;
        if (this.kdCheckOrg.isSelected() && isLeftTable) {
            isAllAccount = true;
        }
        HashSet<String> isNotLeaf = new HashSet<String>();
        if (!isAllAccount) {
            String[] lns = null;
            int size = bizColls.size();
            for (int index = 0; index < size; ++index) {
                bgAccountInfo = (BgAccountInfo)bizColls.get(index);
                lns = bgAccountInfo.getLongNumber().split("!");
                for (int l = 0; l < lns.length - 1; ++l) {
                    isNotLeaf.add(lns[l]);
                }
            }
        }
        int size = bizColls.size();
        for (int index = 0; index < size; ++index) {
            bgAccountInfo = (BgAccountInfo)bizColls.get(index);
            if (!isAllAccount) {
                bgAccountInfo.setIsLeaf(!isNotLeaf.contains(bgAccountInfo.getNumber()));
            }
            row = table.addRow();
            row.getCell("id").setValue((Object)bgAccountInfo.getId().toString());
            row.getCell("number").setValue((Object)bgAccountInfo.getNumber());
            row.getCell("name").setValue((Object)bgAccountInfo.getName());
            row.getCell("longNumber").setValue((Object)bgAccountInfo.getLongNumber());
            row.getCell("isLeaf").setValue((Object)bgAccountInfo.isIsLeaf());
            row.getCell("level").setValue((Object)bgAccountInfo.getLevel());
            row.getCell("displayName").setValue((Object)bgAccountInfo.getDisplayName());
            row.getCell("parent").setValue((Object)this.getParentInfo(bgAccountInfo.getLongNumber(), isLeftTable ? this.leftMap : this.rightMap));
            bgAccountInfo.setParent((BgAccountInfo)this.getParentInfo(bgAccountInfo.getLongNumber(), isLeftTable ? this.leftMap : this.rightMap));
            row.setUserObject((Object)bgAccountInfo);
            numberExpandInfo = new NumberExpandInfo();
            numberExpandInfo.setName(bgAccountInfo.getNumber());
            numberExpandInfo.setNumber(bgAccountInfo.getNumber());
            numberExpandInfo.setLongNumber(bgAccountInfo.getLongNumber());
            numberExpandInfo.setLevel(bgAccountInfo.getLevel());
            numberExpandInfo.setLeaf(bgAccountInfo.isIsLeaf());
            numberExpandInfo.setExpandStatus(true);
            row.getCell("number").setValue((Object)numberExpandInfo);
            this.disableColorExistMember(row);
        }
    }

    private void disableColorExistMember(IRow row) {
        if (row == null) {
            return;
        }
        Color disableColor = new Color(230, 230, 230);
        if (this.rightNumSet.contains(row.getCell("number").getValue().toString())) {
            row.getStyleAttributes().setBackground(disableColor);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        Object data = this.prmtGroup.getData();
        if (data == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"groupNotNull"));
            return;
        }
        HashSet<String> repeatNumSet = new HashSet<String>();
        HashSet<String> numSet = new HashSet<String>();
        String accNumber = null;
        CoreBaseCollection colls = new CoreBaseCollection();
        BgAccountInfo info = null;
        IRow row = null;
        int rightCount = this.tblRight.getRowCount();
        HashMap<String, BgAccountInfo> newAccountMap = new HashMap<String, BgAccountInfo>();
        for (int index = 0; index < rightCount; ++index) {
            row = this.tblRight.getRow(index);
            info = new BgAccountInfo();
            info.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            row.getStyleAttributes().setBackground(new Color(230, 230, 230));
            accNumber = row.getCell("number").getValue().toString();
            if (!numSet.contains(accNumber)) {
                numSet.add(accNumber);
            } else {
                repeatNumSet.add(accNumber);
            }
            info.setNumber(accNumber);
            info.setName((String)row.getCell("name").getValue());
            info.setLongNumber(row.getCell("longNumber").getValue().toString());
            info.setLevel(Integer.valueOf(row.getCell("level").getValue().toString()));
            info.setIsLeaf((Boolean)row.getCell("isLeaf").getValue());
            info.setParent((BgAccountInfo)row.getCell("parent").getValue());
            info.setGroup(data instanceof BgAccountGroupInfo ? (BgAccountGroupInfo)data : null);
            if (info.getParent() != null && newAccountMap.containsKey(info.getParent().getNumber())) {
                info.setParent((BgAccountInfo)newAccountMap.get(info.getParent().getNumber()));
            } else if (info.getNumber().equals(info.getLongNumber())) {
                info.setParent(null);
            }
            info.setBgAccountView((BgAccountViewInfo)this.getUIContext().get("viewInfo"));
            info.setDisplayName(row.getCell("displayName").getValue() != null ? row.getCell("displayName").getValue().toString() : (String)row.getCell("name").getValue());
            if (!this.rightMap.containsKey(info.getLongNumber())) {
                info.setIsEnabled(true);
            }
            BgAccountHelper.setCancelDate(info);
            if (!this.rightMap.containsKey(info.getLongNumber())) {
                this.beforeSave(info);
                colls.add((CoreBaseInfo)info);
                newAccountMap.put(info.getNumber(), info);
                this.rightAccountColls.add((TreeBaseInfo)info);
                continue;
            }
            if (!this.rightMap.containsKey(info.getLongNumber()) || String.valueOf(info.isIsLeaf()).equals(String.valueOf(((BgAccountInfo)row.getUserObject()).isIsLeaf()))) continue;
            colls.add((CoreBaseInfo)info);
        }
        BgAccountHelper.checkNumRepeat(repeatNumSet);
        if (!colls.isEmpty()) {
            if (this.rightNumSet != null && !this.rightNumSet.isEmpty()) {
                this.rightNumSet.clear();
            }
            for (int i = 0; i < colls.size(); ++i) {
                this.rightNumSet.add(((BgAccountInfo)colls.get(i)).getNumber());
            }
            this.getAccountInterface().sysImportData((IObjectCollection)colls);
            this.getAddAccountColls().clear();
            this.parseRightCol();
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"simpleSaveSuccess"));
            this.showMessage();
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"please_choose_accouns"));
        }
    }

    private void beforeSave(BgAccountInfo info) throws EASBizException, BOSException {
        info.setPolAlgorithm(BgUpperGatherEnum.add);
        info.setPeriodAlgorithm(BgPeriodSumEnum.sum);
        info.setBgAccountDataType(BgAccountDataTypeEnum.CURRENCY);
        info.setBgDecreditAlgorithm(BgDecreditAlgorithmEnum.CREDEDIT);
        Object obj = this.getUIContext().get("unitInfo");
        if (obj != null && obj instanceof CostCenterOrgUnitInfo) {
            info.setOrgUnit((CostCenterOrgUnitInfo)obj);
        } else if (obj != null && obj instanceof FullOrgUnitInfo) {
            BOSUuid id = ((FullOrgUnitInfo)obj).getId();
            info.setOrgUnit(CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(id)));
        } else {
            this.setUnitInfo(SysContext.getSysContext().getCurrentCostUnit());
        }
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        int acticeRowIndex = this.tblRight.getSelectManager().getActiveRowIndex();
        if (this.tblRight.getRowCount() == 0 || acticeRowIndex < 0) {
            return;
        }
        BgAccountInfo info = (BgAccountInfo)this.tblRight.getRow(acticeRowIndex).getUserObject();
        if (!this.getAddAccountColls().containsKey(info.getNumber())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"isOnlyRemoveSelected"));
            SysUtil.abort();
        }
        Object parentInfo = this.tblRight.getRow(acticeRowIndex).getCell("parent").getValue();
        Set numberSet = this.leftMap.keySet();
        HashSet<String> trimNumberSet = new HashSet<String>();
        Iterator iter = numberSet.iterator();
        while (iter.hasNext()) {
            String longNumber = BgNumberHelper.trimNumber((String)iter.next());
            trimNumberSet.add(longNumber);
        }
        String longnumber = (String)this.tblRight.getCell(acticeRowIndex, "longNumber").getValue();
        if (longnumber == null) {
            longnumber = info.getNumber();
        }
        if (trimNumberSet.contains(info.getLongNumber()) && this.getAddAccountColls().containsKey(info.getNumber())) {
            this.tblRight.removeRow(acticeRowIndex);
            this.getAddAccountColls().remove(info.getNumber());
            this.rightNumSet.remove(info.getNumber());
        }
        String childLongNumber = null;
        for (int r = this.tblRight.getRowCount() - 1; r >= 0; --r) {
            BgAccountInfo childInfo = (BgAccountInfo)this.tblRight.getRow(r).getUserObject();
            childLongNumber = (String)this.tblRight.getCell(r, "longNumber").getValue();
            if (childLongNumber == null || !childLongNumber.startsWith(longnumber + "!")) continue;
            this.tblRight.removeRow(r);
            this.getAddAccountColls().remove(childInfo.getNumber());
            this.rightNumSet.remove(childInfo.getNumber());
        }
        if (parentInfo != null) {
            this.afterDeleteRow(info, (BgAccountInfo)parentInfo);
        }
    }

    private void afterDeleteRow(BgAccountInfo info, BgAccountInfo parentInfo) {
        Boolean isParentIsLeaf = true;
        String parentNum = parentInfo.getNumber();
        String parentLongNum = parentInfo.getLongNumber();
        Object var6_6 = null;
        for (TreeBaseInfo treeBaseInfo : this.getAddAccountColls().values()) {
            if (!treeBaseInfo.getLongNumber().startsWith(parentLongNum + "!")) continue;
            isParentIsLeaf = false;
            break;
        }
        if (this.rightMap.containsKey(parentLongNum)) {
            for (TreeBaseInfo treeBaseInfo : this.rightMap.values()) {
                if (!treeBaseInfo.getLongNumber().startsWith(parentLongNum + "!")) continue;
                isParentIsLeaf = false;
                break;
            }
        }
        if (isParentIsLeaf.booleanValue()) {
            IRow row = null;
            String rowNum = null;
            int in = this.tblRight.getRowCount();
            for (int i = 0; i < in; ++i) {
                row = this.tblRight.getRow(i);
                rowNum = row.getCell("number").getValue().toString();
                if (!rowNum.equals(parentNum)) continue;
                row.getCell("isLeaf").setValue((Object)true);
                Object obj = row.getCell("number").getValue();
                if (!(obj instanceof NumberExpandInfo)) break;
                ((NumberExpandInfo)obj).setLeaf(true);
                row.getCell("number").setValue(obj);
                break;
            }
        }
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteAll_actionPerformed(e);
        if (!this.getAddAccountColls().isEmpty() && this.rightAccountColls != null && !this.rightAccountColls.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"isOnlyRemoveSelected"));
        }
        this.actionDeleteAll_actionPerformed();
    }

    protected void actionDeleteAll_actionPerformed() {
        this.tblRight.removeRows();
        this.putDataToTable(this.rightAccountColls, this.tblRight, false);
        this.getAddAccountColls().clear();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        this.checkRepeat();
        if (!this.getAddAccountColls().isEmpty()) {
            this.actionDeleteAll_actionPerformed();
        }
        this.selectAll_Action();
    }

    @Override
    public void actionSelect_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelect_actionPerformed(e);
        this.select_Action();
    }

    private void select_Action() throws EASBizException, BOSException {
        int leftCount = this.tblMain.getRowCount();
        int rightCount = this.tblRight.getRowCount();
        HashSet<String> vSet = this.verifySelects();
        StringBuffer sb = new StringBuffer();
        if (!vSet.isEmpty()) {
            for (String st : vSet) {
                sb.append(st + ",");
            }
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"noParent_chooseAgain", (Object[])new Object[]{sb, this.toString()}));
            SysUtil.abort();
        }
        BgAccountInfo leftInfo = null;
        BgAccountInfo rightInfo = null;
        IRow newRow = null;
        IRow sRow = null;
        int acticeRowIndex = this.tblRight.getSelectManager().getActiveRowIndex();
        if (acticeRowIndex >= 0) {
            sRow = this.tblRight.getRow(acticeRowIndex);
        }
        boolean isRightNull = false;
        if (rightCount == 0) {
            isRightNull = true;
        }
        boolean isLeftHideRow = false;
        for (int index = 0; index < leftCount; ++index) {
            if (isLeftHideRow) continue;
            isLeftHideRow = this.tblMain.getRow(index).getStyleAttributes().isHided();
        }
        HashMap<String, TreeBaseInfo> tmpMap = this.getSelectColls();
        if (tmpMap.isEmpty()) {
            this.getAutoSelectValues();
        }
        ArrayList<String> numLst = new ArrayList<String>(tmpMap.keySet());
        if (leftCount == 0 || numLst.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"noChoose"));
            SysUtil.abort();
        }
        Collections.sort(numLst);
        Iterator<String> ite = numLst.iterator();
        while (ite.hasNext()) {
            leftInfo = (BgAccountInfo)tmpMap.get(ite.next());
            leftInfo.setNumber(BgNumberHelper.trimNumber(leftInfo.getNumber()));
            leftInfo.setLongNumber(BgNumberHelper.trimNumber(leftInfo.getLongNumber()));
            if (this.getAddAccountColls().containsKey(leftInfo.getNumber()) || this.rightNumSet.contains(leftInfo.getNumber())) continue;
            if (isRightNull) {
                newRow = this.tblRight.addRow();
                this.select_AfterAddNewRightRow(newRow, leftInfo, null, isLeftHideRow);
            } else if (sRow != null) {
                rightInfo = (BgAccountInfo)sRow.getUserObject();
                this.checkRightRow(rightInfo);
                newRow = this.tblRight.addRow(++acticeRowIndex);
                this.select_AfterAddNewRightRow(newRow, leftInfo, rightInfo, isLeftHideRow);
                if (((Boolean)sRow.getCell("isLeaf").getValue()).booleanValue()) {
                    sRow.getCell("isLeaf").setValue((Object)false);
                    ((NumberExpandInfo)sRow.getCell("number").getValue()).setLeaf(false);
                }
            } else {
                newRow = this.tblRight.addRow(rightCount);
                this.select_AfterAddNewRightRow(newRow, leftInfo, null, isLeftHideRow);
            }
            this.tblRight.setRowCount(rightCount++);
            this.getAddAccountColls().put(leftInfo.getNumber(), this.getNewLeftInfoByNewRow(newRow));
        }
    }

    private void checkRightRow(BgAccountInfo rightInfo) throws EASBizException, BOSException {
        if (rightInfo == null || rightInfo.getId() == null || this.rightIDSet.isEmpty()) {
            return;
        }
        if (this.refDataIds == null && this.isNeedCheckRf) {
            this.refDataIds = (HashSet)this.getAccountInterface().checkRef(this.rightIDSet, true).get("ref_data");
            if (this.refDataIds == null) {
                this.isNeedCheckRf = false;
            }
        }
        if (this.refDataIds != null && this.refDataIds.contains(rightInfo.getId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"rightRow_hasData", (Object[])new Object[]{rightInfo.getNumber()}));
            SysUtil.abort();
        }
    }

    private BgAccountInfo getNewLeftInfoByNewRow(IRow row) {
        BgAccountInfo newLeftInfo = new BgAccountInfo();
        newLeftInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
        newLeftInfo.setNumber(row.getCell("number").getValue().toString());
        newLeftInfo.setName((String)row.getCell("name").getValue());
        newLeftInfo.setLongNumber(row.getCell("longNumber").getValue().toString());
        newLeftInfo.setDisplayName(row.getCell("displayName").getValue().toString());
        newLeftInfo.setLevel(Integer.valueOf(row.getCell("level").getValue().toString()));
        newLeftInfo.setIsLeaf((Boolean)row.getCell("isLeaf").getValue());
        return newLeftInfo;
    }

    private void select_AfterAddNewRightRow(IRow newRow, BgAccountInfo leftInfo, BgAccountInfo RightInfo, boolean isLeftHideRow) {
        String longNumber = null;
        String displayName = null;
        boolean isLeaf = false;
        int level = 1;
        BgAccountInfo parent = null;
        Set<String> numSet = this.getSelectColls().keySet();
        for (String str : numSet) {
            if (str.indexOf(leftInfo.getLongNumber() + "!") >= 0) {
                isLeaf = false;
                break;
            }
            isLeaf = true;
        }
        if (RightInfo != null) {
            if (!leftInfo.getLongNumber().contains("!") || !this.getSelectColls().keySet().contains(leftInfo.getLongNumber().substring(0, leftInfo.getLongNumber().lastIndexOf("!")))) {
                if (this.getAddAccountColls().containsKey(RightInfo.getNumber())) {
                    parent = this.getAddAccountColls().get(RightInfo.getNumber());
                    level = parent.getLevel() + 1;
                } else {
                    parent = RightInfo;
                    level = RightInfo.getLevel() + 1;
                }
            } else if (this.getAddAccountColls().containsKey(leftInfo.getParent().getNumber())) {
                parent = this.getAddAccountColls().get(leftInfo.getParent().getNumber());
                level = parent.getLevel() + 1;
            } else {
                parent = leftInfo.getParent();
                level = leftInfo.getParent().getLevel() + 1;
            }
            longNumber = parent.getLongNumber() + "!" + leftInfo.getNumber();
            displayName = parent.getDisplayName() + "_" + leftInfo.getName();
        } else {
            if (!leftInfo.getLongNumber().contains("!") || !this.getSelectColls().keySet().contains(leftInfo.getLongNumber().substring(0, leftInfo.getLongNumber().lastIndexOf("!")))) {
                parent = null;
                level = 1;
            } else if (this.getAddAccountColls().containsKey(leftInfo.getParent().getNumber())) {
                parent = this.getAddAccountColls().get(leftInfo.getParent().getNumber());
                level = parent.getLevel() + 1;
            } else {
                parent = leftInfo.getParent();
                level = leftInfo.getParent().getLevel() + 1;
            }
            longNumber = parent == null ? leftInfo.getNumber() : parent.getLongNumber() + "!" + leftInfo.getNumber();
            displayName = parent == null ? leftInfo.getName() : parent.getDisplayName() + "_" + leftInfo.getName();
        }
        this.afterAddRow(newRow, leftInfo, longNumber, level, isLeaf, parent, displayName);
    }

    protected void checkRepeat() {
        int leftCount = this.tblMain.getRowCount();
        BgAccountInfo leftInfo = null;
        IRow leftRow = null;
        String repeatStr = new String();
        int count = 0;
        int hideCount = 0;
        int in = leftCount;
        for (int i = 0; i < in; ++i) {
            leftRow = this.tblMain.getRow(i);
            if (leftRow.getStyleAttributes().isHided()) {
                ++hideCount;
                continue;
            }
            leftInfo = (BgAccountInfo)leftRow.getUserObject();
            if (!this.rightNumSet.contains(leftInfo.getNumber())) continue;
            ++count;
            repeatStr = repeatStr + leftInfo.getNumber() + ",";
        }
        if (repeatStr.length() > 0 && repeatStr.endsWith(",")) {
            repeatStr = repeatStr.substring(0, repeatStr.length() - 1);
            if (count + hideCount == leftCount) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"accountsRepeat"), (String)(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"repeat_number_is") + "\n" + repeatStr), (int)1);
            }
        }
    }

    private void selectAll_Action() throws EASBizException, BOSException {
        int leftCount = this.tblMain.getRowCount();
        int rightCount = this.tblRight.getRowCount();
        if (leftCount == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"noChoose"));
            SysUtil.abort();
        }
        BgAccountInfo leftInfo = null;
        BgAccountInfo rightInfo = null;
        IRow leftRow = null;
        IRow newRow = null;
        IRow sRow = null;
        int acticeRowIndex = this.tblRight.getSelectManager().getActiveRowIndex();
        if (acticeRowIndex >= 0) {
            sRow = this.tblRight.getRow(acticeRowIndex);
        }
        boolean isRightNull = false;
        if (rightCount == 0) {
            isRightNull = true;
        }
        boolean isLeftHideRow = false;
        String repeatStr = new String();
        HashSet<String> numberSet = new HashSet<String>();
        int in = leftCount;
        for (int i = 0; i < in; ++i) {
            leftRow = this.tblMain.getRow(i);
            if (leftRow.getStyleAttributes().isHided()) continue;
            leftInfo = (BgAccountInfo)leftRow.getUserObject();
            leftInfo.setNumber(BgNumberHelper.trimNumber(leftInfo.getNumber()));
            leftInfo.setLongNumber(BgNumberHelper.trimNumber(leftInfo.getLongNumber()));
            if (this.rightNumSet.contains(leftInfo.getNumber())) {
                repeatStr = repeatStr + leftInfo.getNumber() + ",";
            }
            if (isLeftHideRow) continue;
            isLeftHideRow = leftRow.getStyleAttributes().isHided();
        }
        ArrayList<IRow> rows = new ArrayList<IRow>();
        int in2 = leftCount;
        for (int i = 0; i < in2; ++i) {
            leftRow = this.tblMain.getRow(i);
            leftInfo = (BgAccountInfo)leftRow.getUserObject();
            leftInfo.setNumber(BgNumberHelper.trimNumber(leftInfo.getNumber()));
            leftInfo.setLongNumber(BgNumberHelper.trimNumber(leftInfo.getLongNumber()));
            if (this.rightNumSet.contains(leftInfo.getNumber()) || leftRow.getStyleAttributes().isHided() || numberSet.contains(leftInfo.getNumber())) continue;
            numberSet.add(leftInfo.getNumber());
            if (isRightNull) {
                newRow = this.tblRight.addRow();
                rows.add(newRow);
                this.selectAll_AfterAddNewRightRow(newRow, leftInfo, null, isLeftHideRow);
            } else if (sRow != null) {
                rightInfo = (BgAccountInfo)sRow.getUserObject();
                this.checkRightRow(rightInfo);
                newRow = this.tblRight.addRow(++acticeRowIndex);
                this.selectAll_AfterAddNewRightRow(newRow, leftInfo, rightInfo, isLeftHideRow);
                if (((Boolean)sRow.getCell("isLeaf").getValue()).booleanValue()) {
                    sRow.getCell("isLeaf").setValue((Object)false);
                    ((NumberExpandInfo)sRow.getCell("number").getValue()).setLeaf(false);
                }
            } else {
                newRow = this.tblRight.addRow(rightCount);
                rows.add(newRow);
                this.selectAll_AfterAddNewRightRow(newRow, leftInfo, null, isLeftHideRow);
            }
            this.tblRight.setRowCount(rightCount++);
            this.getAddAccountColls().put(leftInfo.getNumber(), leftInfo);
        }
        this.resetTreeInfo(rows, null);
    }

    private void resetTreeInfo(List<IRow> rows, BgAccountInfo parentInfo) {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        IRow row = null;
        NumberExpandInfo info = null;
        HashMap<String, NumberExpandInfo> accounLntMap = new HashMap<String, NumberExpandInfo>();
        HashMap<String, NumberExpandInfo> accounNumberMap = new HashMap<String, NumberExpandInfo>();
        for (int i = 0; i < rows.size(); ++i) {
            row = rows.get(i);
            info = (NumberExpandInfo)row.getCell("number").getValue();
            accounLntMap.put(info.getLongNumber(), info);
            accounNumberMap.put(info.getNumber(), info);
        }
        Object[] longNumbers = accounLntMap.keySet().toArray(new String[0]);
        String[] lns = null;
        Arrays.sort(longNumbers);
        for (Object longNumber : longNumbers) {
            info = (NumberExpandInfo)accounLntMap.get(longNumber);
            lns = ((String)longNumber).split("!");
            if (lns.length == 1 || !accounNumberMap.containsKey(lns[lns.length - 2])) {
                if (parentInfo != null) {
                    info.setLongNumber(parentInfo.getLongNumber() + "!" + info.getNumber());
                    info.setLevel(parentInfo.getLevel() + 1);
                    continue;
                }
                info.setLongNumber(info.getNumber());
                info.setLevel(1);
                continue;
            }
            info.setLongNumber(((NumberExpandInfo)accounNumberMap.get(lns[lns.length - 2])).getLongNumber() + "!" + info.getNumber());
            info.setLevel(((NumberExpandInfo)accounNumberMap.get(lns[lns.length - 2])).getLevel() + 1);
        }
        for (int i = 0; i < rows.size(); ++i) {
            row = rows.get(i);
            info = (NumberExpandInfo)row.getCell("number").getValue();
            row.getCell("longNumber").setValue((Object)info.getLongNumber());
            row.getCell("level").setValue((Object)info.getLevel());
        }
    }

    private void selectAll_AfterAddNewRightRow(IRow newRow, BgAccountInfo leftInfo, BgAccountInfo selectInfo, Boolean isLeftHideRow) {
        String longNumber = null;
        String displayName = null;
        Integer level = null;
        Boolean isLeaf = null;
        BgAccountInfo parent = null;
        longNumber = selectInfo != null ? selectInfo.getLongNumber() + "!" + leftInfo.getLongNumber() : leftInfo.getLongNumber();
        level = selectInfo != null ? selectInfo.getLevel() + leftInfo.getLevel() : leftInfo.getLevel();
        isLeaf = selectInfo != null ? leftInfo.isIsLeaf() : leftInfo.isIsLeaf();
        parent = selectInfo != null ? (leftInfo.getParent() == null ? selectInfo : leftInfo.getParent()) : leftInfo.getParent();
        displayName = selectInfo != null ? selectInfo.getDisplayName() + "_" + leftInfo.getDisplayName() : leftInfo.getDisplayName();
        this.afterAddRow(newRow, leftInfo, longNumber, level, isLeaf, parent, displayName);
    }

    private void afterAddRow(IRow newRow, BgAccountInfo leftInfo, String longNumber, int level, boolean isLeaf, BgAccountInfo parent, String displayName) {
        newRow.getCell("id").setValue((Object)leftInfo.getId().toString());
        newRow.getCell("number").setValue((Object)leftInfo.getNumber());
        newRow.getCell("name").setValue((Object)leftInfo.getName());
        newRow.getCell("longNumber").setValue((Object)longNumber);
        newRow.getCell("isLeaf").setValue((Object)isLeaf);
        newRow.getCell("level").setValue((Object)level);
        newRow.getCell("parent").setValue((Object)parent);
        newRow.getCell("displayName").setValue((Object)displayName);
        newRow.setUserObject((Object)leftInfo);
        NumberExpandInfo numberExpandInfo = new NumberExpandInfo();
        numberExpandInfo.setName(leftInfo.getNumber());
        numberExpandInfo.setNumber(leftInfo.getNumber());
        numberExpandInfo.setLongNumber(longNumber);
        numberExpandInfo.setLevel(level);
        numberExpandInfo.setLeaf(isLeaf);
        numberExpandInfo.setExpandStatus(true);
        newRow.getCell("number").setValue((Object)numberExpandInfo);
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.getAutoSelectValues();
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 1) {
            return;
        }
        this.select_Action();
    }

    @Override
    protected void tblRight_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblRight_tableClicked(e);
        KDTSelectManager sm = this.tblRight.getSelectManager();
        if ((sm.isCtrlKeyDown() || e.isControlDown()) && (e.getButton() == 1 || e.getButton() == 3)) {
            int ac = sm.getActiveRowIndex();
            KDTSelectBlock sb = new KDTSelectBlock(ac, 0, ac, this.tblRight.getColumnCount() - 1);
            sb.setTable(this.tblRight);
            sm.setActiveRowIndex(-1);
            sm.unselect(sb, false);
            this.tblRight.repaint();
        }
    }

    private BgDimSourceInfo getBgASInfo() {
        return this.prmtSourceMember.getData() instanceof BgDimSourceInfo ? (BgDimSourceInfo)this.prmtSourceMember.getData() : null;
    }

    private IBgDimSource getBizInterface() throws BOSException {
        return BgDimSourceFactory.getRemoteInstance();
    }

    private IBgAccount getAccountInterface() throws BOSException {
        return BgAccountFactory.getRemoteInstance();
    }

    @Override
    public void setUITitle(String title) {
        title = EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"sysImportTitle");
        super.setUITitle(title);
    }

    @Override
    protected String getSysImportPermission() {
        return "mbg_bgAccount009_sysImport";
    }

    protected boolean checkBeforeWindowClosing() {
        if (!this.getAddAccountColls().isEmpty()) {
            int rs = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"needSave"));
            if (rs == 0 || rs == 0) {
                try {
                    this.actionSave_actionPerformed(null);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                    this.handUIExceptionAndAbort(e);
                }
                return false;
            }
            return true;
        }
        return super.checkBeforeWindowClosing();
    }
}

