/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgAccountViewFactory;
import com.kingdee.eas.ma.base.BgAccountViewInfo;
import com.kingdee.eas.ma.base.IBgAccountView;
import com.kingdee.eas.ma.base.RptSrcTypeEnum;
import com.kingdee.eas.ma.base.client.AbstractBgAccountViewEditUI;
import com.kingdee.eas.ma.base.client.BgAccountListUI;
import com.kingdee.eas.ma.base.utils.BgAccountHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class BgAccountViewEditUI
extends AbstractBgAccountViewEditUI {
    private static final long serialVersionUID = -9196761587813234340L;
    private static final Logger logger = CoreUIObject.getLogger(BgAccountViewEditUI.class);
    private boolean isRelease = false;
    private CostCenterOrgUnitInfo costInfo = null;

    public CostCenterOrgUnitInfo getCostInfo() {
        return this.costInfo;
    }

    public void setCostInfo(CostCenterOrgUnitInfo costInfo) {
        this.costInfo = costInfo;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.prmtOrgUnit.setEnabled(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.isRelease = true;
    }

    protected void loadData() throws Exception {
        super.loadData();
        this.initPrmtOrgUnit();
        this.disEnabelTxtNumber();
    }

    private void disEnabelTxtNumber() throws Exception {
        if (OprtState.EDIT.equals(this.getOprtState()) || this.editData.getId() != null) {
            if (this.getBizInterface().isHasAccount((IObjectPK)new ObjectUuidPK(this.editData.getId()))) {
                this.txtNumber.setEditable(false);
                this.txtNumber.setEnabled(false);
            }
        } else {
            this.txtNumber.setEditable(true);
            this.txtNumber.setEnabled(true);
        }
    }

    private void initPrmtOrgUnit() {
        CostCenterOrgUnitInfo unitInfo = null;
        String curUnitID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        String optState = this.getOprtState();
        OrgUnitInfo org = (OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        CostCenterOrgUnitInfo costCenterOrgUnitInfo = null;
        try {
            costCenterOrgUnitInfo = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(org.getId().toString()));
            this.setCostInfo(costCenterOrgUnitInfo);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (OprtState.ADDNEW.equals(optState)) {
            unitInfo = costCenterOrgUnitInfo;
        } else if (OprtState.EDIT.equals(optState) || OprtState.VIEW.equals(optState)) {
            unitInfo = this.editData.getOrgUnit();
        }
        BgCommCHelper.initOrgUnit((CoreUIObject)this, this.prmtOrgUnit, unitInfo, curUnitID);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            BgCommCHelper.disableAction((JButton)this.btnSubmit, null);
            this.prmtOrgUnit.setEnabled(false);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanEdit();
        super.actionEdit_actionPerformed(e);
        this.disEnabelTxtNumber();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.disEnabelTxtNumber();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        this.getUIWindow().close();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        Object object = this.getUIContext().get("Owner");
        if (object instanceof BgAccountListUI) {
            ((BgAccountListUI)((Object)object)).newAccViewNum = this.txtNumber.getText();
        }
        super.actionSubmit_actionPerformed(e);
        if (object instanceof BgAccountListUI) {
            ((BgAccountListUI)((Object)object)).initTree();
            ((BgAccountListUI)((Object)object)).setSelectTreeNode();
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        Object selectedItem;
        Object data;
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"NumberIsNull"));
                SysUtil.abort();
            } else if (!BgNumberHelper.checkNumber(this.txtNumber.getText())) {
                this.txtNumber.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "haveEspecial"));
                SysUtil.abort();
            }
        }
        if (BgDBUtils.length(this.txtNumber.getText()) > 80) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"NumberIsOverMax", (Object[])new Object[]{80}));
            SysUtil.abort();
        }
        if ((data = ((MultiLangItem)(selectedItem = this.txtName.getModel().getSelectedItem())).getData()) == null || StringUtils.isEmpty((String)data.toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"NameIsNull"));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        BgAccountViewInfo info = new BgAccountViewInfo();
        info.setOrgUnit(this.getCostInfo());
        info.setIsLeaf(true);
        info.setSourceType((RptSrcTypeEnum)((Object)this.getUIContext().get("SOURCE_TYPE")));
        return info;
    }

    private void checkCanEdit() {
        String distributeId;
        BgAccountViewInfo curDataObject = (BgAccountViewInfo)this.getDataObject();
        if (curDataObject.getId() == null) {
            return;
        }
        String id = curDataObject.getId().toString();
        if (!id.equals(distributeId = curDataObject.getDistributeViewRootId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"cantUpdateViewRootDistribute", (Object[])new Object[]{curDataObject.getNumber()}));
            SysUtil.abort();
        }
    }

    protected IBgAccountView getBizInterface() throws Exception {
        return BgAccountViewFactory.getRemoteInstance();
    }

    public boolean checkBeforeWindowClosing() {
        boolean bclose = super.checkBeforeWindowClosing();
        if (bclose && this.isRelease) {
            BgAccountViewInfo obj = null;
            if (this.getDataObject() != null) {
                obj = (BgAccountViewInfo)this.getDataObject();
            }
            if (obj != null && obj.getId() != null) {
                BgAccountHelper.releaseMutexService(obj.getId().toString());
            }
        }
        return bclose;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("distributeViewRootId"));
        return sic;
    }
}

