/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgAccountViewCollection;
import com.kingdee.eas.ma.base.BgAccountViewFactory;
import com.kingdee.eas.ma.base.BgAccountViewInfo;
import com.kingdee.eas.ma.base.IBgAccountView;
import com.kingdee.eas.ma.base.RptSrcTypeEnum;
import com.kingdee.eas.ma.base.client.AbstractBgAccountViewF7UI;
import com.kingdee.eas.ma.base.client.BgAccountViewEditUI;
import com.kingdee.eas.ma.base.client.utils.BgPermissionUtil;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import org.apache.log4j.Logger;

public class BgAccountViewF7UI
extends AbstractBgAccountViewF7UI {
    private static final Logger logger = CoreUIObject.getLogger(BgAccountViewF7UI.class);
    private RptSrcTypeEnum sourceType = null;
    private OrgUnitInfo curOrgUnitInfo = null;
    private BgAccountViewCollection result = new BgAccountViewCollection();

    public RptSrcTypeEnum getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(RptSrcTypeEnum sourceType) {
        this.sourceType = sourceType;
    }

    public OrgUnitInfo getCurOrgUnitInfo() {
        return this.curOrgUnitInfo;
    }

    public void setCurOrgUnitInfo(OrgUnitInfo curOrgUnitInfo) {
        this.curOrgUnitInfo = curOrgUnitInfo;
    }

    protected BgAccountViewCollection getResult() {
        return this.result;
    }

    public Object getData() {
        return null;
    }

    protected BgAccountViewInfo getResultOne() {
        if (!this.result.isEmpty()) {
            return this.result.get(0);
        }
        return null;
    }

    @Override
    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this.btnAddNew);
        this.toolBar.add((Component)this.btnView);
        this.toolBar.add((Component)this.btnEdit);
        this.toolBar.add((Component)this.btnRemove);
        this.toolBar.add((Component)this.btnRefresh);
    }

    protected String getEditUIName() {
        return BgAccountViewEditUI.class.getName();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.afterConfirm();
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, (Object)this.getCurOrgUnitInfo());
        uiContext.put((Object)"SOURCE_TYPE", (Object)this.getSourceType());
    }

    private void afterConfirm() throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        this.getResult().clear();
        int currRow = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow iRow = this.tblMain.getRow(currRow);
        String id = iRow.getCell("id").getValue().toString();
        try {
            IBgAccountView iAccView = BgAccountViewFactory.getRemoteInstance();
            this.getResult().add((BgAccountViewInfo)iAccView.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id))));
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        catch (EASBizException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        this.getUIWindow().close();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgAccountViewFactory.getRemoteInstance();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterInfo _filter;
        if ((viewInfo = viewInfo == null ? new EntityViewInfo() : (EntityViewInfo)viewInfo.clone()).getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        FilterInfo filter = viewInfo.getFilter();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getCurOrgUnitInfo().getId().toString()));
        String filterText = this.kDTextField1.getText();
        if (!StringUtils.isEmpty((String)filterText)) {
            _filter = new FilterInfo();
            _filter.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + filterText + "%"), CompareType.LIKE));
            _filter.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + filterText + "%"), CompareType.LIKE));
            _filter.getFilterItems().add(new FilterItemInfo("description", (Object)("%" + filterText + "%"), CompareType.LIKE));
            _filter.setMaskString(" #0 OR #1 OR #2 ");
            try {
                viewInfo.getFilter().mergeFilter(_filter, "AND");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            this.kDTextField1.setSelectAllOnFocus(true);
        }
        _filter = new FilterInfo();
        _filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)this.getSourceType().getValue()));
        try {
            viewInfo.getFilter().mergeFilter(_filter, "AND");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    protected void kDTextField1_focusLost(FocusEvent e) throws Exception {
        super.kDTextField1_focusLost(e);
        this.refreshList();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission(this.getCurOrgUnitInfo(), this.getGroupDeletePermission());
        this.checkViewIsDistribute(true);
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission(this.getCurOrgUnitInfo(), this.getGroupEditPermission());
        this.checkViewIsDistribute(false);
        super.actionEdit_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission(this.getCurOrgUnitInfo(), this.getGroupViewPermission());
        super.actionView_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission(this.getCurOrgUnitInfo(), this.getGroupAddNewPermission());
        super.actionAddNew_actionPerformed(e);
    }

    private void checkViewIsDistribute(boolean isDelete) throws EASBizException, BOSException {
        String distribute;
        String id;
        BgAccountViewInfo bgAccViewInfo = this.getSelectViewInfo();
        if (bgAccViewInfo != null && !(id = bgAccViewInfo.getId().toString()).equals(distribute = bgAccViewInfo.getDistributeViewRootId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)(isDelete ? "cantDeleteViewRootDistribute" : "cantUpdateViewRootDistribute"), (Object[])new Object[]{bgAccViewInfo.getNumber()}));
            SysUtil.abort();
        }
    }

    private BgAccountViewInfo getSelectViewInfo() throws BOSException, EASBizException {
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (activeRowIndex != -1) {
            String id = (String)this.tblMain.getRow(activeRowIndex).getCell("id").getValue();
            BgAccountViewInfo bgAccountViewInfo = BgAccountViewFactory.getRemoteInstance().getBgAccountViewInfo("where id = '" + id + "'");
            if (bgAccountViewInfo != null) {
                return bgAccountViewInfo;
            }
        }
        return null;
    }

    protected String getGroupAddNewPermission() {
        return "mbg_bgAccountView002_addNew";
    }

    protected String getGroupEditPermission() {
        return "mbg_bgAccountView003_Edit";
    }

    protected String getGroupViewPermission() {
        return "mbg_bgAccountView004_View";
    }

    protected String getGroupDeletePermission() {
        return "mbg_bgAccountView005_delete";
    }

    protected String getBgAccountViewPermission() {
        return "mbg_bgAccountMem004_view";
    }
}

