/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgBaseFacadeFactory;
import com.kingdee.eas.ma.base.BgElementDataTypeEnum;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.client.AbstractBgElementEditUI;
import com.kingdee.eas.ma.base.client.BgElementBaseDialog;
import com.kingdee.eas.ma.base.utils.BgCodeNumberCHelper;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class BgElementEditUI
extends AbstractBgElementEditUI {
    private static final long serialVersionUID = -8387016221476289101L;
    private static final Logger logger = CoreUIObject.getLogger(BgElementEditUI.class);
    private OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
    private boolean hasCodeNumber = false;
    private boolean hasShowCodeNumber = false;
    private boolean hasUseIntermitNumber = false;

    public void setHasCodeNumber(boolean hasCodeNumber) {
        this.hasCodeNumber = hasCodeNumber;
    }

    public boolean isHasCodeNumber() {
        return this.hasCodeNumber;
    }

    public void setHasShowCodeNumber(boolean hasShowCodeNumber) {
        this.hasShowCodeNumber = hasShowCodeNumber;
    }

    public boolean isHasShowCodeNumber() {
        return this.hasShowCodeNumber;
    }

    public void setHasUseIntermitNumber(boolean hasUseIntermitNumber) {
        this.hasUseIntermitNumber = hasUseIntermitNumber;
    }

    public boolean isHasUseIntermitNumber() {
        return this.hasUseIntermitNumber;
    }

    protected LanguageInfo getCurrentLanguage() {
        return new LanguageInfo(this.getCurrentLocale());
    }

    public OrgUnitInfo getOrgUnitInfo() {
        return this.orgUnitInfo;
    }

    public BgElementEditUI() throws Exception {
        this.comDataType.addItem((Object)BgElementDataTypeEnum.MONEY);
        this.comDataType.addItem((Object)BgElementDataTypeEnum.PRICE);
        this.comDataType.addItem((Object)BgElementDataTypeEnum.AMOUNT);
        this.comDataType.addItem((Object)BgElementDataTypeEnum.RATE);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            BgCommCHelper.setDisable((Component)this.comDataType);
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            BgCommCHelper.setDisable((Component)this.txtNumber);
            this.PromptParent.setEnabled(true);
        }
        this.PromptParent.setEditable(false);
        this.PromptParent.setData((Object)this.editData.getParent());
        this.contParent.setEnabled(false);
        this.contParent.setVisible(false);
        this.PromptParent.setEnabled(false);
        this.PromptParent.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        BgCommCHelper.disableVisible((JButton)this.btnEdit, (JMenuItem)this.menuItemEdit);
        BgCommCHelper.disableVisible((JButton)this.btnSave, (JMenuItem)this.menuItemSave);
        BgCommCHelper.disableVisible((JButton)this.btnCopy, (JMenuItem)this.menuItemCopy);
        BgCommCHelper.disableVisible((JButton)this.btnRemove, (JMenuItem)this.menuItemRemove);
        BgCommCHelper.disableVisible((JButton)this.btnPrint, (JMenuItem)this.menuItemPrint);
        BgCommCHelper.disableVisible((JButton)this.btnPrintPreview, (JMenuItem)this.menuItemPrintPreview);
        BgCommCHelper.disableVisible((JButton)this.btnCancel, (JMenuItem)this.menuItemCancel);
        BgCommCHelper.disableVisible((JButton)this.btnCancelCancel, (JMenuItem)this.menuItemCancelCancel);
        BgCommCHelper.disableVisible((JButton)this.btnFirst, (JMenuItem)this.menuItemFirst);
        BgCommCHelper.disableVisible((JButton)this.btnPre, (JMenuItem)this.menuItemPre);
        BgCommCHelper.disableVisible((JButton)this.btnNext, (JMenuItem)this.menuItemNext);
        BgCommCHelper.disableVisible((JButton)this.btnLast, (JMenuItem)this.menuItemLast);
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        if (dataObject instanceof BgElementInfo) {
            this.editData = (BgElementInfo)dataObject;
        }
        super.setDataObject(dataObject);
    }

    private boolean isSysData() {
        return this.editData != null && this.editData.getNumber() != null && this.editData.getNumber().equals("01");
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.PromptParent.setAccessAuthority(0);
        if (OprtState.VIEW.equals(this.getOprtState()) || this.isSysData()) {
            BgCommCHelper.enableVisible((JButton)this.btnAddNew, null);
            BgCommCHelper.enableVisible((JButton)this.btnEdit, null);
            BgCommCHelper.enableVisible((JButton)this.btnSubmit, null);
            BgCommCHelper.disableAction((JButton)this.btnSubmit);
            this.PromptParent.setEnabled(false);
            if (this.isSysData()) {
                this.txtName.setEnabled(false);
                this.comDataType.setEnabled(false);
                this.txtDescription.setEditable(false);
            }
        } else if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.ADDNEW.equals(this.getOprtState())) {
            this.PromptParent.setEnabled(true);
        }
        BgElementBaseDialog elementDialog = new BgElementBaseDialog();
        elementDialog.setIsShowName(true);
        elementDialog.setIsChooseOne(true);
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            elementDialog.setLongNumber(this.editData.getLongNumber());
        } else {
            elementDialog.setLongNumber(null);
        }
        this.PromptParent.setSelector((KDPromptSelector)elementDialog);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgElementFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("dataType");
        sic.add("description");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("longNumber");
        sic.add("level");
        sic.add("isLeaf");
        sic.add("parent.id");
        sic.add("parent.Number");
        sic.add("parent.name");
        sic.add("parent.longNumber");
        sic.add("parent.level");
        sic.add("showData");
        return sic;
    }

    protected IObjectValue createNewData() {
        BgElementInfo bgElementInfo = new BgElementInfo();
        bgElementInfo.setId(BOSUuid.create((BOSObjectType)bgElementInfo.getBOSType()));
        bgElementInfo.setShowData(true);
        return bgElementInfo;
    }

    protected void loadData() throws Exception {
        super.loadData();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String OUID = this.getOrgUnitInfo().getId().toString();
            this.setHasCodeNumber(BgCodeNumberCHelper.hasCodeNumber((IObjectValue)this.editData, OUID));
            if (this.isHasCodeNumber()) {
                this.setHasShowCodeNumber(BgCodeNumberCHelper.hasDisplayNumber((IObjectValue)this.editData, OUID));
            }
            this.getNumberByCodingRule((IObjectValue)this.editData, OUID);
        }
        if (this.editData != null) {
            this.chbShowData.setSelected(this.editData.isShowData());
        }
    }

    protected void getNumberByCodingRule(IObjectValue caller, String orgId) {
        if (this.isHasCodeNumber() && this.isHasShowCodeNumber()) {
            BgCodeNumberCHelper.applyNumber(this.txtNumber, (IObjectValue)this.editData, orgId, this.isHasCodeNumber(), this.isHasShowCodeNumber());
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        LanguageInfo currLang = this.getCurrentLanguage();
        if (this.txtNumber.isEnabled()) {
            if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
                this.txtNumber.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgElementResource", "noNumber"));
                SysUtil.abort();
            } else if (!BgNumberHelper.checkNumber(this.txtNumber.getText())) {
                this.txtNumber.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgElementResource", "haveEspecial"));
                SysUtil.abort();
            }
        }
        if (this.txtName.getItemBy(currLang).getData() == null || StringUtils.isEmpty((String)this.txtName.getItemBy(currLang).getData().toString())) {
            this.txtName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgElementResource", "noName"));
            SysUtil.abort();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.txtNumber.setEnabled(true);
        this.PromptParent.setEnabled(true);
        this.getNumberByCodingRule((IObjectValue)this.editData, this.getOrgUnitInfo().getId().toString());
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setDataType((BgElementDataTypeEnum)((Object)this.comDataType.getSelectedItem()));
        super.actionEdit_actionPerformed(e);
        this.txtNumber.setEnabled(false);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        BgElementInfo parent = (BgElementInfo)this.PromptParent.getData();
        if (parent != null) {
            boolean canChange;
            if (parent.getNumber().equals("01")) {
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "cantSelectSysData"));
                SysUtil.abort();
            }
            if (parent.getId().toString().equals(this.editData.getId().toString())) {
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "cantSelectSelf"));
                SysUtil.abort();
            }
            if (canChange = BgBaseFacadeFactory.getRemoteInstance().checkParent(parent)) {
                int level = parent.getLevel();
                String ParentLongNumber = parent.getLongNumber();
                this.editData.setParent(parent);
                this.editData.setLongNumber(ParentLongNumber + "!" + this.txtNumber.getText());
                this.editData.setLevel(level + 1);
                super.actionSubmit_actionPerformed(e);
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "cantEditVerson"));
                this.PromptParent.setData(null);
                SysUtil.abort();
            }
        } else {
            this.editData.setParent(null);
            super.actionSubmit_actionPerformed(e);
        }
    }

    protected boolean isContinueAddNew() {
        return true;
    }

    @Override
    protected void comDataType_itemStateChanged(ItemEvent e) throws Exception {
        BgElementDataTypeEnum type;
        super.comDataType_itemStateChanged(e);
        if (e.getStateChange() == 1 && (type = (BgElementDataTypeEnum)((Object)e.getItem())) != null) {
            int value = type.getValue();
            if (0 == value || 2 == value) {
                this.chbShowData.setEnabled(false);
                this.chbShowData.setSelected(true);
            } else {
                this.chbShowData.setEnabled(true);
                this.chbShowData.setSelected(false);
            }
        }
    }
}

