/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.io.kds.KDSBookToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.RptSrcTypeEnum;
import com.kingdee.eas.ma.base.client.AbstractBgElementListUI;
import com.kingdee.eas.ma.base.client.BgElementEditUI;
import com.kingdee.eas.ma.base.client.BgElementQueryProcessor;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.NumberExpendRender;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.client.utils.BgPermissionUtil;
import com.kingdee.eas.ma.base.utils.BgAccountHelper;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgElementListUI
extends AbstractBgElementListUI {
    private static final long serialVersionUID = 8441203496263944874L;
    private static final Logger logger = CoreUIObject.getLogger(BgElementListUI.class);
    private NumberExpendRender render = null;
    private static final String SYS_ELEMENT_NUMBER = "01";

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setRender(new NumberExpendRender(1));
        this.tblMain.getColumn("number").setRenderer((IBasicRender)this.getRender());
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected BgElementInfo getSelectedBgElementInfo() {
        IRow row;
        BgElementInfo elementInfo = null;
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0 && (row = this.tblMain.getRow(rowIndex)) != null) {
            elementInfo = new BgElementInfo();
            elementInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            elementInfo.setName(row.getCell("name").getValue().toString());
            Object obj = row.getCell("number").getValue();
            if (obj instanceof NumberExpandInfo) {
                elementInfo.setNumber(((NumberExpandInfo)obj).getNumber());
            } else {
                elementInfo.setNumber(obj.toString());
            }
        }
        return elementInfo;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("longNumber");
        sic.add("isSysData");
        sic.add("level");
        sic.add("isLeaf");
        sic.add("parent.id");
        sic.add("parent.Number");
        sic.add("parent.name");
        sic.add("parent.longNumber");
        sic.add("parent.level");
        sic.add("lastUpdateUser.name");
        sic.add("lastUpdateTime");
        return sic;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getType() == 1) {
            IRow row;
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            int clickCount = e.getClickCount();
            if (clickCount == 1 && (row = this.tblMain.getRow(rowIndex)) != null && colIndex == this.tblMain.getColumn("number").getColumnIndex()) {
                NumberExpandInfo expandInfo = (NumberExpandInfo)row.getCell("number").getValue();
                if (this.getRender().inRect(expandInfo, e.getX(), e.getY())) {
                    this.setTreeDisplayStyle(row, expandInfo);
                }
            }
        }
    }

    protected boolean isOrderForClickTableHead() {
        return true;
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) throws Exception {
        boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
        if (!isLeaf) {
            this.tblMain.setRefresh(false);
            this.expandTable(row, expandInfo);
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    public RequestContext prepareActionEdit(IItemAction itemAction) throws Exception {
        return super.prepareActionEdit(itemAction);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(selectRows[0]);
        Object oldParentId = row.getCell("parent.id").getValue();
        Object longNumber = row.getCell("longNumber").getValue();
        if (row.getCell("number").getValue().toString().equals(SYS_ELEMENT_NUMBER)) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgElementResource", "isSysData"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
        Object newParentId = row.getCell("parent.id").getValue();
        if (oldParentId != null && (!oldParentId.toString().equals(newParentId.toString()) && newParentId != null || newParentId == null)) {
            this.dealParent(oldParentId.toString(), longNumber.toString());
        }
    }

    public void dealParent(String oldParentId, String longNumber) {
        String parentLongNumber = null;
        if (longNumber != null) {
            parentLongNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
        }
        boolean hasChild = false;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!row.getCell("longNumber").getValue().toString().startsWith(parentLongNumber + "!")) continue;
            hasChild = true;
            break;
        }
        if (!hasChild) {
            try {
                BgElementInfo oldParent = BgElementFactory.getRemoteInstance().getBgElementInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)oldParentId)));
                oldParent.setIsLeaf(true);
                BgElementFactory.getRemoteInstance().save((CoreBaseInfo)oldParent);
            }
            catch (EASBizException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (UuidException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo) throws Exception {
        if (row == null) {
            return;
        }
        IRow child = null;
        int parentLevel = parentExpandInfo.getLevel();
        String longNumber = null;
        String parentLongNumber = null;
        NumberExpandInfo expandInfo = null;
        parentLongNumber = parentExpandInfo.getLongNumber();
        boolean isExpandStatus = parentExpandInfo.isExpandStatus();
        if (isExpandStatus) {
            parentExpandInfo.setExpandStatus(false);
            int rowCount = this.tblMain.getRowCount3();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell("number").getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                child.getStyleAttributes().setHided(true);
            }
        } else {
            parentExpandInfo.setExpandStatus(true);
            int rowCount = this.tblMain.getRowCount3();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell("number").getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                if (expandInfo.getLevel() - parentLevel != 1) continue;
                child.getStyleAttributes().setHided(false);
                if (expandInfo.isLeaf()) continue;
                expandInfo.setExpandStatus(false);
            }
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    BgElementListUI.this.afterDataFill_actionEvent(e);
                }
                catch (Exception ex) {
                    BgElementListUI.this.handUIExceptionAndAbort(ex);
                }
            }
        });
    }

    protected void afterDataFill_actionEvent(KDTDataRequestEvent e) throws Exception {
        int beginIndex = e.getFirstRow();
        int endIndex = e.getLastRow();
        int level = 0;
        Object numberValue = null;
        String id = null;
        String number = null;
        String longNumber = null;
        String name = null;
        IRow row = null;
        NumberExpandInfo expandInfo = null;
        for (int index = beginIndex; index <= endIndex; ++index) {
            row = this.tblMain.getRow(index);
            if (row == null) continue;
            id = (String)row.getCell("id").getValue();
            numberValue = row.getCell("number").getValue();
            if (!(numberValue instanceof String)) {
                return;
            }
            number = numberValue.toString();
            longNumber = row.getCell("longNumber").getValue().toString();
            level = (Integer)row.getCell("level").getValue();
            name = row.getCell("name").getValue() != null ? ((String)row.getCell("name").getValue()).toString() : null;
            boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
            expandInfo = new NumberExpandInfo();
            expandInfo.setId(id);
            expandInfo.setLevel(level);
            expandInfo.setLeaf(isLeaf);
            expandInfo.setName(number);
            expandInfo.setNumber(number);
            expandInfo.setLongNumber(longNumber);
            expandInfo.setExpandStatus(true);
            row.getCell("number").setValue((Object)expandInfo);
            row.getCell("number").setRenderer((IBasicRender)this.getRender());
        }
    }

    public NumberExpendRender getRender() {
        return this.render;
    }

    public void setRender(NumberExpendRender render) {
        this.render = render;
    }

    protected String getEditUIName() {
        return BgElementEditUI.class.getName();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgElementFactory.getRemoteInstance();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return new FilterInfo();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        dialog.setProcessor((IProcessor)new BgElementQueryProcessor((IUIObject)this));
        return dialog;
    }

    protected List<Integer> getSelectRowIndex() {
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range.size() == 0) {
            return null;
        }
        ArrayList<Integer> selectRowIndex = new ArrayList<Integer>();
        KDTSelectBlock block = null;
        for (int index = 0; index < range.size(); ++index) {
            block = (KDTSelectBlock)range.get(index);
            for (int r = block.getBeginRow(); r <= block.getEndRow(); ++r) {
                selectRowIndex.add(r);
            }
        }
        Collections.sort(selectRowIndex);
        return selectRowIndex;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int re = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "delete_confirm"));
        if (re == 1 || re == 2) {
            return;
        }
        List<Integer> indexs = this.getSelectRowIndex();
        ArrayList<String> selectDel = new ArrayList<String>();
        IRow row = null;
        String rowId = null;
        int rowIndex = 0;
        CostCenterOrgUnitInfo ccoui = SysContext.getSysContext().getCurrentCostUnit();
        HashMap<String, String> numberMap = new HashMap<String, String>();
        HashSet difOrg = new HashSet();
        HashSet<String> sysVersion = new HashSet<String>();
        for (int index = 0; index < indexs.size(); ++index) {
            rowIndex = indexs.get(index);
            row = this.tblMain.getRow(indexs.get(index).intValue());
            rowId = row.getCell("id").getValue().toString();
            NumberExpandInfo Info = (NumberExpandInfo)row.getCell("number").getValue();
            String number = Info.getNumber().toString();
            if (rowId != null) {
                if (number.equals(SYS_ELEMENT_NUMBER)) {
                    sysVersion.add(rowId.toString());
                } else {
                    selectDel.add(rowId);
                }
            }
            numberMap.put(rowId, number);
        }
        Map result = BgElementFactory.getRemoteInstance().remove(selectDel);
        Set cantRemove = new HashSet();
        Set delete = new HashSet();
        if (result != null) {
            cantRemove = (Set)result.get("cantRemove");
            delete = (Set)result.get("canSet");
        }
        StringBuffer message = new StringBuffer();
        if (sysVersion.size() == 0 && cantRemove.size() == 0 && difOrg.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "delete_success"));
            this.refresh(e);
        } else {
            String id;
            Iterator iter = delete.iterator();
            while (iter.hasNext()) {
                id = iter.next().toString();
                message.append(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "removeSuccess"), numberMap.get(id)));
                message.append("\r\n");
            }
            iter = cantRemove.iterator();
            while (iter.hasNext()) {
                id = iter.next().toString();
                message.append(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "cantRemoveSelf"), numberMap.get(id)));
                message.append("\r\n");
            }
            iter = sysVersion.iterator();
            while (iter.hasNext()) {
                id = iter.next().toString();
                message.append(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "cantRemoveSysdate"), numberMap.get(id)));
                message.append("\r\n");
            }
            iter = difOrg.iterator();
            while (iter.hasNext()) {
                id = iter.next().toString();
                message.append(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "remove_difOrg"), numberMap.get(id)));
                message.append("\r\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "delete_failed"), (String)message.toString(), (int)1);
        }
        this.tblMain.refresh();
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission(SysContext.getSysContext().getCurrentOrgUnit().getId(), "mbg_bgelement006_import");
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"template", (Object)this.loadTempTable());
        ctx.put((Object)"sourceType", (Object)this.getSourceType());
        ctx.put((Object)"bg.user", (Object)SysContext.getSysContext().getCurrentUserInfo());
        ctx.put((Object)"bg.orgUnit", (Object)SysContext.getSysContext().getCurrentOrgUnit());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.base.client.BgElementImportUI", (Map)ctx, null, OprtState.VIEW);
        window.getUIObject().setUITitle(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgScenarioResource", "tileElement"));
        window.show();
        this.actionRefresh_actionPerformed(e);
    }

    protected RptSrcTypeEnum getSourceType() {
        return RptSrcTypeEnum.PT_BUDGET_REPORT;
    }

    private KDTable loadTempTable() throws EASBizException, BOSException {
        KDTable tbl = new KDTable();
        ArrayList<String> tempHeadNumber = new ArrayList<String>();
        tempHeadNumber.add("number");
        tempHeadNumber.add("name");
        tempHeadNumber.add("dataType");
        tempHeadNumber.add("showData");
        tempHeadNumber.add("description");
        ArrayList<String> tempHeadName = new ArrayList<String>();
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"number") + "*");
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"name") + "*");
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"dataType") + "*");
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"showData") + "*");
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"describe"));
        IRow head = tbl.addHeadRow();
        for (int i = 0; i < tempHeadNumber.size(); ++i) {
            IColumn column = tbl.addColumn();
            column.setKey((String)tempHeadNumber.get(i));
            head.getCell(column.getColumnIndex()).setValue(tempHeadName.get(i));
        }
        return tbl;
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission(SysContext.getSysContext().getCurrentOrgUnit().getId(), "mbg_bgelement006_export");
        BgFileUtil bgFileUtil = new BgFileUtil();
        KDFileChooser fileChooser = bgFileUtil.getFileChooserForExp((Object)this);
        fileChooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"outTitleEle"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        String filePath = BgAccountHelper.fileSelect(fileChooser, (CoreUI)this);
        if (filePath == null) {
            SysUtil.abort();
        }
        KDSBook kdsBook = new KDSBook("001");
        KDSSheet kdsSheet = new KDSSheet(kdsBook, "001");
        kdsSheet.getSheetStyleAttributes().setFont(new Font(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"font"), 0, 9));
        kdsSheet.getSheetStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        kdsSheet.getSheetStyleAttributes().setNumberFormat("@");
        kdsSheet.setCellValue(0, 0, (Object)(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"number") + "*"));
        kdsSheet.setCellValue(0, 1, (Object)(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"name") + "*"));
        kdsSheet.setCellValue(0, 2, (Object)(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"dataType") + "*"));
        kdsSheet.setCellValue(0, 3, (Object)(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"showData") + "*"));
        kdsSheet.setCellValue(0, 4, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"describe"));
        IRow row = null;
        int n = this.tblMain.getRowCount3();
        for (int i = 0; i < n; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("number").getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgAccountResource", "errorValue", new Integer[]{i + 1}));
                return;
            }
            kdsSheet.setCellValue(i + 1, 0, (Object)row.getCell("number").getValue().toString());
            kdsSheet.setCellValue(i + 1, 1, row.getCell("name").getValue() != null ? row.getCell("name").getValue().toString() : null);
            kdsSheet.setCellValue(i + 1, 2, row.getCell("dataType").getValue() != null ? row.getCell("dataType").getValue().toString() : null);
            kdsSheet.setCellValue(i + 1, 3, (Object)((Boolean)row.getCell("showData").getValue() != false ? EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"true") : EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"false")));
            kdsSheet.setCellValue(i + 1, 4, row.getCell("description").getValue() != null ? row.getCell("description").getValue().toString() : null);
        }
        File file = new File(filePath);
        if (file.exists()) {
            int result = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.tools.datatask.DatataskResource", "fileHasExisted"));
            if (result == 0) {
                if (file.delete()) {
                    file = new File(filePath);
                } else {
                    MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.tools.datatask.DatataskResource", "openedfile"));
                }
            } else {
                SysUtil.abort();
            }
        }
        kdsBook.addSheet(null, kdsSheet);
        ExportManager export = new ExportManager();
        try {
            String sen = GlobalFunction.getFileExtension((String)filePath);
            Book temBook = null;
            if (sen.equals("xlsx")) {
                temBook = KDSBookToBook.traslate((KDSBook)kdsBook);
                BookDataWrapper bookDataWrapper = new BookDataWrapper(temBook);
                SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
                if (filePath != null) {
                    booksc.write(filePath.replaceAll(" ", ""));
                }
            } else {
                export.exportToExcel(kdsBook, filePath);
            }
            bgFileUtil.storeDefaultPathForEXP(filePath, this.getUIContext());
        }
        catch (RuntimeException e1) {
            SysUtil.abort();
        }
        this.setMessageBarValue("successExportElement");
    }

    private void setMessageBarValue(String value) {
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)value));
        this.showMessage();
    }
}

