/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.base.BgItemException;
import com.kingdee.eas.ma.base.BgItemGroupFactory;
import com.kingdee.eas.ma.base.BgItemGroupInfo;
import com.kingdee.eas.ma.base.BgItemRelationFactory;
import com.kingdee.eas.ma.base.client.AbstractBgItemGroupEditUI;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCodeNumberCHelper;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.Timestamp;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class BgItemGroupEditUI
extends AbstractBgItemGroupEditUI {
    private static final long serialVersionUID = -957208139156970639L;
    private static final Logger logger = CoreUIObject.getLogger(BgItemGroupEditUI.class);
    private OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
    private boolean hasCodeNumber = false;
    private boolean hasShowCodeNumber = false;
    private boolean hasUseIntermitNumber = false;

    public void onLoad() throws Exception {
        super.onLoad();
        Object obj = this.getUIContext().get("ParentNode");
        if (obj instanceof BgItemGroupInfo) {
            this.editData.setParent((BgItemGroupInfo)obj);
        }
        if (!OprtState.ADDNEW.equals(this.getOprtState()) && OprtState.EDIT.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        BgCommCHelper.disableVisible((JButton)this.btnAddNew, (JMenuItem)this.menuItemAddNew);
        BgCommCHelper.disableVisible((JButton)this.btnEdit, (JMenuItem)this.menuItemEdit);
        BgCommCHelper.disableVisible((JButton)this.btnSave, (JMenuItem)this.menuItemSave);
        BgCommCHelper.disableVisible((JButton)this.btnCopy, (JMenuItem)this.menuItemCopy);
        BgCommCHelper.disableVisible((JButton)this.btnRemove, (JMenuItem)this.menuItemRemove);
        BgCommCHelper.disableVisible((JButton)this.btnPrint, (JMenuItem)this.menuItemPrint);
        BgCommCHelper.disableVisible((JButton)this.btnPrintPreview, (JMenuItem)this.menuItemPrintPreview);
        BgCommCHelper.disableVisible((JButton)this.btnCancel, (JMenuItem)this.menuItemCancel);
        BgCommCHelper.disableVisible((JButton)this.btnCancelCancel, (JMenuItem)this.menuItemCancelCancel);
    }

    @Override
    protected void chkGlobal_itemStateChanged(ItemEvent e) throws Exception {
        super.chkGlobal_itemStateChanged(e);
        if (1 == e.getStateChange() && this.editData.getId() != null && BgItemRelationFactory.getRemoteInstance().exists("where rootId is not null and bgItem.bgItemGroup.Id = '" + this.editData.getId() + "'")) {
            this.chkGlobal.setSelected(false);
            throw new BgItemException(BgItemException.CHECKGOBAL);
        }
    }

    public void setHasCodeNumber(boolean hasCodeNumber) {
        this.hasCodeNumber = hasCodeNumber;
    }

    public boolean isHasCodeNumber() {
        return this.hasCodeNumber;
    }

    public void setHasShowCodeNumber(boolean hasShowCodeNumber) {
        this.hasShowCodeNumber = hasShowCodeNumber;
    }

    public boolean isHasShowCodeNumber() {
        return this.hasShowCodeNumber;
    }

    public void setHasUseIntermitNumber(boolean hasUseIntermitNumber) {
        this.hasUseIntermitNumber = hasUseIntermitNumber;
    }

    public boolean isHasUseIntermitNumber() {
        return this.hasUseIntermitNumber;
    }

    protected IObjectValue createNewData() {
        BgItemGroupInfo itemGroupInfo = new BgItemGroupInfo();
        itemGroupInfo.setId(BOSUuid.create((BOSObjectType)itemGroupInfo.getBOSType()));
        itemGroupInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        itemGroupInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        itemGroupInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        return itemGroupInfo;
    }

    protected void applyDefaultValue(IObjectValue vo) {
        super.applyDefaultValue(vo);
        BgItemGroupInfo itemGroupInfo = (BgItemGroupInfo)vo;
        Object obj = this.getUIContext().get(BgBaseConstants.BGITEMGROUP_INFO);
        if (obj instanceof BgItemGroupInfo) {
            itemGroupInfo.setParent((BgItemGroupInfo)obj);
            String rootNumber = itemGroupInfo.getParent().getLongNumber().split("!")[0];
            try {
                BgItemGroupInfo root = BgItemGroupFactory.getRemoteInstance().getBgItemGroupInfo("select global where number = '" + rootNumber + "'");
                itemGroupInfo.setGlobal(root.isGlobal());
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIExceptionAndAbort(e);
            }
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgItemGroupFactory.getRemoteInstance();
    }

    protected void loadData() throws Exception {
        super.loadData();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String OUID = this.orgUnitInfo.getId().toString();
            this.setHasCodeNumber(BgCodeNumberCHelper.hasCodeNumber((IObjectValue)this.editData, OUID));
            if (this.isHasCodeNumber()) {
                this.setHasShowCodeNumber(BgCodeNumberCHelper.hasDisplayNumber((IObjectValue)this.editData, OUID));
            }
            this.getNumberByCodingRule((IObjectValue)this.editData, OUID);
        }
    }

    protected void getNumberByCodingRule(IObjectValue caller, String orgId) {
        if (this.isHasCodeNumber() && this.isHasShowCodeNumber()) {
            BgCodeNumberCHelper.applyNumber(this.txtNumber, (IObjectValue)this.editData, orgId, this.isHasCodeNumber(), this.isHasShowCodeNumber());
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        LanguageInfo currLang = this.getCurrentLanguage();
        if (this.txtNumber.isEnabled()) {
            if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
                this.txtNumber.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgItemResource", (String)"GroupNumberNull"));
                SysUtil.abort();
            } else if (!BgNumberHelper.checkNumber(this.txtNumber.getText())) {
                this.txtNumber.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "haveEspecial"));
                SysUtil.abort();
            }
        }
        if (this.txtName.getItemBy(currLang).getData() == null || StringUtils.isEmpty((String)this.txtName.getItemBy(currLang).getData().toString())) {
            this.txtName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgItemResource", (String)"GroupNameNull"));
            SysUtil.abort();
        }
    }

    protected LanguageInfo getCurrentLanguage() {
        return new LanguageInfo(this.getCurrentLocale());
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            request.put(BgBaseConstants.ORGUNIT_INFO, (Object)this.orgUnitInfo);
        }
        return handler;
    }
}

