/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.BgSelfDefinedPeriodInfo;
import com.kingdee.eas.ma.base.IBgPeriodDisp;
import com.kingdee.eas.ma.base.client.AbstractBgPeriodDispEditUI;
import com.kingdee.eas.ma.base.client.BgPeriodTreeListUI;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.NumberExpendRender;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class BgPeriodDispEditUI
extends AbstractBgPeriodDispEditUI {
    private static final long serialVersionUID = 1674119499278863618L;
    private static final Logger logger = CoreUIObject.getLogger(BgPeriodDispEditUI.class);
    public static final int MAX_ROW = 998;
    public static final String colKey = "selfDefinedName";
    public static final String colKeyP = "parentSelfDefined";
    protected BgPeriodTypeInfo bgPeriodTypeInfo = null;
    protected CalendarHelper helper = new CalendarHelper();
    boolean onlySelfDefined = false;
    boolean isSelfDefined = false;
    public final String SUFFIX = EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Day");
    protected NumberExpendRender render = new NumberExpendRender(0);

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.init();
    }

    public void init() {
        BgPeriodTypeInfo typeInfo;
        this.kDContainer1.addButton((JButton)this.btnAddLine);
        this.kDContainer1.addButton((JButton)this.btnDelLine);
        this.kDContainer1.addButton((JButton)this.btnLeft);
        this.kDContainer1.addButton((JButton)this.btnRight);
        this.bgPeriodTypeInfo = typeInfo = (BgPeriodTypeInfo)this.getUIContext().get("UI_KEY_BGPERIODTYPEINFO");
        if (typeInfo == null) {
            return;
        }
        this.isSelfDefined = typeInfo.isSelfDefined();
        this.onlySelfDefined = BgNPeriodHelper.isOnlySelfDefinedPeriod(typeInfo);
        this.contBeginDate.setEnabled(!this.onlySelfDefined);
        this.contEndDate.setEnabled(!this.onlySelfDefined);
        this.kDSpEndDate.setEnabled(!this.onlySelfDefined);
        int currYear = this.getCalHelper().getCurrentlyYear();
        if (!this.onlySelfDefined) {
            this.kDSpBeginDate.setModel((SpinnerModel)new SpinnerNumberModel(currYear, 1900, 2050, 1));
            this.kDSpEndDate.setModel((SpinnerModel)new SpinnerNumberModel(currYear, 1900, 2050, 1));
        }
        this.kDSpBeginDate.setValue((Object)currYear);
        this.kDSpEndDate.setValue((Object)currYear);
        if (!this.isSelfDefined) {
            this.kDContainer1.setEnabled(false);
            this.btnAddLine.setEnabled(false);
            this.btnDelLine.setEnabled(false);
            this.btnLeft.setEnabled(false);
            this.btnRight.setEnabled(false);
        }
        this.initStartTime();
    }

    private void initStartTime() {
        for (int i = 1; i <= 31; ++i) {
            this.cbxStartTime.addItem((Object)new StartTimeInfo(i, this.SUFFIX));
        }
        this.cbxStartTime.setSelectedIndex(0);
        if (4 != this.bgPeriodTypeInfo.getBgPeriodEnum(false) || this.bgPeriodTypeInfo.isSelfDefined()) {
            this.cbxStartTime.setEnabled(false);
            this.cbxStrideYear.setEnabled(false);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.loadTable();
    }

    protected void loadTable() {
        this.kdDefinedSetTable.checkParsed();
        this.initDefinedSetTable();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        int end;
        super.verifyInput(e);
        if (this.onlySelfDefined) {
            if (this.kdDefinedSetTable.getRowCount() == 0) {
                this.showErrorMsg("error_selfDefinedPeriodisNull", new Object[0]);
            }
            HashSet<String> names = new HashSet<String>();
            if (this.kdDefinedSetTable.getRowCount() != 0) {
                for (int i = 0; i < this.kdDefinedSetTable.getRowCount(); ++i) {
                    if (this.kdDefinedSetTable.getRow(i).getCell(colKey) == null || "".equals(this.kdDefinedSetTable.getRow(i).getCell(colKey).getValue().toString().trim())) {
                        this.showErrorMsg("selfDefinedNameIsNull", new Object[0]);
                    }
                    if (this.kdDefinedSetTable.getRow(i).getCell(colKey).getValue().toString().trim().length() > 80) {
                        this.showErrorMsg("selfDefinedNameToLong", new Object[0]);
                    }
                    if (names.contains(this.kdDefinedSetTable.getRow(i).getCell(colKey).getValue().toString())) {
                        this.showErrorMsg("selfDefinedPeriodIsDumpt", new Object[0]);
                    }
                    names.add(this.kdDefinedSetTable.getRow(i).getCell(colKey).getValue().toString());
                }
            }
            if (!names.isEmpty()) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add("name");
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("name", names, CompareType.INCLUDE));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("type.selfDefined", (Object)Boolean.TRUE));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("type.year", (Object)Boolean.FALSE));
                if (BgPeriodDispFactory.getRemoteInstance().exists(evi.getFilter())) {
                    this.showErrorMsg("selfDefinedPeriodIsDumpt", new Object[0]);
                }
            }
        }
        if (!this.isSelfDefined) {
            if (this.kDSpBeginDate.getValue() == null && this.kDSpEndDate.getValue() == null) {
                this.showErrorMsg("budgetYearIsNull", new Object[0]);
            } else {
                int start = Integer.valueOf(this.kDSpBeginDate.getValue().toString());
                if (start > (end = Integer.valueOf(this.kDSpEndDate.getValue().toString()).intValue())) {
                    this.showErrorMsg("startY_compare_endY", new Object[0]);
                }
            }
        }
        if (!this.onlySelfDefined) {
            if (this.isSelfDefined && this.kdDefinedSetTable.getRowCount() == 0) {
                this.showErrorMsg("error_selfDefinedPeriodisNull", new Object[0]);
            }
            if (this.kdDefinedSetTable.getRowCount() != 0) {
                for (int i = 0; i < this.kdDefinedSetTable.getRowCount(); ++i) {
                    if (this.kdDefinedSetTable.getRow(i).getCell(colKey) == null || this.kdDefinedSetTable.getRow(i).getCell(colKey).getValue() == null || "".equals(this.kdDefinedSetTable.getRow(i).getCell(colKey).getValue().toString().trim())) {
                        this.showErrorMsg("selfDefinedNameIsNull", new Object[0]);
                    }
                    if (this.kdDefinedSetTable.getRow(i).getCell(colKey).getValue().toString().trim().length() <= 80) continue;
                    this.showErrorMsg("selfDefinedNameToLong", new Object[0]);
                }
            }
            if (this.kDSpBeginDate.getValue() == null && this.kDSpEndDate.getValue() == null) {
                this.showErrorMsg("budgetYearIsNull", new Object[0]);
            } else {
                int start = Integer.valueOf(this.kDSpBeginDate.getValue().toString());
                if (start > (end = Integer.valueOf(this.kDSpEndDate.getValue().toString()).intValue())) {
                    this.showErrorMsg("startY_compare_endY", new Object[0]);
                }
            }
        }
    }

    private void validateSelfDate(int i) {
        Date beginDate = (Date)this.kdDefinedSetTable.getRow(i).getCell("beginDate").getValue();
        Date endDate = (Date)this.kdDefinedSetTable.getRow(i).getCell("beginDate").getValue();
        if (beginDate == null) {
            this.showErrorMsg("beginDateIsNull0", i + 1);
        }
        if (endDate == null) {
            this.showErrorMsg("endDateIsNull0", i + 1);
        }
        if (beginDate.compareTo(endDate) > 0) {
            this.showErrorMsg("beginDateLargerEndDate0", i + 1);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        Object info;
        this.verifyInput(e);
        StringBuilder sb = new StringBuilder();
        Object[] errorData = null;
        int start = Integer.valueOf(this.kDSpBeginDate.getValue().toString());
        int end = Integer.valueOf(this.kDSpEndDate.getValue().toString());
        if (this.onlySelfDefined) {
            info = this.getSelfDefinedPeriodInfo();
            errorData = (Object[])this.getBizInterface().addBgPeriodByPeriodType(this.bgPeriodTypeInfo, this.helper.getCurrentlyYear(), this.helper.getCurrentlyYear(), (List)info);
            sb.append(errorData[2]);
        } else {
            info = this.getSelfDefinedPeriodInfo();
            StartTimeInfo startTimeInfo = (StartTimeInfo)this.cbxStartTime.getModel().getSelectedItem();
            errorData = (Object[])this.getBizInterface().addBgPeriodByPeriodType((IObjectValue)this.bgPeriodTypeInfo, start, end, (List)info, startTimeInfo.getStartTime(), this.cbxStrideYear.isSelected());
            sb.append(errorData[2]);
        }
        if (this.onlySelfDefined) {
            info = EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"createSelfPeriodFinished");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)info, (String)(errorData == null ? "" : sb.toString()), (int)1);
        } else if (null != errorData) {
            Object[] data = errorData;
            if (data != null && data.length >= 2 && data[1] != null && "0".equals(data[1].toString().trim())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"createPeriodSuccess"));
            } else {
                String error = EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"createPeriodFinished", (Object[])new Object[]{end - start + 1, data[0], data[1]});
                MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)(errorData == null ? "" : data[2].toString()), (int)1);
            }
        }
        this.getUIWindow().close();
        if (this.getUIContext().get("Owner") instanceof BgPeriodTreeListUI) {
            ((BgPeriodTreeListUI)((Object)this.getUIContext().get("Owner"))).actionRefresh_leftTable();
        }
    }

    private List<BgSelfDefinedPeriodInfo> getSelfDefinedPeriodInfo() {
        ArrayList<BgSelfDefinedPeriodInfo> reList = null;
        BgSelfDefinedPeriodInfo info = null;
        if (this.kdDefinedSetTable.getRowCount() > 0) {
            reList = new ArrayList<BgSelfDefinedPeriodInfo>();
            int count = this.kdDefinedSetTable.getRowCount();
            for (int i = 0; i < count; ++i) {
                Object value = this.kdDefinedSetTable.getRow(i).getCell(colKey).getValue();
                if (value == null && value instanceof NumberExpandInfo) {
                    this.showErrorMsg("can't is null!", new Object[0]);
                }
                info = new BgSelfDefinedPeriodInfo();
                info.setNumber(((NumberExpandInfo)value).getNumber());
                info.setName(((NumberExpandInfo)value).getName());
                String string = this.kdDefinedSetTable.getRow(i).getCell("longNumber").getValue().toString();
                info.setLongNumber(string);
                int parseInt = Integer.parseInt(this.kdDefinedSetTable.getRow(i).getCell("level").getValue().toString());
                if (parseInt > 8) {
                    this.showErrorMsg("exceedMAX", 8);
                }
                info.setLevel(parseInt);
                info.setShowLevel(Integer.parseInt(this.kdDefinedSetTable.getRow(i).getCell("showLevel").getValue().toString()));
                info.setIsleaf((Boolean)this.kdDefinedSetTable.getRow(i).getCell("isLeaf").getValue());
                reList.add(info);
            }
        }
        return reList;
    }

    @Override
    public void actionRightMove_actionPerformed(ActionEvent e) throws Exception {
        this.kdDefinedSetTable.getRowCount();
        int rowIndex = this.kdDefinedSetTable.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        Object value = this.kdDefinedSetTable.getRow(rowIndex).getCell(colKey).getValue();
        if (value == null || StringUtil.isEmptyString((String)value.toString())) {
            this.showErrorMsg("selfDefinedNameIsNull", new Object[0]);
        }
        String selectedLongnumber = this.kdDefinedSetTable.getRow(rowIndex).getCell("longNumber").getValue().toString();
        String selectednumber = this.kdDefinedSetTable.getRow(rowIndex).getCell("number").getValue().toString();
        if (rowIndex == 0) {
            this.showErrorMsg("root_right_failed", new Object[0]);
        } else {
            int sameLevelRowData = this.getSameLevelRowData(rowIndex);
            if (sameLevelRowData != -1) {
                this.kdDefinedSetTable.getRow(rowIndex).getCell(colKeyP).setValue(this.kdDefinedSetTable.getRow(sameLevelRowData).getCell(colKey).getValue());
                String longNumber = this.kdDefinedSetTable.getRow(sameLevelRowData).getCell("longNumber").getValue() + "!" + selectednumber;
                this.kdDefinedSetTable.getRow(rowIndex).getCell("longNumber").setValue((Object)longNumber);
                int level = Integer.parseInt(this.kdDefinedSetTable.getRow(sameLevelRowData).getCell("level").getValue().toString());
                this.kdDefinedSetTable.getRow(rowIndex).getCell("level").setValue((Object)(level + 1));
                this.kdDefinedSetTable.getRow(sameLevelRowData).getCell("isLeaf").setValue((Object)false);
                for (int i = 0; i < this.kdDefinedSetTable.getRowCount(); ++i) {
                    Object childLongNumber = this.kdDefinedSetTable.getCell(i, "longNumber").getValue();
                    if (!childLongNumber.toString().startsWith(selectedLongnumber + "!")) continue;
                    int level0 = Integer.parseInt(this.kdDefinedSetTable.getRow(i).getCell("level").getValue().toString());
                    this.kdDefinedSetTable.getRow(i).getCell("level").setValue((Object)(level0 + 1));
                    String string = this.kdDefinedSetTable.getRow(i).getCell("longNumber").getValue().toString();
                    String newLongnumber = string.replace(selectedLongnumber + "!", longNumber + "!");
                    this.kdDefinedSetTable.getRow(i).getCell("longNumber").setValue((Object)newLongnumber);
                }
            }
        }
        boolean hasChildren = false;
        String newLong = this.kdDefinedSetTable.getCell(rowIndex, "longNumber").getValue().toString() + "!";
        for (int i = 0; i < this.kdDefinedSetTable.getRowCount(); ++i) {
            Object childLongNumber = this.kdDefinedSetTable.getCell(i, "longNumber").getValue();
            if (!childLongNumber.toString().startsWith(newLong)) continue;
            hasChildren = true;
            break;
        }
        if (!hasChildren) {
            this.kdDefinedSetTable.getRow(rowIndex).getCell("isLeaf").setValue((Object)true);
        }
        this.afterDataFill_actionEvent(null);
    }

    private int getSameLevelRowData(int rowIndex) {
        Object level0 = this.kdDefinedSetTable.getRow(rowIndex).getCell("level").getValue();
        for (int i = rowIndex - 1; i >= 0; --i) {
            Object level1 = this.kdDefinedSetTable.getRow(i).getCell("level").getValue();
            if (!level0.equals(level1)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void actionLeftMove_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.kdDefinedSetTable.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        Object value = this.kdDefinedSetTable.getRow(rowIndex).getCell(colKey).getValue();
        int selectlevel = Integer.parseInt(this.kdDefinedSetTable.getRow(rowIndex).getCell("level").getValue().toString());
        if (selectlevel == 1) {
            this.showErrorMsg("root_left_failed", new Object[0]);
        } else if (value == null || StringUtil.isEmptyString((String)value.toString())) {
            this.showErrorMsg("selfDefinedNameIsNull", new Object[0]);
        } else if (value == null || StringUtil.isEmptyString((String)value.toString())) {
            this.showErrorMsg("leftMoveFailedNotexistParent", new Object[0]);
        } else {
            String oldLongnumber = this.kdDefinedSetTable.getRow(rowIndex).getCell("longNumber").getValue().toString();
            String oldnumber = this.kdDefinedSetTable.getRow(rowIndex).getCell("number").getValue().toString();
            String oldPLongnumber = oldLongnumber.replace("!" + oldnumber, "");
            String[] numbers = oldPLongnumber.split("!");
            String oldpnumber = numbers[numbers.length - 1];
            int pRowIndex = -1;
            boolean hasOtherChildren = false;
            for (int i = 0; i < this.kdDefinedSetTable.getRowCount(); ++i) {
                String oldPnumber;
                Object value2 = this.kdDefinedSetTable.getCell(i, "longNumber").getValue();
                if (value2.toString().startsWith(oldLongnumber + "!")) {
                    String newLongNumber = value2.toString().replace(oldpnumber + "!", "");
                    this.kdDefinedSetTable.getCell(i, "longNumber").setValue((Object)newLongNumber);
                    int level = Integer.parseInt(this.kdDefinedSetTable.getRow(i).getCell("level").getValue().toString());
                    this.kdDefinedSetTable.getRow(i).getCell("level").setValue((Object)(level - 1));
                }
                if (value2.equals(oldPLongnumber)) {
                    pRowIndex = i;
                    this.kdDefinedSetTable.getRow(rowIndex).getCell(colKeyP).setValue(this.kdDefinedSetTable.getCell(i, colKeyP).getValue());
                    this.kdDefinedSetTable.getRow(rowIndex).getCell("level").setValue((Object)(selectlevel - 1));
                    oldPnumber = this.kdDefinedSetTable.getCell(i, "number").getValue().toString();
                    String longnumber = oldLongnumber.replace(oldPnumber + "!", "");
                    this.kdDefinedSetTable.getRow(rowIndex).getCell("longNumber").setValue((Object)longnumber);
                    continue;
                }
                if (!value2.toString().startsWith(oldPLongnumber)) continue;
                oldPnumber = this.kdDefinedSetTable.getCell(i, "number").getValue().toString();
                if (!value2.toString().equals(oldPLongnumber + "!" + oldPnumber)) continue;
                hasOtherChildren = true;
            }
            if (!hasOtherChildren && pRowIndex != -1) {
                this.kdDefinedSetTable.getCell(pRowIndex, "isLeaf").setValue((Object)(!hasOtherChildren ? 1 : 0));
            }
            this.afterDataFill_actionEvent(null);
        }
    }

    @Override
    protected void btnAddLine_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.kdDefinedSetTable.getRowCount();
        if (rowCount > 998) {
            this.showErrorMsg("MAX_ROW_SELFDEFINED", new Object[0]);
        }
        IRow addRow = this.kdDefinedSetTable.addRow();
        addRow.getCell(colKey).setValue((Object)(rowCount + 1));
        String number = this.bgPeriodTypeInfo.getNumber() + "." + "[Year]" + "." + this.getFormatStr(rowCount);
        addRow.getCell("number").setValue((Object)number);
        addRow.getCell("longNumber").setValue((Object)number);
        addRow.getCell("level").setValue((Object)1);
        addRow.getCell("showLevel").setValue((Object)(10000000 + rowCount));
        addRow.getCell("isLeaf").setValue((Object)true);
        NumberExpandInfo expandInfo = new NumberExpandInfo();
        expandInfo.setId(number);
        expandInfo.setLevel(1);
        expandInfo.setLeaf(true);
        expandInfo.setName("");
        expandInfo.setNumber(number);
        expandInfo.setLongNumber(number);
        expandInfo.setExpandStatus(true);
        addRow.getCell(colKey).setValue((Object)expandInfo);
        addRow.setUserObject((Object)expandInfo);
    }

    private String getFormatStr(int i) {
        String str = "[";
        str = i < 9 ? str + "00" + (i + 1) + "]" : (i >= 9 && i < 99 ? str + "0" + (i + 1) + "]" : str + (i + 1) + "]");
        return str;
    }

    @Override
    protected void btnDelLine_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.kdDefinedSetTable.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        int delLevel = Integer.parseInt(this.kdDefinedSetTable.getRow(rowIndex).getCell("level").getValue().toString());
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (int i = rowIndex + 1; i < this.kdDefinedSetTable.getRowCount(); ++i) {
            int selectlevel = Integer.parseInt(this.kdDefinedSetTable.getRow(i).getCell("level").getValue().toString());
            if (selectlevel == 1 || selectlevel != delLevel + 1) continue;
            rows.add(i);
        }
        for (Integer row : rows) {
            this.kdDefinedSetTable.getSelectManager().setActiveRowIndex(row.intValue());
            this.actionLeftMove_actionPerformed(e);
        }
        boolean hasSameLevel = false;
        for (int i = rowIndex + 1; i < this.kdDefinedSetTable.getRowCount(); ++i) {
            int selectlevel = Integer.parseInt(this.kdDefinedSetTable.getRow(i).getCell("level").getValue().toString());
            if (selectlevel != delLevel) continue;
            hasSameLevel = true;
        }
        if (!hasSameLevel && rowIndex > 0) {
            this.kdDefinedSetTable.getCell(rowIndex - 1, "isLeaf").setValue((Object)true);
        }
        this.kdDefinedSetTable.removeRow(rowIndex);
        this.afterDataFill_actionEvent(null);
    }

    private void initDefinedSetTable() {
        this.kdDefinedSetTable.getViewManager().setFreezeView(0, 3);
        this.kdDefinedSetTable.getSelectManager().setSelectMode(2);
        this.kdDefinedSetTable.getColumn(colKey).setRenderer((IBasicRender)this.getRender());
        this.kdDefinedSetTable.checkParsed();
    }

    protected void initListener() {
        super.initListener();
        this.kdDefinedSetTable.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    BgPeriodDispEditUI.this.afterDataFill_actionEvent(e);
                }
                catch (Exception ex) {
                    BgPeriodDispEditUI.this.handUIExceptionAndAbort(ex);
                }
            }
        });
    }

    protected void afterDataFill_actionEvent(KDTDataRequestEvent e) throws Exception {
        int beginIndex;
        int endIndex;
        int level = 0;
        IRow row = null;
        NumberExpandInfo expandInfo = null;
        Object id = null;
        String number = null;
        String longNumber = null;
        if (e == null) {
            endIndex = this.kdDefinedSetTable.getRowCount() - 1;
            beginIndex = 0;
        } else {
            beginIndex = e.getFirstRow();
            endIndex = e.getLastRow();
        }
        for (int index = beginIndex; index <= endIndex; ++index) {
            row = this.kdDefinedSetTable.getRow(index);
            number = row.getCell("number").getValue().toString();
            longNumber = row.getCell("longNumber").getValue().toString();
            level = (Integer)row.getCell("level").getValue();
            boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
            expandInfo = new NumberExpandInfo();
            expandInfo.setId(number);
            expandInfo.setLevel(level);
            expandInfo.setLeaf(isLeaf);
            expandInfo.setName(row.getCell(colKey).getValue().toString());
            expandInfo.setNumber(number);
            expandInfo.setLongNumber(longNumber);
            expandInfo.setExpandStatus(true);
            row.getCell(colKey).setValue((Object)expandInfo);
            row.setUserObject((Object)expandInfo);
        }
    }

    @Override
    protected void kdDefinedSetTable_tableClicked(KDTMouseEvent e) throws Exception {
        int clickCount;
        if (e.getType() == 1 ? (clickCount = e.getClickCount()) == 2 : e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            return;
        }
        super.kdDefinedSetTable_tableClicked(e);
        if (e.getType() == 1) {
            IRow row;
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            int clickCount2 = e.getClickCount();
            if (clickCount2 == 1 && (row = this.kdDefinedSetTable.getRow(rowIndex)) != null && colIndex == this.kdDefinedSetTable.getColumn(colKey).getColumnIndex() && row.getCell(colKey).getValue() instanceof NumberExpandInfo) {
                NumberExpandInfo expandInfo = (NumberExpandInfo)row.getCell(colKey).getValue();
                if (expandInfo == null) {
                    return;
                }
                if (this.getRender().inRect(expandInfo, e.getX(), e.getY())) {
                    this.setTreeDisplayStyle(row, expandInfo);
                }
            }
        }
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) throws Exception {
        boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
        if (!isLeaf) {
            this.kdDefinedSetTable.setRefresh(false);
            this.expandTable(row, expandInfo, expandInfo.isExpandStatus());
            this.kdDefinedSetTable.setRefresh(true);
            this.kdDefinedSetTable.reLayoutAndPaint();
        }
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo, boolean isExpandStatus) throws Exception {
        boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
        if (!isLeaf) {
            this.kdDefinedSetTable.setRefresh(false);
            this.expandTable(row, expandInfo, isExpandStatus);
            this.kdDefinedSetTable.setRefresh(true);
            this.kdDefinedSetTable.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo, boolean isExpandStatus) throws Exception {
        int rowIndex;
        if (row == null) {
            return;
        }
        IRow child = null;
        int parentLevel = parentExpandInfo.getLevel();
        String longNumber = null;
        String parentLongNumber = parentExpandInfo.getLongNumber();
        NumberExpandInfo expandInfo = null;
        int rowCount = this.kdDefinedSetTable.getRowCount3();
        if (isExpandStatus) {
            parentExpandInfo.setExpandStatus(false);
            for (rowIndex = row.getRowIndex() + 1; rowIndex < rowCount; ++rowIndex) {
                child = this.kdDefinedSetTable.getRow(rowIndex);
                if (child == null || child.getCell(colKey) == null) {
                    return;
                }
                expandInfo = (NumberExpandInfo)child.getCell(colKey).getValue();
                longNumber = expandInfo.getLongNumber();
                if (longNumber.startsWith(parentLongNumber + "!")) {
                    child.getStyleAttributes().setHided(true);
                    continue;
                }
                break;
            }
        } else {
            parentExpandInfo.setExpandStatus(true);
            while (rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.kdDefinedSetTable.getRow(rowIndex)).getCell(colKey).getValue()).getLongNumber()).startsWith(parentLongNumber + "!")) {
                if (expandInfo.getLevel() - parentLevel == 1) {
                    child.getStyleAttributes().setHided(false);
                    if (!expandInfo.isLeaf()) {
                        expandInfo.setExpandStatus(false);
                    }
                }
                ++rowIndex;
            }
        }
    }

    @Override
    protected void kdDefinedSetTable_editStopped(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        String columnKey = this.kdDefinedSetTable.getColumnKey(colIndex);
        IRow row = this.kdDefinedSetTable.getRow(e.getRowIndex());
        NumberExpandInfo info = (NumberExpandInfo)row.getUserObject();
        int activelevel = Integer.parseInt(this.kdDefinedSetTable.getRow(e.getRowIndex()).getCell("level").getValue().toString());
        if (e.getValue() == null) {
            info.setName("");
        } else if (!"endDate".equals(columnKey) && !"endDate".equals(columnKey) && colKey.equals(columnKey)) {
            info.setName(e.getValue().toString());
            if (!info.isLeaf()) {
                int sublevel;
                for (int i = e.getRowIndex(); i < this.kdDefinedSetTable.getRowCount() && this.kdDefinedSetTable.getRow(i + 1) != null && activelevel != (sublevel = Integer.parseInt(this.kdDefinedSetTable.getRow(i + 1).getCell("level").getValue().toString())); ++i) {
                    if (activelevel != sublevel - 1) continue;
                    this.kdDefinedSetTable.getRow(i + 1).getCell(colKeyP).setValue(this.kdDefinedSetTable.getRow(e.getRowIndex()).getCell(colKey).getValue());
                }
            }
        }
        row.getCell(colKey).setValue((Object)info);
    }

    public NumberExpendRender getRender() {
        return this.render;
    }

    protected IObjectValue createNewData() {
        return new BgPeriodInfo();
    }

    protected IBgPeriodDisp getBizInterface() throws Exception {
        return BgPeriodDispFactory.getRemoteInstance();
    }

    public CalendarHelper getCalHelper() {
        return this.helper;
    }

    private void showErrorMsg(String key, Object ... objects) {
        String msg = EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)key, (Object[])objects);
        MsgBox.showInfo((Component)((Object)this), (String)msg);
        SysUtil.abort();
    }

    @Override
    protected void cbxStrideYear_itemStateChanged(ItemEvent e) throws Exception {
        super.cbxStrideYear_itemStateChanged(e);
    }

    @Override
    protected void cbxStartTime_itemStateChanged(ItemEvent e) throws Exception {
        StartTimeInfo startTimeInfo = (StartTimeInfo)e.getItem();
        if (startTimeInfo.getStartTime() == 1) {
            this.cbxStrideYear.setEnabled(false);
            this.cbxStrideYear.setSelected(false);
        } else {
            this.cbxStrideYear.setEnabled(true);
        }
    }

    class StartTimeInfo {
        private final String suffix;
        private final int startTime;

        public StartTimeInfo(Integer startTime, String suffix) {
            this.startTime = startTime;
            this.suffix = suffix;
        }

        public int getStartTime() {
            return this.startTime;
        }

        public String toString() {
            return this.startTime + this.suffix;
        }
    }
}

