/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeCollection;
import com.kingdee.eas.ma.base.BgPeriodTypeFactory;
import com.kingdee.eas.ma.base.client.AbstractBgPeriodF7UI;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgPeriodF7UI
extends AbstractBgPeriodF7UI {
    private static final long serialVersionUID = -7217395579474718824L;
    private static final Logger logger = CoreUIObject.getLogger(BgPeriodF7UI.class);
    public static final String BGSCHEME_ID = BgBaseConstants.BGSCHEME_ID;
    public static final String PERIOD_NUMBER = "periodNumber";

    @Override
    public void onLoad() throws Exception {
        this.updateBeginDateAndEndDate();
        super.onLoad();
    }

    private static BgPeriodDispCollection getPeriodDisp(Set periodTypeIds, Set<String> pset) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("type.id", (Object)periodTypeIds, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.id", pset, CompareType.INCLUDE));
        BgPeriodDispCollection bgPeriodDispCollection = BgPeriodDispFactory.getRemoteInstance().getBgPeriodDispCollection(evi);
        return bgPeriodDispCollection;
    }

    public void onShow() throws Exception {
        super.onShow();
        BgPeriodInfo[] objs = (BgPeriodInfo[])this.getUIContext().get(BgBaseConstants.BGPERIOD_INFO);
        if (objs != null && objs.length > 0) {
            BgPeriodInfo bgPeriod;
            this.tblRight.addRows(objs.length);
            HashMap<String, String> peridName = new HashMap<String, String>();
            if (this.getUIContext().get(BgBaseConstants.BGSCHEME_ID) != null) {
                BgSchemeDimensionHelper helper = new BgSchemeDimensionHelper((String)this.getUIContext().get(BgBaseConstants.BGSCHEME_ID));
                Set periodTypeIds = BgSchemeDimensionHelper.getMemberSet((BgDimensionInfo)helper.getDimension(DimensionConstants.DEF_PERIOD_NUMBER), (boolean)false);
                HashSet<String> pset = new HashSet<String>();
                for (int i = 0; i < objs.length; ++i) {
                    bgPeriod = objs[i];
                    pset.add(bgPeriod.getId().toString());
                }
                BgPeriodDispCollection periodDispColls = BgPeriodF7UI.getPeriodDisp(periodTypeIds, pset);
                if (!periodDispColls.isEmpty()) {
                    BgPeriodDispInfo bgPeriodDispInfo = periodDispColls.get(0);
                    peridName.put(bgPeriodDispInfo.getNumber(), bgPeriodDispInfo.getAlias());
                }
            }
            HashSet<String> numbers = new HashSet<String>();
            for (int i = 0; i < objs.length; ++i) {
                bgPeriod = objs[i];
                IRow row = this.tblRight.getRow(i);
                row.getCell("number").setValue((Object)bgPeriod.getNumber());
                row.getCell("name").setValue((Object)bgPeriod.getName());
                if (peridName.isEmpty()) {
                    if (bgPeriod.getDisplayName() != null) {
                        row.getCell("alias").setValue((Object)(bgPeriod.getDisplayName().equals("\u4e00") ? bgPeriod.getName() : bgPeriod.getDisplayName()));
                        continue;
                    }
                    row.getCell("alias").setValue((Object)bgPeriod.getName());
                    continue;
                }
                row.getCell("alias").setValue(peridName.get(bgPeriod.getNumber()) != null ? peridName.get(bgPeriod.getNumber()) : bgPeriod.getName());
            }
            this.setSelectCombox(numbers);
        }
    }

    @Override
    public Object getData() throws BOSException, EASBizException {
        BgPeriodCollection col = this.getBgPeriodCollection();
        if (col != null && !col.isEmpty()) {
            BgPeriodInfo[] data = new BgPeriodInfo[col.size()];
            for (int i = 0; i < col.size(); ++i) {
                data[i] = col.get(i);
            }
            return data;
        }
        return null;
    }

    @Override
    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblRight.getSelectManager().setSelectMode(10);
    }

    @Override
    public void dataChanged(DataChangeEvent eventObj) {
        super.dataChanged(eventObj);
        this.tblRight.removeRows();
        Object[] objs = null;
        if (eventObj.getNewValue() instanceof Object[]) {
            objs = (Object[])eventObj.getNewValue();
        } else if (eventObj.getNewValue() instanceof Collection) {
            objs = ((Collection)eventObj.getNewValue()).toArray();
        } else if (eventObj.getNewValue() instanceof BgPeriodCollection) {
            objs = ((BgPeriodCollection)((Object)eventObj.getNewValue())).toArray();
        }
        if (objs == null || objs.length == 0 || objs.length == 1 && objs[0] == null) {
            this.setSelectCombox(null);
            return;
        }
        this.tblRight.addRows(objs.length);
        HashSet<String> numbers = new HashSet<String>();
        for (int i = 0; i < objs.length; ++i) {
            IRow row = this.tblRight.getRow(i);
            String number = this.getNumber(objs[i]);
            row.getCell("number").setValue((Object)number);
            row.getCell("name").setValue((Object)this.getName(objs[i]));
            if (this.getAlias(objs[i]) != null) {
                row.getCell("alias").setValue((Object)this.getAlias(objs[i]));
                continue;
            }
            row.getCell("alias").setValue((Object)this.getName(objs[i]));
        }
        this.setSelectCombox(numbers);
    }

    @Override
    protected void loadBgPeriodType() {
        Object bgSchemeID = this.getUIContext().get(BgBaseConstants.BGSCHEME_ID);
        if (bgSchemeID == null) {
            super.loadBgPeriodType();
        } else {
            try {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(new FilterInfo());
                evi.setSelector(new SelectorItemCollection());
                evi.setSorter(new SorterItemCollection());
                evi.getSelector().add("*");
                SorterItemInfo info0 = new SorterItemInfo("simplename");
                info0.setSortType(SortType.ASCEND);
                evi.getSorter().add(info0);
                SorterItemInfo info1 = new SorterItemInfo("isSysdata");
                info1.setSortType(SortType.DESCEND);
                evi.getSorter().add(info1);
                SorterItemInfo info2 = new SorterItemInfo("number");
                info2.setSortType(SortType.ASCEND);
                evi.getSorter().add(info2);
                String sql = "SELECT type.FID FROM T_Mbg_BgScheme scheme  join T_Mbg_BgDimSettings dim on dim.FBgschemeID = scheme.FID  join T_Mbg_BgDimSettingsMember dimMember on dimMember.FBgDimsettingsID = dim.FID  join T_MBG_BgPeriodType type on  type.FID = dimMember.FMemberID  where scheme.FID = '" + bgSchemeID.toString() + "'";
                evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
                BgPeriodTypeCollection coll = BgPeriodTypeFactory.getRemoteInstance().getBgPeriodTypeCollection(evi);
                this.cbxBgPeriodType.removeAllItems();
                if (coll != null && !coll.isEmpty()) {
                    this.cbxBgPeriodType.addItems(coll.toArray());
                    this.selectDefaultBgPeriodType();
                }
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.updateBeginDateAndEndDate();
        this.loadBgPeriodType();
        this.loadYear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBeginDateAndEndDate() {
        String bgSchemeId = (String)this.getUIContext().get(BgBaseConstants.BGSCHEME_ID);
        if (bgSchemeId == null) {
            return;
        }
        if (bgSchemeId != null) {
            IRowSet rs = null;
            Date dateFrom = null;
            Date dateTo = null;
            try {
                String sql = "SELECT fdateFrom,fdateto  FROM T_Mbg_BgScheme    where FID = '" + bgSchemeId.toString() + "'";
                rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
                while (rs.next()) {
                    rs.getObject(1);
                    dateFrom = new Date(rs.getTimestamp(1).getTime());
                    dateTo = new Date(rs.getTimestamp(2).getTime());
                }
                this.getUIContext().put("beginDate", dateFrom);
                this.getUIContext().put("endDate", dateTo);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }
}

