/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.IBgPeriod;
import com.kingdee.eas.ma.base.client.AbstractBgPeriodListUI;
import com.kingdee.eas.ma.base.client.BgPeriodEditUI;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.NumberExpendRender;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class BgPeriodListUI
extends AbstractBgPeriodListUI {
    private static final long serialVersionUID = 9033160447490172969L;
    private static final Logger logger = CoreUIObject.getLogger(BgPeriodListUI.class);
    protected int selYear = 0;
    protected NumberExpendRender render = new NumberExpendRender(1);

    public NumberExpendRender getRender() {
        return this.render;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    protected void init() {
        this.initUI();
        this.initBase();
    }

    protected void initUI() {
        this.tblMain.getColumn("number").setRenderer((IBasicRender)this.getRender());
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getColumn("beginDate").getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
    }

    protected void initBase() {
        this.queryYearPeriod();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRemoveYear.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.menuItemRemoveYear.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.btnExpand.setIcon(EASResource.getIcon((String)"imgTbtn_upenumnew"));
        this.btnConstriction.setIcon(EASResource.getIcon((String)"imgTbtn_upenumdel"));
        BgCommCHelper.disableVisible((JButton)this.btnEdit, (JMenuItem)this.menuItemEdit);
        BgCommCHelper.disableVisible((JButton)this.btnView, (JMenuItem)this.menuItemView);
        BgCommCHelper.enableAction((JButton)this.btnRemoveYear);
        BgCommCHelper.disableVisible((JButton)this.btnExpand, null);
        BgCommCHelper.disableVisible((JButton)this.btnConstriction, null);
        BgCommCHelper.disableVisible((JButton)this.btnLocate, (JMenuItem)this.menuItemLocate);
        this.menuItemRemoveYear.setEnabled(true);
        this.menuItemRemoveYear.setVisible(true);
    }

    protected String getEditUIName() {
        return BgPeriodEditUI.class.getName();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgPeriodFactory.getRemoteInstance();
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    BgPeriodListUI.this.afterDataFill_actionEvent(e);
                }
                catch (Exception ex) {
                    BgPeriodListUI.this.handUIExceptionAndAbort(ex);
                }
            }
        });
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return super.getSelectors();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (this.comYear.getSelectedItem() instanceof BgPeriodInfo) {
            BgPeriodInfo periodInfo = (BgPeriodInfo)this.comYear.getSelectedItem();
            filter.getFilterItems().add(new FilterItemInfo("year", (Object)periodInfo.getYear(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("year", (Object)1900, CompareType.EQUALS));
        }
        return filter;
    }

    @Override
    protected void comYear_actionPerformed(ActionEvent e) throws Exception {
        super.comYear_actionPerformed(e);
        if (this.comYear.getSelectedItem() instanceof BgPeriodInfo) {
            BgPeriodInfo periodInfo = (BgPeriodInfo)this.comYear.getSelectedItem();
            this.querySelectedPeriod(periodInfo.getYear());
        }
    }

    public void queryYearPeriod() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        SorterItemInfo sort = new SorterItemInfo("year");
        sort.setSortType(SortType.DESCEND);
        view.getSorter().add(sort);
        try {
            CoreBaseCollection colls = this.getBizInterface().getCollection(view);
            if (colls != null) {
                this.comYear.removeAllItems();
                this.comYear.addItems(colls.toArray());
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    public void querySelectedPeriod(int year) {
        if (this.selYear != year) {
            this.selYear = year;
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("year", (Object)year, CompareType.EQUALS));
            this.mainQuery.setFilter(filter);
            this.execQuery();
        }
    }

    public void setSelectedPeriod(int year) {
        this.selYear = year;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void reQueryYearPeriod(int year) {
        this.queryYearPeriod();
        int itemCount = this.comYear.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            BgPeriodInfo periodInfo = (BgPeriodInfo)this.comYear.getItemAt(i);
            Object object = periodInfo.get("year");
            if (Integer.valueOf(object.toString()) != year) continue;
            this.querySelectedPeriod(periodInfo.getYear());
            this.setSelectedPeriod(year);
            this.comYear.setSelectedItem((Object)periodInfo);
            break;
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
    }

    @Override
    protected void btnExpand_actionPerformed(ActionEvent e) throws Exception {
        super.btnExpand_actionPerformed(e);
        int rowSize = this.tblMain.getBody().size();
        if (rowSize == 0) {
            return;
        }
        IRow row = null;
        NumberExpandInfo expandInfo = null;
        for (int i = 0; i < rowSize; ++i) {
            row = this.tblMain.getRow(i);
            if (row == null) continue;
            expandInfo = (NumberExpandInfo)row.getCell("number").getValue();
            expandInfo.setExpandStatus(true);
            row.getStyleAttributes().setHided(false);
        }
        this.tblMain.setRowCount(rowSize);
    }

    @Override
    protected void btnConstriction_actionPerformed(ActionEvent e) throws Exception {
        super.btnConstriction_actionPerformed(e);
        int rowSize = this.tblMain.getBody().size();
        if (rowSize == 0) {
            return;
        }
        IRow row = null;
        NumberExpandInfo expandInfo = null;
        for (int i = 0; i < rowSize; ++i) {
            row = this.tblMain.getRow(i);
            if (row == null) continue;
            expandInfo = (NumberExpandInfo)row.getCell("number").getValue();
            expandInfo.setExpandStatus(false);
            if (i <= 0) continue;
            row.getStyleAttributes().setHided(true);
        }
        this.tblMain.setRowCount(1);
    }

    protected void afterDataFill_actionEvent(KDTDataRequestEvent e) throws Exception {
        int beginIndex = e.getFirstRow();
        int endIndex = e.getLastRow();
        int level = 0;
        Object numberValue = null;
        String id = null;
        String number = null;
        String longNumber = null;
        IRow row = null;
        NumberExpandInfo expandInfo = null;
        for (int index = beginIndex; index <= endIndex; ++index) {
            row = this.tblMain.getRow(index);
            id = (String)row.getCell("id").getValue();
            numberValue = row.getCell("number").getValue();
            if (!(numberValue instanceof String)) {
                return;
            }
            number = numberValue.toString();
            longNumber = row.getCell("longNumber").getValue().toString();
            level = (Integer)row.getCell("level").getValue();
            boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
            expandInfo = new NumberExpandInfo();
            expandInfo.setId(id);
            expandInfo.setLevel(level);
            expandInfo.setLeaf(isLeaf);
            expandInfo.setNumber(number);
            expandInfo.setLongNumber(longNumber);
            expandInfo.setExpandStatus(true);
            expandInfo.setName(number);
            row.getCell("number").setValue((Object)expandInfo);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int clickCount;
        if (e.getType() == 1 && (clickCount = e.getClickCount()) == 2) {
            return;
        }
        super.tblMain_tableClicked(e);
        if (e.getType() == 1) {
            IRow row;
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            int clickCount2 = e.getClickCount();
            if (clickCount2 == 1 && (row = this.tblMain.getRow(rowIndex)) != null && colIndex == this.tblMain.getColumn("number").getColumnIndex()) {
                NumberExpandInfo expandInfo = (NumberExpandInfo)row.getCell("number").getValue();
                if (this.getRender().inRect(expandInfo, e.getX(), e.getY())) {
                    this.setTreeDisplayStyle(row, expandInfo);
                }
            }
            if (clickCount2 == 2) {
                return;
            }
        }
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) throws Exception {
        boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
        if (!isLeaf) {
            this.tblMain.setRefresh(false);
            this.expandTable(row, expandInfo);
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo) throws Exception {
        if (row == null) {
            return;
        }
        IRow child = null;
        int parentLevel = parentExpandInfo.getLevel();
        String longNumber = null;
        String parentLongNumber = null;
        NumberExpandInfo expandInfo = null;
        parentLongNumber = parentExpandInfo.getLongNumber();
        boolean isExpandStatus = parentExpandInfo.isExpandStatus();
        if (isExpandStatus) {
            parentExpandInfo.setExpandStatus(false);
            int rowCount = this.tblMain.getRowCount3();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell("number").getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                child.getStyleAttributes().setHided(true);
            }
        } else {
            parentExpandInfo.setExpandStatus(true);
            int rowCount = this.tblMain.getRowCount3();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell("number").getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                if (expandInfo.getLevel() - parentLevel != 1) continue;
                child.getStyleAttributes().setHided(false);
                if (expandInfo.isLeaf()) continue;
                expandInfo.setExpandStatus(false);
            }
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    protected boolean confirmRemove() {
        int re = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgPeriodResource", "isRemove"));
        return MsgBox.isYes((int)re);
    }

    protected void Remove() throws Exception {
        ArrayList periodIds = this.getSelectedIdValues();
        if (periodIds != null) {
            ObjectUuidPK[] pks = new ObjectUuidPK[periodIds.size()];
            int in = periodIds.size();
            for (int i = 0; i < in; ++i) {
                pks[i] = new ObjectUuidPK((String)periodIds.get(i));
            }
            this.getBizInterface().deleteBatchData((IObjectPK[])pks);
            this.queryYearPeriod();
        }
    }

    @Override
    public void actionRemoveYear_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveYear_actionPerformed(e);
        int re = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"isRemoveAll"));
        if (re == 1 || re == 2) {
            return;
        }
        BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.comYear.getSelectedItem();
        if (bgPeriodInfo != null) {
            ((IBgPeriod)this.getBizInterface()).deleteYearPeriod(bgPeriodInfo.getYear());
            this.queryYearPeriod();
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        return super.prepareInit();
    }
}

