/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.IBgPeriodDisp;
import com.kingdee.eas.ma.base.client.AbstractBgPeriodOfOnlySelfDispEditUI;
import com.kingdee.eas.ma.base.client.BgPeriodTreeListUI;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;

public class BgPeriodOfOnlySelfDispEditUI
extends AbstractBgPeriodOfOnlySelfDispEditUI {
    private static final long serialVersionUID = 7632299287845784159L;
    private static final Logger logger = CoreUIObject.getLogger(BgPeriodOfOnlySelfDispEditUI.class);
    public static final int MAX_ROW = 998;
    public static final String colKey = "selfDefinedName";
    protected BgPeriodTypeInfo bgPeriodTypeInfo = null;
    protected BgPeriodDispInfo parentBgPeriodDispInfo = null;
    protected List<BgPeriodDispInfo> list = new ArrayList<BgPeriodDispInfo>();
    protected String parentId = null;
    protected String selectId = null;
    private int sequence = 1;
    protected Map<String, BgPeriodDispInfo> oldInfoMap = new HashMap<String, BgPeriodDispInfo>();
    protected ArrayList<BgPeriodDispInfo> otherPeriodDispInfos = new ArrayList();
    protected List<BgPeriodInfo> detailList = new ArrayList<BgPeriodInfo>();
    protected CalendarHelper helper = new CalendarHelper();
    BgPeriodInfo parentBgPeriodInfo = null;
    private boolean isModify = true;

    protected IObjectValue createNewData() {
        BgPeriodDispInfo info = new BgPeriodDispInfo();
        return info;
    }

    protected IBgPeriodDisp getBizInterface() throws Exception {
        return BgPeriodDispFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.detailTable.checkParsed();
        super.onLoad();
        this.prmtBgPeriodNumber.setEnabled(false);
        KDDatePicker detailTable_DatePicker = new KDDatePicker();
        detailTable_DatePicker.setName("datePicker");
        detailTable_DatePicker.setVisible(true);
        detailTable_DatePicker.setEditable(true);
        KDTDefaultCellEditor detailTable_Editor = new KDTDefaultCellEditor(detailTable_DatePicker);
        this.detailTable.getColumn(2).setEditor((ICellEditor)detailTable_Editor);
        this.detailTable.getColumn(3).setEditor((ICellEditor)detailTable_Editor);
        BgPeriodTypeInfo typeInfo = (BgPeriodTypeInfo)this.getUIContext().get("UI_KEY_BGPERIODTYPEINFO");
        if (this.getUIContext().get("UI_KEY_BGPERIODINFO_ID") != null) {
            this.selectId = this.getUIContext().get("UI_KEY_BGPERIODINFO_ID").toString();
        }
        this.bgPeriodTypeInfo = typeInfo;
        this.init();
    }

    private void init() {
        this.loadPeriodMemberOfType(this.bgPeriodTypeInfo.getId().toString());
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            if (this.parentBgPeriodDispInfo != null) {
                this.prmtBgPeriodNumber.setText(this.parentBgPeriodDispInfo.getNumber());
                this.prmtBgPeriodName.setText(this.parentBgPeriodDispInfo.getName());
                this.kDBeginDatePicker.setValue((Object)this.parentBgPeriodDispInfo.getBeginDate());
                this.kDEndDatePicker.setValue((Object)this.parentBgPeriodDispInfo.getEndDate());
            }
            this.loadDetailTable();
        } else {
            String number = this.bgPeriodTypeInfo.getNumber() + "." + Calendar.getInstance().get(1) + "Y" + "." + this.getFormatNumberIndex();
            this.prmtBgPeriodNumber.setText(number);
            this.prmtBgPeriodName.setText(null);
            this.kDBeginDatePicker.setValue((Object)new Date());
            this.kDEndDatePicker.setValue((Object)new Date());
            this.setParentPeriodDateIsEnbled(true);
            this.detailTable.removeRows();
        }
    }

    private void loadDetailTable() {
        this.detailTable.removeRows();
        int newRowCount = 0;
        if (this.list == null || this.list.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            IRow addRow = this.detailTable.addRow();
            ++newRowCount;
            addRow.getCell(colKey).setValue((Object)this.list.get(i).getName());
            addRow.getCell("number").setValue((Object)this.list.get(i).getNumber());
            addRow.getCell("level").setValue((Object)2);
            addRow.getCell("showLevel").setValue((Object)this.list.get(i).getNumber());
            addRow.getCell("isLeaf").setValue((Object)true);
            addRow.getCell("beginDate").setValue((Object)this.list.get(i).getBeginDate());
            addRow.getCell("endDate").setValue((Object)this.list.get(i).getEndDate());
        }
        this.setParentPeriodDateIsEnbled(false);
        this.detailTable.setRowCount(newRowCount);
    }

    private void loadPeriodMemberOfType(String typeId) {
        BgPeriodDispInfo info = null;
        try {
            int i;
            BgPeriodDispCollection collection = this.getBizInterface().getBgPeriodDispCollection("select id,number,longNumber,name,beginDate,endDate,parent.id,showLevel,level,bgPeriod.id where type.id = '" + typeId + "'");
            if (collection == null || collection.isEmpty()) {
                return;
            }
            int tempSequence = 1;
            for (i = 0; i < collection.size(); ++i) {
                String substring;
                info = collection.get(i);
                if (info.getNumber().equals(info.getLongNumber()) && tempSequence < Integer.parseInt(substring = info.getNumber().substring(11))) {
                    tempSequence = Integer.parseInt(substring);
                }
                if (this.selectId != null && this.selectId.equals(info.getId().toString())) {
                    if (info.getParent() != null) {
                        this.parentId = info.getParent().getId().toString();
                        continue;
                    }
                    this.parentId = this.selectId;
                    continue;
                }
                if (this.parentBgPeriodInfo == null || !this.parentBgPeriodInfo.getNumber().equals(info.getNumber())) continue;
                this.parentId = info.getId().toString();
            }
            this.sequence = tempSequence + 1;
            this.oldInfoMap.clear();
            this.list.clear();
            this.otherPeriodDispInfos.clear();
            for (i = 0; i < collection.size(); ++i) {
                info = collection.get(i);
                if (info.getId().toString().equals(this.parentId)) {
                    this.parentBgPeriodDispInfo = info;
                    this.oldInfoMap.put(this.parentBgPeriodDispInfo.getNumber(), this.parentBgPeriodDispInfo);
                    continue;
                }
                if (info.getParent() != null && info.getParent().getId().toString().equals(this.parentId)) {
                    this.oldInfoMap.put(info.getNumber(), info);
                    this.list.add(info);
                    continue;
                }
                this.otherPeriodDispInfos.add(info);
            }
            Collections.sort(this.list, new Comparator<BgPeriodDispInfo>(){

                @Override
                public int compare(BgPeriodDispInfo o1, BgPeriodDispInfo o2) {
                    if (o1.getBeginDate() != null || o2.getBeginDate() != null) {
                        return o1.getBeginDate().compareTo(o2.getBeginDate());
                    }
                    return -1;
                }
            });
        }
        catch (Exception e) {
            logger.info((Object)e.getCause().getMessage());
        }
    }

    private boolean checkDetailTableIsEmpty() {
        return this.detailTable.getRowCount() <= 0;
    }

    private void verifyRequiredItem() {
        if (StringUtils.isEmpty((String)this.prmtBgPeriodNumber.getText())) {
            this.showErrorMsg("periodNumberIsNull", new Object[0]);
        }
        if (StringUtils.isEmpty((String)this.prmtBgPeriodName.getText())) {
            this.showErrorMsg("periodNameIsNull", new Object[0]);
        }
        if (this.detailTable.getRowCount() == 0) {
            if (this.kDBeginDatePicker.getValue() == null) {
                this.showErrorMsg("beginDateIsNull", new Object[0]);
            }
            if (this.kDEndDatePicker.getValue() == null) {
                this.showErrorMsg("endDateIsNull", new Object[0]);
            }
        } else {
            boolean flag = false;
            for (int i = 0; i < this.detailTable.getRowCount(); ++i) {
                boolean bl = flag = this.detailTable.getRow(i).getCell(colKey).getValue() == null || this.detailTable.getRow(i).getCell("beginDate").getValue() == null || this.detailTable.getRow(i).getCell("endDate").getValue() == null;
                if (!flag) continue;
                this.showErrorMsg("detailPeriodHasNull", new Object[0]);
            }
        }
    }

    private void verifyDumplicate() throws Exception {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < this.otherPeriodDispInfos.size(); ++i) {
            names.add(this.otherPeriodDispInfos.get(i).getName());
        }
        String failMsg = new String();
        if (names.contains(this.parentBgPeriodInfo.getName())) {
            this.showErrorMsg("selfDefinedPeriodIsDumpt", this.parentBgPeriodInfo.getName());
        } else {
            names.add(this.parentBgPeriodInfo.getName());
        }
        if (this.detailTable.getRowCount() != 0) {
            for (int i = 0; i < this.detailTable.getRowCount(); ++i) {
                if (names.contains(this.detailTable.getRow(i).getCell(colKey).getValue().toString())) {
                    this.showErrorMsg("selfDefinedPeriodIsDumpt", this.detailTable.getRow(i).getCell(colKey).getValue().toString());
                    continue;
                }
                names.add(this.detailTable.getRow(i).getCell(colKey).getValue().toString());
            }
        }
    }

    private void verifyPeriodValid() {
        int i;
        StringBuffer msg = new StringBuffer();
        for (i = 0; i < this.detailList.size(); ++i) {
            if (!this.detailList.get(i).getBeginDate().before(this.detailList.get(i).getEndDate()) || this.detailList.get(i).getBeginDate().toString().equals(this.detailList.get(i).getEndDate().toString())) {
                this.showErrorMsg("beginAfterEndDate", this.detailList.get(i).getName());
            }
            if (i >= this.detailList.size() - 1) continue;
            if (BgNPeriodHelper.isAcross(this.detailList.get(i).getBeginDate(), this.detailList.get(i).getEndDate(), this.detailList.get(i + 1).getBeginDate(), this.detailList.get(i + 1).getEndDate())) {
                this.showErrorMsg("dateCross", this.detailList.get(i).getName());
            }
            if (DateUtils.isSameDay((Date)BgNPeriodHelper.dateAddOne(this.detailList.get(i).getEndDate()), (Date)this.detailList.get(i + 1).getBeginDate())) continue;
            this.showErrorMsg("periodNotContinue", new Object[0]);
        }
        if (!this.detailList.isEmpty()) {
            this.parentBgPeriodInfo.setBeginDate(this.detailList.get(0).getBeginDate());
            this.parentBgPeriodInfo.setEndDate(this.detailList.get(this.detailList.size() - 1).getEndDate());
        }
        if (this.parentBgPeriodInfo != null) {
            if (!this.parentBgPeriodInfo.getBeginDate().before(this.parentBgPeriodInfo.getEndDate()) || this.parentBgPeriodInfo.getBeginDate().toString().equals(this.parentBgPeriodInfo.getEndDate().toString())) {
                this.showErrorMsg("beginAfterEndDate", this.parentBgPeriodInfo.getName());
            }
            int count = this.otherPeriodDispInfos.size();
            for (i = 0; i < count; ++i) {
                if (this.otherPeriodDispInfos.get(i).getBeginDate() == null || this.otherPeriodDispInfos.get(i).getEndDate() == null || !BgNPeriodHelper.isAcross(this.parentBgPeriodInfo.getBeginDate(), this.parentBgPeriodInfo.getEndDate(), this.otherPeriodDispInfos.get(i).getBeginDate(), this.otherPeriodDispInfos.get(i).getEndDate())) continue;
                if (msg.length() > 1) {
                    msg.append("\r\n");
                }
                this.showErrorMsg("dateCross", this.parentBgPeriodInfo.getName());
            }
        }
        this.kDBeginDatePicker.setValue((Object)this.parentBgPeriodInfo.getBeginDate());
        this.kDEndDatePicker.setValue((Object)this.parentBgPeriodInfo.getEndDate());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.kDContainer1.addButton((JButton)this.addRow);
        this.kDContainer1.addButton((JButton)this.deleteRow);
    }

    @Override
    protected void btnAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.checkPeriodUsed(BgPeriodException.ADDDELLINEPERIOD);
        int rowCount = this.detailTable.getRowCount();
        if (rowCount > 998) {
            this.showErrorMsg("MAX_ROW_SELFDEFINED", new Object[0]);
        }
        IRow addRow = this.detailTable.addRow();
        KDDatePicker detailTable_DatePicker = new KDDatePicker();
        detailTable_DatePicker.setName("datePicker");
        detailTable_DatePicker.setVisible(true);
        detailTable_DatePicker.setEditable(true);
        KDTDefaultCellEditor detailTable_Editor = new KDTDefaultCellEditor(detailTable_DatePicker);
        addRow.getCell("beginDate").setEditor((ICellEditor)detailTable_Editor);
        addRow.getCell("endDate").setEditor((ICellEditor)detailTable_Editor);
        addRow.getCell("beginDate").setValue((Object)new Date());
        addRow.getCell("endDate").setValue((Object)new Date());
        addRow.getCell("level").setValue((Object)2);
        addRow.getCell("showLevel").setValue((Object)(10000000 + rowCount));
        addRow.getCell("isLeaf").setValue((Object)true);
        this.setParentPeriodDateIsEnbled(false);
    }

    private void showErrorMsg(String key, Object ... objects) {
        String msg = EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)key, (Object[])objects);
        MsgBox.showInfo((Component)((Object)this), (String)msg);
        SysUtil.abort();
    }

    @Override
    protected void btnDelLine_actionPerformed(ActionEvent e) throws Exception {
        this.checkPeriodUsed(BgPeriodException.ADDDELLINEPERIOD);
        this.checkSelected();
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = this.detailTable.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (this.detailTable.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                this.detailTable.removeRow(rowIndex);
            }
            if (this.detailTable.getRow(0) != null) {
                this.detailTable.getSelectManager().select(0, 0);
            }
        }
        if (this.detailTable.getRowCount() == 0) {
            this.setParentPeriodDateIsEnbled(true);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkPeriodUsed(BgPeriodException.EDITDELPERIOD);
        this.verifyRequiredItem();
        Map<String, List<BgPeriodInfo>> infos = this.getSelfDefinedPeriodInfoMap();
        this.verifyDumplicate();
        this.verifyPeriodValid();
        if (!this.oldInfoMap.isEmpty()) {
            Object[] array = this.oldInfoMap.values().toArray();
            ObjectUuidPK pk = null;
            for (int i = 0; i < this.oldInfoMap.values().size(); ++i) {
                if (((BgPeriodDispInfo)array[i]).getLevel() != 1) continue;
                pk = new ObjectUuidPK(((BgPeriodDispInfo)array[i]).getId());
            }
            if (pk != null) {
                this.getBizInterface().delete((IObjectPK)pk);
            }
        }
        if (infos.get("addNew") != null) {
            List<BgPeriodInfo> addNewList = infos.get("addNew");
            this.getBizInterface().addBatchData(addNewList, this.bgPeriodTypeInfo.getId().toString());
        }
        if (this.getUIContext().get("Owner") instanceof BgPeriodTreeListUI) {
            ((BgPeriodTreeListUI)((Object)this.getUIContext().get("Owner"))).actionRefresh_leftTable();
        }
        this.loadPeriodMemberOfType(this.bgPeriodTypeInfo.getId().toString());
        this.loadDetailTable();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"saveSuccess"));
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.setOprtState(OprtState.ADDNEW);
        this.selectId = null;
        this.parentBgPeriodInfo = null;
        this.parentId = null;
        this.init();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int re = -1;
        re = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgPeriodResource", "deleteSelfDefiend"));
        if (!MsgBox.isYes((int)re)) {
            return;
        }
        if (this.parentBgPeriodDispInfo != null) {
            this.getBizInterface().delete((IObjectPK)new ObjectUuidPK(this.parentBgPeriodDispInfo.getId()));
        }
        this.isModify = false;
        this.getUIWindow().close();
        BgNFCHelper.refreshListUI((CoreUI)this);
    }

    private Map<String, List<BgPeriodInfo>> getSelfDefinedPeriodInfoMap() {
        this.detailList.clear();
        ArrayList<BgPeriodInfo> addNewList = new ArrayList<BgPeriodInfo>();
        HashMap<String, List<BgPeriodInfo>> result = new HashMap<String, List<BgPeriodInfo>>();
        BgPeriodInfo info = null;
        this.parentBgPeriodInfo = new BgPeriodInfo();
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.parentBgPeriodInfo.setId(this.oldInfoMap.get(this.prmtBgPeriodNumber.getText()).getBgPeriod().getId());
        } else {
            this.parentBgPeriodInfo.setId(BOSUuid.create((BOSObjectType)this.parentBgPeriodInfo.getBOSType()));
        }
        String substring = this.prmtBgPeriodNumber.getText().substring(11);
        this.parentBgPeriodInfo.setShowLevel(Integer.parseInt(substring) * 1000);
        this.parentBgPeriodInfo.setPeriodType(BgPeriodEnum.ONLYSELFPERIOD_DETAIL);
        this.parentBgPeriodInfo.setIsLeaf(true);
        this.parentBgPeriodInfo.setLevel(1);
        this.parentBgPeriodInfo.setNumber(this.prmtBgPeriodNumber.getText());
        this.parentBgPeriodInfo.setLongNumber(this.prmtBgPeriodNumber.getText());
        this.parentBgPeriodInfo.setName(this.prmtBgPeriodName.getText());
        this.parentBgPeriodInfo.setBeginDate(this.helper.getStartDate((Date)this.kDBeginDatePicker.getValue()));
        this.parentBgPeriodInfo.setEndDate(this.helper.getBeoverDate((Date)this.kDEndDatePicker.getValue()));
        this.parentBgPeriodInfo.setYear(Calendar.getInstance().get(1));
        this.parentBgPeriodInfo.setSimpleName(Calendar.getInstance().get(1) + "");
        if (this.detailTable.getRowCount() > 0) {
            int i;
            int count = this.detailTable.getRowCount();
            for (i = 0; i < count; ++i) {
                Object value = this.detailTable.getRow(i).getCell(colKey).getValue();
                info = new BgPeriodInfo();
                info.setParent(this.parentBgPeriodInfo);
                info.setPeriodType(BgPeriodEnum.ONLYSELFPERIOD_DETAIL);
                info.setNumber(this.prmtBgPeriodNumber.getText() + "." + this.getFormatStr(i));
                info.setName(value.toString());
                info.setLongNumber(this.parentBgPeriodInfo.getNumber() + "!" + info.getNumber());
                info.setLevel(2);
                info.setShowLevel(this.parentBgPeriodInfo.getShowLevel() + i + 1);
                info.setIsLeaf(true);
                Date beginDate = (Date)this.detailTable.getRow(i).getCell("beginDate").getValue();
                Date endDate = (Date)this.detailTable.getRow(i).getCell("endDate").getValue();
                info.setBeginDate(this.helper.getStartDate(beginDate));
                info.setEndDate(this.helper.getBeoverDate(endDate));
                info.setYear(Calendar.getInstance().get(1));
                info.setSimpleName(Calendar.getInstance().get(1) + "");
                if (this.oldInfoMap.containsKey(info.getNumber())) {
                    info.setId(this.oldInfoMap.get(info.getNumber()).getId());
                } else {
                    info.setId(BOSUuid.create((BOSObjectType)this.parentBgPeriodInfo.getBOSType()));
                }
                this.detailList.add(info);
            }
            Collections.sort(this.detailList, new Comparator<BgPeriodInfo>(){

                @Override
                public int compare(BgPeriodInfo o1, BgPeriodInfo o2) {
                    return o1.getBeginDate().compareTo(o2.getBeginDate());
                }
            });
            for (i = 0; i < this.detailList.size(); ++i) {
                this.detailList.get(i).setNumber(this.prmtBgPeriodNumber.getText() + "." + this.getFormatStr(i));
                this.detailList.get(i).setLongNumber(this.parentBgPeriodInfo.getNumber() + "!" + this.detailList.get(i).getNumber());
                this.detailList.get(i).setShowLevel(this.parentBgPeriodInfo.getShowLevel() + i + 1);
            }
            addNewList.addAll(this.detailList);
            this.parentBgPeriodInfo.setIsLeaf(false);
            this.parentBgPeriodInfo.setPeriodType(BgPeriodEnum.ONLYSELFPERIOD_NO_DETAIL);
        }
        addNewList.add(this.parentBgPeriodInfo);
        if (!addNewList.isEmpty()) {
            result.put("addNew", addNewList);
        }
        return result;
    }

    private String getFormatStr(int i) {
        String str = "";
        str = i < 9 ? str + "00" + (i + 1) : (i >= 9 && i < 99 ? str + "0" + (i + 1) : str + (i + 1));
        return str;
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    private int getMaxSequence() throws BOSException {
        int sequence = 1;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add("number");
        coll.add("longnumber");
        coll.add("showlevel");
        coll.add("id");
        coll.add("bgPeriod.id");
        coll.add("bgPeriod.number");
        coll.add("bgPeriod.longnumber");
        view.setSelector(coll);
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("type.id", (Object)this.bgPeriodTypeInfo.getId());
        view.getSorter().add(new SorterItemInfo("number"));
        view.setFilter(filter);
        IBgPeriodDisp instance = null;
        instance = BgPeriodDispFactory.getRemoteInstance();
        BgPeriodDispCollection bgPeriodCollection = instance.getBgPeriodDispCollection(view);
        if (bgPeriodCollection != null && !bgPeriodCollection.isEmpty()) {
            for (int i = bgPeriodCollection.size() - 1; i >= 0; --i) {
                BgPeriodDispInfo bgPeriodDispInfo = bgPeriodCollection.get(i);
                if (!bgPeriodDispInfo.getNumber().equals(bgPeriodDispInfo.getLongNumber())) continue;
                String substring = bgPeriodDispInfo.getNumber().substring(11);
                sequence = Integer.parseInt(substring) + 1;
                break;
            }
        }
        return sequence;
    }

    private String getFormatNumberIndex() {
        String str = "";
        str = this.sequence <= 9 ? str + "000" + this.sequence : (this.sequence >= 10 && this.sequence <= 99 ? str + "00" + this.sequence : (this.sequence >= 100 && this.sequence <= 999 ? str + "0" + this.sequence : str + this.sequence));
        ++this.sequence;
        return str;
    }

    private void setParentPeriodDateIsEnbled(boolean flag) {
        this.kDBeginDatePicker.setEnabled(flag);
        this.kDEndDatePicker.setEnabled(flag);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        ((BgPeriodDispInfo)this.editData).setNumber(this.prmtBgPeriodNumber.getText());
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public boolean isModify() {
        this.isModify = this.parentBgPeriodInfo != null ? this.checkisModify(this.parentBgPeriodInfo, this.detailList) : (this.parentBgPeriodDispInfo == null ? true : this.checkisModify(this.parentBgPeriodDispInfo, this.list));
        return this.isModify;
    }

    private void checkSelected() {
        if (this.detailTable.getRowCount() == 0 || this.detailTable.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private void checkPeriodUsed(NumericExceptionSubItem info) throws Exception {
        boolean flag;
        if (this.parentId == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("type.*");
        selector.add("id");
        selector.add("number");
        selector.add("longNumber");
        ObjectUuidPK pk = new ObjectUuidPK(this.parentId);
        BgPeriodDispInfo bgPeriodDispInfo = this.getBizInterface().getBgPeriodDispInfo((IObjectPK)pk, selector);
        String longNumber = bgPeriodDispInfo.getLongNumber();
        BgPeriodTypeInfo type = bgPeriodDispInfo.getType();
        String preNumber = null;
        preNumber = longNumber.indexOf(BgBaseConstants.SEP_ONE_STR) > 0 ? longNumber.substring(0, longNumber.indexOf(BgBaseConstants.SEP_ONE_STR)) : longNumber;
        String innerSql = "select Fbgperiodid from t_mbg_bgperioddisp where fnumber ='" + preNumber + "' or flongNumber like '" + preNumber + "!%'";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)innerSql, CompareType.INNER));
        view.setFilter(filter);
        BgPeriodCollection bgPeriodCollection = BgPeriodFactory.getRemoteInstance().getBgPeriodCollection(view);
        ArrayList<BgPeriodInfo> periods = new ArrayList<BgPeriodInfo>();
        if (bgPeriodCollection != null && !bgPeriodCollection.isEmpty()) {
            for (int i = 0; i < bgPeriodCollection.size(); ++i) {
                periods.add(bgPeriodCollection.get(i));
            }
        }
        if (flag = this.getBizInterface().isUse(periods)) {
            throw new BgPeriodException(info);
        }
    }

    private boolean checkisModify(Object parent, List detailList) {
        Date endDate;
        Date beginDate;
        String name;
        if (parent instanceof BgPeriodInfo) {
            BgPeriodInfo parBgPeriodInfo = (BgPeriodInfo)parent;
            name = parBgPeriodInfo.getName();
            beginDate = parBgPeriodInfo.getBeginDate();
            endDate = parBgPeriodInfo.getEndDate();
        } else {
            BgPeriodDispInfo parBgPeriodDispInfo = (BgPeriodDispInfo)parent;
            name = parBgPeriodDispInfo.getName();
            beginDate = parBgPeriodDispInfo.getBeginDate();
            endDate = parBgPeriodDispInfo.getEndDate();
        }
        if (!(name.equals(this.prmtBgPeriodName.getText()) && beginDate != null && endDate != null && DateUtils.isSameDay((Date)beginDate, (Date)((Date)this.kDBeginDatePicker.getValue())) && DateUtils.isSameDay((Date)endDate, (Date)((Date)this.kDEndDatePicker.getValue())))) {
            return true;
        }
        if (this.detailTable.getRowCount() != detailList.size()) {
            return true;
        }
        for (int i = 0; i < this.detailTable.getRowCount(); ++i) {
            if (detailList.get(i) instanceof BgPeriodInfo) {
                name = ((BgPeriodInfo)detailList.get(i)).getName();
                beginDate = ((BgPeriodInfo)detailList.get(i)).getBeginDate();
                endDate = ((BgPeriodInfo)detailList.get(i)).getEndDate();
            } else {
                name = ((BgPeriodDispInfo)detailList.get(i)).getName();
                beginDate = ((BgPeriodDispInfo)detailList.get(i)).getBeginDate();
                endDate = ((BgPeriodDispInfo)detailList.get(i)).getEndDate();
            }
            if (name.equals(this.detailTable.getRow(i).getCell(colKey).getValue().toString()) && beginDate != null && endDate != null && DateUtils.isSameDay((Date)beginDate, (Date)((Date)this.detailTable.getRow(i).getCell("beginDate").getValue())) && DateUtils.isSameDay((Date)endDate, (Date)((Date)this.detailTable.getRow(i).getCell("endDate").getValue()))) continue;
            return true;
        }
        return false;
    }
}

