/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgPropertyCollection;
import com.kingdee.eas.ma.base.BgPropertyFactory;
import com.kingdee.eas.ma.base.BgPropertyInfo;
import com.kingdee.eas.ma.base.BgPropertySortCollection;
import com.kingdee.eas.ma.base.BgPropertySortFactory;
import com.kingdee.eas.ma.base.BgPropertySortInfo;
import com.kingdee.eas.ma.base.IBgProperty;
import com.kingdee.eas.ma.base.IBgPropertySort;
import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.base.MemberSegregationRuleEnum;
import com.kingdee.eas.ma.base.client.AbstractBgPropertyParentF7UI;
import com.kingdee.eas.ma.base.client.utils.NumberExpandHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgPropertyParentF7UI
extends AbstractBgPropertyParentF7UI {
    private static final Logger logger = CoreUIObject.getLogger(BgPropertyParentF7UI.class);
    private boolean isCancel = true;
    private BgPropertyInfo resultOne = null;
    private boolean isFilterText = true;
    boolean isChooseOne = true;
    private String propertyId = null;
    private String sortId = null;
    private List hadSelectedProperty;
    private NumberExpandHelper numberHelper = null;
    private String sourceType = null;
    private String mbgDimID = null;
    private Set<String> parentAndChildOrgUnitIds = null;
    private MbgViewInfo mbgViewInfo = null;
    private CostCenterOrgUnitInfo orgUnitInfo = null;
    private BgPropertySortInfo propertySortInfo = null;
    private BgPropertyCollection result = new BgPropertyCollection();

    private NumberExpandHelper getNumberExpandHelper() {
        if (this.numberHelper == null) {
            this.numberHelper = new NumberExpandHelper(this, this.tblMain);
        }
        return this.numberHelper;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("hadSelectedProperty") instanceof List) {
            this.hadSelectedProperty = (List)this.getUIContext().get("hadSelectedProperty");
        }
        this.btnPropSearch.setText("");
        this.btnPropSearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.tblMain.checkParsed();
        super.onLoad();
        this.getNumberExpandHelper();
        this.isFilterText = (Boolean)this.getUIContext().get("isFilterText");
        this.isChooseOne = (Boolean)this.getUIContext().get("isChooseOne");
        if (this.getUIContext().get("propertyIdQuery") != null) {
            this.propertyId = this.getUIContext().get("propertyIdQuery").toString();
        }
        if (this.getUIContext().get("propertySortId") != null) {
            this.sortId = this.getUIContext().get("propertySortId").toString();
        }
        if (this.getUIContext().get(BgBaseConstants.BGPROPSORT_SOURCE) != null) {
            this.sourceType = this.getUIContext().get(BgBaseConstants.BGPROPSORT_SOURCE).toString();
        }
        this.mbgDimID = this.getUIContext().get(BgBaseConstants.BGMBGDIM_ID) != null ? this.getUIContext().get(BgBaseConstants.BGMBGDIM_ID).toString() : null;
        this.parentAndChildOrgUnitIds = this.getUIContext().get(BgBaseConstants.ORGUNIT_IDS) != null ? (Set)this.getUIContext().get(BgBaseConstants.ORGUNIT_IDS) : null;
        this.mbgViewInfo = this.getUIContext().get(BgBaseConstants.MBGVIEWINFO) != null ? (MbgViewInfo)this.getUIContext().get(BgBaseConstants.MBGVIEWINFO) : null;
        this.orgUnitInfo = this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO) != null ? (CostCenterOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO) : null;
        this.propertySortInfo = this.getUIContext().get(BgBaseConstants.BGPROPSORT_INFO) != null ? (BgPropertySortInfo)this.getUIContext().get(BgBaseConstants.BGPROPSORT_INFO) : null;
        this.putDataToKDTable();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.colSetLocked();
    }

    private void putDataToKDTable() {
        if (this.queryBgPropertyQuery == null) {
            this.queryBgPropertyQuery = new EntityViewInfo();
        }
        this.txtPropSearch.setUserObject((Object)this.txtPropSearch.getText());
        FilterInfo filter = new FilterInfo();
        if (this.isFilterText) {
            if (this.txtPropSearch.getText().trim().length() > 0) {
                this.tblMain.removeRows();
                FilterItemInfo item = new FilterItemInfo("description", (Object)('%' + this.txtPropSearch.getText() + '%'), CompareType.LIKE);
                filter.getFilterItems().add(item);
                item = new FilterItemInfo("number", (Object)('%' + this.txtPropSearch.getText() + '%'), CompareType.LIKE);
                filter.getFilterItems().add(item);
                item = new FilterItemInfo("name", (Object)('%' + this.txtPropSearch.getText() + '%'), CompareType.LIKE);
                filter.getFilterItems().add(item);
                filter.setMaskString(" (#" + String.valueOf(filter.getFilterItems().size() - 3) + ") or (#" + String.valueOf(filter.getFilterItems().size() - 2) + ") or (#" + String.valueOf(filter.getFilterItems().size() - 1) + "))");
            }
        } else if (this.txtPropSearch.getText().trim().length() > 0) {
            this.tblMain.removeRows();
            FilterItemInfo item = new FilterItemInfo("number", (Object)('%' + this.txtPropSearch.getText() + '%'), CompareType.LIKE);
            filter.getFilterItems().add(item);
            item = new FilterItemInfo("name", (Object)('%' + this.txtPropSearch.getText() + '%'), CompareType.LIKE);
            filter.getFilterItems().add(item);
            item = new FilterItemInfo("description", (Object)('%' + this.txtPropSearch.getText() + '%'), CompareType.LIKE);
            filter.getFilterItems().add(item);
            filter.setMaskString(" (#" + String.valueOf(filter.getFilterItems().size() - 3) + ") or (#" + String.valueOf(filter.getFilterItems().size() - 2) + ") or (#" + String.valueOf(filter.getFilterItems().size() - 1) + "))");
        }
        this.queryBgPropertyQuery.setFilter(filter);
        this.tblMain.removeRows();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("longNumber");
        sic.add("level");
        sic.add("isLeaf");
        sic.add("parent.id");
        sic.add("parent.Number");
        sic.add("parent.name");
        sic.add("parent.longNumber");
        sic.add("parent.level");
        return sic;
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if ((viewInfo = viewInfo != null ? (EntityViewInfo)viewInfo.clone() : new EntityViewInfo()).getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        IQueryExecutor ex = super.getQueryExecutor(queryPK, viewInfo);
        FilterInfo filter = new FilterInfo();
        Set<String> set = null;
        Object sortSet = null;
        Object setIn = null;
        try {
            set = this.getPropAllChildren(this.propertyId);
        }
        catch (Exception e1) {
            logger.error((Object)"getPropAllChildren err");
        }
        if (set != null && !set.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.NOTINCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("bgpropertysort.id", (Object)this.sortId, CompareType.EQUALS));
        this.addSegregationFilter(filter);
        if (this.txtPropSearch.getText().trim().length() > 0) {
            FilterInfo _ft = new FilterInfo();
            FilterItemInfo item = new FilterItemInfo("description", (Object)('%' + this.txtPropSearch.getText() + '%'), CompareType.LIKE);
            _ft.getFilterItems().add(item);
            item = new FilterItemInfo("number", (Object)('%' + this.txtPropSearch.getText() + '%'), CompareType.LIKE);
            _ft.getFilterItems().add(item);
            item = new FilterItemInfo("name", (Object)('%' + this.txtPropSearch.getText() + '%'), CompareType.LIKE);
            _ft.getFilterItems().add(item);
            _ft.setMaskString("#0 or #1 or #2");
            try {
                filter.mergeFilter(_ft, "and");
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
        viewInfo.setFilter(filter);
        viewInfo.getSorter().clear();
        SorterItemCollection sorts = viewInfo.getSorter();
        SorterItemInfo sort = new SorterItemInfo("longNumber");
        sorts.add(sort);
        viewInfo.setSorter(sorts);
        try {
            this.getNumberExpandHelper().setFilter(viewInfo.getFilter(), (ICoreBase)BgPropertyFactory.getRemoteInstance());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        return ex;
    }

    protected Set<String> getPropSortByFilter() {
        BgPropertySortCollection sortCollection = null;
        IBgPropertySort iPropertySort = null;
        BgPropertySortInfo sortInfo = null;
        HashSet<String> set = new HashSet<String>();
        try {
            iPropertySort = BgPropertySortFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (this.sourceType != null) {
                filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)this.sourceType, CompareType.EQUALS));
            }
            if (this.mbgDimID != null) {
                filter.getFilterItems().add(new FilterItemInfo("mbgDim.id", (Object)this.mbgDimID, CompareType.EQUALS));
            }
            view.setFilter(filter);
            sortCollection = iPropertySort.getBgPropertySortCollection(view);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        if (sortCollection != null && !sortCollection.isEmpty()) {
            int len = sortCollection.size();
            for (int i = 0; i < len; ++i) {
                sortInfo = sortCollection.get(i);
                set.add(sortInfo.getId().toString());
            }
        }
        return set;
    }

    protected Set<String> getPropBySortId(String sortId) throws BOSException, EASBizException {
        if (sortId == null) {
            return new HashSet<String>();
        }
        BgPropertyInfo propertyInfo = null;
        BgPropertyCollection propertyCollection = null;
        HashSet<String> set = new HashSet<String>();
        IBgProperty iProperty = BgPropertyFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgpropertysort", (Object)sortId, CompareType.EQUALS));
        view.setFilter(filter);
        propertyCollection = iProperty.getBgPropertyCollection(view);
        if (propertyCollection != null && !propertyCollection.isEmpty()) {
            int len = propertyCollection.size();
            for (int i = 0; i < len; ++i) {
                propertyInfo = propertyCollection.get(i);
                set.add(propertyInfo.getId().toString());
            }
        }
        return set;
    }

    protected Set<String> getPropAllChildren(String propertyId) throws BOSException, EASBizException {
        if (propertyId == null) {
            return new HashSet<String>();
        }
        BgPropertyInfo propertyInfo = null;
        BgPropertyCollection propertyCollection = null;
        HashSet<String> set = new HashSet<String>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("longnumber");
        IBgProperty iProperty = BgPropertyFactory.getRemoteInstance();
        propertyInfo = (BgPropertyInfo)iProperty.getValue((IObjectPK)new ObjectUuidPK(propertyId), sic);
        if (propertyInfo != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(propertyInfo.getLongNumber() + "!%"), CompareType.LIKE));
            view.setFilter(filter);
            SorterItemCollection sort = new SorterItemCollection();
            sort.add(new SorterItemInfo("longNumber"));
            view.setSorter(sort);
            propertyCollection = iProperty.getBgPropertyCollection(view);
        }
        set.add(propertyId);
        if (propertyCollection != null && !propertyCollection.isEmpty()) {
            int len = propertyCollection.size();
            for (int i = 0; i < len; ++i) {
                propertyInfo = propertyCollection.get(i);
                set.add(propertyInfo.getId().toString());
            }
        }
        return set;
    }

    private void colSetLocked() {
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("description").getStyleAttributes().setLocked(true);
    }

    @Override
    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.queryBgPropertyQuery != null) {
            int start = (Integer)e.getParam1();
            int length = (Integer)e.getParam2() - start + 1;
            try {
                IQueryExecutor exec = this.getQueryExecutor(this.queryBgPropertyQueryPK, this.queryBgPropertyQuery);
                exec.option().isAutoTranslateEnum = true;
                IRowSet rowSet = exec.executeQuery(start, length);
                e.setRowSet(rowSet);
                this.onGetRowSet(rowSet);
            }
            catch (Exception ee) {
                this.handUIException(ee);
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        if (!this.isChooseOne) {
            IRow initRow = this.tblMain.getRow(0);
            if (initRow == null) {
                return;
            }
            initRow.getCell("choose").setValue((Object)Boolean.FALSE);
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                this.tblMain.getRow(i).getCell("choose").setValue((Object)Boolean.FALSE);
                if (this.hadSelectedProperty == null || this.hadSelectedProperty.isEmpty() || !this.hadSelectedProperty.contains(this.tblMain.getCell(i, 1).getValue().toString())) continue;
                this.tblMain.getRow(i).getCell("choose").setValue((Object)Boolean.TRUE);
            }
        }
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.onBtnConfirm();
        }
    }

    private void onBtnConfirm() throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        int currRow = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow iRow = this.tblMain.getRow(currRow);
        if (!this.isChooseOne) {
            iRow.getCell("choose").setValue((Object)Boolean.TRUE);
            this.isCancel = false;
        } else {
            String id = iRow.getCell("id").getValue().toString();
            try {
                IBgProperty iProperty = BgPropertyFactory.getRemoteInstance();
                this.resultOne = (BgPropertyInfo)iProperty.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            }
            catch (BOSException ex) {
                logger.error((Object)ex.getMessage());
                throw ex;
            }
            catch (EASBizException ex) {
                logger.error((Object)ex.getMessage());
                throw ex;
            }
            this.isCancel = false;
            this.getUIWindow().close();
        }
    }

    protected BgPropertyCollection getResult() {
        return this.result;
    }

    protected BgPropertyInfo getResultOne() {
        return this.resultOne;
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        if (this.isChooseOne) {
            int currRow = this.tblMain.getSelectManager().getActiveRowIndex();
            if (currRow != -1) {
                IRow iRow = this.tblMain.getRow(currRow);
                String id = iRow.getCell("id").getValue().toString();
                try {
                    IBgProperty iProperty = BgPropertyFactory.getRemoteInstance();
                    this.resultOne = (BgPropertyInfo)iProperty.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                }
                catch (BOSException ex) {
                    logger.error((Object)ex.getMessage());
                    throw ex;
                }
                catch (EASBizException ex) {
                    logger.error((Object)ex.getMessage());
                    throw ex;
                }
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertyResource", (String)"selectBgName"));
            }
        } else {
            Object info = null;
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                Object value = this.tblMain.getRow(i).getCell("choose").getValue();
                if (value == null || !value.toString().equals("true")) continue;
                IRow iRow = this.tblMain.getRow(i);
                String id = iRow.getCell("id").getValue().toString();
                idSet.add(id);
            }
            if (idSet.isEmpty()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertyResource", (String)"selectBgName"));
                return;
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.getSelector().addObjectCollection((IObjectCollection)this.queryBgPropertyQuery.getSelector());
            view.setFilter(filter);
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo sortInfo = new SorterItemInfo("longNumber");
            sorter.add(sortInfo);
            view.setSorter(sorter);
            try {
                IBgProperty iProperty = BgPropertyFactory.getRemoteInstance();
                CoreBaseCollection col = iProperty.getCollection(view);
                this.result = new BgPropertyCollection();
                if (col != null) {
                    this.result.addObjectCollection((IObjectCollection)col);
                }
            }
            catch (BOSException ex) {
                logger.error((Object)ex.getMessage());
                throw ex;
            }
        }
        if (this.resultOne != null || !this.result.isEmpty()) {
            this.isCancel = false;
            this.getUIWindow().close();
        }
    }

    @Override
    protected void btnPropSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnPropSearch_actionPerformed(e);
        this.putDataToKDTable();
        this.processChooseCols();
    }

    protected void processChooseCols() {
        for (int i = 0; i < this.tblMain.getBody().size(); ++i) {
            if (this.isChooseOne) {
                this.tblMain.getColumn("choose").getStyleAttributes().setHided(true);
                continue;
            }
            this.tblMain.getRow(i).getCell("choose").setValue((Object)Boolean.FALSE);
        }
        if (this.tblMain.getBody().size() == 1) {
            this.tblMain.getRow(0).getCell("choose").setValue((Object)Boolean.TRUE);
            this.tblMain.getSelectManager().select(0, 0, 0, 0);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    @Override
    protected void txtPropSearch_focusLost(FocusEvent e) throws Exception {
        super.txtPropSearch_focusLost(e);
        if (StringUtils.equals((String)((String)this.txtPropSearch.getUserObject()), (String)this.txtPropSearch.getText())) {
            return;
        }
        this.putDataToKDTable();
        this.processChooseCols();
    }

    private void addSegregationFilter(FilterInfo filter) {
        if ("D177852B".equals(this.sourceType) && this.mbgViewInfo != null && this.propertySortInfo != null && 1 == this.propertySortInfo.getSegregationRule().getValue()) {
            MemberSegregationRuleEnum segregationRule = this.mbgViewInfo.getSegregationRule();
            if (MemberSegregationRuleEnum.SEGREGATEORG.equals((Object)segregationRule)) {
                FilterItemInfo orgItemInfo = new FilterItemInfo("orgUnit.id", (Object)this.orgUnitInfo.getId().toString(), CompareType.EQUALS);
                BgCommCHelper.replaceFilterItems(filter, orgItemInfo);
            } else if (MemberSegregationRuleEnum.SEGREGATEEQUALS.equals((Object)segregationRule) && this.parentAndChildOrgUnitIds != null && !this.parentAndChildOrgUnitIds.isEmpty()) {
                FilterItemInfo orgItemInfo = new FilterItemInfo("orgUnit.id", this.parentAndChildOrgUnitIds, CompareType.INCLUDE);
                BgCommCHelper.replaceFilterItems(filter, orgItemInfo);
            }
        }
    }
}

