/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgPropertySortFactory;
import com.kingdee.eas.ma.base.BgPropertySortInfo;
import com.kingdee.eas.ma.base.IBgPropertySort;
import com.kingdee.eas.ma.base.IMbgDim;
import com.kingdee.eas.ma.base.MbgDimFactory;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.PropertySegregationRuleEnum;
import com.kingdee.eas.ma.base.client.AbstractBgPropertySortEditUI;
import com.kingdee.eas.ma.base.client.BgPropertyF7UI;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class BgPropertySortEditUI
extends AbstractBgPropertySortEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BgPropertySortEditUI.class);
    private String sourceType = null;

    @Override
    public void storeFields() {
        super.storeFields();
        IObjectValue dataObject = this.getDataObject();
        if (dataObject instanceof BgPropertySortInfo) {
            BgPropertySortInfo info = (BgPropertySortInfo)dataObject;
            if (!(this.sourceType == null || info.getSourceType() != null && info.getSourceType().equals(this.sourceType))) {
                info.setSourceType(this.sourceType);
            }
        }
        if (this.shareGlobal.isSelected()) {
            this.editData.setSegregationRule(PropertySegregationRuleEnum.SHAREDGLOBAL);
        } else if (this.segregateMemberEquals.isSelected()) {
            this.editData.setSegregationRule(PropertySegregationRuleEnum.SEGREGATEMEMBEREQUALS);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.prmtOrgUnit.setEnabled(false);
    }

    public void onLoad() throws Exception {
        this.sourceType = this.getUIContext().get(BgBaseConstants.BGPROPSORT_SOURCE).toString();
        super.onLoad();
        if (PropertySegregationRuleEnum.SHAREDGLOBAL.equals((Object)this.editData.getSegregationRule())) {
            this.shareGlobal.setSelected(true);
        } else if (PropertySegregationRuleEnum.SEGREGATEMEMBEREQUALS.equals((Object)this.editData.getSegregationRule())) {
            this.segregateMemberEquals.setSelected(true);
        }
    }

    protected void loadData() throws Exception {
        super.loadData();
        this.initPrmtOrgUnit();
    }

    private void initPrmtOrgUnit() {
        CostCenterOrgUnitInfo unitInfo = null;
        String curUnitID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        String optState = this.getOprtState();
        if (OprtState.ADDNEW.equals(optState)) {
            unitInfo = (CostCenterOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        } else if (OprtState.EDIT.equals(optState) || OprtState.VIEW.equals(optState)) {
            unitInfo = this.editData.getOrgUnit();
        }
        BgCommCHelper.initOrgUnit((CoreUIObject)this, this.prmtOrgUnit, unitInfo, curUnitID);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            BgCommCHelper.disableAction((JButton)this.btnSubmit, null);
        }
        this.initState();
        if ("D177852B".equals(this.sourceType)) {
            this.propertySegregationRule.setVisible(true);
        } else {
            this.propertySegregationRule.setVisible(false);
            this.repaintOrgAndAccPanel();
        }
    }

    private void repaintOrgAndAccPanel() {
        this.kDTextField1.setBounds(new Rectangle(110, 96, 170, 19));
        this.labDescription.setBounds(new Rectangle(10, 96, 100, 19));
        this.txtDescription.setBounds(new Rectangle(10, 124, 280, 190));
        this.repaint();
    }

    protected void initState() {
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(false);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        BgPropertySortInfo sortInfo;
        CostCenterOrgUnitInfo orgInfo = (CostCenterOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        List<BOSUuid> allChildOrg = this.getAllChildOrgIds(orgInfo);
        if (!allChildOrg.contains((sortInfo = this.editData).getOrgUnit().getId())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertySortResource", (String)"notModifyByOrg"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        BgPropertySortInfo sortInfo;
        CostCenterOrgUnitInfo orgInfo = (CostCenterOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        List<BOSUuid> allChildOrg = this.getAllChildOrgIds(orgInfo);
        if (!allChildOrg.contains((sortInfo = this.editData).getOrgUnit().getId())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertySortResource", (String)"notDeleteByOrg"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
        this.getUIWindow().close();
    }

    protected List<BOSUuid> getAllChildOrgIds(CostCenterOrgUnitInfo _orgUnitInfo) throws BOSException, EASBizException {
        ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
        list.add(_orgUnitInfo.getId());
        IObjectCollection _collection = this.getOrgAllChildren(_orgUnitInfo.getId());
        if (_collection != null && !_collection.isEmpty()) {
            int in = _collection.size();
            for (int i = 0; i < in; ++i) {
                CostCenterOrgUnitInfo _ccOrgUnitInfo = (CostCenterOrgUnitInfo)_collection.getObject(i);
                if (_ccOrgUnitInfo.isIsSealUp()) continue;
                list.add(_ccOrgUnitInfo.getId());
            }
            _collection.clear();
        }
        return list;
    }

    protected IObjectCollection getOrgAllChildren(BOSUuid orgUnitId) throws BOSException, EASBizException {
        if (orgUnitId == null) {
            return new CostCenterOrgUnitCollection();
        }
        CostCenterOrgUnitInfo unitInfo = null;
        CostCenterOrgUnitCollection unitCollection = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("longnumber");
        ICostCenterOrgUnit iOrgUnit = CostCenterOrgUnitFactory.getRemoteInstance();
        unitInfo = (CostCenterOrgUnitInfo)iOrgUnit.getValue((IObjectPK)new ObjectUuidPK(orgUnitId), sic);
        if (unitInfo != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(unitInfo.getLongNumber() + "!%"), CompareType.LIKE));
            view.setFilter(filter);
            SorterItemCollection sort = new SorterItemCollection();
            sort.add(new SorterItemInfo("number"));
            view.setSorter(sort);
            unitCollection = iOrgUnit.getCostCenterOrgUnitCollection(view);
        }
        return unitCollection;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        Object object = this.getUIContext().get("Owner");
        super.actionSubmit_actionPerformed(e);
        if (object instanceof BgPropertyF7UI) {
            ((BgPropertyF7UI)object).initTree();
            ((BgPropertyF7UI)object).setSelectTreeNode(this.txtNumber.getText());
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        Object selectedItem;
        Object data;
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertySortResource", (String)"numberIsNull"));
                SysUtil.abort();
            } else if (!BgNumberHelper.checkNumber(this.txtNumber.getText())) {
                this.txtNumber.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "haveEspecial"));
                SysUtil.abort();
            }
        }
        if (BgDBUtils.length(this.txtNumber.getText()) > 80) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertySortResource", (String)"numberIsOverMax", (Object[])new Object[]{80}));
            SysUtil.abort();
        }
        if ((data = ((MultiLangItem)(selectedItem = this.txtName.getModel().getSelectedItem())).getData()) == null || StringUtils.isEmpty((String)data.toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertySortResource", (String)"nameIsNull"));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        BgPropertySortInfo info = new BgPropertySortInfo();
        info.setOrgUnit((CostCenterOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
        info.setIsLeaf(true);
        info.setSourceType(this.getUIContext().get(BgBaseConstants.BGPROPSORT_SOURCE).toString());
        if (this.getUIContext().get(BgBaseConstants.BGMBGDIM_ID) == null) {
            info.setMbgDim(null);
        } else {
            String mbgDimID = this.getUIContext().get(BgBaseConstants.BGMBGDIM_ID).toString();
            MbgDimInfo dimInfo = null;
            try {
                dimInfo = this.getMbgDimInterface().getMbgDimInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)mbgDimID)));
            }
            catch (Exception e) {
                logger.error((Object)("propertySort create err" + e.getMessage()));
            }
            info.setMbgDim(dimInfo);
        }
        if (this.shareGlobal.isSelected()) {
            info.setSegregationRule(PropertySegregationRuleEnum.SHAREDGLOBAL);
        } else if (this.segregateMemberEquals.isSelected()) {
            info.setSegregationRule(PropertySegregationRuleEnum.SEGREGATEMEMBEREQUALS);
        }
        return info;
    }

    private IMbgDim getMbgDimInterface() throws BOSException {
        return MbgDimFactory.getRemoteInstance();
    }

    protected IBgPropertySort getBizInterface() throws Exception {
        return BgPropertySortFactory.getRemoteInstance();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.txtNumber.setEnabled(true);
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selector = super.getSelectors();
        selector.add("mbgDim.id");
        selector.add("segregationRule");
        return selector;
    }
}

