/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPropertySortCollection;
import com.kingdee.eas.ma.base.BgPropertySortFactory;
import com.kingdee.eas.ma.base.BgPropertySortInfo;
import com.kingdee.eas.ma.base.client.AbstractBgPropertySortF7UI;
import com.kingdee.eas.ma.base.client.utils.ISimpleQuickQueryHandler;
import com.kingdee.eas.ma.base.client.utils.SimpleQuickQueryHandler;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgPropertySortF7UI
extends AbstractBgPropertySortF7UI
implements ISimpleQuickQueryHandler,
DataChangeListener {
    private static final long serialVersionUID = 7071476386789632249L;
    private static final Logger logger = CoreUIObject.getLogger(BgPropertySortF7UI.class);
    protected boolean isCancel = true;
    private boolean isShowExtSort = true;
    private boolean ishideDimension = false;
    public static final String DIMENSION_NUMBER = "DIMENSION_NUMBER";
    public static final String BGSCHEME_ID = BgBaseConstants.BGSCHEME_ID;
    public static final String SELECT_ID = "SELECT_ID";
    public static final String SHOW_EXT_SORT = "SHOW_EXT_SORT";
    protected BgPropertySortCollection data = null;
    public static final String IS_HIDE_DIMENSION = "IS_HIDE_DIMENSION";
    private Set<String> selectedProp = null;
    private List<BgPropertySortInfo> result = null;
    private static final String COL_Selected = "selected";
    private static final String COL_id = "id";
    private static final String COL_Dimension = "dimension";
    private static final String COL_Number = "number";
    private static final String COL_Name = "name";
    private SimpleQuickQueryHandler quickQuery = null;

    public void onLoad() throws Exception {
        this.ishideDimension = (Boolean)this.getUIContext().get(IS_HIDE_DIMENSION) == null ? this.ishideDimension : (Boolean)this.getUIContext().get(IS_HIDE_DIMENSION);
        super.onLoad();
        this.quickQuery = new SimpleQuickQueryHandler(this.txtSearch, this);
        this.executeQuery();
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblMain.checkParsed();
        if (this.ishideDimension) {
            this.tblMain.getColumn(COL_Dimension).getStyleAttributes().setHided(true);
        } else {
            this.tblMain.getColumn(COL_Dimension).getStyleAttributes().setHided(false);
        }
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnSearch_actionPerformed(e);
        this.executeQuery();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        this.data = new BgPropertySortCollection();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!Boolean.TRUE.equals(row.getCell(COL_Selected).getValue())) continue;
            this.data.add((BgPropertySortInfo)row.getUserObject());
        }
        this.isCancel = false;
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    protected void txtSearch_focusLost(FocusEvent e) throws Exception {
        super.txtSearch_focusLost(e);
        if (StringUtils.equals((String)this.quickQuery.getFilterString((String)this.txtSearch.getUserObject()), (String)this.quickQuery.getFilterString(this.txtSearch.getText()))) {
            return;
        }
        this.executeQuery();
    }

    @Override
    public void doQuickQuery() {
        try {
            this.executeQuery();
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    protected void executeQuery() throws EASBizException, BOSException {
        this.txtSearch.setUserObject((Object)this.txtSearch.getText());
        Set dimNumbers = (Set)this.getUIContext().get(DIMENSION_NUMBER);
        this.selectedProp = (Set)this.getUIContext().get(SELECT_ID);
        this.isShowExtSort = (Boolean)this.getUIContext().get(SHOW_EXT_SORT) == null ? this.isShowExtSort : (Boolean)this.getUIContext().get(SHOW_EXT_SORT);
        this.result = BgPropertySortFactory.getRemoteInstance().querySort(dimNumbers, this.quickQuery.getFilterString(), this.isShowExtSort);
        this.fillData();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public BgPropertySortCollection getData() {
        if (null != this.data && !this.data.isEmpty()) {
            return this.data;
        }
        return null;
    }

    public void dataChanged(DataChangeEvent eventObj) {
        BgPropertySortInfo info = null;
        Object newValue = eventObj.getNewValue();
        this.selectedProp = new HashSet<String>();
        if (newValue != this.data) {
            if (newValue != null && newValue instanceof BgPropertySortCollection) {
                BgPropertySortCollection col = (BgPropertySortCollection)((Object)newValue);
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    info = (BgPropertySortInfo)it.next();
                    this.selectedProp.add(info.getId().toString() + BgBaseConstants.COMBINATE_SPLITER_TABLE + info.getNumber());
                }
            }
            this.fillData();
            this.data = (BgPropertySortCollection)((Object)eventObj.getNewValue());
        }
    }

    private void fillData() {
        this.tblMain.removeRows();
        this.tblMain.addRows(this.result.size());
        if (this.result != null && !this.result.isEmpty()) {
            String key = null;
            int rowIndex = 0;
            boolean isSelected = false;
            for (int flag = 0; flag < 2; ++flag) {
                for (int i = 0; i < this.result.size(); ++i) {
                    BgPropertySortInfo info = this.result.get(i);
                    key = (info.getId() != null ? info.getId().toString() : null) + "_" + info.getNumber();
                    boolean bl = isSelected = this.selectedProp != null && this.selectedProp.contains(key);
                    if ((flag != 0 || !isSelected) && (flag != 1 || isSelected)) continue;
                    IRow row = this.tblMain.getRow(rowIndex);
                    ++rowIndex;
                    row.setUserObject((Object)info);
                    row.getCell(COL_id).setValue((Object)info.getId());
                    row.getCell(COL_Dimension).setValue(info.get(BgBaseConstants.DIMENSION_NAME));
                    row.getCell(COL_Number).setValue((Object)info.getNumber());
                    row.getCell(COL_Name).setValue((Object)info.getName());
                    row.getCell(COL_Selected).setValue((Object)isSelected);
                }
            }
        }
    }
}

