/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgBaseFacadeFactory;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioNodeCollection;
import com.kingdee.eas.ma.base.BgScenarioNodeFactory;
import com.kingdee.eas.ma.base.BgScenarioNodeInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.client.AbstractBgScenarioEditUI;
import com.kingdee.eas.ma.base.client.BgScenarioBaseDialog;
import com.kingdee.eas.ma.base.client.MyFormat;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class BgScenarioEditUI
extends AbstractBgScenarioEditUI {
    private static final long serialVersionUID = -381045803368025315L;
    private static final Logger logger = CoreUIObject.getLogger(BgScenarioEditUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            BgCommCHelper.setDisable((Component)this.contType);
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            BgCommCHelper.setDisable((Component)this.txtNumber);
            BgCommCHelper.setDisable((Component)this.contType);
            if (this.editData.getIsSysData() == 1) {
                this.txtName.setEnabled(false);
            }
        }
        this.prmtParent.setEditable(false);
        this.contParent.setVisible(false);
        this.contParent.setEnabled(false);
        this.prmtParent.setVisible(false);
        this.prmtParent.setEnabled(false);
        this.setActPrmt();
        this.prmtActScenarios.setEditFormatter((IFormatter)new MyFormat("number"));
        this.prmtActScenarios.setDisplayFormatter((IFormatter)new MyFormat("name"));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        BgCommCHelper.disableVisible((JButton)this.btnSave, (JMenuItem)this.menuItemSave);
        BgCommCHelper.disableVisible((JButton)this.btnCopy, (JMenuItem)this.menuItemCopy);
        BgCommCHelper.disableVisible((JButton)this.btnPrint, (JMenuItem)this.menuItemPrint);
        BgCommCHelper.disableVisible((JButton)this.btnPrintPreview, (JMenuItem)this.menuItemPrintPreview);
        BgCommCHelper.disableVisible((JButton)this.btnCancel, (JMenuItem)this.menuItemCancel);
        BgCommCHelper.disableVisible((JButton)this.btnCancelCancel, (JMenuItem)this.menuItemCancelCancel);
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        this.prmtActScenarios.setUserObject(null);
        if (dataObject instanceof BgScenarioInfo) {
            this.editData = (BgScenarioInfo)dataObject;
        }
        super.setDataObject(dataObject);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.prmtParent.setAccessAuthority(0);
        BgScenarioBaseDialog scenarioDialog = new BgScenarioBaseDialog();
        scenarioDialog.setIsShowName(true);
        scenarioDialog.setIsChooseOne(true);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            scenarioDialog.setLongNumber(this.editData.getLongNumber());
        }
        this.prmtParent.setSelector((KDPromptSelector)scenarioDialog);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("type", (Object)1));
        this.prmtActScenarios.setEntityViewInfo(evi);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.prmtParent.setEnabled(false);
        } else {
            this.prmtParent.setEnabled(true);
        }
        this.setActPrmt();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.storeActScenario();
    }

    protected void storeActScenario() {
        if (this.editData.getActScenarios() != this.prmtActScenarios.getData()) {
            this.editData.getActScenarios().clear();
            if (this.prmtActScenarios.getData() instanceof BgScenarioNodeCollection) {
                this.editData.getActScenarios().addObjectCollection((IObjectCollection)((BgScenarioNodeCollection)((Object)this.prmtActScenarios.getData())));
            }
        }
    }

    @Override
    protected void txtType_itemStateChanged(ItemEvent e) throws Exception {
        super.txtType_itemStateChanged(e);
        if (1 == e.getStateChange()) {
            this.setActPrmt();
        }
    }

    protected void setActPrmt() {
        BgScenarioType type = (BgScenarioType)((Object)this.txtType.getSelectedItem());
        if (BgScenarioType.BudgetData.equals((Object)type)) {
            if (OprtState.EDIT.equalsIgnoreCase(this.getOprtState()) || OprtState.ADDNEW.equalsIgnoreCase(this.getOprtState())) {
                this.prmtActScenarios.setEnabled(true);
            } else {
                this.prmtActScenarios.setEnabled(false);
            }
        } else {
            this.prmtActScenarios.setEnabled(false);
            this.prmtActScenarios.setData(null);
        }
    }

    @Override
    protected void prmtActScenarios_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtActScenarios_dataChanged(e);
        Map<String, BgScenarioNodeInfo> nodeMap = null;
        if (this.prmtActScenarios.getUserObject() == null) {
            nodeMap = new HashMap();
            this.prmtActScenarios.setUserObject(nodeMap);
        } else {
            nodeMap = (Map)this.prmtActScenarios.getUserObject();
        }
        if (e.getNewValue() instanceof BgScenarioNodeCollection) {
            BgScenarioNodeCollection col = (BgScenarioNodeCollection)((Object)e.getNewValue());
            if (!col.isEmpty()) {
                int i;
                HashSet<String> ids = new HashSet<String>();
                for (i = 0; i < col.size(); ++i) {
                    if (col.get(i).getActScenario().getNumber() != null) continue;
                    ids.add(col.get(i).getId().toString());
                }
                if (!ids.isEmpty()) {
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    viewInfo.setFilter(filter);
                    viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("id"));
                    selector.add(new SelectorItemInfo("actscenarios.id"));
                    selector.add(new SelectorItemInfo("actScenario.name"));
                    selector.add(new SelectorItemInfo("actScenario.number"));
                    selector.add(new SelectorItemInfo("bgScenario.id"));
                    selector.add(new SelectorItemInfo("bgScenario.name"));
                    selector.add(new SelectorItemInfo("bgScenario.number"));
                    viewInfo.setSelector(selector);
                    col = BgScenarioNodeFactory.getRemoteInstance().getCollection(viewInfo);
                }
                this.prmtActScenarios.setDataNoNotify((Object)col);
                for (i = 0; i < col.size(); ++i) {
                    if (nodeMap == null) continue;
                    nodeMap.put(col.get(i).getActScenario().getNumber(), col.get(i));
                }
            } else {
                this.prmtActScenarios.setDataNoNotify(null);
            }
        } else if (e.getNewValue() instanceof Object[]) {
            Object[] objs = (Object[])e.getNewValue();
            BgScenarioNodeCollection col = new BgScenarioNodeCollection();
            BgScenarioInfo info = null;
            BgScenarioNodeInfo nodeInfo = null;
            for (int i = 0; i < objs.length; ++i) {
                if (!(objs[i] instanceof BgScenarioInfo)) continue;
                info = (BgScenarioInfo)objs[i];
                if (nodeMap.containsKey(info.getNumber())) {
                    col.add((BgScenarioNodeInfo)nodeMap.get(info.getNumber()));
                    continue;
                }
                nodeInfo = new BgScenarioNodeInfo();
                nodeInfo.setBgScenario(this.editData);
                nodeInfo.setActScenario(info);
                col.add(nodeInfo);
            }
            if (col.isEmpty()) {
                this.prmtActScenarios.setDataNoNotify(null);
            } else {
                this.prmtActScenarios.setDataNoNotify((Object)col);
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        LanguageInfo currLang = this.getCurrentLanguage();
        if (this.txtNumber.isEnabled()) {
            if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
                this.txtNumber.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgScenarioResource", "noNumber"));
                SysUtil.abort();
            } else if (!BgNumberHelper.checkNumber(this.txtNumber.getText())) {
                this.txtNumber.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgScenarioResource", "haveEspecial"));
                SysUtil.abort();
            }
        }
        if (this.txtName.getItemBy(currLang).getData() == null || StringUtils.isEmpty((String)this.txtName.getItemBy(currLang).getData().toString())) {
            this.txtName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgScenarioResource", "noName"));
            SysUtil.abort();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("creator.id");
        sic.add("description");
        sic.add("isSysData");
        sic.add("type");
        sic.add("creator.name");
        sic.add("longNumber");
        sic.add("level");
        sic.add("isLeaf");
        sic.add("parent.id");
        sic.add("parent.Number");
        sic.add("parent.name");
        sic.add("parent.longNumber");
        sic.add("parent.level");
        sic.add("orgUnit.id");
        sic.add("actScenarios.bgScenario.id");
        sic.add("actScenarios.actScenario.id");
        sic.add("actScenarios.actScenario.number");
        sic.add("actScenarios.actScenario.name");
        return sic;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.editData.getOrgUnit().getId().equals((Object)SysContext.getSysContext().getCurrentCostUnit().getId())) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgScenarioResource", "BGSCENARIO_EDIT_ERROR_MSG_ORG"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
        this.txtNumber.setEnabled(false);
        this.contType.setEnabled(false);
        if (this.editData.getIsSysData() == 1) {
            this.txtName.setEnabled(false);
        } else {
            this.txtName.setEnabled(true);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.txtNumber.setEnabled(true);
        this.txtName.setEnabled(true);
        this.contType.setEnabled(true);
    }

    protected LanguageInfo getCurrentLanguage() {
        return new LanguageInfo(this.getCurrentLocale());
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String number = this.editData.getNumber();
        if (BgScenarioHelper.sysDataNumbers.contains(number)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"BGSCENARIO_SYSDATA_FORBIDDEN_DELETE"));
        } else if (!this.checkIsCreatedByLocalOrgUnit()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"BGSCENARIO_DELETE_FORBBIT_ORG"));
        } else if (this.checkIsRefByTemplate()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"BGSCENARIO_REFED_FORBIDDEN_DELETE"));
        } else {
            super.actionRemove_actionPerformed(e);
        }
    }

    private boolean checkIsCreatedByLocalOrgUnit() {
        FullOrgUnitInfo orgUnit = this.editData.getOrgUnit();
        OrgUnitInfo orgObject = SysContext.getSysContext().getCurrentOrgUnit();
        if (orgObject instanceof OrgUnitInfo) {
            FullOrgUnitInfo castToFullOrgUnitInfo = orgObject.castToFullOrgUnitInfo();
            String longNumber = orgUnit.getLongNumber();
            String longNumber2 = castToFullOrgUnitInfo.getLongNumber();
            return longNumber2.equals(longNumber);
        }
        return false;
    }

    private boolean checkIsRefByTemplate() {
        String id = this.editData.getId().toString();
        String sql = "SELECT fid FROM T_MBG_BgTemplate WHERE FBgScenarioID = '" + id + "'";
        try {
            ISQLExecutor iSql = SQLExecutorFactory.getRemoteInstance((String)sql);
            IRowSet rs = iSql.executeSQL();
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.handUIException(e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.handUIException(e);
        }
        return false;
    }

    protected IObjectValue createNewData() {
        BgScenarioInfo itemInfo = new BgScenarioInfo();
        itemInfo.setId(BOSUuid.create((BOSObjectType)itemInfo.getBOSType()));
        itemInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        itemInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        CtrlUnitInfo currentCtrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
        itemInfo.setCU(currentCtrlUnit);
        OrgUnitInfo orgObject = SysContext.getSysContext().getCurrentOrgUnit();
        if (orgObject instanceof OrgUnitInfo) {
            itemInfo.setOrgUnit(orgObject.castToFullOrgUnitInfo());
        }
        return itemInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgScenarioFactory.getRemoteInstance();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        BgScenarioInfo parent = (BgScenarioInfo)this.prmtParent.getData();
        if (parent != null) {
            boolean canChange;
            if (parent.getId().toString().equals(this.editData.getId().toString())) {
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "cantSelectSelf"));
                SysUtil.abort();
            }
            if (canChange = BgBaseFacadeFactory.getRemoteInstance().checkParent(parent)) {
                int level = parent.getLevel();
                String ParentLongNumber = parent.getLongNumber();
                this.editData.setParent(parent);
                this.editData.setLongNumber(ParentLongNumber + "!" + this.txtNumber.getText());
                this.editData.setLevel(level + 1);
                super.actionSubmit_actionPerformed(e);
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "cantEditVerson"));
                this.prmtParent.setData(null);
                SysUtil.abort();
            }
        } else {
            this.editData.setParent(null);
            super.actionSubmit_actionPerformed(e);
        }
    }
}

