/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.IBgScenario;
import com.kingdee.eas.ma.base.client.AbstractBgScenarioF7UI;
import com.kingdee.eas.ma.base.client.utils.BgBaseHelper;
import com.kingdee.eas.ma.base.client.utils.NumberExpandHelper;
import com.kingdee.eas.ma.base.utils.BgScenarioCollObject;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BgScenarioF7UI
extends AbstractBgScenarioF7UI {
    private static final Logger logger = CoreUIObject.getLogger(BgScenarioF7UI.class);
    private boolean isCancel = true;
    private BgScenarioInfo resultOne = null;
    private BgScenarioCollection result = new BgScenarioCollection();
    private boolean isFilterText = true;
    boolean isChooseOne = true;
    private NumberExpandHelper numberHelper = null;
    private List hadSelectedScenario;
    private boolean isShowName = false;

    public NumberExpandHelper getNumberHelper() {
        if (this.numberHelper == null) {
            this.numberHelper = new NumberExpandHelper(this, this.tblMain);
        }
        return this.numberHelper;
    }

    public void onLoad() throws Exception {
        this.setPreferredSize(new Dimension(580, 435));
        if (this.getUIContext().get("hadSelectedScenario") instanceof List) {
            this.hadSelectedScenario = (List)this.getUIContext().get("hadSelectedScenario");
        }
        this.btnEleSearch.setText("");
        this.btnEleSearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.tblMain.checkParsed();
        super.onLoad();
        this.getNumberHelper();
        this.isFilterText = (Boolean)this.getUIContext().get("isFilterText");
        this.isChooseOne = (Boolean)this.getUIContext().get("isChooseOne");
        this.tblMain.getSelectManager().setSelectMode(2);
        this.putDataToKDTable();
        if (this.isChooseOne) {
            this.tblMain.getColumn("choose").getStyleAttributes().setHided(true);
        }
        this.colSetLocked();
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor ex = super.getQueryExecutor(queryPK, viewInfo);
        viewInfo.getSorter().clear();
        SorterItemCollection sorts = viewInfo.getSorter();
        SorterItemInfo sort1 = new SorterItemInfo("longNumber");
        sorts.add(sort1);
        viewInfo.setSorter(sorts);
        BgBaseHelper.addLongNumberFilter(this.getUIContext(), viewInfo.getFilter());
        BgBaseHelper.addIdFilter(this, viewInfo);
        try {
            this.getNumberHelper().setFilter(viewInfo.getFilter(), (ICoreBase)BgScenarioFactory.getRemoteInstance());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        return ex;
    }

    private void colSetLocked() {
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("type").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("desc").getStyleAttributes().setLocked(true);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("longNumber");
        sic.add("isSysData");
        sic.add("level");
        sic.add("isLeaf");
        sic.add("parent.id");
        sic.add("parent.Number");
        sic.add("parent.name");
        sic.add("parent.longNumber");
        sic.add("parent.level");
        return sic;
    }

    private void putDataToKDTable() {
        if (this.bgScenarioQuery == null) {
            this.bgScenarioQuery = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        this.txtEleSearch.setUserObject((Object)this.txtEleSearch.getText());
        if (this.isFilterText) {
            if (this.txtEleSearch.getText().trim().length() > 0) {
                FilterItemInfo item = new FilterItemInfo("number", (Object)('%' + this.txtEleSearch.getText() + '%'), CompareType.LIKE);
                filter.getFilterItems().add(item);
                item = new FilterItemInfo("name", (Object)('%' + this.txtEleSearch.getText() + '%'), CompareType.LIKE);
                filter.getFilterItems().add(item);
                item = new FilterItemInfo("description", (Object)('%' + this.txtEleSearch.getText() + '%'), CompareType.LIKE);
                filter.getFilterItems().add(item);
                filter.setMaskString(" (#" + String.valueOf(filter.getFilterItems().size() - 3) + ") or (#" + String.valueOf(filter.getFilterItems().size() - 2) + ") or (#" + String.valueOf(filter.getFilterItems().size() - 1) + "))");
            }
        } else if (this.txtEleSearch.getText().trim().length() > 0) {
            FilterItemInfo item = new FilterItemInfo("number", (Object)('%' + this.txtEleSearch.getText() + '%'), CompareType.LIKE);
            filter.getFilterItems().add(item);
            item = new FilterItemInfo("name", (Object)('%' + this.txtEleSearch.getText() + '%'), CompareType.LIKE);
            filter.getFilterItems().add(item);
            item = new FilterItemInfo("description", (Object)('%' + this.txtEleSearch.getText() + '%'), CompareType.LIKE);
            filter.getFilterItems().add(item);
            filter.setMaskString(" (#" + String.valueOf(filter.getFilterItems().size() - 3) + ") or (#" + String.valueOf(filter.getFilterItems().size() - 2) + ") or (#" + String.valueOf(filter.getFilterItems().size() - 1) + "))");
        }
        this.bgScenarioQuery.setFilter(filter);
        this.tblMain.removeRows();
    }

    @Override
    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.bgScenarioQuery != null) {
            int start = (Integer)e.getParam1();
            int length = (Integer)e.getParam2() - start + 1;
            try {
                IQueryExecutor exec = this.getQueryExecutor(this.bgScenarioQueryPK, this.bgScenarioQuery);
                exec.option().isAutoTranslateEnum = true;
                IRowSet rowSet = exec.executeQuery(start, length);
                e.setRowSet(rowSet);
                this.onGetRowSet(rowSet);
            }
            catch (Exception ee) {
                this.handUIException(ee);
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        if (!this.isChooseOne) {
            IRow initRow = this.tblMain.getRow(0);
            if (initRow == null) {
                return;
            }
            initRow.getCell("choose").setValue((Object)Boolean.FALSE);
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                this.tblMain.getRow(i).getCell("choose").setValue((Object)Boolean.FALSE);
                if (this.hadSelectedScenario == null || this.hadSelectedScenario.isEmpty() || !this.hadSelectedScenario.contains(this.tblMain.getCell(i, 1).getValue().toString())) continue;
                this.tblMain.getRow(i).getCell("choose").setValue((Object)Boolean.TRUE);
            }
        }
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.onBtnConfirm();
        }
    }

    private void onBtnConfirm() throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        int currRow = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow iRow = this.tblMain.getRow(currRow);
        if (!this.isChooseOne) {
            iRow.getCell("choose").setValue((Object)Boolean.TRUE);
            this.isCancel = false;
        } else {
            String id = iRow.getCell("id").getValue().toString();
            try {
                IBgScenario iScenario = BgScenarioFactory.getRemoteInstance();
                this.resultOne = (BgScenarioInfo)iScenario.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            }
            catch (BOSException ex) {
                logger.error((Object)ex.getMessage());
                throw ex;
            }
            catch (EASBizException ex) {
                logger.error((Object)ex.getMessage());
                throw ex;
            }
            this.isCancel = false;
            this.getUIWindow().close();
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        if (this.isChooseOne) {
            int currRow = this.tblMain.getSelectManager().getActiveRowIndex();
            if (currRow != -1) {
                IRow iRow = this.tblMain.getRow(currRow);
                String id = iRow.getCell("id").getValue().toString();
                try {
                    IBgScenario iScenario = BgScenarioFactory.getRemoteInstance();
                    this.resultOne = (BgScenarioInfo)iScenario.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                }
                catch (BOSException ex) {
                    logger.error((Object)ex.getMessage());
                    throw ex;
                }
                catch (EASBizException ex) {
                    logger.error((Object)ex.getMessage());
                    throw ex;
                }
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgScenarioResource", (String)"selectBgName"));
            }
        } else {
            Object info = null;
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                Object value = this.tblMain.getRow(i).getCell("choose").getValue();
                if (value == null || !value.toString().equals("true")) continue;
                IRow iRow = this.tblMain.getRow(i);
                String id = iRow.getCell("id").getValue().toString();
                idSet.add(id);
            }
            if (idSet.isEmpty()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgScenarioResource", (String)"selectBgName"));
                return;
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.getSelector().addObjectCollection((IObjectCollection)this.bgScenarioQuery.getSelector());
            view.setFilter(filter);
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo sortInfo = new SorterItemInfo("longNumber");
            sorter.add(sortInfo);
            view.setSorter(sorter);
            try {
                IBgScenario ie = BgScenarioFactory.getRemoteInstance();
                CoreBaseCollection col = ie.getCollection(view);
                this.result = new BgScenarioCollection();
                if (col != null) {
                    this.result.addObjectCollection((IObjectCollection)col);
                }
            }
            catch (BOSException ex) {
                logger.error((Object)ex.getMessage());
                throw ex;
            }
        }
        if (this.resultOne != null || !this.result.isEmpty()) {
            this.isCancel = false;
            this.getUIWindow().close();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public BgScenarioInfo getResultOne() {
        return this.resultOne;
    }

    public BgScenarioCollObject getResult() {
        return new BgScenarioCollObject(this.result, this.isShowName);
    }

    @Override
    protected void btnEleSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnEleSearch_actionPerformed(e);
        this.putDataToKDTable();
        this.processChooseCols();
    }

    protected void processChooseCols() {
        for (int i = 0; i < this.tblMain.getBody().size(); ++i) {
            if (this.isChooseOne) {
                this.tblMain.getColumn("choose").getStyleAttributes().setHided(true);
                continue;
            }
            this.tblMain.getRow(i).getCell("choose").setValue((Object)Boolean.FALSE);
        }
        if (this.tblMain.getBody().size() == 1) {
            this.tblMain.getRow(0).getCell("choose").setValue((Object)Boolean.TRUE);
            this.tblMain.getSelectManager().select(0, 0, 0, 0);
        }
    }

    @Override
    protected void txtEleSearch_focusLost(FocusEvent e) throws Exception {
        super.txtEleSearch_focusLost(e);
        if (StringUtils.equals((String)((String)this.txtEleSearch.getUserObject()), (String)this.txtEleSearch.getText())) {
            return;
        }
        this.putDataToKDTable();
        this.processChooseCols();
    }

    public void setIsShowName(boolean isShowName) {
        this.isShowName = isShowName;
    }
}

