/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.io.kds.KDSBookToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioNodeCollection;
import com.kingdee.eas.ma.base.BgScenarioNodeFactory;
import com.kingdee.eas.ma.base.BgScenarioNodeInfo;
import com.kingdee.eas.ma.base.RptSrcTypeEnum;
import com.kingdee.eas.ma.base.client.AbstractBgScenarioListUI;
import com.kingdee.eas.ma.base.client.BgScenarioEditUI;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.NumberExpendRender;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.client.utils.BgPermissionUtil;
import com.kingdee.eas.ma.base.utils.BgAccountHelper;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgScenarioListUI
extends AbstractBgScenarioListUI {
    private static final long serialVersionUID = -6723010446847877527L;
    private static final Logger logger = CoreUIObject.getLogger(BgScenarioListUI.class);
    private NumberExpendRender render = null;

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.setRender(new NumberExpendRender(1));
        this.tblMain.getColumn("number").setRenderer((IBasicRender)this.getRender());
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgScenarioFactory.getRemoteInstance();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"BgScenarioInfo", (Object)this.getSelectedBgScenarioInfo());
    }

    protected BgScenarioInfo getSelectedBgScenarioInfo() {
        IRow row;
        BgScenarioInfo scenarioInfo = null;
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0 && (row = this.tblMain.getRow(rowIndex)) != null) {
            scenarioInfo = new BgScenarioInfo();
            scenarioInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            scenarioInfo.setName(row.getCell("name").getValue() != null ? row.getCell("name").getValue().toString() : null);
            Object obj = row.getCell("number").getValue();
            if (obj instanceof NumberExpandInfo) {
                scenarioInfo.setNumber(((NumberExpandInfo)obj).getNumber());
            } else {
                scenarioInfo.setNumber(obj.toString());
            }
        }
        return scenarioInfo;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("longNumber");
        sic.add("isSysData");
        sic.add("level");
        sic.add("isLeaf");
        sic.add("parent.id");
        sic.add("parent.Number");
        sic.add("parent.name");
        sic.add("parent.longNumber");
        sic.add("parent.level");
        sic.add("lastUpdateUser.name");
        sic.add("lastUpdateTime");
        return sic;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getType() == 1) {
            IRow row;
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            int clickCount = e.getClickCount();
            if (clickCount == 1 && (row = this.tblMain.getRow(rowIndex)) != null && colIndex == this.tblMain.getColumn("number").getColumnIndex()) {
                NumberExpandInfo expandInfo = (NumberExpandInfo)row.getCell("number").getValue();
                if (this.getRender().inRect(expandInfo, e.getX(), e.getY())) {
                    this.setTreeDisplayStyle(row, expandInfo);
                }
            }
        }
    }

    protected boolean isOrderForClickTableHead() {
        return true;
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) throws Exception {
        boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
        if (!isLeaf) {
            this.tblMain.setRefresh(false);
            this.expandTable(row, expandInfo);
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo) throws Exception {
        if (row == null) {
            return;
        }
        IRow child = null;
        int parentLevel = parentExpandInfo.getLevel();
        String longNumber = null;
        String parentLongNumber = null;
        NumberExpandInfo expandInfo = null;
        parentLongNumber = parentExpandInfo.getLongNumber();
        boolean isExpandStatus = parentExpandInfo.isExpandStatus();
        if (isExpandStatus) {
            parentExpandInfo.setExpandStatus(false);
            int rowCount = this.tblMain.getRowCount3();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell("number").getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                child.getStyleAttributes().setHided(true);
            }
        } else {
            parentExpandInfo.setExpandStatus(true);
            int rowCount = this.tblMain.getRowCount3();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell("number").getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                if (expandInfo.getLevel() - parentLevel != 1) continue;
                child.getStyleAttributes().setHided(false);
                if (expandInfo.isLeaf()) continue;
                expandInfo.setExpandStatus(false);
            }
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    BgScenarioListUI.this.afterDataFill_actionEvent(e);
                }
                catch (Exception ex) {
                    BgScenarioListUI.this.handUIExceptionAndAbort(ex);
                }
            }
        });
    }

    protected void afterDataFill_actionEvent(KDTDataRequestEvent e) throws Exception {
        int beginIndex = e.getFirstRow();
        int endIndex = e.getLastRow();
        int level = 0;
        Object numberValue = null;
        String id = null;
        String number = null;
        String longNumber = null;
        String name = null;
        IRow row = null;
        NumberExpandInfo expandInfo = null;
        HashMap<String, StringBuffer> actScenMap = new HashMap<String, StringBuffer>();
        HashMap actMap = new HashMap();
        for (int index = beginIndex; index <= endIndex; ++index) {
            row = this.tblMain.getRow(index);
            if (row == null) continue;
            id = (String)row.getCell("id").getValue();
            actScenMap.put(id, null);
            numberValue = row.getCell("number").getValue();
            if (!(numberValue instanceof String)) {
                return;
            }
            number = numberValue.toString();
            longNumber = row.getCell("longNumber").getValue() != null ? row.getCell("longNumber").getValue().toString() : null;
            level = row.getCell("level").getValue() != null ? Integer.valueOf((Integer)row.getCell("level").getValue()) : null;
            name = row.getCell("name").getValue() != null ? (String)row.getCell("name").getValue() : null;
            boolean isLeaf = row.getCell("isLeaf").getValue() != null ? Boolean.valueOf((Boolean)row.getCell("isLeaf").getValue()) : null;
            expandInfo = new NumberExpandInfo();
            expandInfo.setId(id);
            expandInfo.setLevel(level);
            expandInfo.setLeaf(isLeaf);
            expandInfo.setName(number);
            expandInfo.setNumber(number);
            expandInfo.setLongNumber(longNumber);
            expandInfo.setExpandStatus(true);
            row.getCell("number").setValue((Object)expandInfo);
            row.getCell("number").setRenderer((IBasicRender)this.getRender());
        }
        if (actScenMap.isEmpty()) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("bgScenario.id");
        evi.getSelector().add("bgScenario.name");
        evi.getSelector().add("actScenario.id");
        evi.getSelector().add("actScenario.name");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScenario.id", new HashSet(actScenMap.keySet()), CompareType.INCLUDE));
        evi.setSorter(new SorterItemCollection());
        SorterItemInfo s = new SorterItemInfo("actScenario.isSysData");
        s.setSortType(SortType.DESCEND);
        evi.getSorter().add(s);
        evi.getSorter().add(new SorterItemInfo("actScenario.number"));
        BgScenarioNodeCollection col = BgScenarioNodeFactory.getRemoteInstance().getCollection(evi);
        if (col == null || col.isEmpty()) {
            return;
        }
        actScenMap.clear();
        StringBuffer names = null;
        BgScenarioNodeInfo nodeInfo = null;
        for (int i = 0; i < col.size(); ++i) {
            nodeInfo = col.get(i);
            if (!actScenMap.containsKey(nodeInfo.getBgScenario().getId().toString())) {
                actScenMap.put(nodeInfo.getBgScenario().getId().toString(), new StringBuffer());
            }
            if (!actMap.containsKey(nodeInfo.getBgScenario().getId().toString())) {
                actMap.put(nodeInfo.getBgScenario().getId().toString(), new HashSet());
            }
            names = (StringBuffer)actScenMap.get(nodeInfo.getBgScenario().getId().toString());
            Set set = (Set)actMap.get(nodeInfo.getBgScenario().getId().toString());
            if (names.length() > 0) {
                names.append(", ");
            }
            names.append(nodeInfo.getActScenario().getName());
            set.add(nodeInfo.getActScenario().getId().toString());
        }
        for (int index = beginIndex; index <= endIndex; ++index) {
            row = this.tblMain.getRow(index);
            if (row == null || !actScenMap.containsKey(id = (String)row.getCell("id").getValue()) || row.getCell("actScenarios") == null) continue;
            row.getCell("actScenarios").setValue(actScenMap.get(id));
            row.getCell("actScenarios").setUserObject(actMap.get(id));
        }
    }

    public NumberExpendRender getRender() {
        return this.render;
    }

    public void setRender(NumberExpendRender render) {
        this.render = render;
    }

    protected String getEditUIName() {
        return BgScenarioEditUI.class.getName();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        CostCenterOrgUnitInfo ccoui = SysContext.getSysContext().getCurrentCostUnit();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(selectRows[0]);
        Object oldParentId = row.getCell("parent.id").getValue();
        Object longNumber = row.getCell("longNumber").getValue();
        String createOrgUnitId = row.getCell("orgUnit.id").getValue().toString();
        if (!createOrgUnitId.equalsIgnoreCase(ccoui.getId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgScenarioResource", "BGSCENARIO_EDIT_ERROR_MSG_ORG"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
        Object newParentId = row.getCell("parent.id").getValue();
        if (oldParentId != null && (!oldParentId.toString().equals(newParentId.toString()) && newParentId != null || newParentId == null)) {
            this.dealParent(oldParentId.toString(), longNumber.toString());
        }
    }

    public void dealParent(String oldParentId, String longNumber) {
        String parentLongNumber = null;
        if (longNumber != null) {
            parentLongNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
        }
        boolean hasChild = false;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!row.getCell("longNumber").getValue().toString().startsWith(parentLongNumber + "!")) continue;
            hasChild = true;
            break;
        }
        if (!hasChild) {
            try {
                BgScenarioInfo oldParent = BgScenarioFactory.getRemoteInstance().getBgScenarioInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)oldParentId)));
                oldParent.setIsLeaf(true);
                BgScenarioFactory.getRemoteInstance().save((CoreBaseInfo)oldParent);
            }
            catch (EASBizException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (UuidException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
    }

    protected List<Integer> getSelectRowIndex() {
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range.size() == 0) {
            return null;
        }
        ArrayList<Integer> selectRowIndex = new ArrayList<Integer>();
        KDTSelectBlock block = null;
        for (int index = 0; index < range.size(); ++index) {
            block = (KDTSelectBlock)range.get(index);
            for (int r = block.getBeginRow(); r <= block.getEndRow(); ++r) {
                selectRowIndex.add(r);
            }
        }
        Collections.sort(selectRowIndex);
        return selectRowIndex;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int re = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "delete_confirm"));
        if (re == 1 || re == 2) {
            return;
        }
        List<Integer> indexs = this.getSelectRowIndex();
        ArrayList<String> selectDel = new ArrayList<String>();
        IRow row = null;
        String rowId = null;
        int rowIndex = 0;
        CostCenterOrgUnitInfo ccoui = SysContext.getSysContext().getCurrentCostUnit();
        HashMap<String, String> numberMap = new HashMap<String, String>();
        HashSet<String> difOrg = new HashSet<String>();
        HashSet<String> sysVersion = new HashSet<String>();
        for (int index = 0; index < indexs.size(); ++index) {
            rowIndex = indexs.get(index);
            row = this.tblMain.getRow(indexs.get(index).intValue());
            rowId = row.getCell("id").getValue().toString();
            String creatOrgId = row.getCell("orgUnit.id").getValue().toString();
            NumberExpandInfo Info = (NumberExpandInfo)row.getCell("number").getValue();
            String number = Info.getNumber().toString();
            if (rowId != null) {
                if (Integer.valueOf(row.getCell("isSysData").getValue().toString()) == 1) {
                    sysVersion.add(rowId.toString());
                } else if (!creatOrgId.equalsIgnoreCase(ccoui.getId().toString())) {
                    difOrg.add(rowId);
                } else {
                    selectDel.add(rowId);
                }
            }
            numberMap.put(rowId, number);
        }
        Map result = BgScenarioFactory.getRemoteInstance().remove(selectDel);
        Set cantRemove = new HashSet();
        Set delete = new HashSet();
        Set refByBgScenario = new HashSet();
        if (result != null) {
            cantRemove = (Set)result.get("cantRemove");
            delete = (Set)result.get("canSet");
            refByBgScenario = (Set)result.get("refByBgScenario");
        }
        StringBuffer message = new StringBuffer();
        if (sysVersion.size() == 0 && cantRemove.size() == 0 && difOrg.size() == 0 && refByBgScenario != null && refByBgScenario.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "delete_success"));
            this.refresh(e);
        } else {
            String id;
            Iterator iter = delete.iterator();
            while (iter.hasNext()) {
                id = iter.next().toString();
                message.append(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "removeSuccess"), numberMap.get(id)));
                message.append("\r\n");
            }
            iter = sysVersion.iterator();
            while (iter.hasNext()) {
                id = iter.next().toString();
                message.append(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "cantRemoveSysdate"), numberMap.get(id)));
                message.append("\r\n");
            }
            iter = refByBgScenario.iterator();
            while (iter.hasNext()) {
                id = iter.next().toString();
                message.append(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "refByBgScenario"), numberMap.get(id)));
                message.append("\r\n");
            }
            iter = cantRemove.iterator();
            while (iter.hasNext()) {
                id = iter.next().toString();
                message.append(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "cantRemoveSelf"), numberMap.get(id)));
                message.append("\r\n");
            }
            iter = difOrg.iterator();
            while (iter.hasNext()) {
                id = iter.next().toString();
                message.append(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "remove_difOrg"), numberMap.get(id)));
                message.append("\r\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "delete_failed"), (String)message.toString(), (int)1);
        }
        this.tblMain.refresh();
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission(SysContext.getSysContext().getCurrentOrgUnit().getId(), "mbg_bgScenario_import");
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"template", (Object)this.loadTempTable());
        ctx.put((Object)"sourceType", (Object)this.getSourceType());
        ctx.put((Object)"bg.user", (Object)SysContext.getSysContext().getCurrentUserInfo());
        ctx.put((Object)"bg.orgUnit", (Object)SysContext.getSysContext().getCurrentOrgUnit());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.base.client.BgScenarioImportUI", (Map)ctx, null, OprtState.VIEW);
        window.getUIObject().setUITitle(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgScenarioResource", "titleScenario"));
        window.show();
        this.actionRefresh_actionPerformed(e);
    }

    protected RptSrcTypeEnum getSourceType() {
        return RptSrcTypeEnum.PT_BUDGET_REPORT;
    }

    private KDTable loadTempTable() throws EASBizException, BOSException {
        KDTable tbl = new KDTable();
        ArrayList<String> tempHeadNumber = new ArrayList<String>();
        tempHeadNumber.add("number");
        tempHeadNumber.add("name");
        tempHeadNumber.add("type");
        tempHeadNumber.add("actScenarios.number");
        tempHeadNumber.add("actScenarios");
        tempHeadNumber.add("description");
        tempHeadNumber.add("orgUnit.name");
        ArrayList<String> tempHeadName = new ArrayList<String>();
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"number") + "*");
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"name") + "*");
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"type") + "*");
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"actNumbers"));
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"actNames"));
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"describe"));
        tempHeadName.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"orgunit"));
        IRow head = tbl.addHeadRow();
        for (int i = 0; i < tempHeadNumber.size(); ++i) {
            IColumn column = tbl.addColumn();
            column.setKey((String)tempHeadNumber.get(i));
            head.getCell(column.getColumnIndex()).setValue(tempHeadName.get(i));
        }
        return tbl;
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        BgPermissionUtil.checkPermission(SysContext.getSysContext().getCurrentOrgUnit().getId(), "mbg_bgScenario_export");
        BgFileUtil bgFileUtil = new BgFileUtil();
        KDFileChooser fileChooser = bgFileUtil.getFileChooserForExp((Object)this);
        fileChooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"outTitleScen"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        String filePath = BgAccountHelper.fileSelect(fileChooser, (CoreUI)this);
        if (filePath == null) {
            SysUtil.abort();
        }
        KDSBook kdsBook = new KDSBook("001");
        KDSSheet kdsSheet = new KDSSheet(kdsBook, "001");
        kdsSheet.getSheetStyleAttributes().setFont(new Font(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"font"), 0, 9));
        kdsSheet.getSheetStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        kdsSheet.getSheetStyleAttributes().setNumberFormat("@");
        kdsSheet.setCellValue(0, 0, (Object)(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"number") + "*"));
        kdsSheet.setCellValue(0, 1, (Object)(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"name") + "*"));
        kdsSheet.setCellValue(0, 2, (Object)(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"type") + "*"));
        kdsSheet.setCellValue(0, 3, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"actNumbers"));
        kdsSheet.setCellValue(0, 4, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"actNames"));
        kdsSheet.setCellValue(0, 5, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"describe"));
        kdsSheet.setCellValue(0, 6, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)"orgunit"));
        IRow row = null;
        int n = this.tblMain.getRowCount3();
        for (int i = 0; i < n; ++i) {
            StringBuilder str;
            row = this.tblMain.getRow(i);
            if (row.getCell("number").getValue() != null) {
                str = new StringBuilder();
                Object userObject = row.getCell("actScenarios").getUserObject();
                if (userObject instanceof Set) {
                    Set ids = (Set)userObject;
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setSelector(new SelectorItemCollection());
                    evi.getSelector().add("id");
                    evi.getSelector().add("name");
                    evi.getSelector().add("number");
                    evi.setFilter(new FilterInfo());
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
                    SorterItemInfo s = new SorterItemInfo("isSysData");
                    s.setSortType(SortType.DESCEND);
                    evi.getSorter().add(s);
                    evi.getSorter().add(new SorterItemInfo("number"));
                    BgScenarioCollection col = BgScenarioFactory.getRemoteInstance().getBgScenarioCollection(evi);
                    for (int j = 0; j < col.size(); ++j) {
                        if (j == 0) {
                            str.append(col.get(j).getNumber());
                            continue;
                        }
                        str.append(",").append(col.get(j).getNumber());
                    }
                }
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgAccountResource", "errorValue", new Integer[]{i + 1}));
                return;
            }
            kdsSheet.setCellValue(i + 1, 0, (Object)row.getCell("number").getValue().toString());
            kdsSheet.setCellValue(i + 1, 1, row.getCell("name").getValue() != null ? row.getCell("name").getValue().toString() : null);
            kdsSheet.setCellValue(i + 1, 2, row.getCell("type").getValue() != null ? row.getCell("type").getValue().toString() : null);
            kdsSheet.setCellValue(i + 1, 3, (Object)str.toString());
            kdsSheet.setCellValue(i + 1, 4, row.getCell("actScenarios").getValue() != null ? row.getCell("actScenarios").getValue().toString() : null);
            kdsSheet.setCellValue(i + 1, 5, row.getCell("description").getValue() != null ? row.getCell("description").getValue().toString() : null);
            kdsSheet.setCellValue(i + 1, 6, row.getCell("orgUnit.name").getValue() != null ? row.getCell("orgUnit.name").getValue().toString() : null);
        }
        File file = new File(filePath);
        if (file.exists()) {
            int result = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.tools.datatask.DatataskResource", "fileHasExisted"));
            if (result == 0) {
                if (file.delete()) {
                    file = new File(filePath);
                } else {
                    MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.tools.datatask.DatataskResource", "openedfile"));
                }
            } else {
                SysUtil.abort();
            }
        }
        kdsBook.addSheet(null, kdsSheet);
        ExportManager export = new ExportManager();
        try {
            String sen = GlobalFunction.getFileExtension((String)filePath);
            Book temBook = null;
            if (sen.equals("xlsx")) {
                temBook = KDSBookToBook.traslate((KDSBook)kdsBook);
                BookDataWrapper bookDataWrapper = new BookDataWrapper(temBook);
                SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
                if (filePath != null) {
                    booksc.write(filePath.replaceAll(" ", ""));
                }
            } else {
                export.exportToExcel(kdsBook, filePath);
            }
            bgFileUtil.storeDefaultPathForEXP(filePath, this.getUIContext());
        }
        catch (RuntimeException e1) {
            SysUtil.abort();
        }
        this.setMessageBarValue("successExport");
    }

    private void setMessageBarValue(String value) {
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.ma.base.BgScenarioResource", (String)value));
        this.showMessage();
    }
}

