/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.client.AbstractBgSysImportUI;
import com.kingdee.eas.ma.base.client.BgCostCenterBaseF7;
import com.kingdee.eas.ma.base.client.utils.NumberExpandHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public class BgSysImportUI
extends AbstractBgSysImportUI {
    private static final long serialVersionUID = 4047127281144981151L;
    private static final Logger logger = CoreUIObject.getLogger(BgSysImportUI.class);
    private NumberExpandHelper leftNumberHelper = null;
    private NumberExpandHelper rightNumberHelper = null;
    private HashSet<String> selectedLongNumber = new HashSet();
    private HashSet<Integer> selectedLevel = new HashSet();
    protected static final String COL_PARENT = "parent";
    protected Map<String, MbgMemberInfo> rightNumMap = new HashMap<String, MbgMemberInfo>();
    protected HashSet<String> rightNumSet = new HashSet();
    protected HashMap<String, TreeBaseInfo> rightMap = new HashMap();
    protected HashMap<String, TreeBaseInfo> leftMap = new HashMap();
    private HashMap<String, TreeBaseInfo> selectColls = new HashMap();
    private CtrlUnitInfo CU = SysContext.getSysContext().getCurrentCtrlUnit();
    private CostCenterOrgUnitInfo unitInfo = null;

    public HashMap<String, TreeBaseInfo> getSelectColls() {
        return this.selectColls;
    }

    public CtrlUnitInfo getCU() {
        return this.CU;
    }

    public CostCenterOrgUnitInfo getUnitInfo() {
        return this.unitInfo;
    }

    public void setUnitInfo(CostCenterOrgUnitInfo unitInfo) {
        this.unitInfo = unitInfo;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Object obj = this.getUIContext().get("unitInfo");
        if (obj != null && obj instanceof CostCenterOrgUnitInfo) {
            this.setUnitInfo((CostCenterOrgUnitInfo)obj);
        } else if (obj != null && obj instanceof FullOrgUnitInfo) {
            BOSUuid id = ((FullOrgUnitInfo)obj).getId();
            this.setUnitInfo(CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(id)));
        } else {
            this.setUnitInfo(SysContext.getSysContext().getCurrentCostUnit());
        }
        this.init();
    }

    protected void init() {
        this.getLeftExpandHelper();
        this.getRightExpandHelper();
        this.initPrmtCost();
        this.initPrmtView();
        if (this.isTreeBase()) {
            this.addPopMenu();
        }
    }

    private NumberExpandHelper getLeftExpandHelper() {
        if (this.leftNumberHelper == null) {
            this.leftNumberHelper = new NumberExpandHelper(this, this.tblMain);
        }
        return this.leftNumberHelper;
    }

    private NumberExpandHelper getRightExpandHelper() {
        if (this.rightNumberHelper == null) {
            this.rightNumberHelper = new NumberExpandHelper(this, this.tblRight);
        }
        return this.rightNumberHelper;
    }

    protected void initPrmtCost() {
        BgCostCenterBaseF7 f7 = new BgCostCenterBaseF7((IUIObject)this);
        f7.setPermissionItem(this.getSysImportPermission());
        f7.setRootUnitID(this.getCU().getId().toString());
        f7.setContainSealUp(true);
        f7.setMultiSelect(false);
        this.prmtCostCenter.setData((Object)this.getUnitInfo());
        this.prmtCostCenter.setSelector((KDPromptSelector)f7);
    }

    protected void initPrmtView() {
        this.prmtView.setEditable(false);
        this.prmtView.setEnabled(false);
        Object obj = this.getUIContext().get("viewInfo");
        if (obj != null) {
            this.prmtView.setData(obj);
        }
    }

    private boolean isTreeBase() {
        return true;
    }

    protected String getSysImportPermission() {
        return null;
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    public void setUITitle(String title) {
        super.setUITitle(title);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteAll_actionPerformed(e);
    }

    @Override
    public void actionSelect_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelect_actionPerformed(e);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    @Override
    protected void tblRight_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblRight_tableClicked(e);
    }

    @Override
    protected void kdLeftSearch_focusLost(FocusEvent e) throws Exception {
        super.kdLeftSearch_focusLost(e);
        this.left_search();
    }

    @Override
    protected void btnLeftSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnLeftSearch_actionPerformed(e);
        this.left_search();
    }

    protected void left_search() {
        String txtStr = this.kdLeftSearch.getText();
        IRow row = null;
        int count = this.tblMain.getRowCount();
        for (int index = 0; index < count; ++index) {
            row = this.tblMain.getRow(index);
            if (StringUtils.isEmpty((String)txtStr)) {
                row.getStyleAttributes().setHided(false);
                continue;
            }
            if ((row.getCell("name").getValue() == null || row.getCell("name").getValue().toString().indexOf(txtStr) < 0) && row.getCell("number").getValue().toString().indexOf(txtStr) < 0) {
                row.getStyleAttributes().setHided(true);
                continue;
            }
            row.getStyleAttributes().setHided(false);
        }
    }

    @Override
    protected void kdRightSearch_focusLost(FocusEvent e) throws Exception {
        super.kdRightSearch_focusLost(e);
        this.right_search();
    }

    @Override
    protected void btnRightSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnRightSearch_actionPerformed(e);
        this.right_search();
    }

    protected void right_search() {
        String txtStr = this.kdRightSearch.getText();
        IRow row = null;
        int count = this.tblRight.getRowCount();
        for (int index = 0; index < count; ++index) {
            row = this.tblRight.getRow(index);
            if (StringUtils.isEmpty((String)txtStr)) {
                row.getStyleAttributes().setHided(false);
                continue;
            }
            if (row.getCell("name").getValue().toString().indexOf(txtStr) < 0 && row.getCell("number").getValue().toString().indexOf(txtStr) < 0) {
                row.getStyleAttributes().setHided(true);
                continue;
            }
            row.getStyleAttributes().setHided(false);
        }
    }

    @Override
    protected void prmtCostCenter_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtCostCenter.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"CostCenterIsNull"));
            this.prmtCostCenter.setValue(e.getOldValue());
            return;
        }
        super.prmtCostCenter_dataChanged(e);
        if (e.getNewValue() instanceof CostCenterOrgUnitInfo) {
            this.setUnitInfo((CostCenterOrgUnitInfo)e.getNewValue());
        }
    }

    protected TreeBaseInfo getParentInfo(String longNum, HashMap<String, TreeBaseInfo> tmpMap) {
        if (StringUtils.isEmpty((String)longNum) || tmpMap.isEmpty()) {
            return null;
        }
        TreeBaseInfo parent = null;
        if (!longNum.contains("!")) {
            if (tmpMap.containsKey(longNum)) {
                return parent;
            }
        } else {
            String longNumEx = longNum.substring(0, longNum.lastIndexOf("!"));
            if (tmpMap.containsKey(longNumEx)) {
                parent = tmpMap.get(longNumEx);
            }
        }
        return parent;
    }

    protected IObjectValue getRowUserObject(IRow row) {
        return (IObjectValue)row.getUserObject();
    }

    protected void addPopMenu() {
        AbstractAction directChildAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BgSysImportUI.this.getAutoSelectValues();
                KDTSelectBlock sb = null;
                int columnCount = BgSysImportUI.this.tblMain.getColumnCount();
                IRow row = null;
                TreeBaseInfo info = null;
                String longNumEx = null;
                int count = BgSysImportUI.this.tblMain.getRowCount();
                for (int i = 0; i < count; ++i) {
                    boolean isDirectChild = false;
                    row = BgSysImportUI.this.tblMain.getRow(i);
                    info = (TreeBaseInfo)BgSysImportUI.this.getRowUserObject(row);
                    info.setNumber(BgNumberHelper.trimNumber(info.getNumber()));
                    info.setLongNumber(BgNumberHelper.trimNumber(info.getLongNumber()));
                    if (info.getLongNumber().contains("!")) {
                        longNumEx = info.getLongNumber().substring(0, info.getLongNumber().lastIndexOf("!") + 1);
                        if (BgSysImportUI.this.selectedLongNumber.contains(longNumEx) || BgSysImportUI.this.selectedLongNumber.contains(info.getLongNumber())) {
                            isDirectChild = true;
                        }
                    }
                    if (!BgSysImportUI.this.selectedLevel.contains(info.getLevel() - 1) || !isDirectChild) continue;
                    sb = new KDTSelectBlock(i, 0, i, columnCount - 1);
                    BgSysImportUI.this.tblMain.getSelectManager().add(sb, false);
                    BgSysImportUI.this.getSelectColls().put(info.getLongNumber(), info);
                }
            }
        };
        AbstractAction allChildAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BgSysImportUI.this.getAutoSelectValues();
                KDTSelectBlock sb = null;
                int columnCount = BgSysImportUI.this.tblMain.getColumnCount();
                IRow row = null;
                TreeBaseInfo info = null;
                String longNumEx = null;
                int count = BgSysImportUI.this.tblMain.getRowCount();
                for (int i = 0; i < count; ++i) {
                    boolean isChild = false;
                    row = BgSysImportUI.this.tblMain.getRow(i);
                    info = (TreeBaseInfo)BgSysImportUI.this.getRowUserObject(row);
                    info.setNumber(BgNumberHelper.trimNumber(info.getNumber()));
                    info.setLongNumber(BgNumberHelper.trimNumber(info.getLongNumber()));
                    longNumEx = info.getLongNumber() + "!";
                    for (String selectedLongNum : BgSysImportUI.this.selectedLongNumber) {
                        if (!longNumEx.startsWith(selectedLongNum)) continue;
                        isChild = true;
                    }
                    if (!isChild) continue;
                    sb = new KDTSelectBlock(i, 0, i, columnCount - 1);
                    BgSysImportUI.this.tblMain.getSelectManager().add(sb, false);
                    BgSysImportUI.this.getSelectColls().put(info.getLongNumber(), info);
                }
            }
        };
        AbstractAction levelChildAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BgSysImportUI.this.getAutoSelectValues();
                KDTSelectBlock sb = null;
                int columnCount = BgSysImportUI.this.tblMain.getColumnCount();
                IRow row = null;
                TreeBaseInfo info = null;
                int count = BgSysImportUI.this.tblMain.getRowCount();
                for (int i = 0; i < count; ++i) {
                    boolean isLevel = false;
                    row = BgSysImportUI.this.tblMain.getRow(i);
                    info = (TreeBaseInfo)BgSysImportUI.this.getRowUserObject(row);
                    info.setNumber(BgNumberHelper.trimNumber(info.getNumber()));
                    info.setLongNumber(BgNumberHelper.trimNumber(info.getLongNumber()));
                    if (BgSysImportUI.this.selectedLevel.contains(info.getLevel())) {
                        isLevel = true;
                    }
                    if (!isLevel) continue;
                    sb = new KDTSelectBlock(i, 0, i, columnCount - 1);
                    BgSysImportUI.this.tblMain.getSelectManager().add(sb, false);
                    BgSysImportUI.this.getSelectColls().put(BgNumberHelper.trimNumber(info.getLongNumber()), info);
                }
            }
        };
        KDTMenuManager menuManager = this.getMenuManager(this.tblMain);
        if (menuManager == null) {
            return;
        }
        KDMenuItem directChild = new KDMenuItem();
        directChild.setAction((Action)directChildAction);
        directChildAction.putValue("Name", EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"directChild"));
        menuManager.getMenu().addSeparator();
        menuManager.getMenu().add((JMenuItem)directChild, 0);
        KDMenuItem allChild = new KDMenuItem();
        allChild.setAction((Action)allChildAction);
        allChildAction.putValue("Name", EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"allChild"));
        menuManager.getMenu().addSeparator();
        menuManager.getMenu().add((JMenuItem)allChild, 1);
        KDMenuItem levelChild = new KDMenuItem();
        levelChild.setAction((Action)levelChildAction);
        levelChildAction.putValue("Name", EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"levelChild"));
        menuManager.getMenu().addSeparator();
        menuManager.getMenu().add((JMenuItem)levelChild, 2);
        JPopupMenu.Separator kdsp = new JPopupMenu.Separator();
        menuManager.getMenu().add((Component)kdsp, 3);
    }

    protected void getAutoSelectValues() {
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range.size() == 0) {
            return;
        }
        this.getSelectColls().clear();
        this.selectedLongNumber.clear();
        this.selectedLevel.clear();
        TreeBaseInfo info = null;
        IRow row = null;
        KDTSelectBlock block = null;
        for (int index = 0; index < range.size(); ++index) {
            block = (KDTSelectBlock)range.get(index);
            int mode = 0;
            if (block != null && block.size() == 1) {
                mode = ((IBlock)this.tblMain.getSelectManager().getBlocks().get(0)).getMode();
                if (mode != 8) break;
                int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
                for (int s = 0; s < selectRows.length; ++s) {
                    row = this.tblMain.getRow(s);
                    if (row.getStyleAttributes().isHided()) continue;
                    info = (TreeBaseInfo)this.getRowUserObject(row);
                    info.setNumber(BgNumberHelper.trimNumber(info.getNumber()));
                    info.setLongNumber(BgNumberHelper.trimNumber(info.getLongNumber()));
                    this.getSelectColls().put(info.getLongNumber(), info);
                    this.selectedLongNumber.add(info.getLongNumber() + "!");
                    this.selectedLevel.add(info.getLevel());
                }
                break;
            }
            for (int r = block.getBeginRow(); r <= block.getEndRow(); ++r) {
                row = this.tblMain.getRow(r);
                if (row.getStyleAttributes().isHided()) continue;
                info = (TreeBaseInfo)this.getRowUserObject(row);
                info.setNumber(BgNumberHelper.trimNumber(info.getNumber()));
                info.setLongNumber(BgNumberHelper.trimNumber(info.getLongNumber()));
                this.getSelectColls().put(info.getLongNumber(), info);
                this.selectedLongNumber.add(info.getLongNumber() + "!");
                this.selectedLevel.add(info.getLevel());
            }
        }
    }

    protected HashSet<String> verifySelects() {
        HashSet<String> returnSet = new HashSet<String>();
        if (this.getSelectColls().isEmpty()) {
            return returnSet;
        }
        String longNum2 = null;
        TreeBaseInfo info = null;
        ArrayList<String> longNumLst = new ArrayList<String>(this.getSelectColls().keySet());
        Collections.sort(longNumLst);
        HashSet<String> numSet = new HashSet<String>();
        Iterator<String> ite = longNumLst.iterator();
        while (ite.hasNext()) {
            numSet.add(this.getSelectColls().get(ite.next()).getNumber());
        }
        String[] longNumEx = null;
        Boolean hasDerectParent = false;
        Boolean hasInDerectParent = false;
        for (String longNum2 : longNumLst) {
            int length;
            info = this.getSelectColls().get(longNum2);
            if (!longNum2.contains("!") || (length = (longNumEx = longNum2.split("!")).length) < 3) continue;
            hasDerectParent = numSet.contains(longNumEx[length - 2]);
            for (int i = length - 3; i >= 0; --i) {
                if (!numSet.contains(longNumEx[i])) continue;
                hasInDerectParent = true;
                break;
            }
            if (hasDerectParent.booleanValue() || !hasInDerectParent.booleanValue()) continue;
            returnSet.add(info.getNumber());
        }
        return returnSet;
    }

    protected KDTable getTableForCommon() {
        return this.tblMain;
    }
}

