/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.VersionUtil;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.client.AbstractBgVersionListUI;
import com.kingdee.eas.ma.base.client.BgVersionEditUI;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.NumberExpendRender;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgVersionListUI
extends AbstractBgVersionListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgVersionListUI.class);
    private static final String CREATE_ORGUNIT_ID = "orgUnit.id";
    private NumberExpendRender render = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setRender(new NumberExpendRender(1));
        this.tblMain.getColumn("number").setRenderer((IBasicRender)this.getRender());
    }

    protected String getEditUIName() {
        return BgVersionEditUI.class.getName();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgVersionFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("longNumber");
        sic.add("isSysData");
        sic.add("level");
        sic.add("isLeaf");
        sic.add("parent.id");
        sic.add("parent.Number");
        sic.add("parent.name");
        sic.add("parent.longNumber");
        sic.add("parent.level");
        return sic;
    }

    protected BgVersionInfo getSelectedBgVersionInfo() {
        IRow row;
        BgVersionInfo versionInfo = null;
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0 && (row = this.tblMain.getRow(rowIndex)) != null) {
            versionInfo = new BgVersionInfo();
            versionInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            versionInfo.setName(row.getCell("name").getValue().toString());
            Object obj = row.getCell("number").getValue();
            if (obj instanceof NumberExpandInfo) {
                versionInfo.setNumber(((NumberExpandInfo)obj).getNumber());
            } else {
                versionInfo.setNumber(obj.toString());
            }
        }
        return versionInfo;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getType() == 1) {
            IRow row;
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            int clickCount = e.getClickCount();
            if (clickCount == 1 && (row = this.tblMain.getRow(rowIndex)) != null && colIndex == this.tblMain.getColumn("number").getColumnIndex()) {
                NumberExpandInfo expandInfo = (NumberExpandInfo)row.getCell("number").getValue();
                if (this.getRender().inRect(expandInfo, e.getX(), e.getY())) {
                    this.setTreeDisplayStyle(row, expandInfo);
                }
            }
        }
    }

    protected boolean isOrderForClickTableHead() {
        return true;
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) throws Exception {
        boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
        if (!isLeaf) {
            this.tblMain.setRefresh(false);
            this.expandTable(row, expandInfo);
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo) throws Exception {
        if (row == null) {
            return;
        }
        IRow child = null;
        int parentLevel = parentExpandInfo.getLevel();
        String longNumber = null;
        String parentLongNumber = null;
        NumberExpandInfo expandInfo = null;
        parentLongNumber = parentExpandInfo.getLongNumber();
        boolean isExpandStatus = parentExpandInfo.isExpandStatus();
        if (isExpandStatus) {
            parentExpandInfo.setExpandStatus(false);
            int rowCount = this.tblMain.getRowCount3();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell("number").getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                child.getStyleAttributes().setHided(true);
            }
        } else {
            parentExpandInfo.setExpandStatus(true);
            int rowCount = this.tblMain.getRowCount3();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell("number").getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                if (expandInfo.getLevel() - parentLevel != 1) continue;
                child.getStyleAttributes().setHided(false);
                if (expandInfo.isLeaf()) continue;
                expandInfo.setExpandStatus(false);
            }
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    BgVersionListUI.this.afterDataFill_actionEvent(e);
                }
                catch (Exception ex) {
                    BgVersionListUI.this.handUIExceptionAndAbort(ex);
                }
            }
        });
    }

    protected void afterDataFill_actionEvent(KDTDataRequestEvent e) throws Exception {
        int beginIndex = e.getFirstRow();
        int endIndex = e.getLastRow();
        int level = 0;
        Object numberValue = null;
        String id = null;
        String number = null;
        String longNumber = null;
        String name = null;
        IRow row = null;
        NumberExpandInfo expandInfo = null;
        for (int index = beginIndex; index <= endIndex; ++index) {
            row = this.tblMain.getRow(index);
            if (row == null) continue;
            id = (String)row.getCell("id").getValue();
            numberValue = row.getCell("number").getValue();
            if (!(numberValue instanceof String)) {
                return;
            }
            number = numberValue.toString();
            longNumber = row.getCell("longNumber").getValue().toString();
            level = (Integer)row.getCell("level").getValue();
            name = row.getCell("name").getValue() != null ? ((String)row.getCell("name").getValue()).toString() : null;
            boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
            expandInfo = new NumberExpandInfo();
            expandInfo.setId(id);
            expandInfo.setLevel(level);
            expandInfo.setLeaf(isLeaf);
            expandInfo.setName(number);
            expandInfo.setNumber(number);
            expandInfo.setLongNumber(longNumber);
            expandInfo.setExpandStatus(true);
            row.getCell("number").setValue((Object)expandInfo);
            row.getCell("number").setRenderer((IBasicRender)this.getRender());
        }
    }

    public NumberExpendRender getRender() {
        return this.render;
    }

    public void setRender(NumberExpendRender render) {
        this.render = render;
    }

    protected List<Integer> getSelectRowIndex() {
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range.size() == 0) {
            return null;
        }
        ArrayList<Integer> selectRowIndex = new ArrayList<Integer>();
        KDTSelectBlock block = null;
        for (int index = 0; index < range.size(); ++index) {
            block = (KDTSelectBlock)range.get(index);
            for (int r = block.getBeginRow(); r <= block.getEndRow(); ++r) {
                selectRowIndex.add(r);
            }
        }
        Collections.sort(selectRowIndex);
        return selectRowIndex;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int re = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "delete_confirm"));
        if (re == 1 || re == 2) {
            return;
        }
        List<Integer> indexs = this.getSelectRowIndex();
        ArrayList<String> selectDel = new ArrayList<String>();
        IRow row = null;
        String rowId = null;
        int rowIndex = 0;
        HashMap<String, String> numberMap = new HashMap<String, String>();
        HashSet<String> difOrg = new HashSet<String>();
        HashSet<String> sysVersion = new HashSet<String>();
        CostCenterOrgUnitInfo ccoui = SysContext.getSysContext().getCurrentCostUnit();
        for (int index = 0; index < indexs.size(); ++index) {
            rowIndex = indexs.get(index);
            row = this.tblMain.getRow(indexs.get(index).intValue());
            rowId = row.getCell("id").getValue().toString();
            String creatOrgId = row.getCell(CREATE_ORGUNIT_ID).getValue().toString();
            NumberExpandInfo Info = (NumberExpandInfo)row.getCell("number").getValue();
            String number = Info.getNumber().toString();
            if (rowId != null) {
                if (Integer.valueOf(row.getCell("isSysData").getValue().toString()) == 1) {
                    sysVersion.add(rowId.toString());
                } else if (!creatOrgId.equalsIgnoreCase(ccoui.getId().toString())) {
                    difOrg.add(rowId);
                } else {
                    selectDel.add(rowId);
                }
            }
            numberMap.put(rowId, number);
        }
        Map result = BgVersionFactory.getRemoteInstance().remove(selectDel);
        Set cantRemove = new HashSet();
        Set delete = new HashSet();
        if (result != null) {
            cantRemove = (Set)result.get("cantRemove");
            delete = (Set)result.get("canSet");
        }
        StringBuffer message = new StringBuffer();
        if (sysVersion.size() == 0 && cantRemove.size() == 0 && difOrg.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "delete_success"));
            this.refresh(e);
        } else {
            String id;
            Iterator iter = delete.iterator();
            while (iter.hasNext()) {
                id = iter.next().toString();
                message.append(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "removeSuccess"), numberMap.get(id)));
                message.append("\r\n");
            }
            iter = sysVersion.iterator();
            while (iter.hasNext()) {
                id = iter.next().toString();
                message.append(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "cantRemoveSysdate"), numberMap.get(id)));
                message.append("\r\n");
            }
            iter = cantRemove.iterator();
            while (iter.hasNext()) {
                id = iter.next().toString();
                message.append(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "cantRemoveSelf"), numberMap.get(id)));
                message.append("\r\n");
            }
            iter = difOrg.iterator();
            while (iter.hasNext()) {
                id = iter.next().toString();
                message.append(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "remove_difOrg"), numberMap.get(id)));
                message.append("\r\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "delete_failed"), (String)message.toString(), (int)1);
        }
        this.tblMain.refresh();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        CostCenterOrgUnitInfo ccoui = SysContext.getSysContext().getCurrentCostUnit();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(selectRows[0]);
        Object oldParentId = row.getCell("parent.id").getValue();
        Object longNumber = row.getCell("longNumber").getValue();
        String createOrgUnitId = row.getCell(CREATE_ORGUNIT_ID).getValue().toString();
        if (!createOrgUnitId.equalsIgnoreCase(ccoui.getId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "cannotEditVersion"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
        Object newParentId = row.getCell("parent.id").getValue();
        if (oldParentId != null && (!oldParentId.toString().equals(newParentId.toString()) && newParentId != null || newParentId == null)) {
            this.dealParent(oldParentId.toString(), longNumber.toString());
        }
    }

    public void dealParent(String oldParentId, String longNumber) {
        String parentLongNumber = null;
        if (longNumber != null) {
            parentLongNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
        }
        boolean hasChild = false;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!row.getCell("longNumber").getValue().toString().startsWith(parentLongNumber + "!")) continue;
            hasChild = true;
            break;
        }
        if (!hasChild) {
            try {
                BgVersionInfo oldParent = BgVersionFactory.getRemoteInstance().getBgVersionInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)oldParentId)));
                oldParent.setIsLeaf(true);
                BgVersionFactory.getRemoteInstance().save((CoreBaseInfo)oldParent);
            }
            catch (EASBizException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (UuidException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        String url = "http://club.kisdee.com/forumall.php";
        VersionUtil.gotoSite((String)url);
    }

    @Override
    protected void cbxIsShowRoll_itemStateChanged(ItemEvent e) throws Exception {
        this.execQuery();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo vi) {
        EntityViewInfo viewInfo = null;
        viewInfo = vi == null ? new EntityViewInfo() : (EntityViewInfo)vi.clone();
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        if (!this.cbxIsShowRoll.isSelected()) {
            BgCommHelper.addFilterItem(viewInfo.getFilter(), new FilterItemInfo("isRollVersion", (Object)false, CompareType.EQUALS));
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }
}

