/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.MetaDataFacadeFactory;
import com.kingdee.eas.ma.base.client.utils.BgEntityUtil;
import com.kingdee.eas.ma.base.utils.BgLocaleHelper;
import com.kingdee.eas.ma.base.utils.VirtualMetaInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class DimMetaDataTreeDlgUI
extends KDDialog
implements KDPromptSelector {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)DimMetaDataTreeDlgUI.class.getName());
    public static final String JAVA_LANG = "java.lang.";
    private int maxLevel = 3;
    private String targetClazz = null;
    private static Icon icon = EASResource.getIcon((String)"imgTbtn_distributelog");
    private static Map map = new HashMap();
    private static final String entityTreePromptDialogRes = "com.kingdee.eas.base.commonquery.client.EntityTreePromptDialog";
    private Map entities = new Hashtable();
    private EntityObjectInfo entity;
    private KDTree tree;
    private KDButton btnCommit;
    private KDButton btnCancel;
    private boolean cancel = false;
    private DefaultKingdeeTreeNode result = null;

    public DimMetaDataTreeDlgUI(Dialog owner, String title, boolean modal, EntityObjectInfo entity) {
        super(owner, title, modal);
        this.entity = entity;
        this.jbInit();
    }

    public DimMetaDataTreeDlgUI(Frame owner, String title, boolean modal, EntityObjectInfo entity) {
        super(owner, title, modal);
        this.entity = entity;
        this.jbInit();
    }

    private void jbInit() {
        this.createTree();
        KDTreeView kDTreeView = new KDTreeView();
        kDTreeView.setShowButton(false);
        kDTreeView.setShowControlPanel(false);
        kDTreeView.setTree(this.tree);
        kDTreeView.setAutoscrolls(true);
        this.setSize(new Dimension(510, 410));
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(null);
        this.getContentPane().add((Component)kDTreeView);
        kDTreeView.setBounds(10, 10, 480, 323);
        KDSeparator separator = new KDSeparator();
        this.getContentPane().add((Component)separator);
        separator.setBounds(0, 343, 500, 2);
        this.btnCommit = new KDButton();
        this.btnCommit.setText(EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgBaseResource", (String)"confirm"));
        this.btnCommit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DimMetaDataTreeDlgUI.this.btnCommit_onclick(e);
            }
        });
        this.btnCancel = new KDButton();
        this.btnCancel.setText(EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgBaseResource", (String)"cancel"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DimMetaDataTreeDlgUI.this.btnCancel_onclick(e);
            }
        });
        this.getContentPane().add((Component)this.btnCommit);
        this.getContentPane().add((Component)this.btnCancel);
        this.btnCommit.setBounds(341, 353, 73, 21);
        this.btnCancel.setBounds(417, 353, 73, 21);
        this.setResizable(false);
    }

    private void createTree() {
        try {
            map = MetaDataFacadeFactory.getRemoteInstance().getGeneralAssActType();
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        DefaultKingdeeTreeNode root = this.createRoot();
        this.tree = new KDTree((ITreeNode)root, false);
        this.tree.addTreeWillExpandListener((TreeWillExpandListener)new DimTreeWillExpandListener());
        ((KingdeeTreeModel)this.tree.getModel()).setAsksAllowsChildren(true);
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DimMetaDataTreeDlgUI.this.tree_mouseClicked(e);
            }
        });
    }

    private void tree_mouseClicked(MouseEvent e) {
        this.result = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            if (this.result == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)entityTreePromptDialogRes, (String)"choseWarning"));
            } else if (this.result instanceof DefaultKingdeeTreeNode && !this.result.getAllowsChildren()) {
                this.dispose();
                this.cancel = false;
            }
        }
    }

    private DefaultKingdeeTreeNode createRoot() {
        EntityObjectInfo entity = this.getEntity(this.entity.getFullName());
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        root.setText(BgEntityUtil.getEntityAlias(this.entity, null));
        VirtualMetaInfo dataObject = new VirtualMetaInfo();
        dataObject.setEntity(entity);
        dataObject.setName("");
        dataObject.setAlias("");
        root.setUserObject((Object)dataObject);
        this.createChildNode(root);
        return root;
    }

    private void createChildNode(DefaultKingdeeTreeNode parentNode) {
        VirtualMetaInfo dataObject = (VirtualMetaInfo)((Object)parentNode.getUserObject());
        EntityObjectInfo entity = dataObject.getEntity();
        if (entity == null || dataObject.isExpanded()) {
            return;
        }
        ArrayList al = BgEntityUtil.getWithOutProperties(dataObject.getExtendValue());
        al.add("specialNumber");
        al.add("isSumFormula");
        al.add("acctInit");
        al.add("acctMaintain");
        PropertyCollection properties = BgEntityUtil.getAllEntityProperties(entity);
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = properties.get(i);
            if (!(propertyInfo instanceof OwnPropertyInfo) && dataObject.getNodeLevel() >= this.maxLevel || al.contains(propertyInfo.getName())) continue;
            VirtualMetaInfo childDataObject = new VirtualMetaInfo();
            childDataObject.setNodeLevel(dataObject.getNodeLevel() + 1);
            BgLocaleHelper.copyMultiLangField((IObjectValue)childDataObject, (IObjectValue)propertyInfo, "alias", "alias");
            childDataObject.setName(this.getValue(dataObject, propertyInfo.getName()));
            childDataObject.setExtendValue(this.getExtendValue(dataObject, propertyInfo));
            DefaultKingdeeTreeNode childNode = new DefaultKingdeeTreeNode((Object)childDataObject);
            childNode.setText(BgEntityUtil.getPropertyAlias(propertyInfo));
            if (propertyInfo instanceof OwnPropertyInfo) {
                OwnPropertyInfo own = (OwnPropertyInfo)propertyInfo;
                childDataObject.setMultilingual(own.isMultilingual());
                childDataObject.setTableField(own.getMappingField().getName());
                if (((OwnPropertyInfo)propertyInfo).getDataType().equals((Object)DataType.BYTEARRAY)) continue;
            }
            if (propertyInfo instanceof LinkPropertyInfo) {
                LinkPropertyInfo linkProp = (LinkPropertyInfo)propertyInfo;
                CardinalityType type = linkProp.getRelationship().getChildCardinality(entity);
                if (CardinalityType.ONE_TO_UNBOUNDED.equals((Object)type) || CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)type)) continue;
                childDataObject.setEntity(linkProp.getRelationship().getChildObject(entity));
            } else {
                childNode.setAllowsChildren(false);
            }
            parentNode.add((MutableTreeNode)childNode);
        }
    }

    private String getExtendValue(VirtualMetaInfo parent, PropertyInfo propertyInfo) {
        String extendValue = "";
        String parentExtendValue = parent.getExtendValue();
        String refEntityName = null;
        if (propertyInfo instanceof LinkPropertyInfo) {
            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
            refEntityName = BgEntityUtil.getEntity(parentExtendValue, linkPropertyInfo).getFullName();
        }
        extendValue = refEntityName == null ? parentExtendValue : refEntityName;
        return extendValue;
    }

    private String getValue(VirtualMetaInfo parent, String propertyName) {
        String value = "";
        String parentValue = parent.getName();
        value = parentValue.length() == 0 ? propertyName : parentValue + "." + propertyName;
        return value;
    }

    private EntityObjectInfo getEntity(String entityName) {
        EntityObjectInfo objectInfo = null;
        if (!this.entities.containsKey(entityName)) {
            objectInfo = BgEntityUtil.getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
            this.entities.put(entityName, objectInfo);
        } else {
            objectInfo = (EntityObjectInfo)this.entities.get(entityName);
        }
        return objectInfo;
    }

    private void btnCommit_onclick(ActionEvent e) {
        this.result = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (this.result == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)entityTreePromptDialogRes, (String)"choseWarning"));
        } else if (this.result instanceof DefaultKingdeeTreeNode) {
            if (this.result.getAllowsChildren()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgBaseResource", (String)"selectLeaf"));
                this.result = null;
            } else {
                this.dispose();
                this.cancel = false;
            }
        }
    }

    private void btnCancel_onclick(ActionEvent e) {
        this.dispose();
        this.cancel = true;
    }

    public boolean isCanceled() {
        return this.cancel;
    }

    public Object getData() {
        if (this.result != null) {
            VirtualMetaInfo dataObject = null;
            if (this.result.getUserObject() instanceof VirtualMetaInfo) {
                TreeNode[] nodes = this.result.getPath();
                StringBuffer str = new StringBuffer();
                for (int i = 1; i < nodes.length; ++i) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)nodes[i];
                    str.append(node.getText());
                    if (i >= nodes.length - 1) continue;
                    str.append(".");
                }
                dataObject = (VirtualMetaInfo)((Object)this.result.getUserObject());
                String property = dataObject.getName();
                int index = property.lastIndexOf(".");
                if (index != -1) {
                    property = property.substring(index + 1);
                }
                dataObject.setAlias(str.toString());
                return dataObject;
            }
        }
        return null;
    }

    protected String getFullName(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return null;
        }
        return this.getFullName(node, node.getText());
    }

    protected String getFullName(DefaultKingdeeTreeNode node, String fullname) {
        if (node == null || fullname == null) {
            return null;
        }
        if (node.getRoot() == node.getParent()) {
            return fullname;
        }
        if (node.getParent() != null) {
            DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)node.getParent();
            fullname = this.getFullName(parent, parent.getText() + "." + fullname);
        }
        return fullname;
    }

    public static void initChildren(DefaultKingdeeTreeNode root, String targetClazz, int level, int expandLevel) {
    }

    private class DimTreeWillExpandListener
    implements TreeWillExpandListener {
        private DimTreeWillExpandListener() {
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            TreePath path = event.getPath();
            DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            DimMetaDataTreeDlgUI.this.createChildNode(selectedNode);
        }
    }
}

