/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.AsstActNodeCollection;
import com.kingdee.eas.ma.base.AsstActNodeInfo;
import com.kingdee.eas.ma.base.MbgDimFactory;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.RptSrcTypeEnum;
import com.kingdee.eas.ma.base.client.AbstractMbgDimEditUI;
import com.kingdee.eas.ma.base.client.MbgDimListUI;
import com.kingdee.eas.ma.base.utils.BgAccountHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MbgDimEditUI
extends AbstractMbgDimEditUI {
    private static final long serialVersionUID = 5912326025497139892L;
    private static final Logger logger = CoreUIObject.getLogger(MbgDimEditUI.class);
    private boolean isRelease = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.contAssActType.getBoundLabel().setToolTipText(this.contAssActType.getToolTipText());
        this.isRelease = true;
        this.prmtAsstActType.setEditFormatter((IFormatter)new MyFormat("number"));
        this.prmtAsstActType.setDisplayFormatter((IFormatter)new MyFormat("name"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (DimensionBaseConstants.DEF_CSL_NUMBER.equals(this.editData.getNumber())) {
            this.editData.setDescription(this.editData.getDescription(new Locale("l2")), new Locale("l1"));
            this.editData.setDescription(this.editData.getDescription(new Locale("l2")), new Locale("l3"));
        }
        if (this.editData.getAsstActs() != null && !this.editData.getAsstActs().isEmpty()) {
            this.prmtAsstActType.setDataNoNotify((Object)this.editData.getAsstActs());
        } else if (this.editData.getAsstActType() != null) {
            this.prmtAsstActType.setDataNoNotify((Object)this.editData.getAsstActType());
        }
    }

    protected String getClassAlise() {
        return EASResource.getString((String)"com.kingdee.eas.ma.biz.client.BizResource", (String)"refDim");
    }

    protected LanguageInfo getCurrentLanguage() {
        return new LanguageInfo(this.getCurrentLocale());
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        LanguageInfo currLang = this.getCurrentLanguage();
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"numberIsNull"));
            SysUtil.abort();
        }
        if (!BgNumberHelper.checkNumber(this.txtNumber.getText())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"specialCharInNumber"));
            SysUtil.abort();
        }
        if (this.txtName.getItemBy(currLang).getData() == null || StringUtils.isEmpty((String)this.txtName.getItemBy(currLang).getData().toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"nameIsNull"));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        MbgDimInfo mbgDimInfo = new MbgDimInfo();
        Object orgunit = this.getUIContext().get("unitinfo");
        mbgDimInfo.setId(BOSUuid.create((BOSObjectType)mbgDimInfo.getBOSType()));
        mbgDimInfo.setOrgUnit((FullOrgUnitInfo)orgunit);
        mbgDimInfo.setSourceType((RptSrcTypeEnum)((Object)this.getUIContext().get("sourceType")));
        if (this.editData != null && this.getUIContext().get("listui") != null) {
            ((MbgDimListUI)((Object)this.getUIContext().get("listui"))).setAddNewId(this.editData.getId().toString());
        }
        return mbgDimInfo;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.afterStoreFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnEdit.setEnabled(false);
            this.btnAddNew.setEnabled(true);
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(false);
            this.btnAddNew.setEnabled(true);
        } else if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.btnAddNew.setEnabled(true);
            this.txtNumber.setEnabled(true);
            this.txtNumber.setFocusable(true);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        if (DimensionBaseConstants.DEF_CSL_NUMBER.equals(this.editData.getNumber())) {
            this.btnSubmit.setEnabled(false);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(true);
            this.txtNumber.requestFocus(true);
        }
        if (this.getUIContext().get("listui") != null) {
            ((MbgDimListUI)((Object)this.getUIContext().get("listui"))).setAddNewId(this.editData.getId().toString());
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MbgDimFactory.getRemoteInstance();
    }

    public boolean checkBeforeWindowClosing() {
        MbgDimInfo obj;
        boolean bclose = super.checkBeforeWindowClosing();
        if (bclose && this.isRelease && (obj = (MbgDimInfo)this.getDataObject()).getId() != null) {
            BgAccountHelper.releaseMutexService(obj.getId().toString());
        }
        return bclose;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("sourceType");
        sic.add("asstActType.*");
        sic.add("asstActs.id");
        sic.add("asstActs.*");
        sic.add("asstActs.asstActType.*");
        return sic;
    }

    public void afterStoreFields() {
        if (this.prmtAsstActType.getData() == null) {
            this.editData.getAsstActs().clear();
            this.editData.setAsstActType(null);
        } else {
            Object obj = this.prmtAsstActType.getData();
            AsstActTypeInfo info = null;
            AsstActNodeInfo nodeInfo = null;
            if (obj instanceof AsstActTypeInfo) {
                this.editData.getAsstActs().clear();
                info = (AsstActTypeInfo)obj;
                nodeInfo = new AsstActNodeInfo();
                nodeInfo.setId(BOSUuid.create((BOSObjectType)nodeInfo.getBOSType()));
                nodeInfo.setMbgDim(this.editData);
                nodeInfo.setAsstActType(info);
                this.editData.getAsstActs().add(nodeInfo);
            } else if (obj instanceof Object[]) {
                this.editData.getAsstActs().clear();
                this.editData.setAsstActType(null);
                for (int i = 0; i < ((Object[])obj).length; ++i) {
                    info = (AsstActTypeInfo)((Object[])obj)[i];
                    if (info == null) continue;
                    nodeInfo = new AsstActNodeInfo();
                    nodeInfo.setId(BOSUuid.create((BOSObjectType)nodeInfo.getBOSType()));
                    nodeInfo.setMbgDim(this.editData);
                    nodeInfo.setAsstActType(info);
                    this.editData.getAsstActs().add(nodeInfo);
                }
            }
        }
    }

    class MyFormat
    implements IFormatter {
        private String property = null;

        public MyFormat(String property) {
            this.property = property;
        }

        public String valueToString(Object o) {
            if (o instanceof AsstActNodeCollection) {
                AsstActNodeCollection col = (AsstActNodeCollection)((Object)o);
                if (col.isEmpty()) {
                    return null;
                }
                StringBuffer value = new StringBuffer();
                for (int i = 0; i < col.size(); ++i) {
                    if (value.length() > 0) {
                        value.append("; ");
                    }
                    value.append(col.get(i).getAsstActType().get(this.property));
                }
                return value.toString();
            }
            if (o instanceof Object[]) {
                Object[] objs = (Object[])o;
                StringBuffer value = new StringBuffer();
                for (int i = 0; i < objs.length; ++i) {
                    if (objs[i] instanceof AsstActTypeInfo) {
                        if (value.length() > 0) {
                            value.append("; ");
                        }
                        value.append(((AsstActTypeInfo)objs[i]).get(this.property));
                        continue;
                    }
                    if (!(objs[i] instanceof AsstActNodeInfo)) continue;
                    if (value.length() > 0) {
                        value.append("; ");
                    }
                    value.append(((AsstActNodeInfo)objs[i]).getAsstActType().get(this.property));
                }
                return value.toString();
            }
            if (o instanceof AsstActTypeInfo) {
                return (String)((AsstActTypeInfo)o).get(this.property);
            }
            return null;
        }

        public void applyPattern(String pattern) {
        }
    }
}

