/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.base.IMbgMember;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.MbgMemberNodeCollection;
import com.kingdee.eas.ma.base.MbgMemberNodeFactory;
import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.base.MemberSegregationRuleEnum;
import com.kingdee.eas.ma.base.client.AbstractMbgMemberListF7UI;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.NumberExpendRender;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgMemberListF7UI
extends AbstractMbgMemberListF7UI {
    private static final Logger logger = CoreUIObject.getLogger(MbgMemberListF7UI.class);
    private MbgMemberInfo mbgMemberInfo = null;
    private boolean isCancel = true;
    protected NumberExpendRender render = new NumberExpendRender(1);
    private String viewId = null;
    private String longNumber = null;
    private MbgMemberCollection result = new MbgMemberCollection();

    public String getLongNumber() {
        return this.longNumber;
    }

    public void setLongNumber(String longNumber) {
        this.longNumber = longNumber;
    }

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public MbgMemberInfo getMbgMemberInfo() {
        return this.mbgMemberInfo;
    }

    protected MbgMemberCollection getResult() {
        return this.result;
    }

    protected MbgMemberInfo getResultOne() {
        if (!this.result.isEmpty()) {
            return this.result.get(0);
        }
        return null;
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        if (this.getUIContext().get("viewId") != null) {
            this.setViewId(this.getUIContext().get("viewId").toString());
        }
        if (this.getUIContext().get("longNumber") != null) {
            this.setLongNumber(this.getUIContext().get("longNumber").toString());
        }
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("name").getStyleAttributes().setLocked(true);
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        viewInfo = new EntityViewInfo();
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        FilterItemInfo viewid = new FilterItemInfo("viewid", (Object)this.getViewId(), CompareType.EQUALS);
        viewInfo.getFilter().getFilterItems().add(viewid);
        Object mbgView = this.getUIContext().get("mbgView");
        Object orgUnitInfo = this.getUIContext().get("orgunit.id");
        FilterInfo filter = viewInfo.getFilter();
        int index = 0;
        if (mbgView != null && mbgView instanceof MbgViewInfo) {
            if (((MbgViewInfo)mbgView).getSegregationRule().equals((Object)MemberSegregationRuleEnum.SEGREGATEEQUALS)) {
                Set<String> orgUnitIds = this.getParentAndChildrenOrgUnitIds((OrgUnitInfo)orgUnitInfo);
                if (!orgUnitIds.isEmpty()) {
                    viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", orgUnitIds, CompareType.INCLUDE));
                    ++index;
                }
            } else if (((MbgViewInfo)mbgView).getSegregationRule().equals((Object)MemberSegregationRuleEnum.SEGREGATEORG)) {
                FilterItemInfo orgItemInfo = null;
                OrgUnitInfo orginfo = (OrgUnitInfo)orgUnitInfo;
                if (orginfo != null) {
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setFilter(new FilterInfo());
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("mbgMember.viewId", (Object)((MbgViewInfo)mbgView).getId().toString(), CompareType.EQUALS));
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orginfo.getId().toString(), CompareType.EQUALS));
                    MbgMemberNodeCollection coll = null;
                    try {
                        coll = MbgMemberNodeFactory.getRemoteInstance().getMbgMemberNodeCollection(evi);
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    orgItemInfo = new FilterItemInfo("orgUnit.id", (Object)orginfo.getId().toString(), CompareType.EQUALS);
                    BgCommCHelper.replaceFilterItems(filter, orgItemInfo);
                    filter.getFilterItems().add(new FilterItemInfo("isSystemDefault", (Object)1, CompareType.EQUALS));
                    if (coll != null && !coll.isEmpty()) {
                        HashSet<String> memberids = new HashSet<String>();
                        for (int i = 0; i < coll.size(); ++i) {
                            memberids.add(coll.get(i).getMbgMember().getId().toString());
                        }
                        orgItemInfo = new FilterItemInfo("id", memberids, CompareType.INCLUDE);
                        BgCommCHelper.replaceFilterItems(filter, orgItemInfo);
                        viewInfo.getFilter().setMaskString("#0 and ( #1 OR #2 OR #3)");
                        index += 3;
                    } else {
                        viewInfo.getFilter().setMaskString("#0 and ( #1 OR #2 )");
                        index += 2;
                    }
                }
            }
        }
        if (this.kDTextField1.getText().trim().length() > 0) {
            FilterItemInfo item = new FilterItemInfo("number", (Object)('%' + this.kDTextField1.getText() + '%'), CompareType.LIKE);
            viewInfo.getFilter().getFilterItems().add(item);
            item = new FilterItemInfo("name", (Object)('%' + this.kDTextField1.getText() + '%'), CompareType.LIKE);
            viewInfo.getFilter().getFilterItems().add(item);
            String maskString = "#0";
            if (index == 1) {
                maskString = "#0 and #1";
            } else if (index == 2) {
                maskString = "#0 and ( #1 OR #2 )";
            } else if (index == 3) {
                maskString = "#0 and ( #1 OR #2 OR #3)";
            }
            viewInfo.getFilter().setMaskString("( " + maskString + " and (#" + String.valueOf(viewInfo.getFilter().getFilterItems().size() - 2) + " or #" + String.valueOf(viewInfo.getFilter().getFilterItems().size() - 1) + "))");
        }
        if (this.getUIContext().get("number") != null) {
            FilterItemInfo currentNum = new FilterItemInfo("number", this.getUIContext().get("number"), CompareType.NOTEQUALS);
            viewInfo.getFilter().getFilterItems().add(currentNum);
        }
        SorterItemCollection sic = new SorterItemCollection();
        SorterItemInfo sortorSysDefault = new SorterItemInfo("isSystemDefault");
        sortorSysDefault.setSortType(SortType.DESCEND);
        sic.add(sortorSysDefault);
        viewInfo.setSorter(sic);
        SorterItemInfo sortorLongNum = new SorterItemInfo("longNumber");
        sortorLongNum.setSortType(SortType.ASCEND);
        sic.add(sortorLongNum);
        IQueryExecutor ex = super.getQueryExecutor(queryPK, viewInfo);
        return ex;
    }

    @Override
    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.mbgMemberQuery == null) {
            this.mbgMemberQuery = new EntityViewInfo();
        }
        this.mbgMemberQuery = this.getEntityViewFilter();
        int start = (Integer)e.getParam1();
        int length = (Integer)e.getParam2() - start + 1;
        try {
            IQueryExecutor exec = this.getQueryExecutor(this.mbgMemberQueryPK, this.mbgMemberQuery);
            exec.option().isAutoTranslateEnum = true;
            IRowSet rowSet = exec.executeQuery(start, length);
            e.setRowSet(rowSet);
            this.onGetRowSet(rowSet);
        }
        catch (Exception ee) {
            this.handUIException(ee);
        }
    }

    protected EntityViewInfo getEntityViewFilter() {
        EntityViewInfo result = new EntityViewInfo();
        return result;
    }

    @Override
    protected void btnCancel1_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel1_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    @Override
    protected void btnSearch1_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.removeRows();
        this.getQueryExecutor(this.mbgMemberQueryPK, this.mbgMemberQuery);
    }

    @Override
    protected void btnSubmit1_actionPerformed(ActionEvent e) throws Exception {
        this.onBtnConfirm();
    }

    private IMbgMember getBizInterface() throws BOSException {
        return MbgMemberFactory.getRemoteInstance();
    }

    private void onBtnConfirm() throws Exception {
        boolean isFilteSys;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        int currRow = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow iRow = this.tblMain.getRow(currRow);
        String id = iRow.getCell("id").getValue().toString();
        int level = (Integer)iRow.getCell("level").getValue();
        boolean bl = isFilteSys = this.getUIContext().get("isSystemDefault") != null ? (Boolean)this.getUIContext().get("isSystemDefault") : false;
        if (level == 2 && Boolean.parseBoolean(iRow.getCell("isSystemDefault").getValue().toString()) && !isFilteSys) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cantChoosePreMember"));
            SysUtil.abort();
        }
        try {
            this.result.add(this.getBizInterface().getMbgMemberInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id))));
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        this.isCancel = false;
        this.getUIWindow().close();
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblMain.checkParsed();
        this.tblMain.getColumn("number").setRenderer((IBasicRender)this.render);
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            return;
        }
        if (e.getType() == 1) {
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            int clickCount = e.getClickCount();
            if (clickCount == 1) {
                NumberExpandInfo expandInfo;
                IRow row = this.tblMain.getRow(rowIndex);
                this.tblMain.getSelectManager().select(rowIndex, 0);
                if (row != null && colIndex == this.tblMain.getColumn("number").getColumnIndex() && row.getCell("number").getValue() instanceof NumberExpandInfo && this.render.inRect(expandInfo = (NumberExpandInfo)row.getCell("number").getValue(), e.getX(), e.getY())) {
                    try {
                        this.setTreeDisplayStyle(row, expandInfo);
                    }
                    catch (Exception e1) {
                        logger.error((Object)"", (Throwable)e1);
                        this.handUIExceptionAndAbort(e1);
                    }
                }
            }
        }
        if (e.getClickCount() == 2) {
            this.onBtnConfirm();
        }
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) throws Exception {
        boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
        if (!isLeaf) {
            this.tblMain.setRefresh(false);
            this.expandTable(row, expandInfo, expandInfo.isExpandStatus());
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo, boolean isExpandStatus) throws Exception {
        int rowIndex;
        if (row == null) {
            return;
        }
        IRow child = null;
        int parentLevel = parentExpandInfo.getLevel();
        String longNumber = null;
        String parentLongNumber = parentExpandInfo.getLongNumber();
        NumberExpandInfo expandInfo = null;
        int rowCount = this.tblMain.getRowCount3();
        if (isExpandStatus) {
            parentExpandInfo.setExpandStatus(false);
            for (rowIndex = row.getRowIndex() + 1; rowIndex < rowCount; ++rowIndex) {
                child = this.tblMain.getRow(rowIndex);
                if (child == null || child.getCell("number") == null) {
                    return;
                }
                expandInfo = (NumberExpandInfo)child.getCell("number").getValue();
                longNumber = expandInfo.getLongNumber();
                if (longNumber.startsWith(parentLongNumber + "!")) {
                    expandInfo.setExpandStatus(false);
                    child.getStyleAttributes().setHided(true);
                    continue;
                }
                break;
            }
        } else {
            parentExpandInfo.setExpandStatus(true);
            while (rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell("number").getValue()).getLongNumber()).startsWith(parentLongNumber + "!")) {
                if (expandInfo.getLevel() - parentLevel == 1) {
                    child.getStyleAttributes().setHided(false);
                    if (!expandInfo.isLeaf()) {
                        expandInfo.setExpandStatus(false);
                    }
                }
                ++rowIndex;
            }
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int start = e.getFirstRow();
                int end = e.getLastRow();
                MbgMemberListF7UI.this.setTableDisplayStyle(start, end);
                MbgMemberListF7UI.this.tblMain.requestFocus();
            }
        });
    }

    private void setTableDisplayStyle(int startup, int end) {
        IRow row = null;
        int level = 0;
        Object obj = null;
        NumberExpandInfo expandInfo = null;
        int sizeHirac = 0;
        if (this.getLongNumber() != null) {
            sizeHirac = this.getLongNumber().split("!").length;
        }
        int count = end;
        for (int i = startup; i <= count; ++i) {
            row = this.tblMain.getRow(i);
            if (row == null) continue;
            String id = (String)row.getCell("id").getValue();
            obj = row.getCell("number").getValue();
            if (!(obj instanceof String)) {
                return;
            }
            String number = (String)obj;
            String longNumber = row.getCell("longNumber").getValue().toString();
            level = (Integer)row.getCell("level").getValue();
            boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
            row.getCell("parent.name").getStyleAttributes().setLocked(true);
            if (sizeHirac > 1) {
                this.hideSelfAndChilds(row, longNumber, this.getLongNumber());
            }
            if (end - startup == 1) continue;
            expandInfo = new NumberExpandInfo();
            expandInfo.setId(id);
            expandInfo.setNumber(number);
            expandInfo.setLongNumber(longNumber);
            expandInfo.setLevel(level);
            expandInfo.setLeaf(isLeaf);
            expandInfo.setExpandStatus(true);
            row.getCell("number").setValue((Object)expandInfo);
        }
    }

    private void hideSelfAndChilds(IRow row, String longNumber, String curMemLongNumber) {
        if (row == null || StringUtils.isEmpty((String)longNumber) || StringUtils.isEmpty((String)curMemLongNumber)) {
            return;
        }
        if (longNumber.startsWith(curMemLongNumber)) {
            row.getStyleAttributes().setHided(true);
            row.getStyleAttributes().setLocked(true);
        }
    }

    @Override
    protected void kDTextField1_focusLost(FocusEvent e) throws Exception {
        this.tblMain.removeRows();
        if (StringUtils.isEmpty((String)this.kDTextField1.getText())) {
            return;
        }
        this.onBtnConfirm();
        super.kDTextField1_focusLost(e);
    }

    private Set<String> getParentAndChildrenOrgUnitIds(OrgUnitInfo unitInfo) {
        if (unitInfo == null) {
            return new HashSet<String>();
        }
        String longNumber = unitInfo.getLongNumber();
        String[] tmpLongNumbers = longNumber.split("!");
        if (tmpLongNumbers.length == 1) {
            return new HashSet<String>();
        }
        HashSet<String> orgUnitIds = new HashSet<String>();
        longNumber = unitInfo.getLongNumber();
        Object[] parentNumbers = longNumber.split("!");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        filter.getFilterItems().add(new FilterItemInfo("number", new HashSet(Arrays.asList((Object[])parentNumbers)), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(unitInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filter.setMaskString("#0 or #1");
        evi.setFilter(filter);
        evi.setSelector(sic);
        CostCenterOrgUnitCollection costCenterColls = null;
        try {
            costCenterColls = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)"getParentAndChildrenOrgUnitIds error");
        }
        if (costCenterColls == null) {
            return new HashSet<String>();
        }
        for (int i = 0; i < costCenterColls.size(); ++i) {
            orgUnitIds.add(costCenterColls.get(i).getId().toString());
        }
        return orgUnitIds;
    }
}

