/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.BooleanEnum;
import com.kingdee.eas.base.param.IOtherParam;
import com.kingdee.eas.base.param.ISetOrgType;
import com.kingdee.eas.base.param.client.ICustomParamUI;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.MbgParamsCollection;
import com.kingdee.eas.ma.base.MbgParamsInfo;
import com.kingdee.eas.ma.base.MbgParamsValueFactory;
import com.kingdee.eas.ma.base.MbgParamsValueInfo;
import com.kingdee.eas.ma.base.client.AbstractMbgParamEditUI;
import com.kingdee.util.StringUtils;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class MbgParamEditUI
extends AbstractMbgParamEditUI
implements ICustomParamUI,
IOtherParam,
ISetOrgType {
    private static final long serialVersionUID = 7420286104695081956L;
    private static final Logger logger = CoreUIObject.getLogger(MbgParamEditUI.class);
    private OrgType selOrgType = null;
    private OrgUnitInfo selOrgUnit = null;
    private Map<String, Map<String, MbgParamsInfo>> paramsValueMap = new HashMap<String, Map<String, MbgParamsInfo>>();
    private Comparator<String> comparator = new Comparator<String>(){

        @Override
        public int compare(String p1, String p2) {
            return p1.compareTo(p2);
        }
    };
    private ICellEditor booleanEditor = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    protected void init() throws Exception {
        this.paramsValueMap.clear();
        this.kdParams.checkParsed();
    }

    protected void loadParams() throws Exception {
        this.kdParams.removeRows();
        if (this.selOrgType == null || this.selOrgUnit == null) {
            return;
        }
        MbgParamsInfo mbgParam = null;
        Map<String, MbgParamsInfo> params = null;
        String paramKey = this.getParamKey();
        if (!this.paramsValueMap.containsKey(paramKey)) {
            MbgParamsCollection colls = (MbgParamsCollection)MbgParamsValueFactory.getRemoteInstance().loadParams(this.selOrgType.getValue(), this.selOrgUnit.getId());
            if (colls != null) {
                params = new TreeMap<String, MbgParamsInfo>(this.comparator);
                int in = colls.size();
                for (int i = 0; i < in; ++i) {
                    mbgParam = colls.get(i);
                    params.put(mbgParam.getNumber(), mbgParam);
                }
                this.paramsValueMap.put(paramKey, params);
            }
        } else {
            params = this.paramsValueMap.get(paramKey);
        }
        if (params != null) {
            IRow row = null;
            Map.Entry<String, MbgParamsInfo> entry2 = null;
            for (Map.Entry<String, MbgParamsInfo> entry2 : params.entrySet()) {
                mbgParam = entry2.getValue();
                row = this.kdParams.addRow();
                row.getCell("number").setValue((Object)mbgParam.getNumber());
                row.getCell("name").setValue((Object)mbgParam.getName());
                if (3 == mbgParam.getType().getValue()) {
                    if (mbgParam.isCanModified()) {
                        row.getCell("value").setValue((Object)this.getBooleanValue(Boolean.valueOf(mbgParam.getValue())));
                    } else {
                        row.getCell("value").setValue((Object)this.getBooleanValue(Boolean.valueOf(mbgParam.getDefaultValue())));
                        row.getCell("value").getStyleAttributes().setLocked(true);
                    }
                } else if (mbgParam.isCanModified()) {
                    row.getCell("value").setValue((Object)mbgParam.getValue());
                } else {
                    row.getCell("value").setValue((Object)mbgParam.getDefaultValue());
                    row.getCell("value").getStyleAttributes().setLocked(true);
                }
                row.getCell("ctrlSubOrg").setValue((Object)mbgParam.isCtrlSubOrg());
                row.getCell("ctrlSubOrg").getStyleAttributes().setLocked(true);
                row.getCell("canModified").setValue((Object)mbgParam.isCanModified());
                row.getCell("alias").setValue((Object)mbgParam.getAlias());
                row.setUserObject((Object)mbgParam);
            }
        }
    }

    protected ICellEditor getBooleanEditor() {
        if (this.booleanEditor == null) {
            KDComboBox combox = new KDComboBox();
            combox.addItem((Object)BooleanEnum.TRUE);
            combox.addItem((Object)BooleanEnum.FALSE);
            this.booleanEditor = new KDTDefaultCellEditor((JComboBox)combox);
            combox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        MbgParamEditUI.this.comboxBoolean_itemStateChanged(e);
                    }
                    catch (Exception exc) {
                        MbgParamEditUI.this.handUIException(exc);
                    }
                }
            });
        }
        return this.booleanEditor;
    }

    protected void comboxBoolean_itemStateChanged(ItemEvent e) throws Exception {
        MbgParamsInfo mbgParam;
        if (e == null || e.getStateChange() != 1) {
            return;
        }
        int rowIndex = this.kdParams.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0 && (mbgParam = (MbgParamsInfo)this.kdParams.getRow(rowIndex).getUserObject()) != null && e.getItem() instanceof BooleanEnum) {
            String _value;
            BooleanEnum _enum = (BooleanEnum)e.getItem();
            String string = _value = _enum.getValue() == 1 ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
            if (StringUtils.isEmpty((String)mbgParam.getValue()) || _value.compareTo(mbgParam.getValue()) != 0) {
                mbgParam.setValue(_value);
            }
        }
    }

    protected KDComboBox getBooleanBox() {
        if (this.booleanEditor != null) {
            return (KDComboBox)this.booleanEditor.getComponent();
        }
        return null;
    }

    protected BooleanEnum getBooleanValue(boolean value) {
        return value ? BooleanEnum.TRUE : BooleanEnum.FALSE;
    }

    protected String getParamKey() {
        if (this.selOrgType == null || this.selOrgUnit == null) {
            return null;
        }
        return this.selOrgUnit.getId().toString();
    }

    @Override
    protected void kdParams_tableClicked(KDTMouseEvent e) throws Exception {
        MbgParamsInfo mbgParam;
        super.kdParams_tableClicked(e);
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (rowIndex >= 0 && colIndex == this.kdParams.getColumnIndex("value") && (mbgParam = (MbgParamsInfo)this.kdParams.getRow(rowIndex).getUserObject()) != null && "MBG_C001".equals(mbgParam.getNumber()) && this.kdParams.getCell(rowIndex, colIndex).getEditor() == null) {
            this.kdParams.getCell(rowIndex, colIndex).setEditor(this.getBooleanEditor());
        }
    }

    @Override
    protected void kdParams_editValueChanged(KDTEditEvent e) throws Exception {
        super.kdParams_editValueChanged(e);
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (rowIndex >= 0) {
            MbgParamsInfo mbgParam = null;
            Object obj = this.kdParams.getRow(rowIndex).getUserObject();
            if (obj == null) {
                obj = new MbgParamsInfo();
                this.kdParams.getRow(rowIndex).setUserObject(obj);
            }
            if (obj instanceof MbgParamsInfo) {
                mbgParam = (MbgParamsInfo)obj;
            }
            if (colIndex == this.kdParams.getColumnIndex("value")) {
                if (mbgParam != null) {
                    obj = e.getValue();
                    if (obj instanceof Boolean) {
                        mbgParam.setValue(obj.toString());
                    } else if (obj instanceof BigDecimal) {
                        mbgParam.setValue(((BigDecimal)obj).toPlainString());
                    } else {
                        mbgParam.setValue(obj.toString());
                    }
                }
            } else if (colIndex == this.kdParams.getColumnIndex("ctrlSubOrg") && mbgParam != null) {
                obj = e.getValue();
                if (obj instanceof Boolean) {
                    Boolean selSubOrg = (Boolean)obj;
                    if (selSubOrg.booleanValue()) {
                        mbgParam.setCtrlSubOrg(true);
                    } else {
                        mbgParam.setCtrlSubOrg(false);
                    }
                } else {
                    mbgParam.setCtrlSubOrg(false);
                }
            }
        }
    }

    public Vector getOrgTypeVect() throws BOSException, EASBizException {
        Vector<OrgType> vect = new Vector<OrgType>();
        vect.add(OrgType.CostCenter);
        return vect;
    }

    public void setOrgInfo(OrgType orgType, OrgUnitInfo orgUnit, OrgTreeInfo orgTree) {
    }

    public void sendOrgInfo(OrgType orgType, OrgUnitInfo orgUnit, OrgTreeInfo orgTree) {
        this.selOrgType = orgType;
        this.selOrgUnit = orgUnit;
        try {
            this.loadParams();
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    public void otherParamSave() throws BOSException, EASBizException {
        List newList;
        this.kdParams.getEditManager().stopEditing();
        List<MbgParamsValueInfo> saveParams = this.beforeSave();
        if (saveParams != null && !saveParams.isEmpty() && (newList = MbgParamsValueFactory.getRemoteInstance().saveParams(this.getUserId(), saveParams)) != null) {
            this.afterSave(newList);
        }
    }

    protected BOSUuid getUserId() {
        return SysContext.getSysContext().getCurrentUserInfo().getId();
    }

    protected List<MbgParamsValueInfo> beforeSave() {
        String orgUnitId = null;
        Map<String, MbgParamsInfo> params = null;
        ArrayList<MbgParamsValueInfo> saveParams = new ArrayList<MbgParamsValueInfo>();
        MbgParamsInfo mbgParam2 = null;
        MbgParamsValueInfo value = null;
        Map.Entry<String, Map<String, MbgParamsInfo>> entry2 = null;
        for (Map.Entry<String, Map<String, MbgParamsInfo>> entry2 : this.paramsValueMap.entrySet()) {
            orgUnitId = entry2.getKey();
            params = entry2.getValue();
            for (MbgParamsInfo mbgParam2 : params.values()) {
                if (!mbgParam2.isModify()) continue;
                value = new MbgParamsValueInfo();
                if (mbgParam2.getParamValueId() != null) {
                    value.setId(BOSUuid.read((String)mbgParam2.getParamValueId()));
                }
                value.setMbgParamId(mbgParam2.getId());
                value.setOrgUnitId(BOSUuid.read((String)orgUnitId));
                value.setMbgParamValue(mbgParam2.getValue());
                value.setCtrlSubOrg(mbgParam2.isCtrlSubOrg());
                saveParams.add(value);
            }
        }
        return saveParams;
    }

    protected void afterSave(List<MbgParamsValueInfo> newParams) {
        this.paramsValueMap.clear();
        try {
            this.loadParams();
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }
}

