/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.MbgProgressFacadeFactory;
import com.kingdee.eas.ma.base.client.AbstractMbgProgressBaseUI;
import com.kingdee.eas.ma.base.progress.IMbgProgress;
import com.kingdee.eas.ma.base.progress.MbgProgressInfo;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgProgressBaseUI
extends AbstractMbgProgressBaseUI {
    private static final long serialVersionUID = -3718507829796017875L;
    private static final Logger logger = CoreUIObject.getLogger(MbgProgressBaseUI.class);
    private boolean isRunning = true;
    private boolean isCancel = false;

    public static void showProgressUI(CoreUIObject owner, IMbgProgress progressInvoke) {
        UIContext uiContext = new UIContext((Object)owner);
        uiContext.put((Object)"InitDataObject", (Object)progressInvoke);
        try {
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MbgProgressBaseUI.class.getName(), (Map)uiContext);
            window.show();
        }
        catch (UIException e) {
            e.printStackTrace();
        }
    }

    private IMbgProgress getProgress() {
        return (IMbgProgress)this.getUIContext().get("InitDataObject");
    }

    public void onShow() throws Exception {
        super.onShow();
        final IMbgProgress progress = this.getProgress();
        if (progress.getTitle() != null) {
            this.setUITitle(progress.getTitle());
        }
        this.isRunning = true;
        Thread invokeThread = new Thread(){

            @Override
            public void run() {
                try {
                    Object result = progress.start();
                    if (MbgProgressBaseUI.this.isCancel) {
                        return;
                    }
                    MbgProgressBaseUI.this.endProgress();
                    progress.end(result);
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    progress.exception(e);
                    MbgProgressBaseUI.this.isRunning = false;
                }
                finally {
                    MbgProgressBaseUI.this.endProgress();
                    MbgProgressBaseUI.this.isRunning = false;
                }
            }
        };
        invokeThread.start();
        Thread showProgress = new Thread(){

            @Override
            public void run() {
                while (MbgProgressBaseUI.this.isRunning) {
                    try {
                        MbgProgressInfo progressInfo = MbgProgressFacadeFactory.getRemoteInstance().readProgresss(progress.getProgressKey());
                        MbgProgressBaseUI.this.showProgress(progressInfo);
                        2.sleep(100L);
                    }
                    catch (BOSException e) {
                        logger.error((Object)"", (Throwable)e);
                        MbgProgressBaseUI.this.isRunning = false;
                        MbgProgressBaseUI.this.handUIExceptionAndAbort((Exception)((Object)e));
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)"", (Throwable)e);
                        MbgProgressBaseUI.this.isRunning = false;
                        MbgProgressBaseUI.this.handUIExceptionAndAbort(e);
                    }
                }
            }
        };
        showProgress.start();
    }

    protected void showProgress(MbgProgressInfo progressInfo) {
        if (progressInfo == null) {
            return;
        }
        this.progressBar.setValue(progressInfo.index);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(progressInfo.index + "/" + progressInfo.totalCount);
        this.progressBar.setMaximum(progressInfo.totalCount);
        this.txtTitle.setText(progressInfo.message);
    }

    protected void endProgress() {
        this.destroyWindow();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
        this.getProgress().cancel();
        this.isCancel = true;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }
}

