/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgViewFactory;
import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.base.MemberSegregationRuleEnum;
import com.kingdee.eas.ma.base.client.AbstractMbgViewEditUI;
import com.kingdee.eas.ma.base.client.MbgDimListUI;
import com.kingdee.eas.ma.base.utils.BgAccountHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class MbgViewEditUI
extends AbstractMbgViewEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(MbgViewEditUI.class);
    private boolean isRelease = false;

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.segregateEquals.isSelected()) {
            this.editData.setSegregationRule(MemberSegregationRuleEnum.SEGREGATEEQUALS);
        } else if (this.shareGlobal.isSelected()) {
            this.editData.setSegregationRule(MemberSegregationRuleEnum.SHAREDGLOBAL);
        } else if (this.segregateOrg.isSelected()) {
            this.editData.setSegregationRule(MemberSegregationRuleEnum.SEGREGATEORG);
        }
    }

    protected IObjectValue createNewData() {
        MbgViewInfo mbgViewInfo = new MbgViewInfo();
        Object orgunit = this.getUIContext().get("unitinfo");
        Object mbgdim = this.getUIContext().get("mbgdim");
        mbgViewInfo.setId(BOSUuid.create((BOSObjectType)mbgViewInfo.getBOSType()));
        mbgViewInfo.setMbgDim((MbgDimInfo)mbgdim);
        mbgViewInfo.setOrgUnit((FullOrgUnitInfo)orgunit);
        mbgViewInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        mbgViewInfo.setCreateTime(new Timestamp(new Date().getTime()));
        if (this.segregateEquals.isSelected()) {
            mbgViewInfo.setSegregationRule(MemberSegregationRuleEnum.SEGREGATEEQUALS);
        } else if (this.shareGlobal.isSelected()) {
            mbgViewInfo.setSegregationRule(MemberSegregationRuleEnum.SHAREDGLOBAL);
        } else if (this.segregateOrg.isSelected()) {
            mbgViewInfo.setSegregationRule(MemberSegregationRuleEnum.SEGREGATEORG);
        }
        if (this.editData != null && this.getUIContext().get("listui") != null) {
            ((MbgDimListUI)((Object)this.getUIContext().get("listui"))).setAddNewId(this.editData.getId().toString());
        }
        return mbgViewInfo;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.isRelease = true;
        if (this.editData.getSegregationRule().equals((Object)MemberSegregationRuleEnum.SEGREGATEEQUALS)) {
            this.segregateEquals.setSelected(true);
        } else if (this.editData.getSegregationRule().equals((Object)MemberSegregationRuleEnum.SHAREDGLOBAL)) {
            this.shareGlobal.setSelected(true);
        } else if (this.editData.getSegregationRule().equals((Object)MemberSegregationRuleEnum.SEGREGATEORG)) {
            this.segregateOrg.setSelected(true);
        }
    }

    protected void initWorkButton() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnEdit.setEnabled(true);
            this.btnAddNew.setEnabled(true);
            if (this.getUIContext().get("mbgdim") != null && this.getUIContext().get("mbgdim") instanceof MbgDimInfo && ((MbgDimInfo)this.getUIContext().get("mbgdim")).getNumber().equals(DimensionBaseConstants.DEF_CSL_NUMBER)) {
                this.btnEdit.setEnabled(false);
                this.btnAddNew.setEnabled(false);
                this.btnRemove.setEnabled(false);
            }
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(false);
            this.btnAddNew.setEnabled(true);
        } else if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.btnAddNew.setEnabled(true);
            this.txtNumber.setEnabled(true);
            this.txtNumber.setFocusable(true);
        }
        super.initWorkButton();
    }

    protected LanguageInfo getCurrentLanguage() {
        return new LanguageInfo(this.getCurrentLocale());
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        FullOrgUnitInfo orgunit;
        super.verifyInput(e);
        LanguageInfo currLang = this.getCurrentLanguage();
        if (OprtState.EDIT.equals(this.getOprtState()) && !(orgunit = (FullOrgUnitInfo)this.getUIContext().get("unitinfo")).getId().toString().equals(this.editData.getOrgUnit().getId().toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cantUpdateViewByCurOrg"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"numberIsNull"));
            SysUtil.abort();
        }
        if (!BgNumberHelper.checkNumber(this.txtNumber.getText())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"specialCharInNumber"));
            SysUtil.abort();
        }
        if (this.txtName.getItemBy(currLang).getData() == null || StringUtils.isEmpty((String)this.txtName.getItemBy(currLang).getData().toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"nameIsNull"));
            SysUtil.abort();
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MbgViewFactory.getRemoteInstance();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.checkCanEditByCurOrg();
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(false);
            this.btnAddNew.setEnabled(true);
        }
    }

    private void checkCanEditByCurOrg() {
        if (OprtState.EDIT.equals(this.getOprtState())) {
            FullOrgUnitInfo orgunit = (FullOrgUnitInfo)this.getUIContext().get("unitinfo");
            MbgViewInfo mbgViewInfo = (MbgViewInfo)this.getUIContext().get("mbgView");
            if (!orgunit.getId().toString().equals(mbgViewInfo.getOrgUnit().getId().toString())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cantUpdateViewByCurOrg"));
                SysUtil.abort();
            }
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.btnAddNew.setEnabled(true);
            this.txtNumber.setEnabled(true);
            this.txtNumber.setFocusable(true);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        FullOrgUnitInfo orgunit = (FullOrgUnitInfo)this.getUIContext().get("unitinfo");
        MbgViewInfo mbgViewInfo = (MbgViewInfo)this.getUIContext().get("mbgView");
        if (!orgunit.getId().toString().equals(mbgViewInfo.getOrgUnit().getId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cantDeleteViewByOtherOrg"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public boolean checkBeforeWindowClosing() {
        boolean bclose = super.checkBeforeWindowClosing();
        if (bclose && this.isRelease) {
            MbgViewInfo obj = null;
            if (this.getDataObject() != null) {
                obj = (MbgViewInfo)this.getDataObject();
            }
            if (obj != null && obj.getId() != null) {
                BgAccountHelper.releaseMutexService(obj.getId().toString());
            }
        }
        return bclose;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = null;
        sic = super.getSelectors();
        sic.add(new SelectorItemInfo("segregationRule"));
        return sic;
    }

    @Override
    protected void segregateEquals_actionPerformed(ActionEvent e) throws Exception {
        boolean isRefByModel = MbgMemberFactory.getRemoteInstance().exists("select id  where viewId = '" + this.editData.getId() + "' and isSystemDefault = 0");
        boolean isNotSameCreateOrg = MbgMemberFactory.getRemoteInstance().exists("where viewId = '" + this.editData.getId() + "' and orgunit.id <>'" + this.editData.getOrgUnit().getId() + "'");
        if (isRefByModel && MemberSegregationRuleEnum.SHAREDGLOBAL.equals((Object)this.editData.getSegregationRule()) && isNotSameCreateOrg) {
            this.segregateEquals.setSelected(false);
            this.shareGlobal.setSelected(true);
            this.segregateOrg.setSelected(false);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cannotSwitch", (Object[])new Object[]{this.editData.getSegregationRule().getAlias(), MemberSegregationRuleEnum.SEGREGATEEQUALS.getAlias()}));
            SysUtil.abort();
        }
    }

    @Override
    protected void shareGlobal_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void segregateOrg_actionPerformed(ActionEvent e) throws Exception {
        boolean isRefByModel = MbgMemberFactory.getRemoteInstance().exists("select id  where viewId = '" + this.editData.getId() + "' and isSystemDefault = 0");
        if (isRefByModel) {
            if (MemberSegregationRuleEnum.SHAREDGLOBAL.equals((Object)this.editData.getSegregationRule())) {
                this.segregateEquals.setSelected(false);
                this.shareGlobal.setSelected(true);
                this.segregateOrg.setSelected(false);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cannotSwitch", (Object[])new Object[]{this.editData.getSegregationRule().getAlias(), MemberSegregationRuleEnum.SEGREGATEORG.getAlias()}));
                SysUtil.abort();
            } else if (MemberSegregationRuleEnum.SEGREGATEEQUALS.equals((Object)this.editData.getSegregationRule())) {
                this.segregateEquals.setSelected(true);
                this.shareGlobal.setSelected(false);
                this.segregateOrg.setSelected(false);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cannotSwitch", (Object[])new Object[]{this.editData.getSegregationRule().getAlias(), MemberSegregationRuleEnum.SEGREGATEORG.getAlias()}));
                SysUtil.abort();
            }
        }
    }

    @Override
    protected void chkStandby_actionPerformed(ActionEvent e) throws Exception {
        super.chkStandby_actionPerformed(e);
        if (this.chkStandby.isSelected()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"setStandby"));
        }
    }
}

