/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import org.apache.log4j.Logger;

public abstract class AbstractVirtualModeTableHelper
implements RequestRowSetListener {
    private static final Logger logger = CoreUIObject.getLogger(AbstractVirtualModeTableHelper.class);
    protected CoreUI owner;
    protected KDTable tblMain;
    protected IDataProvider exec = null;
    protected Uuid queryId = null;

    public void setTblMain(KDTable tblMain) {
        this.tblMain = tblMain;
    }

    public AbstractVirtualModeTableHelper(CoreUI owner, KDTable table) {
        this.owner = owner;
        this.tblMain = table;
    }

    public Uuid getQueryId() {
        return this.queryId;
    }

    public void doRequestRowSet(RequestRowSetEvent e) {
        try {
            logger.info((Object)(e.getParam1() + "," + e.getParam2()));
            IDataProvider exec = this.getQueryExecutor();
            if (exec == null) {
                return;
            }
            int start = (Integer)e.getParam1();
            int length = (Integer)e.getParam2() - start + 1;
            IRowSet res = exec.executeQuery(this.queryId, start, length);
            e.setRowSet(res);
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            this.owner.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        catch (EASBizException e1) {
            logger.error((Object)"", (Throwable)e1);
            this.owner.handUIExceptionAndAbort((Exception)((Object)e1));
        }
    }

    protected IDataProvider getQueryExecutor() throws EASBizException, BOSException {
        return this.exec;
    }

    protected void doQuery(Object[] parameters) throws EASBizException, BOSException {
        this.exec = this.createQueryExecutor(parameters);
        this.queryId = this.exec.openQuery();
        this.exec.option().isAutoTranslateEnum = true;
        this.exec.option().pageCount = this.tblMain.getDataRequestManager().getPageRowCount();
        this.tblMain.removeRows();
        this.tblMain.setRowCount(this.exec.getRowCount(this.queryId));
        logger.info((Object)("RowCount:" + this.tblMain.getRowCount()));
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    protected abstract IDataProvider createQueryExecutor(Object[] var1) throws EASBizException, BOSException;
}

