/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountDistributeFacadeFactory;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountGroupCollection;
import com.kingdee.eas.ma.base.BgAccountGroupFactory;
import com.kingdee.eas.ma.base.BgAccountGroupInfo;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgAccountViewFactory;
import com.kingdee.eas.ma.base.BgAccountViewInfo;
import com.kingdee.eas.ma.base.client.BgAccountDistributeUI;
import com.kingdee.eas.ma.base.client.ProgressDialogUI;
import com.kingdee.eas.util.client.EASResource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgAccountDistributeClientHelper {
    private static Logger logger = Logger.getLogger((String)BgAccountDistributeClientHelper.class.getName());
    public static final String resource = "com.kingdee.eas.ma.base.BgAccountDistributeResource";

    public static String getString(String key) {
        return EASResource.getString((String)resource, (String)key);
    }

    public static void distribute(CoreUI owner, BgAccountViewInfo viewInfo, List<TreeBaseInfo> orgs, List<TreeBaseInfo> accts, boolean isAntiDistribute, BgAccountGroupInfo[] bgAccountGroupInfos) throws EASBizException, BOSException {
        IUIWindow window;
        SimpleTimer time = new SimpleTimer();
        UIContext map = new UIContext((Object)owner);
        viewInfo = BgAccountViewFactory.getRemoteInstance().getBgAccountViewInfo("select id, number, name, distributeViewRootId, sourceType where id = '" + viewInfo.getId() + "'");
        BgAccountGroupCollection bgAccountGroupCollection = null;
        if (bgAccountGroupInfos != null) {
            HashSet<String> ids = new HashSet<String>();
            for (int i = 0; i < bgAccountGroupInfos.length; ++i) {
                BgAccountGroupInfo bgAccountGroupInfo = bgAccountGroupInfos[i];
                if (bgAccountGroupInfo == null || bgAccountGroupInfo.getId() == null) continue;
                ids.add(bgAccountGroupInfo.getId().toString());
            }
            if (!ids.isEmpty()) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                bgAccountGroupCollection = BgAccountGroupFactory.getRemoteInstance().getBgAccountGroupCollection(evi);
            }
        }
        if ((window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ProgressDialogUI.class.getName(), (Map)map, null, null, 16)) != null && window.getUIObject() instanceof ProgressDialogUI) {
            ProgressDialogUI ui = (ProgressDialogUI)window.getUIObject();
            ui.setShowTableMessage(true);
            logger.debug((Object)("begin initParameterValue" + time.getTime() + ""));
            BgAccountDistributeClientHelper.initParameterValue(owner, ui, viewInfo, orgs, accts, isAntiDistribute, bgAccountGroupCollection);
            logger.debug((Object)("begin init" + time.getTime() + ""));
            ui.init();
            logger.debug((Object)("begin show" + time.getTime() + ""));
            window.show();
        }
    }

    private static void initParameterValue(CoreUI owner, ProgressDialogUI ui, BgAccountViewInfo viewInfo, List<TreeBaseInfo> orgs, List<TreeBaseInfo> accts, boolean isAntiDistribute, BgAccountGroupCollection bgAccountGroupCollection) throws BOSException {
        if (isAntiDistribute) {
            ui.setUITitle(BgAccountDistributeClientHelper.getString("antiDistributeTitle"));
        } else {
            ui.setUITitle(BgAccountDistributeClientHelper.getString("distributeTitle"));
        }
        ui.setAllSuccessMsg(MessageFormat.format(BgAccountDistributeClientHelper.getString("allSuccessMsg"), ui.getUITitle()));
        ui.setInvokeClass(BgAccountDistributeClientHelper.class.getName());
        ui.setInvokeMethod("runDistribute");
        Class[] cls = new Class[]{CoreUI.class, BgAccountViewInfo.class, TreeBaseInfo.class, TreeBaseInfo.class, List.class, Boolean.TYPE, Boolean.TYPE, BgAccountGroupInfo.class};
        ui.setInvokeMethodParmeterType(cls);
        ArrayList<Object[]> paramValues = new ArrayList<Object[]>();
        TreeBaseInfo orgInfo = null;
        Object[] params = null;
        if (viewInfo == null || viewInfo.getId() == null) {
            return;
        }
        if (bgAccountGroupCollection == null || bgAccountGroupCollection.isEmpty()) {
            bgAccountGroupCollection = BgAccountGroupFactory.getRemoteInstance().getBgAccountGroupCollection("where viewId.id ='" + viewInfo.getId() + "' or number = '" + "ACG" + "'");
        }
        if (bgAccountGroupCollection != null && !bgAccountGroupCollection.isEmpty()) {
            if (accts == null || accts.isEmpty()) {
                return;
            }
            HashSet<String> ids = new HashSet<String>();
            for (int i = 0; i < accts.size(); ++i) {
                if (accts.get(i) == null || accts.get(i).getId() == null) continue;
                ids.add(accts.get(i).getId().toString());
            }
            if (ids.isEmpty()) {
                return;
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            BgAccountCollection bgAccountCollection = BgAccountFactory.getRemoteInstance().getBgAccountCollection(evi);
            if (bgAccountCollection == null || bgAccountCollection.isEmpty()) {
                return;
            }
            for (int i = 0; i < orgs.size(); ++i) {
                for (int j = 0; j < bgAccountGroupCollection.size(); ++j) {
                    BgAccountGroupInfo bgAccountGroupInfo = bgAccountGroupCollection.get(j);
                    if (bgAccountGroupInfo == null || bgAccountGroupInfo.getId() == null) continue;
                    ArrayList<BgAccountInfo> acctsItem = new ArrayList<BgAccountInfo>();
                    for (int k = 0; k < bgAccountCollection.size(); ++k) {
                        BgAccountInfo bgAccountInfo = bgAccountCollection.get(k);
                        if (bgAccountInfo == null || bgAccountInfo.getGroup() == null || bgAccountInfo.getGroup().getId() == null || !bgAccountInfo.getGroup().getId().equals((Object)bgAccountGroupInfo.getId())) continue;
                        acctsItem.add(bgAccountInfo);
                    }
                    if (acctsItem.isEmpty()) continue;
                    orgInfo = orgs.get(i);
                    if (i == 0) {
                        params = new Object[8];
                        params[0] = owner;
                        params[2] = orgInfo;
                        params[5] = isAntiDistribute;
                        params[6] = false;
                        params[7] = bgAccountGroupInfo;
                        paramValues.add(params);
                    }
                    params = new Object[8];
                    params[0] = owner;
                    params[1] = viewInfo;
                    params[3] = orgInfo;
                    params[4] = acctsItem;
                    params[5] = isAntiDistribute;
                    params[6] = false;
                    if (i == orgs.size() - 1) {
                        params[6] = true;
                    }
                    params[7] = bgAccountGroupInfo;
                    paramValues.add(params);
                }
            }
            ui.setInvokeMethodParmeterValue((Object[][])paramValues.toArray((T[])new Object[0][0]));
            ui.setCountSum(paramValues.size() - 1);
        }
    }

    public Object[] runDistribute(CoreUI owner, BgAccountViewInfo viewInfo, TreeBaseInfo nextOrg, TreeBaseInfo thisOrg, List accts, boolean isAntiDistribute, boolean isEnd, BgAccountGroupInfo accountGroup) {
        Object[] obj = new Object[3];
        Object map = null;
        try {
            if (nextOrg != null) {
                obj[0] = isAntiDistribute ? MessageFormat.format(BgAccountDistributeClientHelper.getString("antiDistributeProcess"), nextOrg.getName()) : MessageFormat.format(BgAccountDistributeClientHelper.getString("distributeProcess"), nextOrg.getName());
            }
            if (thisOrg == null) {
                return obj;
            }
            obj[1] = isAntiDistribute ? BgAccountDistributeFacadeFactory.getRemoteInstance().AntiDistribute((IObjectValue)thisOrg, (IObjectValue)viewInfo, accts, accountGroup) : BgAccountDistributeFacadeFactory.getRemoteInstance().distribute((DataBaseInfo)thisOrg, viewInfo, accts, accountGroup);
            if (isEnd && owner instanceof BgAccountDistributeUI) {
                ((BgAccountDistributeUI)owner).queryBgAccount();
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            obj[2] = e;
        }
        return obj;
    }
}

