/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class BgFileUtil {
    private static final String DEFAULT = "DEFAULT";
    private static final String EXP = "_EXP";
    private static final String IMP = "_IMP";
    private static boolean isOnlyKey = true;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.base.client.utils.BgFileUtil");
    String normalizePropertityFile = FilenameUtils.normalize((String)(System.getProperty("user.dir") + File.separator + "mbg_export.properties"));
    private File propertityFile = new File(this.normalizePropertityFile);
    private boolean isAutoCommit = true;
    private Properties propertiesWithCommit = new Properties();
    private Properties golbalProperties = new Properties();
    private boolean isCacheQuery = false;

    public BgFileUtil() {
        String normalize = FilenameUtils.normalize((String)(System.getProperty("user.dir") + File.separator + "mbg_export.properties"));
        this.propertityFile = new File(normalize);
        if (!this.propertityFile.exists()) {
            try {
                this.propertityFile.createNewFile();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    public void setAutoCommit(boolean isAutoCommit) {
        this.isAutoCommit = isAutoCommit;
    }

    public boolean isCacheQuery() {
        return this.isCacheQuery;
    }

    public void setCacheQuery(boolean isCacheQuery) {
        this.isCacheQuery = isCacheQuery;
    }

    public void storeDefaultPathForIMP(Object txtFile, Object uiObject) throws BOSException {
        this.storeDefaultPathForIMP(txtFile, uiObject, null);
    }

    public void storeDefaultPathForIMP(Object txtFile, Object uiObject, String selfSuffix) throws BOSException {
        String keyName = null;
        keyName = isOnlyKey ? DEFAULT : this.getKeyName(uiObject, selfSuffix) + IMP;
        this.storeDefaultPath(txtFile, keyName);
    }

    public void storeDefaultPathForEXP(Object txtFile, Object uiObject) throws BOSException {
        this.storeDefaultPathForEXP(txtFile, uiObject, null);
    }

    public void storeDefaultPathForEXP(Object txtFile, Object uiObject, String selfSuffix) throws BOSException {
        String keyName = null;
        keyName = isOnlyKey ? DEFAULT : this.getKeyName(uiObject, selfSuffix) + EXP;
        this.storeDefaultPath(txtFile, keyName);
    }

    public void storeDefaultValueForSelf(Object content, Object uiObject, String selfSuffix) throws BOSException {
        this.storeDefaultValueForSelf(content, this.getKeyName(uiObject, selfSuffix));
    }

    private void storeDefaultValueForSelf(Object content, String keyName) throws BOSException {
        FileOutputStream os = null;
        FileInputStream in = null;
        String value = null;
        try {
            if (content != null && this.propertityFile != null && this.propertityFile.exists() && !StringUtils.isEmpty((String)(value = content.toString()))) {
                if (this.isAutoCommit()) {
                    Properties properties = new Properties();
                    in = new FileInputStream(this.propertityFile);
                    properties.load(in);
                    properties.setProperty(keyName, value);
                    os = new FileOutputStream(this.propertityFile);
                    properties.store(os, "");
                    os.flush();
                } else {
                    this.propertiesWithCommit.put(keyName, value);
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            this.closeOutputStream(os);
            this.closeInputStream(in);
        }
    }

    private void closeOutputStream(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void commit() throws BOSException {
        FileOutputStream os = null;
        FileInputStream in = null;
        try {
            if (!this.isAutoCommit()) {
                Properties properties = new Properties();
                in = new FileInputStream(this.propertityFile);
                properties.load(in);
                for (String keyName : this.propertiesWithCommit.stringPropertyNames()) {
                    properties.setProperty(keyName, this.propertiesWithCommit.getProperty(keyName));
                }
                os = new FileOutputStream(this.propertityFile);
                properties.store(os, "");
                os.flush();
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            this.closeOutputStream(os);
            this.closeInputStream(in);
            this.clearCommitCache();
        }
    }

    private void clearCommitCache() {
        if (this.propertiesWithCommit != null) {
            this.propertiesWithCommit.clear();
        }
    }

    private void storeDefaultPath(Object txtFile, String keyName) throws BOSException {
        Object os = null;
        Object in = null;
        String filePath = null;
        if (txtFile instanceof KDTextField) {
            filePath = ((KDTextField)txtFile).getText();
        } else if (txtFile instanceof String) {
            filePath = (String)txtFile;
        }
        if (!StringUtils.isEmpty((String)filePath)) {
            File file = new File(filePath);
            if (file.isFile()) {
                filePath = file.getParent();
            }
        } else {
            return;
        }
        this.storeDefaultValueForSelf(filePath, keyName);
    }

    public KDFileChooser getFileChooserForExp(Object uiObject) throws BOSException {
        return this.getFileChooser(uiObject, false, null);
    }

    public KDFileChooser getFileChooserForImp(Object uiObject) throws BOSException {
        return this.getFileChooser(uiObject, true, null);
    }

    public KDFileChooser getFileChooserForExp(Object uiObject, String selfSuffix) throws BOSException {
        return this.getFileChooser(uiObject, false, selfSuffix);
    }

    public KDFileChooser getFileChooserForImp(Object uiObject, String selfSuffix) throws BOSException {
        return this.getFileChooser(uiObject, true, selfSuffix);
    }

    public KDFileChooser getFileChooserForSelf(Object uiObject, String selfSuffix) throws BOSException {
        String keyName = null;
        keyName = isOnlyKey ? DEFAULT : this.getKeyName(uiObject, selfSuffix);
        String defualtPath = this.getDefualtPath(keyName);
        KDFileChooser kdFileChooser = this.getFileChooser(defualtPath);
        return kdFileChooser;
    }

    public String getDefualtPathForIMP(Object uiObject) throws BOSException {
        String keyName = null;
        keyName = isOnlyKey ? DEFAULT : this.getKeyName(uiObject, null) + IMP;
        return this.getDefualtPath(keyName);
    }

    public String getDefualtPathForIMP(Object uiObject, String selfSuffix) throws BOSException {
        String keyName = null;
        keyName = isOnlyKey ? DEFAULT : this.getKeyName(uiObject, selfSuffix) + IMP;
        return this.getDefualtPath(keyName);
    }

    public String getDefualtPathForEXP(Object uiObject) throws BOSException {
        String keyName = null;
        keyName = isOnlyKey ? DEFAULT : this.getKeyName(uiObject, null) + EXP;
        return this.getDefualtPath(keyName);
    }

    public String getDefualtPathForEXP(Object uiObject, String selfSuffix) throws BOSException {
        String keyName = null;
        keyName = isOnlyKey ? DEFAULT : this.getKeyName(uiObject, selfSuffix) + EXP;
        return this.getDefualtPath(keyName);
    }

    public String getDefualtStringValueForSelf(Object uiObject, String selfSuffix) throws BOSException {
        return this.getDefualtValueForSelf(this.getKeyName(uiObject, selfSuffix));
    }

    public boolean getDefualtBooleanValueForSelf(Object uiObject, String selfSuffix) throws BOSException {
        return Boolean.valueOf(this.getDefualtValueForSelf(this.getKeyName(uiObject, selfSuffix)));
    }

    public boolean exists(Object uiObject, String selfSuffix) throws BOSException {
        String defualtValue = this.getDefualtValueForSelf(this.getKeyName(uiObject, selfSuffix));
        return !StringUtils.isEmpty((String)defualtValue);
    }

    private String getDefualtValueForSelf(String keyName) throws BOSException {
        FileInputStream is;
        block8: {
            block11: {
                block10: {
                    Properties properties;
                    block9: {
                        is = null;
                        if (this.propertityFile == null || !this.propertityFile.exists()) break block8;
                        properties = new Properties();
                        if (!this.isCacheQuery()) break block9;
                        if (this.golbalProperties.isEmpty()) {
                            is = new FileInputStream(this.propertityFile);
                            this.golbalProperties.load(is);
                        }
                        String string = this.golbalProperties.getProperty(keyName);
                        this.closeInputStream(is);
                        return string;
                    }
                    if (this.isCacheQuery()) break block8;
                    is = new FileInputStream(this.propertityFile);
                    properties.load(is);
                    String property = properties.getProperty(keyName);
                    if (StringUtils.isEmpty((String)property)) break block10;
                    String string = property;
                    this.closeInputStream(is);
                    return string;
                }
                String os = System.getProperty("os.name");
                if (os == null || !os.toLowerCase(Locale.ENGLISH).startsWith("window")) break block11;
                String string = "C:";
                this.closeInputStream(is);
                return string;
            }
            try {
                String absolutePath = FileSystemView.getFileSystemView().getDefaultDirectory().getAbsolutePath();
                String string = absolutePath == null ? "C:" : absolutePath;
                this.closeInputStream(is);
                return string;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    this.closeInputStream(is);
                    throw throwable;
                }
            }
        }
        this.closeInputStream(is);
        return null;
    }

    private void closeInputStream(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void clearBatchCache() throws BOSException {
        if (!this.golbalProperties.isEmpty()) {
            this.golbalProperties.clear();
        }
    }

    private String getDefualtPath(String keyName) throws BOSException {
        return this.getDefualtValueForSelf(keyName);
    }

    private KDFileChooser getFileChooser(Object uiObject, boolean isImp, String selfSuffix) throws BOSException {
        String setDefualtPath = !isImp ? this.getDefualtPathForEXP(uiObject, selfSuffix) : this.getDefualtPathForIMP(uiObject, selfSuffix);
        KDFileChooser kdFileChooser = this.getFileChooser(setDefualtPath);
        return kdFileChooser;
    }

    private KDFileChooser getFileChooser(String setDefualtPath) {
        File currentDirectory;
        KDFileChooser kdFileChooser = new KDFileChooser();
        if (!StringUtils.isEmpty((String)setDefualtPath)) {
            File file = null;
            String normalize = FilenameUtils.normalize((String)setDefualtPath);
            file = new File(normalize);
            if (file.exists() && file.isDirectory()) {
                kdFileChooser.setCurrentDirectory(file);
            }
        }
        if ((currentDirectory = kdFileChooser.getCurrentDirectory()) != null && !currentDirectory.exists()) {
            kdFileChooser.setCurrentDirectory(new File(BgCommHelper.getDefaultDirtory()));
        }
        return kdFileChooser;
    }

    private String getKeyName(Object uiContext, String selfSuffix) {
        return this.getKeyNamePrefix(uiContext) + this.getSuffix(selfSuffix);
    }

    private String getSuffix(String selfSuffix) {
        String suffix = "";
        if (!StringUtils.isEmpty((String)selfSuffix)) {
            suffix = "_" + selfSuffix;
        }
        return suffix;
    }

    private String getKeyNamePrefix(Object uiObject) {
        if (uiObject == null) {
            return DEFAULT;
        }
        String keyNamePreFix = DEFAULT;
        if (uiObject instanceof Map) {
            Map uiContext = (Map)uiObject;
            if (uiContext.get("Owner") != null) {
                Object objectUI = uiContext.get("Owner");
                keyNamePreFix = objectUI != null ? objectUI.getClass().getName() : DEFAULT;
            }
        } else if (uiObject instanceof CoreUI) {
            keyNamePreFix = uiObject != null ? uiObject.getClass().getName() : DEFAULT;
        } else if (uiObject instanceof KDDialog) {
            keyNamePreFix = uiObject != null ? uiObject.getClass().getName() : DEFAULT;
        }
        return keyNamePreFix;
    }
}

