/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.StringUtils;

public class BgPermissionUtil {
    public static void checkPermission(String permissionItem) throws EASBizException, BOSException {
        OrgUnitInfo currentOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK currentOrgPK = new ObjectUuidPK(currentOrgUnit.getId());
        IPermission iPermisstion = PermissionFactory.getRemoteInstance();
        iPermisstion.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)currentOrgPK, permissionItem);
    }

    public static void checkPermission(BOSUuid currentOrgUnitID, String permissionItem) throws EASBizException, BOSException {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK currentOrgPK = new ObjectUuidPK(currentOrgUnitID);
        IPermission iPermisstion = PermissionFactory.getRemoteInstance();
        iPermisstion.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)currentOrgPK, permissionItem);
    }

    public static void checkPermission(OrgUnitInfo currentOrgUnit, String permissionItem) throws EASBizException, BOSException {
        BgPermissionUtil.checkPermission(currentOrgUnit.getId(), permissionItem);
    }

    public static boolean hasPermission(OrgUnitInfo currentOrgUnit, String permissionItem) throws EASBizException, BOSException {
        if (currentOrgUnit == null || StringUtils.isEmpty((String)permissionItem)) {
            return false;
        }
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK currentOrgPK = new ObjectUuidPK(currentOrgUnit.getId());
        return PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)userPK, (IObjectPK)currentOrgPK, permissionItem);
    }
}

