/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.NumberExpendRender;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class NumberExpandHelper {
    private static Logger logger = Logger.getLogger((String)NumberExpandHelper.class.getName());
    private CoreUI owner = null;
    private KDTable tblMain = null;
    public String COL_id = "id";
    public String COL_number = "number";
    public String COL_name = "name";
    public String COL_longNumber = "longNumber";
    public String COL_level = "level";
    public String COL_isLeaf = "isLeaf";
    private Set noLeafNumbers = null;
    private NumberExpendRender render = new NumberExpendRender(1);

    public void setTblMain(KDTable tblMain) {
        this.tblMain = tblMain;
    }

    public NumberExpandHelper(CoreUI owner, KDTable tblMain) {
        this.owner = owner;
        this.tblMain = tblMain;
        this.init();
    }

    public NumberExpandHelper(CoreUI owner, KDTable tblMain, String col_number) {
        this.tblMain = tblMain;
        this.COL_number = col_number;
        this.init();
    }

    public void setFilter(Set filters, boolean isId, ICoreBase bizIntance) {
        FilterInfo filter = null;
        if (filters != null) {
            filter = new FilterInfo();
            if (!filters.isEmpty()) {
                if (isId) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)filters, CompareType.INCLUDE));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)filters, CompareType.INCLUDE));
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)BgBaseConstants.nullID));
            }
        }
        this.setFilter(filter, bizIntance);
    }

    public void setFilter(FilterInfo filter, ICoreBase bizIntance) {
        if (filter == null || !(bizIntance instanceof ITreeBase)) {
            this.noLeafNumbers = null;
        } else {
            this.noLeafNumbers = new HashSet();
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("longNumber");
            CoreBaseCollection col = null;
            try {
                col = bizIntance.getCollection(evi);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.owner.handUIExceptionAndAbort((Exception)((Object)e));
            }
            if (col != null && !col.isEmpty()) {
                for (int i = 0; i < col.size(); ++i) {
                    String[] ln = col.get(i).getString("longNumber").split("!");
                    for (int s = 0; s < ln.length - 1; ++s) {
                        this.noLeafNumbers.add(ln[s]);
                    }
                }
            }
        }
    }

    private void init() {
        this.tblMain.checkParsed();
        this.setColumnRender(this.tblMain);
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    NumberExpandHelper.this.tblMain_tableClicked(e);
                }
                catch (Exception exc) {
                    NumberExpandHelper.this.owner.handUIException((Throwable)exc);
                }
            }
        });
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    NumberExpandHelper.this.afterDataFill_actionEvent(e);
                }
                catch (Exception ex) {
                    logger.error((Object)"", (Throwable)ex);
                    NumberExpandHelper.this.owner.handUIExceptionAndAbort(ex);
                }
            }
        });
    }

    public void setColumnRender(KDTable tblMain) {
        tblMain.getColumn(this.COL_number).setRenderer((IBasicRender)this.render);
    }

    protected void afterDataFill_actionEvent(KDTDataRequestEvent e) throws Exception {
        int beginIndex = e.getFirstRow();
        int endIndex = e.getLastRow();
        int level = 0;
        Object numberValue = null;
        String id = null;
        String number = null;
        String longNumber = null;
        String name = null;
        IRow row = null;
        NumberExpandInfo expandInfo = null;
        for (int index = beginIndex; index <= endIndex; ++index) {
            boolean isLeaf;
            row = this.tblMain.getRow(index);
            if (row == null) continue;
            if (this.tblMain.getColumn(this.COL_id) != null) {
                id = (String)row.getCell(this.COL_id).getValue();
            }
            if (!((numberValue = row.getCell(this.COL_number).getValue()) instanceof String)) {
                return;
            }
            number = numberValue.toString();
            longNumber = (String)row.getCell(this.COL_longNumber).getValue();
            if (longNumber == null) continue;
            level = ((Number)row.getCell(this.COL_level).getValue()).intValue();
            name = StringUtils.cnulls((Object)row.getCell(this.COL_name).getValue());
            boolean bl = isLeaf = !Boolean.FALSE.equals(row.getCell(this.COL_isLeaf).getValue());
            if (this.noLeafNumbers != null) {
                isLeaf = !this.noLeafNumbers.contains(number);
            }
            isLeaf = isLeaf || this.inUIIsLeaf(index, longNumber, level);
            expandInfo = new NumberExpandInfo();
            expandInfo.setId(id);
            expandInfo.setLevel(level);
            expandInfo.setLeaf(isLeaf);
            expandInfo.setName(number);
            expandInfo.setNumber(number);
            expandInfo.setLongNumber(longNumber);
            expandInfo.setExpandStatus(true);
            row.getCell(this.COL_number).setValue((Object)expandInfo);
        }
    }

    private boolean inUIIsLeaf(int index, String longNum, int level) {
        IRow nextRow = this.tblMain.getRow(index + 1);
        if (nextRow == null) {
            return true;
        }
        String nextLongNum = (String)nextRow.getCell(this.COL_longNumber).getValue();
        int nextLevel = ((Number)nextRow.getCell(this.COL_level).getValue()).intValue();
        return !nextLongNum.startsWith(longNum + "!") || nextLevel != level + 1;
    }

    private void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1) {
            NumberExpandInfo expandInfo;
            IRow row;
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            int clickCount = e.getClickCount();
            if (clickCount == 1 && (row = this.tblMain.getRow(rowIndex)) != null && colIndex == this.tblMain.getColumn(this.COL_number).getColumnIndex() && row.getCell(this.COL_number).getValue() instanceof NumberExpandInfo && ((expandInfo = (NumberExpandInfo)row.getCell(this.COL_number).getValue()).getLongNumber() != null && this.render.inRectForBgOrg(expandInfo, e.getX(), e.getY()) || expandInfo.getLongNumber() == null && this.render.inRect(expandInfo, e.getX(), e.getY()))) {
                this.setTreeDisplayStyle(row, expandInfo);
            }
        }
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) throws Exception {
        boolean isLeaf;
        if (row.getCell(this.COL_isLeaf).getValue() instanceof Boolean && !(isLeaf = ((Boolean)row.getCell(this.COL_isLeaf).getValue()).booleanValue())) {
            this.tblMain.setRefresh(false);
            this.expandTable(row, expandInfo);
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo) throws Exception {
        if (row == null) {
            return;
        }
        IRow child = null;
        int parentLevel = parentExpandInfo.getLevel();
        String longNumber = null;
        String parentLongNumber = null;
        NumberExpandInfo expandInfo = null;
        parentLongNumber = parentExpandInfo.getLongNumber();
        boolean isExpandStatus = parentExpandInfo.isExpandStatus();
        if (isExpandStatus) {
            parentExpandInfo.setExpandStatus(false);
            int rowCount = this.tblMain.getRowCount3();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell(this.COL_number).getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                child.getStyleAttributes().setHided(true);
            }
        } else {
            parentExpandInfo.setExpandStatus(true);
            int rowCount = this.tblMain.getRowCount3();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell(this.COL_number).getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                if (expandInfo.getLevel() - parentLevel != 1) continue;
                child.getStyleAttributes().setHided(false);
                if (expandInfo.isLeaf()) continue;
                expandInfo.setExpandStatus(false);
            }
        }
    }

    public static String getNumber(IRow row) {
        if (row == null || row.getCell("number") == null) {
            return null;
        }
        if (row.getCell("number").getValue() instanceof NumberExpandInfo) {
            return ((NumberExpandInfo)row.getCell("number").getValue()).getNumber();
        }
        return (String)row.getCell("number").getValue();
    }

    public static Object getValue(ICell cell) {
        if (cell == null) {
            return null;
        }
        if (cell.getValue() instanceof NumberExpandInfo) {
            return ((NumberExpandInfo)cell.getValue()).getNumber();
        }
        return cell.getValue();
    }

    protected KDTable getTable() {
        return this.tblMain;
    }
}

