/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client.utils;

import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.eas.ma.base.client.utils.ISimpleQuickQueryHandler;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class SimpleQuickQueryHandler
extends MouseAdapter
implements KeyListener,
FocusListener {
    private KDTextField txtQuickQueryInput;
    private ISimpleQuickQueryHandler handler;
    private String defText = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"404_NewDimensionMemberF7UI");

    public SimpleQuickQueryHandler(KDTextField txtQuickQueryInput, ISimpleQuickQueryHandler handler) {
        this(txtQuickQueryInput, handler, null);
    }

    public SimpleQuickQueryHandler(KDTextField txtQuickQueryInput, ISimpleQuickQueryHandler handler, String defText) {
        this.txtQuickQueryInput = txtQuickQueryInput;
        this.handler = handler;
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)txtQuickQueryInput, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        if (defText != null) {
            this.defText = defText;
        }
        this.txtQuickQueryInput.setText(this.defText);
        this.txtQuickQueryInput.addKeyListener((KeyListener)this);
        this.txtQuickQueryInput.addMouseListener((MouseListener)this);
        this.txtQuickQueryInput.addFocusListener((FocusListener)this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String inputText = this.txtQuickQueryInput.getText();
        if (inputText != null && this.defText.equals(inputText.trim())) {
            this.txtQuickQueryInput.setText("");
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.escape();
        } else if (e.getKeyCode() == 40) {
            this.keyDown();
        } else if (e.getKeyCode() == 38) {
            this.keyUp();
        } else if (e.getKeyCode() == 10) {
            this.keyEnter();
        }
    }

    protected void keyEnter() {
        this.doQuery();
    }

    protected void keyUp() {
    }

    protected void keyDown() {
    }

    protected void escape() {
    }

    protected void doQuery() {
        this.handler.doQuickQuery();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            return;
        }
        if (e.isControlDown() && e.getKeyCode() == 81) {
            this.doQuery();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        String inputText = this.txtQuickQueryInput.getText();
        if (inputText != null && this.defText.equals(inputText.trim())) {
            this.txtQuickQueryInput.setText("");
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        String inputText = this.txtQuickQueryInput.getText();
        if (inputText == null || inputText.trim().length() <= 0) {
            this.txtQuickQueryInput.setText(this.defText);
            return;
        }
    }

    public String getFilterString() {
        return this.getFilterString(this.txtQuickQueryInput.getText());
    }

    public String getFilterString(String txt) {
        if (this.defText.equals(txt)) {
            return "";
        }
        return txt;
    }
}

